/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.adapters.transforms;

import com.sas.etl.models.INotesAndDocumentsContainer;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IParametersContainer;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.job.ICodeGenerator;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IMultiplePortTransformModel;
import com.sas.etl.models.job.IPrePostCode;
import com.sas.etl.models.job.transforms.businessrules.BusinessRuleTransformModel;
import com.sas.etl.models.job.transforms.common.ITransformPort;
import com.sas.etl.models.job.transforms.edmflow.EDMFlowTransformModel;
import com.sas.etl.models.job.transforms.waitforcompletion.WaitForCompletionTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.IPortDescription;
import com.sas.wadmin.jobeditor.diagram.adapters.PortDescriptionFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.AbstractDataTransformAdapter;
import com.sas.wadmin.jobeditor.diagram.adapters.transforms.IDataTransformNodeAdapter;
import com.sas.wadmin.visuals.common.GeneralTab;
import com.sas.wadmin.visuals.common.NotesTab;
import com.sas.wadmin.visuals.common.OptionsTab;
import com.sas.wadmin.visuals.common.ParameterTab;
import com.sas.wadmin.visuals.common.PrePostCodeTab;
import com.sas.wadmin.visuals.common.ProcessTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.mutable.MutableInt;
import org.xml.sax.SAXException;

public abstract class AbstractMultiplePortTransformAdapter
extends AbstractDataTransformAdapter
implements IDataTransformNodeAdapter {
    public static final int CONTROL_PORT = 0;
    private static final Icon ICON_SMALL = AppIconFactory.getAppInstance().getIconForTransformation(BusinessRuleTransformModel.getTransformTypeID(), 16);
    private static final Icon ICON_MEDIUM = AppIconFactory.getAppInstance().getIconForTransformation(BusinessRuleTransformModel.getTransformTypeID(), 24);
    private static final URL ICON_URL_SMALL = AppIconFactory.getAppInstance().getIconURLForTransformation(BusinessRuleTransformModel.getTransformTypeID(), 16);
    private static final URL ICON_URL_MEDIUM = AppIconFactory.getAppInstance().getIconURLForTransformation(BusinessRuleTransformModel.getTransformTypeID(), 24);
    private static final Icon ICON_SMALL_EDM = AppIconFactory.getAppInstance().getIconForTransformation(EDMFlowTransformModel.getTransformTypeID(), 16);
    private static final Icon ICON_MEDIUM_EDM = AppIconFactory.getAppInstance().getIconForTransformation(EDMFlowTransformModel.getTransformTypeID(), 24);
    private static final URL ICON_URL_SMALL_EDM = AppIconFactory.getAppInstance().getIconURLForTransformation(EDMFlowTransformModel.getTransformTypeID(), 16);
    private static final URL ICON_URL_MEDIUM_EDM = AppIconFactory.getAppInstance().getIconURLForTransformation(EDMFlowTransformModel.getTransformTypeID(), 24);
    private static final Icon ICON_SMALL_WFC = AppIconFactory.getAppInstance().getIconForTransformation(WaitForCompletionTransformModel.getTransformTypeID(), 16);
    private static final Icon ICON_MEDIUM_WFC = AppIconFactory.getAppInstance().getIconForTransformation(WaitForCompletionTransformModel.getTransformTypeID(), 24);
    private static final URL ICON_URL_SMALL_WFC = AppIconFactory.getAppInstance().getIconURLForTransformation(WaitForCompletionTransformModel.getTransformTypeID(), 16);
    private static final URL ICON_URL_MEDIUM_WFC = AppIconFactory.getAppInstance().getIconURLForTransformation(WaitForCompletionTransformModel.getTransformTypeID(), 24);
    private IMultiplePortTransformModel m_transform;
    private BusinessRuleTransformModel m_oBRTransform;
    private EDMFlowTransformModel m_oEDMTransform;
    private WaitForCompletionTransformModel m_oWFCTransform;

    public AbstractMultiplePortTransformAdapter(IMultiplePortTransformModel transform) {
        super((IDataTransform)transform);
        this.m_transform = transform;
    }

    public IMultiplePortTransformModel getTransform() {
        return this.m_transform;
    }

    @Override
    public Icon getIcon(int size) {
        if (size == 16) {
            if (this.m_transform.equals(this.m_oBRTransform)) {
                return ICON_SMALL;
            }
            if (this.m_transform.equals(this.m_oEDMTransform)) {
                return ICON_SMALL_EDM;
            }
            if (this.m_transform.equals(this.m_oWFCTransform)) {
                return ICON_SMALL_WFC;
            }
        } else if (size == 24) {
            if (this.m_transform.equals(this.m_oBRTransform)) {
                return ICON_MEDIUM;
            }
            if (this.m_transform.equals(this.m_oEDMTransform)) {
                return ICON_MEDIUM_EDM;
            }
            if (this.m_transform.equals(this.m_oWFCTransform)) {
                return ICON_MEDIUM_WFC;
            }
        }
        throw new IllegalArgumentException("unable to load icon of size " + size + " for " + this.getName());
    }

    @Override
    public URL getIconURL(int size) {
        if (size == 16) {
            if (this.m_transform.equals(this.m_oBRTransform)) {
                return ICON_URL_SMALL;
            }
            if (this.m_transform.equals(this.m_oEDMTransform)) {
                return ICON_URL_SMALL_EDM;
            }
        } else if (size == 24) {
            if (this.m_transform.equals(this.m_oBRTransform)) {
                return ICON_URL_MEDIUM;
            }
            if (this.m_transform.equals(this.m_oEDMTransform)) {
                return ICON_URL_MEDIUM_EDM;
            }
        }
        throw new IllegalArgumentException("unable to load icon URL of size " + size + " for " + this.getName());
    }

    @Override
    protected WAPropertyTab[] getPropertyTabs() {
        try {
            OptionsTab optionsTab = new OptionsTab(this.m_transform.getOptionModel(), "NEED TO FIX", false);
            ArrayList<WAPropertyTab> lTabs = new ArrayList<WAPropertyTab>();
            lTabs.add(new GeneralTab((IObject)this.m_transform));
            lTabs.add(this.createMappingsTab(false));
            lTabs.add(optionsTab);
            lTabs.add(new ProcessTab((ICodeGenerator)this.m_transform, true, false));
            lTabs.add(new PrePostCodeTab((IPrePostCode)this.m_transform));
            lTabs.add(new ParameterTab((IParametersContainer)this.m_transform));
            lTabs.add(new NotesTab((INotesAndDocumentsContainer)this.m_transform));
            this.addAdvancedTabs(lTabs, (IPersistableObject)this.m_transform, false);
            return lTabs.toArray(new WAPropertyTab[lTabs.size()]);
        }
        catch (ServiceException e) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)e);
        }
        catch (ServerConnectionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (MdException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (FileNotFoundException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (IOException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (ParserConfigurationException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (SAXException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        return null;
    }

    @Override
    public IPortDescription[] getOutputPortDescriptions() {
        List aOutputPorts = this.m_transform.getTargetPorts();
        IPortDescription[] aPortDesc = new IPortDescription[aOutputPorts.size() + 1];
        aPortDesc[0] = PortDescriptionFactory.getInstance().createControlOutputPortDescriptionForTransform(1);
        for (int i = 0; i < aOutputPorts.size(); ++i) {
            ITransformPort outputPort = (ITransformPort)aOutputPorts.get(i);
            aPortDesc[i + 1] = this.createOutputPortDescription(outputPort, i + 1);
        }
        return aPortDesc;
    }

    @Override
    public boolean connectToInput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            return super.connectToInput(obj, portIndex);
        }
        if (portIndex > 0 && obj instanceof IDataObject) {
            this.m_transform.addDataSource((ITransformPort)this.m_transform.getSourcePorts().get(portIndex - 1), (IDataObject)obj);
            return true;
        }
        return false;
    }

    @Override
    public boolean connectToOutput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            return super.connectToOutput(obj, portIndex);
        }
        if (portIndex > 0 && obj instanceof IDataObject) {
            this.m_transform.addDataTarget((ITransformPort)this.m_transform.getTargetPorts().get(portIndex - 1), (IDataObject)obj);
            return true;
        }
        return false;
    }

    @Override
    public boolean disconnectFromOutput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            super.disconnectFromOutput(obj, portIndex);
        } else if (portIndex > 0 && obj instanceof IDataObject) {
            List ports = this.m_transform.getTargetPorts();
            if (ports.size() >= portIndex) {
                this.m_transform.removeDataTarget((ITransformPort)ports.get(portIndex - 1), (IDataObject)((IPhysicalTable)obj));
            }
            return true;
        }
        return false;
    }

    @Override
    public IPortDescription[] getInputPortDescriptions() {
        List ports = this.m_transform.getSourcePorts();
        IPortDescription[] aPortDesc = new IPortDescription[ports.size() + 1];
        aPortDesc[0] = PortDescriptionFactory.getInstance().createControlInputPortDescriptionForTransform(1);
        for (int i = 0; i < ports.size(); ++i) {
            ITransformPort port = (ITransformPort)ports.get(i);
            aPortDesc[i + 1] = this.createInputPortDescription(port, i + 1);
        }
        return aPortDesc;
    }

    @Override
    public int getInputPortIndex(IObject obj) {
        int[] iaPorts;
        if (obj instanceof IDataObject && (iaPorts = this.m_transform.getSourcePortIndexWithObject((IDataObject)obj)).length > 0) {
            return iaPorts[0] + 1;
        }
        return -1;
    }

    @Override
    public int[] getInputPortIndexes(IObject obj) {
        if (obj instanceof IDataObject) {
            int[] iaPorts = this.m_transform.getSourcePortIndexWithObject((IDataObject)obj);
            int i = 0;
            while (i < iaPorts.length) {
                int n = i++;
                iaPorts[n] = iaPorts[n] + 1;
            }
            return iaPorts;
        }
        return new int[0];
    }

    @Override
    public int getOutputPortIndex(IObject obj) {
        int[] iaPorts;
        if (obj instanceof IDataObject && (iaPorts = this.m_transform.getTargetPortIndexWithObject((IDataObject)obj)).length > 0) {
            return iaPorts[0] + 1;
        }
        return -1;
    }

    @Override
    public int[] getOutputPortIndexes(IObject obj) {
        if (obj instanceof IDataObject) {
            int[] iaPorts = this.m_transform.getTargetPortIndexWithObject((IDataObject)obj);
            int i = 0;
            while (i < iaPorts.length) {
                int n = i++;
                iaPorts[n] = iaPorts[n] + 1;
            }
            return iaPorts;
        }
        return new int[0];
    }

    protected String getPortDescription(ITransformPort<?> port) {
        return port.getDescription() != null && port.getDescription().length() > 0 ? port.getDescription() : port.getName();
    }

    private IPortDescription createInputPortDescription(ITransformPort<?> port, int index) {
        return PortDescriptionFactory.getInstance().createDataInputPortDescriptionForDataTransform(this.getPortDescription(port), port.getName(), 1, port.getObjectTypes());
    }

    private IPortDescription createOutputPortDescription(ITransformPort<?> port, int index) {
        return PortDescriptionFactory.getInstance().createDataOutputPortDescriptionForDataTransform(this.getPortDescription(port), port.getName(), 1, port.getObjectTypes());
    }

    @Override
    public IPortDescription addInputPortDescription(Object port, MutableInt inputPortIndex) {
        IPortDescription desc = null;
        if (port != null && port instanceof ITransformPort) {
            inputPortIndex.increment();
            desc = this.createInputPortDescription((ITransformPort)port, inputPortIndex.intValue());
        }
        return desc;
    }

    @Override
    public IPortDescription addInputPortDescription(Object obj) {
        IPortDescription desc = null;
        if (obj != null && obj instanceof ITransformPort) {
            ITransformPort port = (ITransformPort)obj;
            int index = port.getPortIndex();
            desc = this.createInputPortDescription(port, index + 1);
        }
        return desc;
    }

    @Override
    public IPortDescription addOutputPortDescription(Object obj, MutableInt outputPortIndex) {
        IPortDescription desc = null;
        if (obj != null && obj instanceof ITransformPort) {
            outputPortIndex.increment();
            desc = this.createOutputPortDescription((ITransformPort)obj, outputPortIndex.intValue());
        }
        return desc;
    }

    @Override
    public IPortDescription addOutputPortDescription(Object obj) {
        IPortDescription desc = null;
        if (obj != null && obj instanceof ITransformPort) {
            ITransformPort port = (ITransformPort)obj;
            int index = port.getPortIndex();
            desc = this.createOutputPortDescription(port, index + 1);
        }
        return desc;
    }

    @Override
    public boolean isValidToConnectInputOnRedraw(IObject obj) {
        if (obj instanceof IDataObject) {
            return this.m_transform.getSourcePortsWithObject((IDataObject)obj).length > 0;
        }
        return true;
    }

    @Override
    public boolean isValidToConnectOutputOnRedraw(IObject obj) {
        if (obj instanceof IDataObject) {
            return this.m_transform.getTargetPortsWithObject((IDataObject)obj).length > 0;
        }
        return true;
    }

    @Override
    public boolean isValidConnectToInput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            return super.isValidConnectToInput(obj, portIndex);
        }
        return portIndex > 0 && obj instanceof IDataObject;
    }

    @Override
    public boolean isValidConnectToOutput(IObject obj, int portIndex) {
        if (portIndex == 0) {
            return super.isValidConnectToOutput(obj, portIndex);
        }
        return portIndex > 0 && obj instanceof IDataObject && !this.m_transform.containsInDataTargets((IDataObject)obj);
    }
}

