/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.adapters.data;

import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.app.AppPropertiesDialogFactory;
import com.sas.wadmin.jobeditor.diagram.DiagramPanel;
import com.sas.wadmin.jobeditor.diagram.adapters.IPortDescription;
import com.sas.wadmin.jobeditor.diagram.adapters.IndicatorFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.PortDescriptionFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.data.AbstractDataAdapter;
import com.sas.wadmin.jobeditor.diagram.adapters.data.MenuUtils;
import com.sas.wadmin.visuals.common.ColumnsTab;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.models.SimpleObject;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPopupMenu;

public class PhysicalTableAdapter
extends AbstractDataAdapter {
    private static final WAdminResource bundle = WAdminResource.getBundle(PhysicalTableAdapter.class);
    private static final IPortDescription INPUT_DATA_PORT = PortDescriptionFactory.getInstance().createInputPortDescriptionForDataObject("PhysicalTable", Integer.MAX_VALUE);
    private static final IPortDescription OUTPUT_DATA_PORT = PortDescriptionFactory.getInstance().createOutputPortDescriptionForDataObject("PhysicalTable");
    private static final IPortDescription[] INPUT_PORTS = new IPortDescription[]{INPUT_DATA_PORT};
    private static final IPortDescription[] OUTPUT_PORTS = new IPortDescription[]{OUTPUT_DATA_PORT};
    private static final Icon ICON_SMALL = AppIconFactory.getInstance().getIconForPublicType("Table", 16);
    private static final Icon ICON_MEDIUM = AppIconFactory.getInstance().getIconForPublicType("Table", 24);
    private IPhysicalTable m_table;

    public PhysicalTableAdapter(IPhysicalTable table) {
        super((IDataObject)table);
        this.m_table = table;
    }

    @Override
    public void addContextMenuItems(JPopupMenu menuPopup) {
        MenuUtils.addContextMenuItems(menuPopup, this.m_table);
    }

    @Override
    public IPortDescription[] getInputPortDescriptions() {
        return INPUT_PORTS;
    }

    @Override
    public IPortDescription[] getOutputPortDescriptions() {
        return OUTPUT_PORTS;
    }

    @Override
    public Icon getIcon(int size) {
        if (size == 16) {
            return ICON_SMALL;
        }
        if (size == 24) {
            return ICON_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon of size " + size + " for " + this.getName());
    }

    @Override
    public String getName() {
        String sName = null;
        sName = this.m_table.getName();
        if (DiagramPanel.isUserPreferenceToIncludePhysicalName()) {
            sName = bundle.formatString("PhysicalTableAdapter.Name.txt", (Object)sName, (Object)this.m_table.getSASTableName());
        }
        return sName;
    }

    @Override
    public String getTitleText() {
        String sName = null;
        sName = this.m_table.getName();
        if (DiagramPanel.isUserPreferenceToIncludePhysicalName()) {
            sName = bundle.formatString("PhysicalTableAdapter.Name.txt", (Object)(sName + "\n"), (Object)this.m_table.getSASTableName());
        }
        return sName;
    }

    @Override
    public String getToolTipText() {
        String sName = null;
        sName = this.m_table.getName();
        if (DiagramPanel.isUserPreferenceToIncludePhysicalName()) {
            sName = bundle.formatString("PhysicalTableAdapter.Name.txt", (Object)sName, (Object)this.m_table.getSASTableName());
        }
        return sName;
    }

    @Override
    protected WAPropertyTab[] getPropertyTabs() {
        throw new UnsupportedOperationException("This method is not supported because this class overrides the showPropertiesDialog method");
    }

    @Override
    public int showPropertiesDialog(Window wdwParent) {
        return AppPropertiesDialogFactory.getInstance().showPropertiesDialog(wdwParent, (SimpleObject)this.m_table);
    }

    @Override
    public WAPropertyTab getNodeDetailsPanel() {
        ColumnsTab.Configuration config = new ColumnsTab.Configuration();
        config.setHiddenActions(new int[]{10});
        return new ColumnsTab((ITable)this.m_table, config);
    }

    @Override
    public String getInvalidConnectOutputMessage(IObject obj, int portIndex) {
        return bundle.getString("PhysicalTableAdapter.InvalidOutputMessage.txt");
    }

    @Override
    public String getInvalidConnectInputMessage(IObject obj, int portIndex) {
        return bundle.getString("PhysicalTableAdapter.InvalidInputMessage.txt");
    }

    @Override
    public List getIndicatorButtons() {
        Integer type = new Integer(this.m_table.getDBMSType().getDBMSTypeID());
        if (this.getIndicatorsMap().containsKey(type)) {
            return new ArrayList(this.getIndicatorsMap().values());
        }
        this.getIndicatorsMap().clear();
        this.getIndicatorsMap().put(type, IndicatorFactory.getInstance().getIndicator(this.m_table.getDBMSType().getDBMSTypeID(), this.m_table.getDBMSType().getConnectionType()));
        return new ArrayList(this.getIndicatorsMap().values());
    }
}

