/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.adapters.data;

import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IDocument;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.app.AppPropertiesDialogFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.IPortDescription;
import com.sas.wadmin.jobeditor.diagram.adapters.ISourceInvalidMessage;
import com.sas.wadmin.jobeditor.diagram.adapters.PortDescriptionFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.data.AbstractDataAdapter;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.models.SimpleObject;
import java.awt.Window;
import javax.swing.Icon;

public class DocumentAdapter
extends AbstractDataAdapter
implements ISourceInvalidMessage {
    private static final WAdminResource bundle = WAdminResource.getBundle(DocumentAdapter.class);
    private static final IPortDescription INPUT_DATA_PORT = PortDescriptionFactory.getInstance().createInputPortDescriptionForDataObject("Document", 1);
    private static final IPortDescription OUTPUT_DATA_PORT = PortDescriptionFactory.getInstance().createOutputPortDescriptionForDataObject("Document");
    private static final IPortDescription[] INPUT_PORTS = new IPortDescription[]{INPUT_DATA_PORT};
    private static final IPortDescription[] OUTPUT_PORTS = new IPortDescription[]{OUTPUT_DATA_PORT};
    private static final Icon ICON_SMALL = AppIconFactory.getInstance().getIconForPublicType("Document", 16);
    private static final Icon ICON_MEDIUM = AppIconFactory.getInstance().getIconForPublicType("Document", 24);
    private IDocument m_document;

    public DocumentAdapter(IDocument document) {
        super((IDataObject)document);
        this.m_document = document;
    }

    @Override
    public IPortDescription[] getInputPortDescriptions() {
        return INPUT_PORTS;
    }

    @Override
    public IPortDescription[] getOutputPortDescriptions() {
        return OUTPUT_PORTS;
    }

    @Override
    public Icon getIcon(int size) {
        if (size == 16) {
            return ICON_SMALL;
        }
        if (size == 24) {
            return ICON_MEDIUM;
        }
        throw new IllegalArgumentException("unable to load icon of size " + size + " for " + this.getName());
    }

    @Override
    protected WAPropertyTab[] getPropertyTabs() {
        throw new UnsupportedOperationException("This method is not supported because this class overrides the showPropertiesDialog method");
    }

    @Override
    public int showPropertiesDialog(Window wdwParent) {
        return AppPropertiesDialogFactory.getInstance().showPropertiesDialog(wdwParent, (SimpleObject)this.m_document);
    }

    @Override
    public String getInvalidConnectOutputMessage(IObject obj, int portIndex) {
        return bundle.getString("DocumentAdapter.InvalidOutputMessage.txt");
    }

    @Override
    public String getInvalidConnectInputMessage(IObject obj, int portIndex) {
        return bundle.getString("DocumentAdapter.InvalidInputMessage.txt");
    }
}

