/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.adapters.data;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.visuals.common.ColumnUIUtilities;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsDefaultTableCellRenderer;
import com.sas.workspace.WsObjectTableColumn;
import com.sas.workspace.WsUniqueNameTableColumn;
import java.awt.Component;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class DataNodeColumnsTableModel
extends WsAbstractTableModel {
    private static final WAdminResource bundle = WAdminResource.getBundle(DataNodeColumnsTableModel.class);
    public static final int NAME_COLUMN = 0;
    private static final int NAME_WIDTH = 100;
    private static final int VISIBLE_COLUMNS = 1;
    private static final int HIDDEN_COLUMNS = 1;
    private ITable m_table;
    private IModelListener m_modelListener;

    public DataNodeColumnsTableModel(ITable table) {
        this.m_table = table;
        this.m_modelListener = new ModelListener();
        this.m_table.getModel().addModelListener(this.m_modelListener);
        this.createColumnDefinitions();
    }

    protected void createColumnDefinitions() {
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsUniqueNameTableColumn((WsAbstractTableModel)this, 0, bundle.getString("DataNodeColumnsTableModel.Column.txt"), 100, 32);
        this.m_aColumns[0].setCellRenderer((TableCellRenderer)((Object)new ColumnNameCellRenderer()));
        this.m_aColumns[this.getColumnCount()] = new WsObjectTableColumn();
    }

    public void moveDataToModel() {
        this.load();
    }

    public void load() {
        this.clear();
        IColumn[] aColumns = this.m_table.getColumns();
        for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
            this.m_lData.add(this.createRowValues(aColumns[iColumn]));
        }
        this.fireTableModelPopulated();
        this.m_nRowInstances = this.m_lData.size() + 1;
    }

    public void dispose() {
        this.m_table.getModel().removeModelListener(this.m_modelListener);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        throw new UnsupportedOperationException("moveDataToStore not implemented.  changes are immediately made to the model");
    }

    public void populateStore() {
        throw new UnsupportedOperationException("populateStore not implemented.  Model does not use a store");
    }

    public int getColumnCount() {
        return 1;
    }

    public int getHiddenColumnCount() {
        return 1;
    }

    private void addColumn(IColumn column) {
        int row = this.m_table.indexOfColumn(column);
        this.insertRow(row - 1, this.createRowValues(column));
    }

    private List createRowValues(IColumn column) {
        ArrayList values = new ArrayList(this.getColumnCount() + this.getHiddenColumnCount());
        this.addVisibleValues(column, values);
        this.addHiddenValues(column, values);
        return values;
    }

    private void removeColumn(IColumn column) {
        this.deleteRow(this.getRowIndex(column));
    }

    protected void addVisibleValues(IColumn column, List values) {
        values.add(column.getName());
    }

    protected void addHiddenValues(IColumn column, List values) {
        values.add(column);
    }

    public String getToolTipAt(int iRow, int iCol) {
        Object obj = this.getValueAt(iRow, 0);
        if (obj instanceof String) {
            return (String)obj;
        }
        return super.getToolTipAt(iRow, iCol);
    }

    public ITable getTable() {
        return this.m_table;
    }

    public int getRowIndex(String id) {
        for (int row = 0; row < this.m_lData.size(); ++row) {
            if (!this.getColumnForRow(row).getID().equals(id)) continue;
            return row;
        }
        return -1;
    }

    public int getRowIndex(IColumn column) {
        for (int row = 0; row < this.m_lData.size(); ++row) {
            if (this.getColumnForRow(row) != column) continue;
            return row;
        }
        return -1;
    }

    public IColumn getColumnForRow(int row) {
        return (IColumn)this.getValueAt(row, this.getColumnCount());
    }

    public String createUniqueNameForNewColumn() {
        return (String)this.m_aColumns[0].createDefaultValue();
    }

    private class ColumnNameCellRenderer
    extends WsDefaultTableCellRenderer {
        private ColumnNameCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            super.getTableCellRendererComponent(table, value, selected, focused, row, column);
            IColumn col = DataNodeColumnsTableModel.this.getColumnForRow(row);
            this.setIcon(ColumnUIUtilities.getTypeIcon(col));
            return this;
        }
    }

    protected class ModelListener
    implements IModelListener {
        protected ModelListener() {
        }

        public void modelChanged(ModelEvent event) {
            String type = event.getType();
            IObject object = event.getModelObject();
            if (type == "ModelController:UnknownChanges") {
                DataNodeColumnsTableModel.this.moveDataToModel();
            } else if (object == DataNodeColumnsTableModel.this.m_table) {
                if (type == "Table:ColumnAdded") {
                    DataNodeColumnsTableModel.this.addColumn((IColumn)event.getData());
                } else if (type == "Table:ColumnMoved") {
                    DataNodeColumnsTableModel.this.removeColumn((IColumn)event.getData());
                    DataNodeColumnsTableModel.this.addColumn((IColumn)event.getData());
                } else if (type == "Table:ColumnRemoved") {
                    DataNodeColumnsTableModel.this.removeColumn((IColumn)event.getData());
                }
            } else if (object instanceof IColumn) {
                IColumn column = (IColumn)object;
                int rowIndex = DataNodeColumnsTableModel.this.getRowIndex(column);
                if (rowIndex == -1) {
                    return;
                }
                if (type == "Object:NameChanged") {
                    DataNodeColumnsTableModel.super.setValueAt(column.getName(), rowIndex, 0);
                } else if (type == "Column:TypeChanged") {
                    DataNodeColumnsTableModel.this.fireTableCellUpdated(rowIndex, 0);
                } else if (type == "Column:SortOrderChanged") {
                    // empty if block
                }
            }
        }
    }
}

