/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram.adapters;

import com.sas.wadmin.jobeditor.diagram.adapters.IPortDescription;
import com.sas.workspace.WAdminResource;

public class PortDescriptionFactory {
    private static final WAdminResource bundle = WAdminResource.getBundle(PortDescriptionFactory.class);
    private static PortDescriptionFactory s_instance;
    private static final String CONTROL = "Control";
    private static final String PRODUCER = ":Producer";
    private static final String CONSUMER = ":Consumer";

    public static PortDescriptionFactory getInstance() {
        if (s_instance == null) {
            s_instance = new PortDescriptionFactory();
        }
        return s_instance;
    }

    private PortDescriptionFactory() {
    }

    public IPortDescription createInputPortDescriptionForDataObject(String sDataType, int nMaximumConnections) {
        String sName = bundle.getString("PortDescriptionFactory.DataObjectPortName.txt");
        return new BasePortDescription(0, null, sName, nMaximumConnections, new String[]{sDataType + PRODUCER});
    }

    public IPortDescription createOutputPortDescriptionForDataObject(String sDataType) {
        String sName = bundle.getString("PortDescriptionFactory.DataObjectPortName.txt");
        return new BasePortDescription(0, null, sName, Integer.MAX_VALUE, new String[]{sDataType + CONSUMER});
    }

    public IPortDescription createDataInputPortDescriptionForDataTransform(String sText, int nMaximumConnections, String[] aPossibleOutputTypes) {
        String sName = bundle.getString("PortDescriptionFactory.TransformDataPortName.txt");
        return this.createDataInputPortDescriptionForDataTransform(sText, sName, nMaximumConnections, aPossibleOutputTypes);
    }

    public IPortDescription createDataInputPortDescriptionForDataTransform(String sText, String sName, int nMaximumConnections, String[] aPossibleInputTypes) {
        String[] aConnectionTypes = new String[aPossibleInputTypes.length];
        for (int iType = 0; iType < aPossibleInputTypes.length; ++iType) {
            aConnectionTypes[iType] = aPossibleInputTypes[iType] + CONSUMER;
        }
        return new BasePortDescription(0, sText, sName, nMaximumConnections, aConnectionTypes);
    }

    public IPortDescription createDataOutputPortDescriptionForDataTransform(String sText, int nMaximumConnections, String[] aPossibleOutputTypes) {
        String sName = bundle.getString("PortDescriptionFactory.TransformDataPortName.txt");
        return this.createDataOutputPortDescriptionForDataTransform(sText, sName, nMaximumConnections, aPossibleOutputTypes);
    }

    public IPortDescription createDataOutputPortDescriptionForDataTransform(String sText, String sName, int nMaximumConnections, String[] aPossibleOutputTypes) {
        String[] aConnectionTypes = new String[aPossibleOutputTypes.length];
        for (int iType = 0; iType < aPossibleOutputTypes.length; ++iType) {
            aConnectionTypes[iType] = aPossibleOutputTypes[iType] + PRODUCER;
        }
        return new BasePortDescription(0, sText, sName, nMaximumConnections, aConnectionTypes);
    }

    public IPortDescription createControlInputPortDescriptionForTransform() {
        return this.createControlInputPortDescriptionForTransform(1);
    }

    public IPortDescription createControlOutputPortDescriptionForTransform() {
        return this.createControlOutputPortDescriptionForTransform(1);
    }

    public IPortDescription createControlInputPortDescriptionForTransform(int nMaximumConnections) {
        String sText = bundle.getString("PortDescriptionFactory.ControlOrderPort.txt");
        String sName = bundle.getString("PortDescriptionFactory.ControlOrderPortName.txt");
        return new BasePortDescription(1, sText, sName, nMaximumConnections, new String[]{CONTROL});
    }

    public IPortDescription createControlOutputPortDescriptionForTransform(int nMaximumConnections) {
        String sText = bundle.getString("PortDescriptionFactory.ControlOrderPort.txt");
        String sName = bundle.getString("PortDescriptionFactory.ControlOrderPortName.txt");
        return new BasePortDescription(1, sText, sName, nMaximumConnections, new String[]{CONTROL});
    }

    private static class BasePortDescription
    implements IPortDescription {
        private String m_sName;
        private int m_eType;
        private String m_sText;
        private int m_nMaximumConnections;
        private String[] m_aConnectionTypes;

        BasePortDescription(int eType, String sText, String sName, int nMaximumConnections, String[] aConnectionTypes) {
            this.m_eType = eType;
            this.m_sText = sText;
            this.m_sName = sName;
            this.m_nMaximumConnections = nMaximumConnections;
            this.m_aConnectionTypes = aConnectionTypes;
        }

        @Override
        public int getType() {
            return this.m_eType;
        }

        @Override
        public String getName() {
            return this.m_sName;
        }

        @Override
        public String getText() {
            return this.m_sText;
        }

        @Override
        public int getMaximumConnections() {
            return this.m_nMaximumConnections;
        }

        @Override
        public String[] getConnectionTypes() {
            return this.m_aConnectionTypes;
        }
    }
}

