/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.jobeditor.diagram;

import com.sas.etl.models.IComplexPersistableObject;
import com.sas.etl.models.IModel;
import com.sas.etl.models.IOMRPersistable;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IDesignTimeModel;
import com.sas.etl.models.job.IJob;
import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.job.transforms.JobTransformModel;
import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDCompositeNode;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.jobeditor.diagram.IPFDModel;
import com.sas.wadmin.jobeditor.diagram.adapters.DiagramNodeAdapterFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.IDiagramNodeAdapter;
import com.sas.wadmin.jobeditor.diagram.shapes.IControlLink;
import com.sas.wadmin.jobeditor.diagram.shapes.IDataNode;
import com.sas.wadmin.jobeditor.diagram.shapes.IDataTransformNode;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramLink;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramNode;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramPersistable;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramStickyNote;
import com.sas.wadmin.jobeditor.diagram.shapes.IShape;
import com.sas.wadmin.jobeditor.diagram.shapes.IWorkTableNode;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.DiagramNodeFactory;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.DiagramParserException;
import com.sas.wadmin.jobeditor.diagram.shapes.impl.DiagramUtil;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.visuals.pfd.WsPFDModel;
import java.awt.Point;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class WADiagramModel
extends WsPFDModel
implements IPFDModel {
    private static final WAdminResource bundle = WAdminResource.getBundle(WADiagramModel.class);
    private IPersistableObject m_object;
    protected static final String DIAGRAM_NODES = "DiagramNodes";
    protected static final String DIAGRAM_LINKS = "DiagramLinks";
    public static final int FLOW_DIRECTION_CHANGED = 1001;
    private DiagramNodeFactory m_factoryNodes;
    private DiagramNodeAdapterFactory m_factoryAdapters;
    private HashMap m_mapNodes;
    private HashMap m_mapObjectShapes;
    private HashMap m_mapLinks;
    private HashMap m_mapStickyNotes;
    private List m_lNodes;
    private List m_lLinks;
    private List m_lStickyNotes;
    private String m_sDiagramXML;
    private boolean m_bFirstOpen;
    private HashMap m_mapDeletedStickyNotes;
    private HashMap m_mapDeletedNodes;
    private HashMap m_mapDeletedLinks;
    private Point m_nextLocation;
    private boolean m_bIncrementLocation;
    private Point m_dropPt;
    private IDiagramNode m_lastNodeAdded;
    private boolean m_bIgnoreDeletedNodes;
    private boolean m_bIgnoreEvents;

    public WADiagramModel() {
        this(null);
    }

    public WADiagramModel(IComplexPersistableObject mdlJob) {
        this(mdlJob, DiagramNodeFactory.getInstance(), DiagramNodeAdapterFactory.getInstance());
    }

    public WADiagramModel(IComplexPersistableObject object, DiagramNodeFactory factoryNodes, DiagramNodeAdapterFactory factoryAdapters) {
        this.setMainObject((IPersistableObject)object);
        this.m_factoryAdapters = factoryAdapters;
        this.m_factoryNodes = factoryNodes;
        this.setFirstOpen(true);
        this.setIgnoreEvents(false);
        this.m_lNodes = new ArrayList();
        this.m_lLinks = new ArrayList();
        this.m_lStickyNotes = new ArrayList();
        this.m_mapNodes = new HashMap();
        this.m_mapLinks = new HashMap();
        this.m_mapStickyNotes = new HashMap();
        this.m_mapObjectShapes = new HashMap();
        this.m_mapDeletedNodes = new HashMap();
        this.m_mapDeletedLinks = new HashMap();
        this.m_mapDeletedStickyNotes = new HashMap();
        this.m_nextLocation = new Point();
        this.m_nextLocation.x = 0;
        this.m_nextLocation.y = 0;
        this.m_bIncrementLocation = true;
    }

    public void setDropPoint(Point newPoint) {
        this.m_dropPt = newPoint;
    }

    public Point getDropPoint() {
        return this.m_dropPt;
    }

    protected void removeDeletedLink(IDiagramNode node, IDiagramLink link) {
        if (node == null || link == null) {
            return;
        }
        ArrayList links = (ArrayList)this.m_mapDeletedLinks.get(node.getId());
        if (links == null || links.indexOf(link) == -1) {
            return;
        }
        links.remove(links.indexOf(link));
        if (links.isEmpty()) {
            this.m_mapDeletedLinks.remove(node.getId());
        } else {
            this.m_mapDeletedLinks.put(node.getId(), links);
        }
    }

    public List getLinks(IObject obj) {
        return this.getObjectShapes(obj, DIAGRAM_LINKS);
    }

    public void setLocation(IShape node, Point oldLocation, Point newLocation) {
        IModel jobModel = this.getObjectModel();
        if (jobModel != null) {
            jobModel.undoableEditHappened((UndoableEdit)new SetLocationUndoable(node, oldLocation, newLocation));
        }
        if (newLocation != null) {
            node.setSpotLocation(1, newLocation);
        }
    }

    public void setLinkLocations(IDiagramLink link, Point[] aOldLocation, Point[] aNewLocation) {
        IModel jobModel = this.getObjectModel();
        if (jobModel != null) {
            jobModel.undoableEditHappened((UndoableEdit)new SetLinkLocationsUndoable(link, aOldLocation, aNewLocation));
        }
        if (aNewLocation == null) {
            return;
        }
        link.removeAllBreakPoints();
        for (int iLocation = 0; iLocation < aNewLocation.length; ++iLocation) {
            link.addBreakPoint(aNewLocation[iLocation]);
        }
    }

    protected void refreshNodes(IObject obj) {
        this.refreshNodes(obj, null);
    }

    protected void refreshNodes(IObject obj, ModelEvent ev) {
        ArrayList nodes = (ArrayList)this.getNodes(obj);
        if (nodes != null) {
            for (int iNode = 0; iNode < nodes.size(); ++iNode) {
                IDiagramNode node = (IDiagramNode)nodes.get(iNode);
                if (ev == null) {
                    node.refresh();
                    continue;
                }
                if (!(obj instanceof IDataTransform)) continue;
                ((IDataTransformNode)node).refresh(ev);
            }
        }
    }

    private void clearAllLists() {
        this.m_mapObjectShapes.clear();
        this.m_mapDeletedNodes.clear();
        this.m_mapDeletedLinks.clear();
        this.m_mapNodes.clear();
        this.m_mapLinks.clear();
        this.m_mapStickyNotes.clear();
        this.m_mapDeletedStickyNotes.clear();
    }

    protected boolean refresh() {
        this.setIgnoreEvents(true);
        this.removeAllPrimitives();
        this.clearAllLists();
        this.setIgnoreEvents(false);
        IPersistableObject jobModel = this.getMainObject();
        if (jobModel != null) {
            String flow = jobModel.getUserProperty("FlowDirection");
            if (flow != null) {
                super.setFlowDirection(flow);
                this.fireModelChange(1001, flow, null);
            }
            boolean bLayout = this.parseDiagramXML();
            bLayout = this.addNodes();
            this.addLinks();
            this.addStickyNotesFromXML();
            if (!bLayout) {
                return true;
            }
        }
        return false;
    }

    protected String createDiagramXML() {
        IModel model = this.getObjectModel();
        if (model != null) {
            ArrayList lShapes = new ArrayList();
            lShapes.addAll(this.m_mapNodes.values());
            lShapes.addAll(this.m_mapLinks.values());
            lShapes.addAll(this.m_mapStickyNotes.values());
            return DiagramUtil.getXMLForObjects(lShapes, (IDesignTimeModel)this.m_object.getModel());
        }
        return null;
    }

    protected boolean parseDiagramXML() {
        String shapes = this.getDiagramXML();
        if (shapes == null) {
            shapes = this.getMainObject().getUserProperty("DiagramXML");
        }
        if (shapes != null) {
            try {
                DiagramUtil.getObjectsFromXML(shapes, this.m_lLinks, this.m_lNodes, this.m_lStickyNotes, (IDesignTimeModel)this.getMainObject().getModel());
            }
            catch (SAXException se) {
                this.clearLinksList();
                this.clearNodesList();
                this.clearStickyNotesList();
                MessageUtil.displayMessage((String)se.getMessage(), (String)bundle.getString("DiagramModel.ExceptionDialog.ParserException.txt"));
                return false;
            }
            catch (IOException ioe) {
                this.clearLinksList();
                this.clearNodesList();
                this.clearStickyNotesList();
                MessageUtil.displayMessage((String)ioe.getMessage(), (String)bundle.getString("DiagramModel.ExceptionDialog.ParserException.txt"));
                return false;
            }
            catch (ParserConfigurationException pce) {
                this.clearLinksList();
                this.clearNodesList();
                this.clearStickyNotesList();
                MessageUtil.displayMessage((String)pce.getMessage(), (String)bundle.getString("DiagramModel.ExceptionDialog.ParserException.txt"));
                return false;
            }
            catch (DiagramParserException dpe) {
                this.clearLinksList();
                this.clearNodesList();
                this.clearStickyNotesList();
                MessageUtil.displayMessage((String)dpe.getMessage(), (String)bundle.getString("DiagramModel.ExceptionDialog.ParserException.txt"));
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    protected void removeStickyNote(IDiagramStickyNote note) {
        this.m_mapStickyNotes.remove(note.getId());
        this.putDeletedStickyNote(note);
    }

    protected void removeNode(IDiagramNode node) {
        this.m_mapNodes.remove(node.getId());
    }

    public List getNodes(IObject obj) {
        return this.getObjectShapes(obj, DIAGRAM_NODES);
    }

    public IDiagramNode getNode(String id) {
        return (IDiagramNode)this.m_mapNodes.get(id);
    }

    protected void putStickyNote(IDiagramStickyNote note) {
        this.m_mapStickyNotes.put(note.getId(), note);
    }

    protected IDiagramStickyNote getStickyNote(String id) {
        return (IDiagramStickyNote)this.m_mapStickyNotes.get(id);
    }

    public IDiagramLink getLink(String fromId, String toId) {
        IDiagramNode node = this.getNode(fromId);
        ArrayList lLinks = (ArrayList)this.getLinks(node.getObject());
        for (int iLink = 0; iLink < lLinks.size(); ++iLink) {
            IDiagramLink link = (IDiagramLink)lLinks.get(iLink);
            if (!link.getFromNodeId().equals(fromId) || !link.getToNodeId().endsWith(toId)) continue;
            return link;
        }
        return null;
    }

    public IDiagramLink getLink(String id) {
        return (IDiagramLink)this.m_mapLinks.get(id);
    }

    protected void putLink(IDiagramLink link) {
        if (this.getLink(link.getId()) == null) {
            IDiagramNode nodeFrom = this.getNode(link.getFromNodeId());
            if (nodeFrom == null) {
                return;
            }
            this.putObjectShape(nodeFrom.getObject(), link);
            IDiagramNode nodeTo = this.getNode(link.getToNodeId());
            if (nodeTo == null) {
                return;
            }
            this.putObjectShape(nodeTo.getObject(), link);
            this.m_mapLinks.put(link.getId(), link);
        }
    }

    public void addLink(PFDLink link) {
        this.putLink((IDiagramLink)link);
        super.addLink(link);
    }

    public void addStickyNote(IDiagramStickyNote note) {
        this.putStickyNote(note);
        super.addPrimitive((PFDPrimitive)note);
    }

    public IDiagramNodeAdapter getAdapter(IObject obj) {
        List lNodes = this.getNodes(obj);
        if (lNodes != null && !lNodes.isEmpty()) {
            return ((IDiagramNode)lNodes.get(0)).getAdapter();
        }
        return null;
    }

    public void setMainObject(IPersistableObject object) {
        this.m_object = object;
    }

    public IPersistableObject getMainObject() {
        return this.m_object;
    }

    @Override
    public IModel getObjectModel() {
        return this.m_object != null ? this.m_object.getModel() : null;
    }

    protected IJob getJobObject() {
        IJob job = null;
        IPersistableObject main = this.getMainObject();
        if (main instanceof IJob) {
            job = (IJob)main;
        } else if (main instanceof ITransform) {
            job = ((ITransform)main).getJob();
        }
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dropDataObject(Point pt, CMetadata obj) {
        block36: {
            IModel jobModel = this.getObjectModel();
            IJob job = this.getJobObject();
            try {
                IDiagramNode last;
                this.setIgnoreDeletedNodes(true);
                String strType = obj.getCMetadataType();
                ArrayList nodes = (ArrayList)this.getObjectShapes(jobModel.getObject(obj.getId()), DIAGRAM_NODES);
                if (nodes != null) {
                    this.setDropPoint(null);
                    IDiagramNode node = this.addNode(((IDiagramNode)nodes.get(0)).getObject());
                    if (node != null) {
                        node.setLocation(pt.x, pt.y);
                        jobModel.undoableEditHappened((UndoableEdit)new AddDataObjectUndoable(node, pt));
                    }
                    boolean bl = true;
                    return bl;
                }
                this.setDropPoint(pt);
                IPhysicalTable oData = null;
                if (jobModel == null) break block36;
                if (jobModel.getObject(obj.getFQID()) == null) {
                    if (strType.compareTo("PhysicalTable") == 0) {
                        oData = jobModel.getObjectFactory().createPhysicalTable(obj.getFQID());
                    } else if (strType.compareTo("ExternalTable") == 0) {
                        oData = jobModel.getObjectFactory().createExternalTable(obj.getFQID());
                    } else if (strType.compareTo("SASLibrary") == 0) {
                        oData = jobModel.getObjectFactory().createLibrary(obj.getFQID());
                    } else if (strType.compareTo("Transformation") == 0) {
                        try {
                            oData = jobModel.getObjectFactory().createMessageQueue((Root)obj);
                        }
                        catch (MdException e) {
                            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
                            oData = null;
                            boolean bl = false;
                            this.setIgnoreDeletedNodes(false);
                            return bl;
                        }
                    } else if (strType.compareTo("Document") == 0) {
                        oData = jobModel.getObjectFactory().createDocument(obj.getFQID());
                    }
                    this.setIgnoreEvents(true);
                    if (oData != null) {
                        try {
                            jobModel.loadFromOMR((IOMRPersistable)oData, Workspace.getMdFactory());
                        }
                        catch (MdException e) {
                            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
                            this.setDropPoint(null);
                            boolean bl = false;
                            this.setIgnoreDeletedNodes(false);
                            return bl;
                        }
                        try {
                            jobModel.startCompoundUndoable();
                            this.setIgnoreEvents(false);
                            if (job != null) {
                                job.getDataObjectsList().add(oData);
                            }
                            last = this.getLastNodeAdded();
                            this.setLocation(last, null, last.getLocation());
                        }
                        finally {
                            jobModel.endCompoundUndoable();
                        }
                    }
                } else if (job != null && !job.getDataObjectsList().contains(jobModel.getObject(obj.getFQID()))) {
                    try {
                        jobModel.startCompoundUndoable();
                        job.getDataObjectsList().add(jobModel.getObject(obj.getFQID()));
                        last = this.getLastNodeAdded();
                        this.setLocation(last, null, last.getLocation());
                    }
                    finally {
                        jobModel.endCompoundUndoable();
                    }
                } else {
                    this.setDropPoint(null);
                    IDiagramNode node = this.addNode(jobModel.getObject(obj.getFQID()));
                    if (node != null) {
                        node.setLocation(pt.x, pt.y);
                        jobModel.undoableEditHappened((UndoableEdit)new AddDataObjectUndoable(node, pt));
                    }
                }
                this.setDropPoint(null);
                boolean bl = true;
                return bl;
            }
            catch (RemoteException re) {
                this.setDropPoint(null);
                Workspace.handleRemoteException((RemoteException)re);
                boolean bl = false;
                return bl;
            }
            finally {
                this.setIgnoreDeletedNodes(false);
            }
        }
        this.setDropPoint(null);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dropSimpleObject(Point pt, SimpleObject simpleObj) {
        boolean bl;
        MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "DiagramModel:dropSimpleObject");
        try {
            Root mdObj = ObjectConverter.getInstance().convertToJOMAObject(store, simpleObj);
            bl = this.dropDataObject(pt, (CMetadata)mdObj);
        }
        catch (Throwable throwable) {
            try {
                store.dispose();
                throw throwable;
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
                return false;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
                return false;
            }
        }
        store.dispose();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dropTransform(Point pt, TransformInterface obj) {
        String sClass = obj.getTransformClass();
        this.setDropPoint(pt);
        IModel jobModel = this.getObjectModel();
        if (jobModel != null) {
            jobModel.startCompoundUndoable();
            try {
                IJob job = this.getJobObject();
                if (job != null) {
                    ITransform transform = jobModel.getObjectFactory().createNewTransform(sClass, job.getID());
                    job.getTransformsList().add(transform);
                    transform.addDefaultSettings();
                }
            }
            catch (MdException me) {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
                boolean bl = false;
                return bl;
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
                boolean bl = false;
                return bl;
            }
            finally {
                jobModel.endCompoundUndoable();
            }
            this.setDropPoint(null);
            return true;
        }
        this.setDropPoint(null);
        return false;
    }

    protected IDiagramStickyNote createStickyNote() {
        return null;
    }

    protected IDiagramNode addNode(IObject obj) {
        IDiagramNode node = null;
        ArrayList nodes = null;
        if (!this.getIgnoreDeletedNodes()) {
            nodes = (ArrayList)this.getDeletedNodes(obj);
        }
        if (nodes != null && !nodes.isEmpty()) {
            for (int iNode = 0; iNode < nodes.size(); ++iNode) {
                node = (IDiagramNode)nodes.get(iNode);
                if (!(obj instanceof IWorkTable) && obj instanceof IDataObject && node.getId().equals(((IDataObject)obj).getChangedNodeId())) break;
            }
        }
        if (node == null) {
            IDiagramNodeAdapter adapter = this.m_factoryAdapters.createAdapter(obj);
            node = (IDiagramNode)this.m_factoryNodes.createNode(adapter);
            if (!(obj instanceof IWorkTable)) {
                if (this.m_dropPt != null) {
                    node.setLocation(this.m_dropPt.x, this.m_dropPt.y);
                } else {
                    node.setLocation(this.m_nextLocation.x, this.m_nextLocation.y);
                    if (this.m_bIncrementLocation) {
                        this.m_nextLocation.x += 20;
                        this.m_nextLocation.y += 20;
                    }
                }
            }
        }
        this.removeDeletedNode(obj, node);
        this.putNode(obj, node);
        this.m_lastNodeAdded = node;
        if (node instanceof IWorkTableNode) {
            return node;
        }
        this.addPrimitive((PFDPrimitive)((PFDAbstractNode)node));
        return node;
    }

    protected boolean addStickyNotesFromXML() {
        if (this.m_lStickyNotes == null || this.m_lStickyNotes.isEmpty()) {
            return false;
        }
        for (int iNote = 0; iNote < this.m_lStickyNotes.size(); ++iNote) {
            IDiagramStickyNote note = (IDiagramStickyNote)this.m_lStickyNotes.get(iNote);
            if (note == null) continue;
            this.addStickyNote(note);
        }
        return true;
    }

    protected Collection getNodes() {
        return this.m_mapNodes.values();
    }

    protected Collection getLinks() {
        return this.m_mapLinks.values();
    }

    protected Collection getStickyNotes() {
        return this.m_mapStickyNotes.values();
    }

    protected List getLinksList() {
        return this.m_lLinks;
    }

    protected List getNodesList() {
        return this.m_lNodes;
    }

    protected List getStickyNoteList() {
        return this.m_lStickyNotes;
    }

    protected void clearLinksList() {
        this.m_lLinks.clear();
    }

    protected void clearNodesList() {
        this.m_lNodes.clear();
    }

    protected void clearStickyNotesList() {
        this.m_lStickyNotes.clear();
    }

    protected boolean save() {
        String flowDirection = this.getFlowDirection();
        IPersistableObject jobModel = this.getMainObject();
        if (jobModel != null) {
            jobModel.setUserProperty("FlowDirection", flowDirection);
            String sXML = this.createDiagramXML();
            if (sXML != null) {
                jobModel.setUserProperty("DiagramXML", sXML.toString());
            } else {
                jobModel.setUserProperty("DiagramXML", "");
            }
            try {
                jobModel.getModel().saveToOMR(Workspace.getMdFactory());
                jobModel.getModel().getUndoManager().discardAllEdits();
                return true;
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Writing");
            }
        }
        return false;
    }

    public IDiagramNode removeNode(String id) {
        IDiagramNode node = this.getNode(id);
        if (node != null) {
            this.removeNode(node);
            this.removeObjectShape(node.getObject(), node);
            this.putDeletedNode(node.getObject(), node);
            if (node instanceof IWorkTableNode) {
                IDataTransformNode transNode = (IDataTransformNode)this.getNode(((IWorkTableNode)node).getTransformNodeId());
                transNode.removeWorkTable((PFDCompositeNode)node);
            } else {
                this.removePrimitive((PFDPrimitive)((PFDAbstractNode)node));
            }
        }
        return node;
    }

    protected IDiagramLink removeLink(IObject fromObj, IObject toObj) {
        IDiagramLink link = this.getLink(fromObj, toObj);
        if (link == null) {
            return null;
        }
        this.removeLink(link);
        return link;
    }

    protected IDiagramLink getLink(IObject fromObj, IObject toObj) {
        ArrayList fromLinks = (ArrayList)this.getLinks(fromObj);
        if (fromLinks != null) {
            for (int iFromLink = 0; iFromLink < fromLinks.size(); ++iFromLink) {
                IDiagramLink fromLink = (IDiagramLink)fromLinks.get(iFromLink);
                ArrayList toLinks = (ArrayList)this.getLinks(toObj);
                if (fromLink == null || toLinks == null) continue;
                for (int iToLink = 0; iToLink < toLinks.size(); ++iToLink) {
                    IDiagramLink toLink = (IDiagramLink)toLinks.get(iToLink);
                    IDiagramNode fromNode = this.getNode(fromLink.getFromNodeId());
                    if (toLink == null || fromNode == null || !fromLink.getId().equals(toLink.getId()) || !fromNode.getObject().equals(fromObj)) continue;
                    return fromLink;
                }
            }
        }
        return null;
    }

    public void removeLink(IDiagramLink link) {
        IDiagramNode toNode;
        if (link == null) {
            return;
        }
        this.m_mapLinks.remove(link.getId());
        IDiagramNode fromNode = this.getNode(link.getFromNodeId());
        if (fromNode != null && this.containsInObjectShapes(fromNode.getObject())) {
            this.removeObjectShape(fromNode.getObject(), link);
        }
        if (fromNode != null) {
            this.putDeletedLink(fromNode, link);
        }
        if ((toNode = this.getNode(link.getToNodeId())) != null && this.containsInObjectShapes(toNode.getObject())) {
            this.removeObjectShape(toNode.getObject(), link);
        }
        if (toNode != null) {
            this.putDeletedLink(toNode, link);
        }
        link.setFromPort(null);
        link.setToPort(null);
        if (this.indexOfPrimitive((PFDPrimitive)((PFDLink)link)) == -1) {
            return;
        }
        this.removePrimitive((PFDPrimitive)((PFDLink)link));
        if (fromNode == null || toNode == null) {
            return;
        }
        if (fromNode.getObject() instanceof IWorkTable && toNode instanceof IDataTransformNode && this.getNode(((IWorkTableNode)fromNode).getTransformNodeId()) != null) {
            ((IDataTransformNode)this.getNode(((IWorkTableNode)fromNode).getTransformNodeId())).updateCollapsedLinks();
        }
        if (toNode.getObject() instanceof IWorkTable && fromNode instanceof IDataTransformNode) {
            ((IDataTransformNode)fromNode).updateCollapsedLinks();
        }
    }

    protected boolean addLinksFromXML() {
        if (this.m_lLinks == null || this.m_lLinks.isEmpty()) {
            return false;
        }
        for (int iLink = 0; iLink < this.m_lLinks.size(); ++iLink) {
            IDiagramLink link = (IDiagramLink)this.m_lLinks.get(iLink);
            if (link == null) continue;
            IDiagramNode nodeFrom = this.getNode(link.getFromNodeId());
            IDiagramNode nodeTo = this.getNode(link.getToNodeId());
            if (nodeFrom == null || nodeTo == null) continue;
            PFDPort portOutputFrom = link.getFromNodePortIndex() <= nodeFrom.getNumOutputPorts() ? nodeFrom.getOutputPort(link.getFromNodePortIndex()) : nodeFrom.getOutputPort(nodeTo.getObject());
            PFDPort portInputTo = link.getToNodePortIndex() <= nodeFrom.getNumInputPorts() ? nodeFrom.getInputPort(link.getToNodePortIndex()) : nodeFrom.getInputPort(nodeFrom.getObject());
            link.setLinkSupportedValidation(false);
            ((PFDLink)link).setFromPort(portOutputFrom);
            ((PFDLink)link).setToPort(portInputTo);
            link.setLinkSupportedValidation(true);
            if (link instanceof IControlLink) {
                // empty if block
            }
            this.addLink((PFDLink)link);
            if (nodeFrom.getObject() instanceof IWorkTable && nodeTo instanceof IDataTransformNode && this.getNode(((IWorkTableNode)nodeFrom).getTransformNodeId()) != null) {
                ((IDataTransformNode)this.getNode(((IWorkTableNode)nodeFrom).getTransformNodeId())).updateCollapsedLinks();
            }
            if (!(nodeTo.getObject() instanceof IWorkTable) || !(nodeFrom instanceof IDataTransformNode)) continue;
            ((IDataTransformNode)nodeFrom).updateCollapsedLinks();
            ((PFDLink)link).setDraggable(false);
            ((PFDLink)link).setSelectable(false);
            ((IDataTransformNode)nodeFrom).updateCollapsedLinks();
        }
        return true;
    }

    protected void addLinks() {
        this.addLinksFromXML();
        this.createLinksNotExistingInXML();
    }

    protected boolean addNodes() {
        boolean bOneAdded;
        this.m_bIncrementLocation = bOneAdded = this.addNodesFromXML();
        bOneAdded = this.createNodesNotExistingInXML();
        return bOneAdded;
    }

    protected void createLinksNotExistingInXML() {
    }

    protected boolean addNodesFromXML() {
        return false;
    }

    protected boolean createNodesNotExistingInXML() {
        return false;
    }

    public void putNode(IObject obj, IDiagramNode node) {
        this.putObjectShape(obj, node);
        this.m_mapNodes.put(node.getId(), node);
    }

    protected void setIgnoreDeletedNodes(boolean bIgnoreDeletedNodes) {
        this.m_bIgnoreDeletedNodes = bIgnoreDeletedNodes;
    }

    protected boolean getIgnoreDeletedNodes() {
        return this.m_bIgnoreDeletedNodes;
    }

    protected void setFirstOpen(boolean bFirstOpen) {
        this.m_bFirstOpen = bFirstOpen;
    }

    protected boolean getFirstOpen() {
        return this.m_bFirstOpen;
    }

    protected void setIgnoreEvents(boolean bIgnoreEvents) {
        this.m_bIgnoreEvents = bIgnoreEvents;
    }

    public boolean isIgnoreEvents() {
        return this.m_bIgnoreEvents;
    }

    protected void setDiagramXML(String sDiagramXML) {
        this.m_sDiagramXML = sDiagramXML;
    }

    protected String getDiagramXML() {
        return this.m_sDiagramXML;
    }

    protected List getDeletedNodes(IObject obj) {
        if (obj == null) {
            return null;
        }
        return (ArrayList)this.m_mapDeletedNodes.get(obj.getID());
    }

    protected IDiagramStickyNote getDeletedStickyNote(String sId) {
        if (sId == null) {
            return null;
        }
        return (IDiagramStickyNote)this.m_mapDeletedNodes.get(sId);
    }

    public void removeDeletedNode(IObject obj, IDiagramNode node) {
        if (obj == null || node == null) {
            return;
        }
        ArrayList nodes = (ArrayList)this.m_mapDeletedNodes.get(obj.getID());
        if (nodes == null || nodes.indexOf(node) == -1) {
            return;
        }
        nodes.remove(nodes.indexOf(node));
        if (nodes.isEmpty()) {
            this.m_mapDeletedNodes.remove(obj.getID());
        } else {
            this.m_mapDeletedNodes.put(obj.getID(), nodes);
        }
    }

    protected void putDeletedNode(IObject obj, IDiagramNode node) {
        if (obj == null || node == null) {
            return;
        }
        ArrayList<IDiagramNode> deletedNodes = (ArrayList<IDiagramNode>)this.m_mapDeletedNodes.get(obj.getID());
        if (deletedNodes == null) {
            deletedNodes = new ArrayList<IDiagramNode>();
        } else {
            this.m_mapDeletedNodes.remove(obj.getID());
        }
        if (deletedNodes.indexOf(node) == -1) {
            deletedNodes.add(node);
        }
        this.m_mapDeletedNodes.put(obj.getID(), deletedNodes);
    }

    public boolean containsInDeletedNodes(String objId) {
        return this.m_mapDeletedNodes.containsKey(objId);
    }

    protected void putDeletedStickyNote(IDiagramStickyNote note) {
        if (note == null) {
            return;
        }
        if (!this.containsInDeletedStickyNotes(note.getId())) {
            this.m_mapDeletedStickyNotes.put(note.getId(), note);
        }
    }

    public boolean containsInDeletedStickyNotes(String Id) {
        return this.m_mapDeletedStickyNotes.containsKey(Id);
    }

    protected IDiagramNode getLastNodeAdded() {
        return this.m_lastNodeAdded;
    }

    protected List getObjectShapes(IObject obj, String type) {
        if (obj == null) {
            return null;
        }
        ArrayList shapes = (ArrayList)this.m_mapObjectShapes.get(obj);
        if (shapes != null) {
            ArrayList<IDiagramPersistable> nodes = new ArrayList<IDiagramPersistable>();
            ArrayList<IDiagramPersistable> links = new ArrayList<IDiagramPersistable>();
            if (shapes != null) {
                for (int iShape = 0; iShape < shapes.size(); ++iShape) {
                    IDiagramPersistable shape = (IDiagramPersistable)shapes.get(iShape);
                    if (shape instanceof IDiagramNode) {
                        nodes.add(shape);
                    }
                    if (!(shape instanceof IDiagramLink)) continue;
                    links.add(shape);
                }
            }
            if (type.equals(DIAGRAM_NODES)) {
                return nodes;
            }
            if (type.equals(DIAGRAM_LINKS)) {
                return links;
            }
            return (ArrayList)this.m_mapObjectShapes.values();
        }
        return null;
    }

    protected void removeObjectShape(IObject obj, IDiagramPersistable shape) {
        if (obj == null || shape == null) {
            return;
        }
        ArrayList shapes = (ArrayList)this.m_mapObjectShapes.get(obj);
        if (shapes == null || shapes.indexOf(shape) == -1) {
            return;
        }
        shapes.remove(shapes.indexOf(shape));
        if (shapes.isEmpty()) {
            this.m_mapObjectShapes.remove(obj);
        } else {
            this.m_mapObjectShapes.put(obj, shapes);
        }
    }

    protected void putObjectShape(IObject obj, IDiagramPersistable shape) {
        if (obj == null || shape == null) {
            return;
        }
        ArrayList<IDiagramPersistable> shapes = (ArrayList<IDiagramPersistable>)this.m_mapObjectShapes.get(obj);
        if (shapes == null) {
            shapes = new ArrayList<IDiagramPersistable>();
        } else {
            this.m_mapObjectShapes.remove(obj);
        }
        if (shapes.indexOf(shape) == -1) {
            shapes.add(shape);
        }
        this.m_mapObjectShapes.put(obj, shapes);
        if (obj instanceof JobTransformModel) {
            this.m_mapObjectShapes.put(((JobTransformModel)obj).getInnerJob(), shapes);
        }
    }

    public boolean containsInObjectShapes(IObject obj) {
        return this.m_mapObjectShapes.containsKey(obj);
    }

    protected IDiagramLink getDeletedLink(IDiagramNode fromNode, IDiagramNode toNode, int fromPortIndex, int toPortIndex) {
        ArrayList links = (ArrayList)this.m_mapDeletedLinks.get(fromNode.getId());
        if (links == null) {
            return null;
        }
        for (int iLink = 0; iLink < links.size(); ++iLink) {
            IDiagramLink link = (IDiagramLink)links.get(iLink);
            if (!link.getToNodeId().equals(toNode.getId())) continue;
            if (toPortIndex != -1 && fromPortIndex != -1) {
                if (link.getToNodePortIndex() != toPortIndex || fromPortIndex == -1 || link.getFromNodePortIndex() != fromPortIndex) continue;
                return link;
            }
            return link;
        }
        return null;
    }

    protected IDiagramLink getDeletedLink(IDiagramNode fromNode, IDiagramNode toNode) {
        return this.getDeletedLink(fromNode, toNode, -1, -1);
    }

    protected List getDeletedLinks(IDiagramNode node) {
        ArrayList links = (ArrayList)this.m_mapDeletedLinks.get(node.getId());
        return links;
    }

    protected void putDeletedLink(IDiagramNode node, IDiagramLink link) {
        if (node == null || link == null) {
            return;
        }
        ArrayList<IDiagramLink> links = (ArrayList<IDiagramLink>)this.m_mapDeletedLinks.get(node.getId());
        if (links == null) {
            links = new ArrayList<IDiagramLink>();
        } else {
            this.m_mapDeletedLinks.remove(node.getId());
        }
        if (links.indexOf(link) == -1) {
            links.add(link);
        }
        this.m_mapDeletedLinks.put(node.getId(), links);
    }

    public boolean containsInDeletedLinks(String nodeId) {
        return this.m_mapDeletedLinks.containsKey(nodeId);
    }

    private class AddDataObjectUndoable
    extends AbstractUndoableEdit {
        private IDiagramNode m_node;
        private Point m_location;

        public AddDataObjectUndoable(IDiagramNode node, Point location) {
            this.m_node = node;
            this.m_location = location;
        }

        @Override
        public void undo() {
            super.undo();
            WADiagramModel.this.removeNode(this.m_node.getId());
        }

        @Override
        public void redo() {
            super.redo();
            WADiagramModel.this.addPrimitive((PFDPrimitive)((PFDAbstractNode)this.m_node));
            WADiagramModel.this.putNode(this.m_node.getObject(), this.m_node);
            this.m_node.setLocation(this.m_location.x, this.m_location.y);
        }
    }

    private class SetLinkLocationsUndoable
    extends AbstractUndoableEdit {
        private IDiagramLink m_link;
        private Point[] m_aOldLinkLocation;
        private Point[] m_aNewLinkLocation;

        public SetLinkLocationsUndoable(IDiagramLink link, Point[] aOldLinkLocation, Point[] aNewLinkLocation) {
            this.m_link = link;
            this.m_aOldLinkLocation = aOldLinkLocation;
            this.m_aNewLinkLocation = aNewLinkLocation;
        }

        @Override
        public void undo() {
            super.undo();
            WADiagramModel.this.setLinkLocations(this.m_link, this.m_aNewLinkLocation, this.m_aOldLinkLocation);
        }

        @Override
        public void redo() {
            super.redo();
            WADiagramModel.this.setLinkLocations(this.m_link, this.m_aOldLinkLocation, this.m_aNewLinkLocation);
        }
    }

    private class SetLocationUndoable
    extends AbstractUndoableEdit {
        private IShape m_node;
        private Point m_pOldLocation;
        private Point m_pNewLocation;

        public SetLocationUndoable(IShape node, Point pOldLocation, Point pNewLocation) {
            this.m_node = node;
            this.m_pOldLocation = pOldLocation;
            this.m_pNewLocation = pNewLocation;
        }

        @Override
        public void undo() {
            super.undo();
            WADiagramModel.this.setLocation(this.m_node, this.m_pNewLocation, this.m_pOldLocation);
            if (this.m_node instanceof IDataNode) {
                ((IDataObject)((IDataNode)this.m_node).getObject()).setChangedNodeId(((IDataNode)this.m_node).getId());
            }
        }

        @Override
        public void redo() {
            super.redo();
            WADiagramModel.this.setLocation(this.m_node, this.m_pOldLocation, this.m_pNewLocation);
        }
    }
}

