/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.efi2;

import com.sas.etl.models.IModel;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.IExternalTable;
import com.sas.etl.models.job.ICodeSource;
import com.sas.etl.models.job.IUserWrittenCodeContainer;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.visuals.common.CodePane;
import com.sas.wadmin.visuals.common.SaveAsDialog;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.rmi.RemoteException;

public class UserWrittenExternalTablePanel2
extends WsDescriptionWizardTab {
    private static final WAdminResource bundle = WAdminResource.getBundle(UserWrittenExternalTablePanel2.class);
    private IExternalTable m_mdlTable;
    private CodePane m_pnlSource;
    private boolean m_preserveView;

    public UserWrittenExternalTablePanel2(IExternalTable mdlTable) {
        super(bundle.getString("UserWrittenExternalTablePanel.Description.txt"));
        this.setName(bundle.getString("ExternalFileParametersTab2.Title.txt"));
        this.m_mdlTable = mdlTable;
        this.m_preserveView = false;
        this.setHelpProduct("wdb");
        this.setHelpTopic("source_code_external");
        this.initialize();
    }

    protected void initialize() {
        this.setPreferredSize(new Dimension(500, 400));
        IUserWrittenCodeContainer userWrittenCodeContainer = this.m_mdlTable.getUserWrittenCode();
        this.m_pnlSource = new CodePane(userWrittenCodeContainer);
        this.m_pnlSource.setCodeSource(null, userWrittenCodeContainer, true, true);
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.m_pnlSource), "Center");
    }

    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        if (!bSaveToModel) {
            this.moveDataToView();
        } else {
            this.moveDataToStore();
        }
        return true;
    }

    public void onNext() {
        try {
            this.moveDataToStore();
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public void onBack() {
        this.m_preserveView = true;
    }

    public void populateStore() throws MdException, RemoteException {
    }

    public void moveDataToView() throws MdException, RemoteException {
        if (this.m_preserveView) {
            return;
        }
        this.setListeningForChanges(false);
        this.readUserWrittenCode();
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.m_preserveView = false;
        this.saveUserWrittenCode();
    }

    private void saveUserWrittenCode() {
        OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace(), bundle.getString("UserWrittenExternalTablePanel2.Saving.msg.txt"), bundle.getString("UserWrittenExternalTablePanel2.Saving.Title.txt"));
        request.setDelayBeforeProgressCancelDialog(0);
        request.setProgressShownOnStatusBar(false);
        cSaveCodeRunnable runnable = new cSaveCodeRunnable();
        request.execute((Runnable)runnable);
    }

    private void readUserWrittenCode() {
        OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace(), bundle.getString("UserWrittenExternalTablePanel2.Reading.msg.txt"), bundle.getString("UserWrittenExternalTablePanel2.Reading.Title.txt"));
        request.setDelayBeforeProgressCancelDialog(0);
        request.setProgressShownOnStatusBar(false);
        cReadCodeRunnable runnable = new cReadCodeRunnable();
        request.execute((Runnable)runnable);
        this.m_pnlSource.setText(runnable.getLoadedCode());
    }

    public boolean validateData() {
        return this.m_pnlSource.validateData();
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_pnlSource.setEditable(bEditable);
    }

    public void saveSettingsAndCleanUp() {
        this.m_pnlSource.saveSettingsAndCleanUp();
        super.saveSettingsAndCleanUp();
    }

    private class cReadCodeRunnable
    implements Runnable {
        private String m_sCode = "";

        @Override
        public void run() {
            IUserWrittenCodeContainer uw = UserWrittenExternalTablePanel2.this.m_mdlTable.getUserWrittenCode();
            try {
                this.m_sCode = uw.getCode();
            }
            catch (ServerException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            }
        }

        public String getLoadedCode() {
            return this.m_sCode;
        }
    }

    private class cSaveCodeRunnable
    implements Runnable {
        private cSaveCodeRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            IUserWrittenCodeContainer uw = UserWrittenExternalTablePanel2.this.m_mdlTable.getUserWrittenCode();
            ICodeSource codeSource = uw.getUserWrittenSourceCode();
            IModel model = UserWrittenExternalTablePanel2.this.m_mdlTable.getModel();
            model.startCompoundUndoable();
            try {
                if (!UserWrittenExternalTablePanel2.this.m_mdlTable.getUserWrittenCode().isFile()) {
                    codeSource = uw.createUserWrittenSourceCodeText(SaveAsDialog.DEFAULT_METADATA_NAME);
                }
                try {
                    codeSource.setCode(UserWrittenExternalTablePanel2.this.m_pnlSource.getText());
                }
                catch (ServerException e) {
                    MessageUtil.displayMessage((String)e.getLocalizedMessage());
                }
            }
            finally {
                model.endCompoundUndoable();
            }
        }
    }
}

