/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.efi2;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ExternalTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.Tree;
import com.sas.services.information.metadata.OMRExternalFile;
import com.sas.wadmin.efi2.ExternalTableDataModel;
import com.sas.wadmin.visuals.SourceCodePanel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.metadata.EFIDataModel;
import com.sas.workspace.visuals.WAGeneralPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.rmi.RemoteException;

public class UserWrittenExternalTablePanel
extends WsDescriptionWizardTab {
    private static final WAdminResource bundle = WAdminResource.getBundle(UserWrittenExternalTablePanel.class);
    private EFIDataModel m_mdlTable;
    private SourceCodePanel m_pnlSource;
    private boolean m_preserveView;

    public UserWrittenExternalTablePanel(EFIDataModel mdlTable) {
        super(bundle.getString("UserWrittenExternalTablePanel.Description.txt"));
        this.m_mdlTable = mdlTable;
        this.m_preserveView = false;
        this.setHelpProduct("wdb");
        this.setHelpTopic("source_code_external");
        this.initialize();
    }

    protected void initialize() {
        this.m_pnlSource = new SourceCodePanel(bundle.getString("UserWrittenExternalTablePanel.MetadataSourceCodeName.txt"), bundle.getString("UserWrittenExternalTablePanel.MetadataSourceCodeDescription.txt"));
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.m_pnlSource), "Center");
    }

    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        if (!bSaveToModel) {
            WAWizardDialog dlgWizard = (WAWizardDialog)this.getTopLevelAncestor();
            MdObjectStore store = (MdObjectStore)dlgWizard.getWizardData("OBJECTSTORE");
            WAGeneralPanel panel = (WAGeneralPanel)dlgWizard.getWizardData("GENERALPANEL");
            Tree mdoFolder = panel.getOwningTree();
            dlgWizard.addWizardData("GROUP", (Object)mdoFolder);
            if (dlgWizard.getWizardData("MASTEROBJECT") == null) {
                String sContainerID = null;
                sContainerID = Workspace.getWorkspace().isChangeManagementOn() ? Workspace.getWorkspace().getDefaultRepository().getFQID().substring(9, 17) : mdoFolder.getFQID().substring(0, 8);
                ExternalTable table = (ExternalTable)Workspace.getMdFactory().createComplexMetadataObject(store, panel.getNameComponent().getText(), "ExternalTable", sContainerID);
                table.setDesc(panel.getDescriptionComponent().getText());
                table.setPublicType("ExternalFile");
                table.setUsageVersion(OMRExternalFile.CURRENT_VERSION.encode());
                table.getTrees().add((Object)mdoFolder);
                this.m_mdlTable = (ExternalTableDataModel)((Object)dlgWizard.getWizardData("EFIDATAMODEL"));
                this.m_mdlTable.setCreateNewTable(true);
                this.m_mdlTable.setExternalTable(table);
                this.m_mdlTable.setUserWritten(true);
                dlgWizard.addWizardData("MASTEROBJECT", (Object)table);
                dlgWizard.addWizardData("IDTOMAKEOBJECTSIN", (Object)sContainerID);
                this.m_pnlSource.setFQIDofRepositoryToMakeTheObjectIn(sContainerID);
            } else {
                ExternalTable oldtable = (ExternalTable)dlgWizard.getWizardData("MASTEROBJECT");
                if (!Workspace.getWorkspace().isChangeManagementOn()) {
                    String sTableRepositoryID;
                    String sTreeRepositoryID = mdoFolder.getFQID().substring(0, 8);
                    if (!sTreeRepositoryID.equalsIgnoreCase(sTableRepositoryID = oldtable.getFQID().substring(0, 8))) {
                        store.clearObjectsFromStore();
                        ExternalTable newtable = (ExternalTable)Workspace.getMdFactory().createComplexMetadataObject(store, panel.getNameComponent().getText(), "ExternalTable", sTreeRepositoryID);
                        newtable.setPublicType("ExternalFile");
                        newtable.setUsageVersion(OMRExternalFile.CURRENT_VERSION.encode());
                        newtable.getTrees().add((Object)mdoFolder);
                        this.m_mdlTable = (ExternalTableDataModel)((Object)dlgWizard.getWizardData("EFIDATAMODEL"));
                        this.m_mdlTable.setCreateNewTable(true);
                        this.m_mdlTable.setExternalTable(newtable);
                        dlgWizard.addWizardData("MASTEROBJECT", (Object)newtable);
                        dlgWizard.addWizardData("IDTOMAKEOBJECTSIN", (Object)sTreeRepositoryID);
                        this.m_pnlSource.setFQIDofRepositoryToMakeTheObjectIn(sTreeRepositoryID);
                        oldtable = newtable;
                    } else {
                        String strExistingOwningTree;
                        String strNewOwningTree = panel.getOwningTree().getFQID();
                        if (strNewOwningTree != (strExistingOwningTree = ((Tree)oldtable.getTrees().get(0)).getFQID())) {
                            oldtable.getTrees().removeAllElements();
                            oldtable.getTrees().add((Object)panel.getOwningTree());
                        }
                    }
                } else {
                    String strExistingOwningTree;
                    String strNewOwningTree = panel.getOwningTree().getFQID();
                    if (strNewOwningTree != (strExistingOwningTree = ((Tree)oldtable.getTrees().get(0)).getFQID())) {
                        oldtable.getTrees().removeAllElements();
                        oldtable.getTrees().add((Object)panel.getOwningTree());
                    }
                }
                oldtable.setName(panel.getNameComponent().getText());
                oldtable.setDesc(panel.getDescriptionComponent().getText());
            }
            this.moveDataToView();
        } else {
            this.moveDataToStore();
        }
        return true;
    }

    public void onNext() {
        try {
            this.moveDataToStore();
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public void onBack() {
        this.m_preserveView = true;
    }

    public void populateStore() throws MdException, RemoteException {
        this.m_mdlTable.populateStore();
    }

    public void moveDataToView() throws MdException, RemoteException {
        if (this.m_preserveView) {
            return;
        }
        this.setListeningForChanges(false);
        this.m_pnlSource.setMetadataStore((MdObjectStore)this.m_mdlTable.getExternalTable().getObjectStore());
        Text text = this.m_mdlTable.getUserWrittenSourceCodeText();
        if (text != null) {
            this.m_pnlSource.setMetadataObject((CMetadata)text);
        }
        this.m_pnlSource.doDataExchange(false);
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.m_preserveView = false;
        Text text = this.m_mdlTable.getUserWrittenSourceCodeText();
        this.m_pnlSource.doDataExchange(true);
        text = this.m_pnlSource.getTextObject();
        this.m_mdlTable.setUserWrittenSourceCodeText(text);
    }

    public boolean validateData() {
        return this.m_pnlSource.validateData();
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_pnlSource.setEditable(bEditable);
    }
}

