/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.efi2;

import com.sas.wadmin.efi2.TextRowHeader;
import com.sas.workspace.Workspace;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.BadLocationException;

public class TextRowHeaderUI
extends ComponentUI {
    private TextRowHeader m_header;
    private MouseInputListener m_lsnrMouse;
    private DocumentListener m_lsnrDocument;
    private Border m_brdrCell;

    public static ComponentUI createUI(JComponent c) {
        return new TextRowHeaderUI();
    }

    @Override
    public void installUI(JComponent cmp) {
        this.m_header = (TextRowHeader)cmp;
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        LookAndFeel.installColors(this.m_header, "TableHeader.background", "TableHeader.foreground");
        this.m_brdrCell = UIManager.getBorder("TableHeader.cellBorder");
        this.m_header.setOpaque(true);
        this.m_header.setFont(this.m_header.getTextComponent().getFont());
    }

    protected void installListeners() {
        this.m_lsnrMouse = this.createMouseInputListener();
        this.m_header.addMouseListener(this.m_lsnrMouse);
        this.m_header.addMouseMotionListener(this.m_lsnrMouse);
        this.m_lsnrDocument = new cDocumentListener();
        this.m_header.getTextComponent().getDocument().addDocumentListener(this.m_lsnrDocument);
    }

    protected MouseInputListener createMouseInputListener() {
        return new cMouseInputHandler();
    }

    protected DocumentListener createDocumentListener() {
        return new cDocumentListener();
    }

    protected void installKeyboardActions() {
    }

    @Override
    public void uninstallUI(JComponent cmp) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.m_header = null;
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallListeners() {
        this.m_header.removeMouseListener(this.m_lsnrMouse);
        this.m_header.removeMouseMotionListener(this.m_lsnrMouse);
        this.m_lsnrMouse = null;
    }

    protected void uninstallKeyboardActions() {
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.m_header.getTextComponent().getText().length() == 0) {
            return;
        }
        Rectangle rBounds = this.m_header.getBounds();
        g.setColor(this.m_header.getForeground());
        g.setFont(this.m_header.getFont());
        FontMetrics fm = g.getFontMetrics();
        int nRows = this.m_header.getTextComponent().getLineCount();
        int yCell = 0;
        for (int iRow = 0; iRow < nRows; ++iRow) {
            this.m_brdrCell.paintBorder(c, g, 0, yCell, rBounds.width, fm.getHeight());
            String sLabel = Integer.toString(iRow + this.m_header.getRowOffset());
            int xLabel = (rBounds.width - fm.stringWidth(sLabel)) / 2;
            int yLabel = yCell + fm.getLeading() + fm.getAscent();
            g.drawString(sLabel, xLabel, yLabel);
            yCell += fm.getHeight() + fm.getLeading();
        }
    }

    private void selectLine(int iLine) {
        try {
            JTextArea txt = this.m_header.getTextComponent();
            int iStart = txt.getLineStartOffset(iLine);
            int iEnd = txt.getLineEndOffset(iLine);
            txt.setCaretPosition(iEnd);
            txt.moveCaretPosition(iStart);
        }
        catch (BadLocationException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        }
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        FontMetrics fm = this.m_header.getFontMetrics(this.m_header.getFont());
        String sLabel = Integer.toString(this.m_header.getTextComponent().getLineCount() + this.m_header.getRowOffset());
        Insets insBorder = this.m_brdrCell.getBorderInsets(c);
        return new Dimension(fm.stringWidth(sLabel) + insBorder.left + insBorder.right + 6, this.m_header.getTextComponent().getPreferredSize().height);
    }

    private int getRowAt(int y) {
        if (y < 0 || y > this.m_header.getHeight()) {
            return -1;
        }
        FontMetrics fm = this.m_header.getFontMetrics(this.m_header.getFont());
        int cyFont = fm.getHeight() + fm.getLeading();
        int iRow = y / cyFont;
        if (iRow < this.m_header.getTextComponent().getLineCount()) {
            return iRow;
        }
        return -1;
    }

    private class cDocumentListener
    implements DocumentListener {
        private int m_nRememberedLines;

        private cDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        private void update() {
            int nLines = TextRowHeaderUI.this.m_header.getTextComponent().getLineCount();
            if (nLines != this.m_nRememberedLines) {
                TextRowHeaderUI.this.m_header.revalidate();
                TextRowHeaderUI.this.m_header.repaint();
            }
        }
    }

    protected class cMouseInputHandler
    extends MouseInputAdapter {
        protected cMouseInputHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TextRowHeaderUI.this.m_header.getTextComponent().requestFocus();
            int iRow = TextRowHeaderUI.this.getRowAt(e.getY());
            if (iRow != -1) {
                TextRowHeaderUI.this.selectLine(iRow);
            }
        }
    }
}

