/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.efi2;

import com.sas.wadmin.efi2.TextColumnModelEvent;
import com.sas.wadmin.efi2.TextColumnModelListener;
import javax.swing.event.EventListenerList;

public class TextColumnModel {
    private int[] m_aBegins = new int[8];
    private int[] m_aEnds = new int[8];
    private int m_nColumns = 0;
    private EventListenerList m_lListeners = new EventListenerList();

    public void insertColumn(int iBeforeColumn, int begin, int end) {
        this.ensureCapacity(this.m_nColumns + 1);
        System.arraycopy(this.m_aBegins, iBeforeColumn, this.m_aBegins, iBeforeColumn + 1, this.m_nColumns - iBeforeColumn);
        System.arraycopy(this.m_aEnds, iBeforeColumn, this.m_aEnds, iBeforeColumn + 1, this.m_nColumns - iBeforeColumn);
        this.m_aBegins[iBeforeColumn] = begin;
        this.m_aEnds[iBeforeColumn] = end;
        ++this.m_nColumns;
        this.fireColumnInserted(iBeforeColumn, begin, end);
    }

    private void ensureCapacity(int nColumns) {
        if (nColumns > this.m_aEnds.length) {
            int nNewColumns = Math.max(this.m_aBegins.length * 2, nColumns);
            int[] aNewBegins = new int[nNewColumns];
            int[] aNewEnds = new int[nNewColumns];
            System.arraycopy(this.m_aBegins, 0, aNewBegins, 0, this.m_nColumns);
            System.arraycopy(this.m_aEnds, 0, aNewEnds, 0, this.m_nColumns);
            this.m_aBegins = aNewBegins;
            this.m_aEnds = aNewEnds;
        }
    }

    public void deleteColumn(int iColumn) {
        this.validateIndex(iColumn);
        int begin = this.m_aBegins[iColumn];
        int end = this.m_aEnds[iColumn];
        --this.m_nColumns;
        System.arraycopy(this.m_aBegins, iColumn + 1, this.m_aBegins, iColumn, this.m_nColumns - iColumn);
        System.arraycopy(this.m_aEnds, iColumn + 1, this.m_aEnds, iColumn, this.m_nColumns - iColumn);
        this.fireColumnDeleted(iColumn, begin, end);
    }

    public void updateColumnBegin(int iColumn, int begin) {
        this.validateIndex(iColumn);
        int oldBegin = this.m_aBegins[iColumn];
        int oldEnd = this.m_aEnds[iColumn];
        this.m_aBegins[iColumn] = begin;
        this.fireColumnUpdated(iColumn, oldBegin, oldEnd, begin, oldEnd);
    }

    public void updateColumnEnd(int iColumn, int end) {
        this.validateIndex(iColumn);
        int oldBegin = this.m_aBegins[iColumn];
        int oldEnd = this.m_aEnds[iColumn];
        this.m_aEnds[iColumn] = end;
        this.fireColumnUpdated(iColumn, oldBegin, oldEnd, oldBegin, end);
    }

    public void updateColumn(int iColumn, int begin, int end) {
        this.validateIndex(iColumn);
        int oldBegin = this.m_aBegins[iColumn];
        int oldEnd = this.m_aEnds[iColumn];
        this.m_aBegins[iColumn] = begin;
        this.m_aEnds[iColumn] = end;
        this.fireColumnUpdated(iColumn, oldBegin, oldEnd, begin, end);
    }

    public int getColumnCount() {
        return this.m_nColumns;
    }

    public int getColumnBegin(int iColumn) {
        this.validateIndex(iColumn);
        return this.m_aBegins[iColumn];
    }

    public int getColumnEnd(int iColumn) {
        this.validateIndex(iColumn);
        return this.m_aEnds[iColumn];
    }

    private void validateIndex(int iColumn) {
        if (iColumn < 0) {
            throw new IndexOutOfBoundsException("Column index out of bounds: " + iColumn + "<0");
        }
        if (iColumn >= this.m_nColumns) {
            throw new IndexOutOfBoundsException("Column index out of bounds: " + iColumn + ">=" + this.m_nColumns);
        }
    }

    public void addModelListener(TextColumnModelListener lsnr) {
        this.m_lListeners.add(TextColumnModelListener.class, lsnr);
    }

    public void removeModelListener(TextColumnModelListener lsnr) {
        this.m_lListeners.remove(TextColumnModelListener.class, lsnr);
    }

    private void fireColumnInserted(int iColumn, int begin, int end) {
        TextColumnModelEvent e = new TextColumnModelEvent(this, iColumn, begin, end);
        Object[] aListeners = this.m_lListeners.getListenerList();
        for (int iListener = aListeners.length - 2; iListener >= 0; iListener -= 2) {
            if (aListeners[iListener] != TextColumnModelListener.class) continue;
            ((TextColumnModelListener)aListeners[iListener + 1]).textColumnInserted(e);
        }
    }

    private void fireColumnUpdated(int iColumn, int oldBegin, int oldEnd, int newBegin, int newEnd) {
        TextColumnModelEvent e = new TextColumnModelEvent(this, iColumn, oldBegin, oldEnd, newBegin, newEnd);
        Object[] aListeners = this.m_lListeners.getListenerList();
        for (int iListener = aListeners.length - 2; iListener >= 0; iListener -= 2) {
            if (aListeners[iListener] != TextColumnModelListener.class) continue;
            ((TextColumnModelListener)aListeners[iListener + 1]).textColumnUpdated(e);
        }
    }

    private void fireColumnDeleted(int iColumn, int begin, int end) {
        TextColumnModelEvent e = new TextColumnModelEvent(this, iColumn, begin, end);
        Object[] aListeners = this.m_lListeners.getListenerList();
        for (int iListener = aListeners.length - 2; iListener >= 0; iListener -= 2) {
            if (aListeners[iListener] != TextColumnModelListener.class) continue;
            ((TextColumnModelListener)aListeners[iListener + 1]).textColumnDeleted(e);
        }
    }

    public void dump() {
        for (int iColumn = 0; iColumn < this.m_nColumns; ++iColumn) {
            System.out.println(iColumn + ":" + this.m_aBegins[iColumn] + "-" + this.m_aEnds[iColumn]);
        }
    }
}

