/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.efi2;

import com.sas.wadmin.efi2.TextColumnHeader;
import com.sas.wadmin.efi2.TextColumnModel;
import com.sas.wadmin.efi2.TextColumnModelEvent;
import com.sas.wadmin.efi2.TextColumnModelListener;
import com.sas.wadmin.efi2.TextOrigin;
import com.sas.wadmin.efi2.TextRowHeader;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WsTextComponentAdapter;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.JTextComponent;

public class TextArea
extends WATextArea {
    private TextColumnHeader m_hdrColumn;
    private TextRowHeader m_hdrRow;
    private TextOrigin m_hdrOrigin;

    public TextArea() {
    }

    public TextArea(int nRows, int nColumns) {
        super(nRows, nColumns);
    }

    protected void initialize() {
        this.setFont(new Font("Monospaced", 0, this.getFont().getSize()));
        this.m_adapter = new WsTextComponentAdapter((JTextComponent)((Object)this));
        this.setColumnHeader(this.createColumnHeader());
        this.setRowHeader(this.createRowHeader());
        this.setOrigin(this.createOriginHeader());
        this.setUI((TextUI)((Object)new cBasicTextAreaUI()));
        this.setAutoSelect(false);
    }

    protected TextColumnHeader createColumnHeader() {
        return new TextColumnHeader((JTextComponent)((Object)this));
    }

    protected TextRowHeader createRowHeader() {
        return new TextRowHeader((JTextArea)((Object)this));
    }

    protected TextOrigin createOriginHeader() {
        return new TextOrigin((JTextComponent)((Object)this));
    }

    public void setColumnHeader(TextColumnHeader hdr) {
        this.m_hdrColumn = hdr;
    }

    public TextColumnHeader getColumnHeader() {
        return this.m_hdrColumn;
    }

    public void setRowHeader(TextRowHeader hdr) {
        this.m_hdrRow = hdr;
    }

    public TextRowHeader getRowHeader() {
        return this.m_hdrRow;
    }

    public void setOrigin(TextOrigin hdr) {
        this.m_hdrOrigin = hdr;
    }

    public TextOrigin getOrigin() {
        return this.m_hdrOrigin;
    }

    public void addNotify() {
        super.addNotify();
        this.configureEnclosingScrollPane();
    }

    public void removeNotify() {
        this.unconfigureEnclosingScrollPane();
        super.removeNotify();
    }

    private JScrollPane getScrollPane() {
        Container cmpGrandParent;
        Container cmpParent = this.getParent();
        if (cmpParent instanceof JViewport && (cmpGrandParent = cmpParent.getParent()) instanceof JScrollPane) {
            return (JScrollPane)cmpGrandParent;
        }
        return null;
    }

    public void configureEnclosingScrollPane() {
        JScrollPane scr = this.getScrollPane();
        if (scr != null) {
            scr.setRowHeaderView(this.getRowHeader());
            scr.setColumnHeaderView(this.getColumnHeader());
            scr.setCorner("UPPER_LEFT_CORNER", this.getOrigin());
        }
    }

    private void unconfigureEnclosingScrollPane() {
        JScrollPane scr = this.getScrollPane();
        if (scr != null) {
            scr.setRowHeaderView(null);
            scr.setColumnHeaderView(null);
        }
    }

    protected static class cBasicTextAreaUI
    extends WATextArea.cBasicTextAreaUI {
        private TextColumnModelListener m_lsnrColumnModel;
        private ListSelectionListener m_lsnrColumnSelection;
        private MouseListener m_lsnrMouse;

        protected cBasicTextAreaUI() {
        }

        protected void installListeners() {
            super.installListeners();
            this.m_lsnrColumnModel = this.createColumnModelListener();
            this.m_lsnrColumnSelection = this.createColumnSelectionListener();
            this.m_lsnrMouse = this.createMouseListener();
            this.getTextArea().addMouseListener(this.m_lsnrMouse);
            TextColumnHeader hdr = this.getTextArea().getColumnHeader();
            hdr.getModel().addModelListener(this.m_lsnrColumnModel);
            hdr.getSelectionModel().addListSelectionListener(this.m_lsnrColumnSelection);
        }

        protected void uninstallListeners() {
            this.getTextArea().removeMouseListener(this.m_lsnrMouse);
            TextColumnHeader hdr = this.getTextArea().getColumnHeader();
            hdr.getModel().removeModelListener(this.m_lsnrColumnModel);
            hdr.getSelectionModel().removeListSelectionListener(this.m_lsnrColumnSelection);
        }

        protected TextColumnModelListener createColumnModelListener() {
            return new cTextColumnModelListener();
        }

        protected ListSelectionListener createColumnSelectionListener() {
            return new cTextColumnSelectionListener();
        }

        protected MouseListener createMouseListener() {
            return new cMouseListener();
        }

        private TextArea getTextArea() {
            return (TextArea)((Object)this.getComponent());
        }

        protected void paintSafely(Graphics g) {
            super.paintSafely(g);
            TextArea txt = (TextArea)((Object)this.getComponent());
            TextColumnModel mdl = txt.getColumnHeader().getModel();
            FontMetrics fm = g.getFontMetrics();
            g.setColor(txt.getForeground());
            int cxChar = fm.charWidth('W');
            int yBottom = txt.getHeight() - 1;
            for (int iColumn = 0; iColumn < mdl.getColumnCount(); ++iColumn) {
                int x = cxChar * (mdl.getColumnBegin(iColumn) - 1);
                g.drawLine(x, 0, x, yBottom);
                x = cxChar * mdl.getColumnEnd(iColumn);
                g.drawLine(x, 0, x, yBottom);
            }
        }

        protected void paintBackground(Graphics g) {
            super.paintBackground(g);
            TextArea cmp = this.getTextArea();
            TextColumnHeader hdr = cmp.getColumnHeader();
            TextColumnModel mdl = hdr.getModel();
            ListSelectionModel mdlSelection = hdr.getSelectionModel();
            float[] rgbControl = new float[3];
            float[] rgbText = new float[3];
            SystemColor.control.getColorComponents(rgbControl);
            SystemColor.text.getColorComponents(rgbText);
            Color clrBackground = new Color((rgbControl[0] + rgbText[0]) / 2.0f, (rgbControl[1] + rgbText[1]) / 2.0f, (rgbControl[2] + rgbText[2]) / 2.0f);
            g.setColor(clrBackground);
            FontMetrics fm = cmp.getFontMetrics(cmp.getFont());
            int cxChar = fm.charWidth('W');
            for (int iColumn = mdlSelection.getMinSelectionIndex(); iColumn <= mdlSelection.getMaxSelectionIndex(); ++iColumn) {
                if (!mdlSelection.isSelectedIndex(iColumn)) continue;
                int begin = mdl.getColumnBegin(iColumn);
                int end = mdl.getColumnEnd(iColumn);
                int x = (begin - 1) * cxChar + 1;
                int w = (end - begin + 1) * cxChar - 1;
                g.fillRect(x, 0, w, cmp.getHeight());
            }
        }

        protected class cMouseListener
        extends MouseAdapter {
            protected cMouseListener() {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                TextArea cmp = cBasicTextAreaUI.this.getTextArea();
                TextColumnModel mdl = cmp.getColumnHeader().getModel();
                ListSelectionModel mdlSelection = cmp.getColumnHeader().getSelectionModel();
                FontMetrics fm = cmp.getFontMetrics(cmp.getFont());
                int cxChar = fm.charWidth('W');
                int position = (e.getX() + cxChar - 1) / cxChar;
                for (int iColumn = 0; iColumn < mdl.getColumnCount(); ++iColumn) {
                    if (mdl.getColumnBegin(iColumn) > position || position > mdl.getColumnEnd(iColumn)) continue;
                    if ((e.getModifiers() & 2) == 2) {
                        if (mdlSelection.isSelectedIndex(iColumn)) {
                            mdlSelection.removeSelectionInterval(iColumn, iColumn);
                        } else {
                            mdlSelection.addSelectionInterval(iColumn, iColumn);
                        }
                    } else if ((e.getModifiers() & 1) == 1) {
                        int iAnchor = mdlSelection.getAnchorSelectionIndex();
                        if (!mdlSelection.isSelectedIndex(iAnchor)) {
                            iAnchor = iColumn;
                        }
                        mdlSelection.setSelectionInterval(iAnchor, iColumn);
                    } else {
                        mdlSelection.setSelectionInterval(iColumn, iColumn);
                    }
                    return;
                }
                mdlSelection.clearSelection();
            }
        }

        protected class cTextColumnSelectionListener
        implements ListSelectionListener {
            protected cTextColumnSelectionListener() {
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                cBasicTextAreaUI.this.getTextArea().repaint();
            }
        }

        protected class cTextColumnModelListener
        implements TextColumnModelListener {
            protected cTextColumnModelListener() {
            }

            @Override
            public void textColumnInserted(TextColumnModelEvent e) {
                this.repaint(e.getBegin(), e.getEnd());
            }

            @Override
            public void textColumnUpdated(TextColumnModelEvent e) {
                this.repaint(e.getOldBegin(), e.getOldEnd());
                this.repaint(e.getNewBegin(), e.getNewEnd());
            }

            @Override
            public void textColumnDeleted(TextColumnModelEvent e) {
                this.repaint(e.getBegin(), e.getEnd());
            }

            private void repaint(int begin, int end) {
                TextArea cmp = cBasicTextAreaUI.this.getTextArea();
                FontMetrics fm = cmp.getFontMetrics(cmp.getFont());
                int cxChar = fm.charWidth('W');
                int x = (begin - 1) * cxChar;
                cmp.repaint(x, 0, 1, cmp.getHeight());
                x = end * cxChar;
                cmp.repaint(x, 0, 1, cmp.getHeight());
            }
        }
    }
}

