/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.efi2;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.efi2.ColumnDefinitionsPanel;
import com.sas.wadmin.efi2.DelimitedExternalTablePanel;
import com.sas.wadmin.efi2.EFIWizardFinishTab;
import com.sas.wadmin.efi2.ExternalFileLocationPanel;
import com.sas.wadmin.efi2.ExternalTableDataModel;
import com.sas.wadmin.plugins.NewObjectInterface;
import com.sas.wadmin.visuals.SASImporter;
import com.sas.wadmin.visuals.WAGeneralWizardPanel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATransitionWizardModel;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.metadata.WsMetadataNameUtil;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.visuals.WAGeneralPanel;
import java.rmi.RemoteException;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class NewDelimitedExternalTableWizard
extends SASImporter
implements NewObjectInterface {
    private WAdminResource bundle = WAdminResource.getBundle(NewDelimitedExternalTableWizard.class);
    private static final String FileLocationPanel = "DelimitedFileLocationPanel";
    private static final String DelimitedPanel = "DelimitedPanel";
    private static final String ColumnsPanel = "ColumnDefinitionsPanel";
    private static final String GeneralPanel = "GeneralPanel";
    private static final String FinishPanel = "FinishPanel";
    private SimpleObject m_folder = null;
    private boolean m_bInitialized = false;

    public NewDelimitedExternalTableWizard() {
        this(null);
    }

    public NewDelimitedExternalTableWizard(SimpleObject folder) {
        this.m_folder = folder;
    }

    @Override
    public boolean initializeWizard(WAWizardDialog dlgWizard, WATransitionWizardModel mdlWizard) {
        try {
            if (this.m_bInitialized) {
                return true;
            }
            MdObjectStore store = (MdObjectStore)dlgWizard.getWizardData("OBJECTSTORE");
            Tree defaultFolder = null;
            if (this.m_folder != null) {
                defaultFolder = (Tree)ObjectConverter.getInstance().convertToJOMAObject(store, this.m_folder);
            }
            if (defaultFolder == null) {
                try {
                    defaultFolder = WsMetadataUtil.getDefaultFolder((MdObjectStore)store);
                }
                catch (ServiceException e) {
                    MessageUtil.displayServiceExceptionMessage((ServiceException)e);
                }
            }
            ExternalTableDataModel mdlTable = new ExternalTableDataModel();
            mdlTable.setEFIType(1);
            dlgWizard.addWizardData("EFIDATAMODEL", (Object)mdlTable);
            dlgWizard.addWizardData("EFITYPE", (Object)"DELIMITED");
            ImageIcon image = this.bundle.getImageIcon("EFIImage.image.notrans");
            dlgWizard.setCanFinishEarly(false);
            WAGeneralWizardPanel generalWizardPanel = new WAGeneralWizardPanel(this.bundle.getString("NewDelimitedExternalTableWizard.GeneralPanel.Description.txt"), null, true);
            WAGeneralPanel generalPanel = generalWizardPanel.getGeneralPanel();
            generalPanel.enableNameValidation(true);
            String sName = WsMetadataNameUtil.getUniqueNameForType((String)"ExternalTable", (String)this.bundle.getString("NewEFIWizard.DefaultName.txt"));
            generalPanel.setNameField(sName);
            generalPanel.setOwningTree(defaultFolder);
            dlgWizard.addWizardData("GENERALPANEL", (Object)generalPanel);
            dlgWizard.addTab(this.bundle.getString("NewDelimitedExternalTableWizard.GeneralPanel.Title.txt"), GeneralPanel, (WAPropertyTab)generalWizardPanel, "wa_source_type.gif", (Icon)image, false);
            dlgWizard.addTab(this.bundle.getString("NewDelimitedExternalTableWizard.ExternalFileLocationPanel.Title.txt"), FileLocationPanel, (WAPropertyTab)new ExternalFileLocationPanel(mdlTable, true), "wa_source_type.gif", (Icon)image, false);
            dlgWizard.addTab(this.bundle.getString("NewDelimitedExternalTableWizard.DelimitedPanel.Title.txt"), DelimitedPanel, (WAPropertyTab)new DelimitedExternalTablePanel(mdlTable), "wa_source_type.gif", (Icon)image, false);
            ColumnDefinitionsPanel columnDefinitionsPanel = new ColumnDefinitionsPanel(mdlTable, "DELIMITED");
            dlgWizard.addTabToCleanupOnCancel((WAPropertyTab)columnDefinitionsPanel);
            dlgWizard.addTab(this.bundle.getString("NewDelimitedExternalTableWizard.ColumnDefintionsPanel.Title.txt"), ColumnsPanel, (WAPropertyTab)columnDefinitionsPanel, "wa_source_type.gif", (Icon)image, false);
            dlgWizard.addTab(this.bundle.getString("FinishTab.Title.txt"), FinishPanel, (WAPropertyTab)new EFIWizardFinishTab(), "wa_source_type.gif", (Icon)image, true);
            String[][] saTransitions = new String[][]{{GeneralPanel, "NEXT", FileLocationPanel}, {FileLocationPanel, "NEXT", DelimitedPanel}, {DelimitedPanel, "NEXT", ColumnsPanel}, {ColumnsPanel, "NEXT", FinishPanel}};
            mdlWizard.addTransitions(saTransitions);
            generalWizardPanel.setHelpProduct("wdb");
            generalWizardPanel.setHelpTopic("external_delimit_wiz");
            this.setTransitionsAdded(true);
            dlgWizard.setResizable(true);
            this.m_bInitialized = true;
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            return false;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return true;
    }

    @Override
    public String getInitialTabName() {
        return GeneralPanel;
    }

    @Override
    public String getToolTip() {
        return null;
    }

    @Override
    public String getCategory() {
        return this.bundle.getString("NewDelimitedExternalTableWizard.Category.txt");
    }

    @Override
    public void initPlugin() {
    }

    @Override
    public void dispose() {
    }

    @Override
    public String getDescription() {
        return this.bundle.getString("NewDelimitedExternalTableWizard.Description.txt");
    }

    @Override
    public Icon getIcon() {
        return WAdminResource.getTypeIcon((String)"ExternalTable", (boolean)true);
    }

    @Override
    public String getName() {
        return this.bundle.getString("NewDelimitedExternalTableWizard.Name.txt");
    }
}

