/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.efi2;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.ExternalTable;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.efi2.ExternalTableDataModel;
import com.sas.wadmin.efi2.ImportCobolCopyBookPanel;
import com.sas.wadmin.efi2.ImportColumnsFromEFF;
import com.sas.wadmin.efi2.ImportColumnsFromHeader;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAIntTextField;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.metadata.ExternalFormatFileUtil;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.visuals.SASLogDialog;
import com.sas.workspace.visuals.objectselector.ObjectsSelectorPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ImportColumnsPanel
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(ImportColumnsPanel.class);
    private static final String FORMAT_FILES_KEY = "ImportColumnsPanel.FormatFiles";
    private static final int FORMAT_FILES_MAX = 8;
    private static final String COBOLCOPYBOOK_FILES_KEY = "ImportColumnsPanel.COBOLCopyBookFiles";
    private static final int COBOLCOPYBOOK_FILES_MAX = 8;
    private static final String DELIMITER_KEY = "ImportColumnsPanel.Delimiter";
    private static final String EFF = "EFF";
    private JRadioButton m_rbnTables;
    private JRadioButton m_rbnFormatFile;
    private JRadioButton m_rbnCobolCopyBook;
    private JRadioButton m_rbnColumnHeadings;
    private JLabel m_lblFormatFile;
    private WAComboBox m_cmbFormatFile;
    private JLabel m_lblCobolCopyBook;
    private WAComboBox m_cmbCobolCopyBook;
    private JLabel m_lblRecordBefore;
    private JLabel m_lblRecordAfter;
    private WAIntTextField m_txtRecord;
    private JLabel m_lblSkipNamesBefore;
    private JLabel m_lblSkipNamesAfter;
    private WAIntTextField m_txtSkipNames;
    private JLabel m_lblDelimiter;
    private WATextField m_txtDelimiter;
    private JButton m_btnSelect;
    private JButton m_btnFormatFileBrowse;
    private JButton m_btnCopybookImporter;
    private WsAbstractAction m_actSelect;
    private WsAbstractAction m_actFormatFileBrowse;
    private WsAbstractAction m_actSettings;
    private WsAbstractAction m_actCopybookImporter;
    private ExternalTableDataModel m_mdlTable;
    private MdObjectStore m_store;
    private List m_lColumns;
    private List m_lNames;
    private ExternalFormatFileUtil m_formatFileUtil;

    public ImportColumnsPanel(ExternalTableDataModel mdlTable) {
        this.m_mdlTable = mdlTable;
        this.setHelpProduct("wdb");
        this.setHelpTopic("import_columns_external");
        this.initialize();
    }

    protected void initialize() {
        this.m_rbnTables = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"ImportColumnsPanel.RadioButton.Tables");
        this.m_rbnFormatFile = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"ImportColumnsPanel.RadioButton.FormatFile");
        this.m_rbnCobolCopyBook = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"ImportColumnsPanel.RadioButton.CobolCopyBook", (int)1);
        this.m_rbnColumnHeadings = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"ImportColumnsPanel.RadioButton.Headings");
        ButtonGroup grp = new ButtonGroup();
        grp.add(this.m_rbnTables);
        grp.add(this.m_rbnFormatFile);
        grp.add(this.m_rbnCobolCopyBook);
        grp.add(this.m_rbnColumnHeadings);
        cCommonItemListener lsnr = new cCommonItemListener();
        this.m_rbnTables.addItemListener(lsnr);
        this.m_rbnFormatFile.addItemListener(lsnr);
        this.m_rbnCobolCopyBook.addItemListener(lsnr);
        this.m_rbnColumnHeadings.addItemListener(lsnr);
        this.m_actSelect = new cSelectAction();
        this.m_actFormatFileBrowse = new cFormatFileBrowseAction();
        this.m_actSettings = new cSettingsAction();
        this.m_actCopybookImporter = new cCopybookImporter();
        this.m_btnSelect = new JButton((Action)this.m_actSelect);
        this.m_btnFormatFileBrowse = new JButton((Action)this.m_actFormatFileBrowse);
        this.m_btnCopybookImporter = new JButton((Action)this.m_actCopybookImporter);
        this.m_cmbFormatFile = new WAComboBox();
        this.m_cmbFormatFile.setEditable(true);
        this.m_lblFormatFile = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbFormatFile, (WAdminResource)bundle, (String)"ImportColumnsPanel.Label.FormatFile");
        this.m_cmbCobolCopyBook = new WAComboBox();
        this.m_cmbCobolCopyBook.setEditable(false);
        this.m_lblCobolCopyBook = WsUIUtilities.createLabelForComponent((JComponent)this.m_cmbCobolCopyBook, (String)bundle.getString("ImportColumnsPanel.Label.CobolCopyBook.txt"));
        this.m_txtRecord = new WAIntTextField();
        this.m_txtRecord.setColumns(4);
        this.m_txtRecord.setValue(1);
        this.m_lblRecordBefore = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtRecord, (WAdminResource)bundle, (String)"ImportColumnsPanel.Label.BeforeRecord");
        this.m_lblRecordAfter = new JLabel("");
        this.m_txtSkipNames = new WAIntTextField();
        this.m_txtSkipNames.setColumns(4);
        this.m_txtSkipNames.setValue(0);
        this.m_lblSkipNamesBefore = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtSkipNames, (WAdminResource)bundle, (String)"ImportColumnsPanel.Label.BeforeSkipNames");
        this.m_lblSkipNamesAfter = new JLabel(bundle.getString("ImportColumnsPanel.Label.AfterSkipNames.txt"));
        this.m_txtDelimiter = new WATextField();
        this.m_txtDelimiter.setColumns(1);
        this.m_txtDelimiter.setMaxCharacters(1);
        this.m_txtDelimiter.setEditable(true);
        this.m_lblDelimiter = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtDelimiter, (WAdminResource)bundle, (String)"ImportColumnsPanel.Label.Delimiter");
        JPanel pnlRecord = new JPanel(new GridBagLayout());
        pnlRecord.add((Component)this.m_lblRecordBefore, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        pnlRecord.add((Component)this.m_txtRecord, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        pnlRecord.add((Component)this.m_lblRecordAfter, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        JPanel pnlSkipNames = new JPanel(new GridBagLayout());
        pnlSkipNames.add((Component)this.m_lblSkipNamesBefore, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        pnlSkipNames.add((Component)this.m_txtSkipNames, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        pnlSkipNames.add((Component)this.m_lblSkipNamesAfter, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(this.m_rbnTables, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_btnSelect, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
        this.add(this.m_rbnFormatFile, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(15, 0, 0, 0), 0, 0));
        this.add(this.m_lblDelimiter, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(15, 10, 0, 0), 0, 0));
        this.add(this.m_lblFormatFile, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 21, 0, 0), 0, 0));
        this.add((Component)this.m_cmbFormatFile, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.m_txtDelimiter, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
        this.add(this.m_btnFormatFileBrowse, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
        this.add(this.m_rbnCobolCopyBook, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 2, new Insets(15, 0, 0, 0), 0, 0));
        this.add(this.m_lblCobolCopyBook, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 21, 0, 0), 0, 0));
        this.add((Component)this.m_cmbCobolCopyBook, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.add(this.m_btnCopybookImporter, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
        this.add(this.m_rbnColumnHeadings, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 17, 2, new Insets(15, 0, 0, 0), 0, 0));
        this.add(pnlRecord, new GridBagConstraints(0, 6, 4, 1, 1.0, 0.0, 17, 2, new Insets(0, 21, 0, 0), 0, 0));
        this.add(pnlSkipNames, new GridBagConstraints(0, 7, 4, 1, 1.0, 0.0, 17, 2, new Insets(0, 21, 0, 0), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(0, 8, 4, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_rbnFormatFile.setSelected(true);
        this.m_rbnCobolCopyBook.setSelected(true);
        this.m_rbnColumnHeadings.setSelected(true);
        this.m_rbnTables.setSelected(true);
        this.m_rbnCobolCopyBook.setEnabled(true);
        this.m_formatFileUtil = new ExternalFormatFileUtil();
    }

    protected void setObjectStore(MdObjectStore store) {
        this.m_store = store;
    }

    protected MdObjectStore getObjectStore() {
        return this.m_store;
    }

    protected List getColumns() {
        return this.m_lColumns;
    }

    protected List getNames() {
        return this.m_lNames;
    }

    public void populateStore() {
    }

    public void moveDataToView() throws MdException, RemoteException {
        File file;
        this.m_cmbFormatFile.loadItems(FORMAT_FILES_KEY, 8);
        ExternalTable externalTable = this.m_mdlTable.getExternalTable();
        this.m_formatFileUtil.setStore((MdObjectStore)externalTable.getObjectStore());
        this.m_formatFileUtil.setFQID(externalTable.getFQID());
        if (!externalTable.isNewObject() && (file = this.m_formatFileUtil.getAssociatedFormatFile(EFF, externalTable)) != null) {
            String sFile = file.getFileName();
            if (this.m_cmbFormatFile.getIndexOf((Object)sFile) < 0) {
                this.m_cmbFormatFile.addItem((Object)sFile);
            }
            this.m_cmbFormatFile.setSelectedItem((Object)sFile);
            this.m_rbnFormatFile.setSelected(true);
        }
        this.m_cmbCobolCopyBook.addItems(this.m_formatFileUtil.getCobolFormatFiles());
        if (!externalTable.isNewObject() && (file = this.m_formatFileUtil.getAssociatedFormatFile("COBEFF", externalTable)) != null) {
            this.m_cmbCobolCopyBook.setSelectedItem((Object)file);
            this.m_rbnCobolCopyBook.setSelected(true);
        }
        this.m_txtDelimiter.loadDefaultValue(DELIMITER_KEY, ",");
        if (this.m_mdlTable.isUserWritten()) {
            this.m_rbnColumnHeadings.setEnabled(false);
            this.m_txtSkipNames.setBehavior(2);
            this.m_txtRecord.setBehavior(2);
        }
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.m_cmbFormatFile.saveItems(FORMAT_FILES_KEY, 8);
        this.m_cmbCobolCopyBook.saveItems(COBOLCOPYBOOK_FILES_KEY, 8);
        this.m_txtDelimiter.saveItem(DELIMITER_KEY);
    }

    public boolean validateData() {
        try {
            this.m_lNames = null;
            if (this.m_rbnTables.isSelected() || this.m_rbnColumnHeadings.isSelected()) {
                try {
                    if (this.m_mdlTable.getExternalFormatFile() != null) {
                        this.m_mdlTable.cleanupFormatFileMD();
                    }
                }
                catch (MdException mdException) {
                    // empty catch block
                }
            }
            if (this.m_rbnTables.isSelected()) {
                if (this.m_lColumns == null || this.m_lColumns.isEmpty()) {
                    MessageUtil.displayMessage((String)bundle.getString("ImportColumnsPanel.Error.NoColumnsSelected.txt"), (int)0);
                    this.m_btnSelect.requestFocus();
                    return false;
                }
            } else {
                if (this.m_rbnFormatFile.isSelected()) {
                    String sFileName = "";
                    if (this.m_cmbFormatFile.getSelectedItem() instanceof File) {
                        sFileName = ((File)this.m_cmbFormatFile.getSelectedItem()).getFileName();
                    }
                    if (this.m_cmbFormatFile.getSelectedItem() instanceof String) {
                        sFileName = (String)this.m_cmbFormatFile.getSelectedItem();
                    }
                    String sDelimiter = this.m_txtDelimiter.getText();
                    return this.formatFile(sFileName, sDelimiter, EFF, this.m_cmbFormatFile);
                }
                if (this.m_rbnCobolCopyBook.isSelected()) {
                    String sFileName = ((File)this.m_cmbCobolCopyBook.getSelectedItem()).getFileName();
                    return this.formatFile(sFileName, ",", "COBEFF", this.m_cmbCobolCopyBook);
                }
                if (this.m_rbnColumnHeadings.isSelected()) {
                    if (this.m_mdlTable.isFixedWidth() && (this.m_mdlTable.getColumns() == null || this.m_mdlTable.getColumns().isEmpty())) {
                        MessageUtil.displayMessage((String)bundle.getString("ImportColumnsPanel.Error.NoColumns.txt"), (int)0);
                        return false;
                    }
                    if (this.m_txtRecord.getText().length() == 0 || this.m_txtRecord.getValue() < 1) {
                        MessageUtil.displayMessage((String)bundle.getString("ImportColumnsPanel.Error.InvalidRecordNumber.txt"), (int)0);
                        this.m_txtRecord.requestFocus();
                        return false;
                    }
                    if (this.m_txtSkipNames.getText().length() == 0) {
                        MessageUtil.displayMessage((String)bundle.getString("ImportColumnsPanel.Error.InvalidSkipNamesNumber.txt"), (int)0);
                        this.m_txtSkipNames.requestFocus();
                        return false;
                    }
                    try {
                        ImportColumnsFromHeader importer = new ImportColumnsFromHeader(this.m_mdlTable, this.m_txtRecord.getValue());
                        this.m_lNames = importer.getColumnNames();
                    }
                    catch (WsAppServerFailException e) {
                        MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
                        return false;
                    }
                    catch (WsAppServerCodeException e) {
                        this.showSASLogDialog(bundle.getString("ImportColumnsPanel.Error.ImportNamesCode.txt"));
                        return false;
                    }
                    catch (SQLException e) {
                        MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
                        return false;
                    }
                    try {
                        int recordStart = this.m_txtRecord.getValue() + 1;
                        this.m_mdlTable.setStartRecord(recordStart);
                    }
                    catch (MdException mde) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Accessing");
                        return false;
                    }
                    this.m_lColumns = null;
                    int nSkip = Math.min(this.m_txtSkipNames.getValue(), this.m_lNames.size());
                    for (int iSkip = 0; iSkip < nSkip; ++iSkip) {
                        this.m_lNames.remove(0);
                    }
                }
            }
            return true;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean formatFile(String filename, String delimiter, String fileType, WAComboBox comboBox) {
        String sFileName = filename;
        if (sFileName == null || sFileName.length() == 0) {
            if (fileType.equals(EFF)) {
                MessageUtil.displayMessage((String)bundle.getString("ImportColumnsPanel.Error.NoFormatFileSpecified.txt"), (int)0);
            } else {
                MessageUtil.displayMessage((String)bundle.getString("ImportColumnsPanel.Error.NoCobolCopyBookSpecified.txt"), (int)0);
            }
            comboBox.requestFocus();
            return false;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            WsAppServer appServer = this.m_mdlTable.getAppServer();
            if (appServer == null) {
                boolean bl = false;
                return bl;
            }
            appServer.doesFileExist(sFileName);
        }
        catch (WsAppServerFailException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            boolean bl = false;
            return bl;
        }
        catch (GenericError e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            comboBox.requestFocus();
            boolean bl = false;
            return bl;
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        try {
            ImportColumnsFromEFF importer = new ImportColumnsFromEFF(this.m_mdlTable, sFileName, delimiter, this.m_store);
            this.m_lColumns = importer.getColumns();
            if (fileType.equals(EFF)) {
                this.m_mdlTable.setExternalFormatFile(sFileName);
            } else {
                this.m_mdlTable.buildFormatFileAssociation((File)this.m_cmbCobolCopyBook.getSelectedItem());
            }
        }
        catch (SQLException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            return false;
        }
        catch (WsAppServerCodeException e) {
            this.showSASLogDialog(bundle.getString("ImportColumnsPanel.Error.ImportColumnsCode.txt"));
            return false;
        }
        catch (WsAppServerFailException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            return false;
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            return false;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return true;
    }

    protected void showSASLogDialog(String sMessage) {
        int choice = MessageUtil.displayMessage((String)sMessage, (int)0, (int)0);
        if (choice == 0) {
            String sTitle = bundle.getString("ImportColumnsPanel.Title.Log.txt");
            SASLogDialog dlg = new SASLogDialog((Frame)Workspace.getWorkspace(), sTitle, true, this.m_mdlTable.getAppServer());
            dlg.show();
        }
    }

    private class cCommonItemListener
    implements ItemListener {
        private cCommonItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            JRadioButton rbn = (JRadioButton)e.getSource();
            boolean bSelected = rbn.isSelected();
            if (rbn == ImportColumnsPanel.this.m_rbnTables) {
                ImportColumnsPanel.this.m_actSelect.setEnabled(bSelected);
            } else if (rbn == ImportColumnsPanel.this.m_rbnFormatFile) {
                ImportColumnsPanel.this.m_lblFormatFile.setEnabled(bSelected);
                ImportColumnsPanel.this.m_cmbFormatFile.setEnabled(bSelected);
                ImportColumnsPanel.this.m_actFormatFileBrowse.setEnabled(bSelected);
                ImportColumnsPanel.this.m_txtDelimiter.setEnabled(bSelected);
                ImportColumnsPanel.this.m_lblDelimiter.setEnabled(bSelected);
            } else if (rbn == ImportColumnsPanel.this.m_rbnCobolCopyBook) {
                ImportColumnsPanel.this.m_lblCobolCopyBook.setEnabled(bSelected);
                ImportColumnsPanel.this.m_cmbCobolCopyBook.setEnabled(bSelected);
                ImportColumnsPanel.this.m_actSettings.setEnabled(bSelected);
                ImportColumnsPanel.this.m_actCopybookImporter.setEnabled(bSelected);
            } else if (rbn == ImportColumnsPanel.this.m_rbnColumnHeadings) {
                ImportColumnsPanel.this.m_lblRecordBefore.setEnabled(bSelected);
                ImportColumnsPanel.this.m_txtRecord.setEnabled(bSelected);
                ImportColumnsPanel.this.m_lblRecordAfter.setEnabled(bSelected);
                ImportColumnsPanel.this.m_lblSkipNamesBefore.setEnabled(bSelected);
                ImportColumnsPanel.this.m_txtSkipNames.setEnabled(bSelected);
                ImportColumnsPanel.this.m_lblSkipNamesAfter.setEnabled(bSelected);
            }
        }
    }

    private class cSettingsAction
    extends WsAbstractAction {
        public cSettingsAction() {
            super(bundle, "ImportColumnsPanel.Action.Settings", false, false);
        }

        public void actionPerformed(ActionEvent e) {
            MessageUtil.displayMessage((String)bundle.getString("ImportColumnsPanel.Action.CobolAdvanced.txt"));
        }
    }

    private class cCopybookImporter
    extends WsAbstractAction {
        public cCopybookImporter() {
            super(bundle, "ImportColumnsPanel.Action.CobolCopybookImporter", false, false);
        }

        public void actionPerformed(ActionEvent e) {
            ImportCobolCopyBookPanel cobolPanel = new ImportCobolCopyBookPanel();
            WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("ImportColumnsPanel.ImportCobolCopybook.title.txt"), true);
            dialog.setMainPanel((WAPanel)cobolPanel);
            dialog.setResizable(true);
            dialog.show();
            if (dialog.getReturnValue() == 1) {
                try {
                    ImportColumnsPanel.this.m_cmbCobolCopyBook.removeAllItems();
                    ImportColumnsPanel.this.m_cmbCobolCopyBook.addItems(ImportColumnsPanel.this.m_formatFileUtil.getCobolFormatFiles());
                }
                catch (MdException me) {
                    MessageUtil.displayMessage((String)me.getLocalizedMessage(), (int)0);
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
        }
    }

    private class cFormatFileBrowseAction
    extends WsAbstractAction {
        public cFormatFileBrowseAction() {
            super(bundle, "ImportColumnsPanel.Action.FormatFileBrowse", false, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            try {
                String filename;
                ImportColumnsPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                WsAppServer appServer = ImportColumnsPanel.this.m_mdlTable.getAppServer();
                if (appServer == null) {
                    return;
                }
                LinkedHashMap<String, String> mapFileTypes = new LinkedHashMap<String, String>();
                mapFileTypes.put(bundle.getString("ImportColumnsPanel.DelimitedFileTypes.txt"), "CSV");
                mapFileTypes.put(bundle.getString("ImportColumnsPanel.AllFileTypes.txt"), "*");
                if (appServer.getOperatingSystem().equalsIgnoreCase("OS")) {
                    MessageUtil.displayMessage((String)bundle.getString("ImportColumnsPanel.Error.UnableToBrowse.txt"), (int)0);
                    return;
                }
                String sName = "";
                if (ImportColumnsPanel.this.m_cmbFormatFile.getSelectedItem() != null) {
                    sName = ImportColumnsPanel.this.m_cmbFormatFile.getSelectedItem().toString();
                }
                if ((filename = appServer.promptForFilename(bundle.getString("ImportColumnsPanel.RemoteFileSelector.Title.txt"), sName, mapFileTypes)) != null) {
                    ImportColumnsPanel.this.m_cmbFormatFile.setSelectedItem((Object)filename);
                }
            }
            catch (WsAppServerFailException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (GenericError ge) {
                MessageUtil.displayMessage((String)ge.getLocalizedMessage(), (int)0);
            }
            finally {
                ImportColumnsPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private class cSelectAction
    extends WsAbstractAction {
        public cSelectAction() {
            super(bundle, "ImportColumnsPanel.Action.Select", false, false);
        }

        public void actionPerformed(ActionEvent e) {
            ObjectsSelectorPanel pnl = new ObjectsSelectorPanel(Workspace.getWorkspace().getUserContext(), 4);
            String sImportDialogTitle = bundle.getString("ImportColumnsPanel.Dialog.ImportColumns.Title.txt");
            WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sImportDialogTitle, true, (WAPanel)pnl);
            dlg.setResizable(true);
            dlg.setHelpProduct("shared");
            dlg.setHelpTopic("import_column_win");
            dlg.show();
            if (dlg.getReturnValue() == 1) {
                try {
                    SimpleObject[] aColumns = pnl.getSelectedObjects();
                    Root[] aMDColumns = ObjectConverter.getInstance().convertToJOMAObjects(ImportColumnsPanel.this.m_store, aColumns);
                    for (int i = 0; i < aMDColumns.length; ++i) {
                        aMDColumns[i] = WsColumnMetadataUtil.createMetadataColumnCopy((Column)((Column)aMDColumns[i]), (MdObjectStore)ImportColumnsPanel.this.m_store, (String)ImportColumnsPanel.this.m_mdlTable.getExternalTable().getRepositoryID());
                    }
                    ImportColumnsPanel.this.m_lColumns = new ArrayList<Root>(Arrays.asList(aMDColumns));
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException((RemoteException)ex);
                }
            }
        }
    }
}

