/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.efi2;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.wadmin.efi2.DelimitedRecordTokenizer;
import com.sas.wadmin.efi2.ExternalTableDataModel;
import com.sas.wadmin.efi2.FixedWidthRecordTokenizer;
import com.sas.wadmin.efi2.GuessingColumnFormats;
import com.sas.wadmin.efi2.GuessingColumnModel;
import com.sas.wadmin.efi2.RecordTokenizerInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import java.awt.Cursor;
import java.awt.KeyboardFocusManager;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GuessingRowsModel {
    private static final WAdminResource bundle = WAdminResource.getBundle(GuessingRowsModel.class);
    private Pattern m_numericPattern = Pattern.compile("[.]([0-9]+)");
    private List m_rows = new ArrayList();
    private List m_records = new ArrayList();
    private int m_columnCount;
    private FixedWidthRecordTokenizer.Interval[] m_intervals;
    private int m_recordLength;
    private ExternalTableDataModel m_mdlTable;

    public GuessingRowsModel(ExternalTableDataModel model) {
        this.m_mdlTable = model;
    }

    public void loadRows() throws StartValueTooLargeException {
        int startLine = this.m_mdlTable.getStartGuessingRecord();
        int numberOfRecords = this.m_mdlTable.getGuessingRecords();
        this.loadRows(startLine, numberOfRecords);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRows(int startLine, int numberOfRecords) throws StartValueTooLargeException {
        try {
            String[] lines;
            KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow().setCursor(Cursor.getPredefinedCursor(3));
            this.m_rows.clear();
            WsAppServer appServer = this.m_mdlTable.getAppServer();
            if (appServer == null) {
                return;
            }
            String sEncoding = this.m_mdlTable.getInfileEncodingTextQuoted();
            String sOptions = !sEncoding.equals("") ? "encoding=" + sEncoding : "";
            String fileName = this.m_mdlTable.getLogicalFilename();
            if (this.m_mdlTable.isHttpAccessMethod()) {
                fileName = this.m_mdlTable.getHttpFilePath(fileName);
            }
            String accessMethod = this.m_mdlTable.getAccessMethodNickName();
            sOptions = sOptions + this.m_mdlTable.getAccessMethodOptions("_temp");
            String opts = this.m_mdlTable.getInfileOptionsText();
            if (opts != null && opts.length() > 0) {
                sOptions = sOptions + " " + opts;
            }
            if ((lines = appServer.readLinesFromFile(startLine, numberOfRecords, fileName, sOptions, accessMethod)).length == 0) {
                throw new StartValueTooLargeException(bundle.getString("GuessingRowsModel.Error.StartRecordTooLarge.txt"));
            }
            for (int lineIndex = 0; lineIndex < lines.length; ++lineIndex) {
                this.m_rows.add(lines[lineIndex]);
            }
        }
        catch (GenericError e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        catch (WsAppServerFailException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        finally {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow().setCursor(Cursor.getDefaultCursor());
        }
    }

    public int getMaximumLineLength() {
        int maxLength = 0;
        for (int lineIndex = 0; lineIndex < this.m_rows.size(); ++lineIndex) {
            String line = (String)this.m_rows.get(lineIndex);
            maxLength = Math.max(line.length(), maxLength);
        }
        return maxLength;
    }

    public int getMaxColumnWidth(int index) {
        int maxWidth = 0;
        try {
            String encoding = this.m_mdlTable.getAppServer().getEncoding();
            for (int recordIndex = 0; recordIndex < this.m_records.size(); ++recordIndex) {
                String value;
                List row = (List)this.m_records.get(recordIndex);
                if (row == null || index >= row.size() || (value = (String)row.get(index)) == null) continue;
                int length = value.length();
                byte[] widths = WsAppServer.findDataWidths((String)value, (String)encoding);
                int bytes = 0;
                for (int byteIndex = 0; byteIndex < widths.length; ++byteIndex) {
                    bytes += widths[byteIndex];
                }
                length = Math.max(length, bytes);
                maxWidth = Math.max(length, maxWidth);
            }
        }
        catch (UnsupportedEncodingException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        catch (WsAppServerFailException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        catch (GenericError e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        return maxWidth;
    }

    public int getMaxDecimalWidth(int index) {
        int maxDecimals = 0;
        for (int recordIndex = 0; recordIndex < this.m_records.size(); ++recordIndex) {
            String decimals;
            Matcher matcher;
            String value;
            List row = (List)this.m_records.get(recordIndex);
            if (row == null || index >= row.size() || (value = (String)row.get(index)) == null || !(matcher = this.m_numericPattern.matcher(value)).find() || (decimals = matcher.group(1)) == null) continue;
            maxDecimals = Math.max(decimals.length(), maxDecimals);
        }
        return maxDecimals;
    }

    public GuessingColumnModel getColumns() throws GenericError, WsAppServerFailException {
        this.splitRecords();
        for (int recordIndex = 0; recordIndex < this.m_records.size(); ++recordIndex) {
            List fields = (List)this.m_records.get(recordIndex);
            if (fields != null) continue;
        }
        GuessingColumnModel columnModel = new GuessingColumnModel();
        int[] columnWidths = new int[this.m_columnCount];
        for (int columnIndex = 0; columnIndex < this.m_columnCount; ++columnIndex) {
            GuessingColumnModel.GuessingColumn column = new GuessingColumnModel.GuessingColumn();
            column.setPosition(columnIndex + 1);
            StringBuffer columnName = new StringBuffer(bundle.getString("GuessingRowsModel.Column.Name.txt"));
            columnName.append(String.valueOf(new Integer(columnIndex + 1)));
            column.setName(columnName.toString());
            column.setWidth(this.getMaxColumnWidth(columnIndex));
            column.setDecimalWidth(this.getMaxDecimalWidth(columnIndex));
            columnModel.addColumn(column);
            columnWidths[columnIndex] = column.getWidth();
        }
        GuessingColumnFormats columnFormats = new GuessingColumnFormats(this.m_mdlTable, columnModel);
        columnModel = columnFormats.getColumnFormats(this.m_records);
        return columnModel;
    }

    public int getColumnCount() {
        return this.m_columnCount;
    }

    protected void splitRecords() {
        ArrayList values = new ArrayList();
        try {
            RecordTokenizerInterface tokenizer;
            String encoding = this.m_mdlTable.getAppServer().getEncoding();
            this.m_records.clear();
            this.m_columnCount = 0;
            if (this.m_mdlTable.isDelimited()) {
                String delimiter = this.m_mdlTable.isDelimiterOverridden() ? this.m_mdlTable.getOverrideDelimiter() : this.m_mdlTable.getDelimiterValue();
                tokenizer = new DelimitedRecordTokenizer(delimiter, this.m_mdlTable.isConsecDelim());
            } else {
                tokenizer = new FixedWidthRecordTokenizer(this.m_intervals, encoding);
            }
            if (this.m_mdlTable.isMultiPerLine()) {
                this.m_columnCount = this.m_mdlTable.getColumnsPerRecord();
            }
            for (int lineIndex = 0; lineIndex < this.m_rows.size(); ++lineIndex) {
                String line = (String)this.m_rows.get(lineIndex);
                if (this.m_recordLength > 0 && line.length() >= this.m_recordLength) {
                    line = line.substring(0, this.m_recordLength);
                }
                tokenizer.setRecord(line);
                values.addAll(tokenizer.splitRecord());
                if (this.m_mdlTable.isMultiPerLine()) {
                    ArrayList subset = new ArrayList();
                    while (values.size() > this.m_mdlTable.getColumnsPerRecord()) {
                        while (subset.size() < this.m_mdlTable.getColumnsPerRecord()) {
                            subset.add(values.remove(0));
                        }
                        this.m_records.add(new ArrayList(subset));
                        subset.clear();
                    }
                    continue;
                }
                this.m_columnCount = Math.max(this.m_columnCount, values.size());
                this.m_records.add(new ArrayList(values));
                values.clear();
            }
        }
        catch (WsAppServerFailException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        catch (GenericError e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
    }

    public List getRows() {
        return this.m_rows;
    }

    public void setRows(List rows) {
        this.m_rows.clear();
        this.m_rows.addAll(rows);
    }

    public void setIntervals(FixedWidthRecordTokenizer.Interval[] intervals) {
        this.m_intervals = intervals;
    }

    public int getRecordLength() {
        return this.m_recordLength;
    }

    public void setRecordLength(int recordLength) {
        this.m_recordLength = recordLength;
    }

    public class StartValueTooLargeException
    extends Exception {
        public StartValueTooLargeException(String message) {
            super(message);
        }
    }
}

