/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.efi2;

import com.sas.wadmin.efi2.RecordTokenizerInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WsAppServer;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class FixedWidthRecordTokenizer
implements RecordTokenizerInterface {
    private String m_record;
    private Interval[] m_intervals;
    private String m_encoding;

    public FixedWidthRecordTokenizer(String record, Interval[] intervals, String encoding) {
        this(intervals, encoding);
        this.m_record = record;
        this.m_encoding = encoding;
    }

    public FixedWidthRecordTokenizer(Interval[] intervals, String encoding) {
        this.m_intervals = intervals;
        this.m_encoding = encoding;
    }

    @Override
    public void setRecord(String record) {
        this.m_record = record;
    }

    public void setEncoding(String encoding) {
        this.m_encoding = encoding;
    }

    @Override
    public List splitRecord() {
        ArrayList<String> fields = new ArrayList<String>();
        int begin = 0;
        int end = 0;
        for (int intervalIndex = 0; intervalIndex < this.m_intervals.length; ++intervalIndex) {
            Interval interval = this.m_intervals[intervalIndex];
            begin = 0;
            end = 0;
            try {
                byte[] widths = WsAppServer.findDataWidths((String)this.m_record, (String)this.m_encoding);
                int bytes = 0;
                for (int byteIndex = 0; byteIndex < widths.length; ++byteIndex) {
                    if (begin <= 0 && (bytes += widths[byteIndex]) >= interval.getBegin()) {
                        begin = byteIndex + 1;
                    }
                    if (end > 0 || bytes < interval.getEnd()) continue;
                    end = byteIndex + 1;
                }
            }
            catch (UnsupportedEncodingException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            }
            if (begin <= 0) {
                begin = 1;
            }
            if (end < 0) {
                end = 0;
            }
            if (this.m_record.length() <= 0 || begin >= this.m_record.length() || end > this.m_record.length() || begin > end) continue;
            fields.add(this.m_record.substring(begin - 1, end));
        }
        return fields;
    }

    public static class Interval {
        public int m_begin;
        public int m_end;

        public Interval(int begin, int end) {
            this.m_begin = begin;
            this.m_end = end;
        }

        public int getBegin() {
            return this.m_begin;
        }

        public void setBegin(int begin) {
            this.m_begin = begin;
        }

        public int getEnd() {
            return this.m_end;
        }

        public void setEnd(int end) {
            this.m_end = end;
        }
    }
}

