/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.efi2;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IExternalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.externalfile.IFixedWidthExternalFile;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.efi2.RawDataPanel2;
import com.sas.wadmin.efi2.TextColumnModel;
import com.sas.wadmin.efi2.TextColumnModelEvent;
import com.sas.wadmin.efi2.TextColumnModelListener;
import com.sas.wadmin.visuals.common.ColumnsTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAUndoManager;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.rmi.RemoteException;
import javax.swing.BorderFactory;
import javax.swing.JSplitPane;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ExternalTableColumnsTab
extends WAPropertyTab {
    private static final WAdminResource bundle = WAdminResource.getBundle(ExternalTableColumnsTab.class);
    private IExternalTable m_mdlTable;
    private ColumnsTab m_pnlColumns;
    private JSplitPane m_pnlSplit;
    private RawDataPanel2 m_pnlRawData;
    private boolean m_bFirstTime;
    private ModelListener m_lsnrModel;
    private cColumnSelectionAdapter m_lsnrSelection;

    public ExternalTableColumnsTab(IExternalTable mdlTable) {
        this.setName(bundle.getString("ExternalTableColumnsTab.Name.txt"));
        this.m_mdlTable = mdlTable;
        this.setHelpProduct("shared");
        this.setHelpTopic("columns_tab");
        this.initialize();
    }

    protected void initialize() {
        this.m_bFirstTime = true;
        Border brdrCommon = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        ColumnsTab.Configuration config = new ColumnsTab.Configuration();
        config.setExtraImportOptions(true);
        if (this.m_mdlTable.isFixedWidth()) {
            config.setPermanentlyHiddenColumns(new int[0]);
            config.setHiddenActions(new int[]{3, 4, 5, 11});
            config.setColumnReorderingEnabled(false);
        }
        this.m_pnlColumns = new ColumnsTab((ITable)this.m_mdlTable, config);
        this.m_pnlColumns.setBorder(brdrCommon);
        this.m_pnlColumns.setWAUndoManager(this.getWAUndoManager());
        this.listenForDataChangesTo((WAPanel)this.m_pnlColumns);
        if (this.m_mdlTable.isFixedWidth()) {
            this.m_pnlRawData = new RawDataPanel2(this.m_mdlTable, 4);
            this.m_pnlRawData.getTextColumnHeader().setEditable(false);
            this.m_pnlRawData.setBorder(brdrCommon);
        }
        this.setLayout(new BorderLayout());
        if (this.m_mdlTable.isFixedWidth()) {
            this.m_pnlSplit = new JSplitPane(0, true, (Component)((Object)this.m_pnlColumns), (Component)((Object)this.m_pnlRawData));
            this.m_pnlSplit.setBorder(null);
            int cyColumns = this.m_pnlColumns.getPreferredSize().height;
            int cySplit = this.m_pnlSplit.getPreferredSize().height;
            this.m_pnlSplit.setResizeWeight((double)cyColumns / (double)cySplit);
            this.add(this.m_pnlSplit, "Center");
        } else {
            this.add((Component)((Object)this.m_pnlColumns), "Center");
        }
        if (this.m_mdlTable.isFixedWidth()) {
            this.m_lsnrModel = new ModelListener();
            this.m_mdlTable.getModel().addModelListener((IModelListener)this.m_lsnrModel);
            this.m_lsnrSelection = new cColumnSelectionAdapter();
            this.m_pnlRawData.getTextColumnHeader().getModel().addModelListener(this.m_lsnrModel);
            this.m_pnlRawData.getTextColumnHeader().getSelectionModel().addListSelectionListener(this.m_lsnrSelection);
            this.m_pnlColumns.getTable().getSelectionModel().addListSelectionListener(this.m_lsnrSelection);
        }
    }

    public void populateStore() throws MdException, RemoteException {
        this.m_pnlColumns.populateStore();
        if (this.m_mdlTable.isFixedWidth()) {
            this.m_pnlRawData.populateStore();
        }
    }

    public void moveDataToView() throws MdException, RemoteException {
        if (this.m_mdlTable.isFixedWidth()) {
            this.m_pnlRawData.updateComponents();
        }
        this.setListeningForChanges(false);
        if (this.m_bFirstTime) {
            if (this.m_mdlTable.isFixedWidth()) {
                this.m_pnlRawData.getTextColumnHeader().setEditable(this.isEditable());
            }
            this.m_bFirstTime = false;
        } else if (this.m_mdlTable.isFixedWidth()) {
            this.m_pnlRawData.clear();
        }
        this.m_pnlColumns.moveDataToView();
        if (this.m_mdlTable.isFixedWidth()) {
            this.m_lsnrModel.m_bUpdateColumnModel = false;
            this.m_pnlRawData.moveDataToView();
            this.m_lsnrModel.m_bUpdateColumnModel = true;
        }
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.m_pnlColumns.moveDataToStore();
    }

    public boolean validateData() {
        return this.m_pnlColumns.validateData();
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_pnlColumns.setEditable(bEditable);
        if (this.m_mdlTable.isFixedWidth()) {
            this.m_pnlRawData.setEditable(bEditable);
        }
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_pnlColumns.saveSettingsAndCleanUp();
        if (this.m_mdlTable.isFixedWidth()) {
            this.m_pnlRawData.saveSettingsAndCleanUp();
        }
        this.m_mdlTable.dispose();
        this.m_mdlTable.getModel().removeModelListener((IModelListener)this.m_lsnrModel);
    }

    public void setWAUndoManager(WAUndoManager mgrUndo) {
        super.setWAUndoManager(mgrUndo);
        this.m_pnlColumns.setWAUndoManager(mgrUndo);
    }

    private class cColumnSelectionAdapter
    implements ListSelectionListener {
        private WsTable m_tblColumns;
        private ListSelectionModel m_mdlColumns;
        private ListSelectionModel m_mdlTextColumns;
        private boolean m_bAdjusting;

        public cColumnSelectionAdapter() {
            this.m_tblColumns = ExternalTableColumnsTab.this.m_pnlColumns.getTable();
            this.m_mdlColumns = this.m_tblColumns.getSelectionModel();
            this.m_mdlTextColumns = ExternalTableColumnsTab.this.m_pnlRawData.getTextColumnHeader().getSelectionModel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(ListSelectionEvent e) {
            block14: {
                if (this.isAdjusting()) {
                    return;
                }
                if (e.getValueIsAdjusting()) {
                    return;
                }
                try {
                    this.setAdjusting(true);
                    if (e.getSource() == this.m_mdlColumns) {
                        try {
                            this.m_mdlTextColumns.setValueIsAdjusting(true);
                            this.m_mdlTextColumns.clearSelection();
                            int[] aSelectedColumns = this.m_tblColumns.getSelectedRowsFromSelectedCells();
                            this.m_tblColumns.convertRowIndexesToModel(aSelectedColumns);
                            for (int iColumn = 0; iColumn < aSelectedColumns.length; ++iColumn) {
                                this.m_mdlTextColumns.addSelectionInterval(aSelectedColumns[iColumn], aSelectedColumns[iColumn]);
                            }
                            break block14;
                        }
                        finally {
                            this.m_mdlTextColumns.setValueIsAdjusting(false);
                        }
                    }
                    try {
                        this.m_mdlColumns.setValueIsAdjusting(true);
                        this.m_mdlColumns.clearSelection();
                        for (int iColumn = this.m_mdlTextColumns.getMinSelectionIndex(); iColumn <= this.m_mdlTextColumns.getMaxSelectionIndex(); ++iColumn) {
                            if (!this.m_mdlTextColumns.isSelectedIndex(iColumn)) continue;
                            this.m_tblColumns.addRowToSelection(this.m_tblColumns.convertRowIndexToView(iColumn));
                        }
                    }
                    finally {
                        this.m_mdlColumns.setValueIsAdjusting(false);
                    }
                }
                finally {
                    this.setAdjusting(false);
                }
            }
        }

        private void setAdjusting(boolean bAdjusting) {
            this.m_bAdjusting = bAdjusting;
        }

        private boolean isAdjusting() {
            return this.m_bAdjusting;
        }
    }

    private class ModelListener
    implements IModelListener,
    TextColumnModelListener {
        protected boolean m_bAdjusting = false;
        protected boolean m_bUpdateColumnModel = true;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void modelChanged(ModelEvent ev) {
            block22: {
                if (this.m_bAdjusting) {
                    return;
                }
                try {
                    IColumn oColumn;
                    this.m_bAdjusting = true;
                    this.m_bUpdateColumnModel = false;
                    String type = ev.getType();
                    if (type.equals("ExternalTable:OverlapChanged")) {
                        boolean overlap = this.isColumnOverlapping();
                        if (overlap) {
                            ExternalTableColumnsTab.this.m_pnlRawData.setEnabled(overlap && ExternalTableColumnsTab.this.isEditable());
                            ExternalTableColumnsTab.this.m_pnlRawData.getTextColumnHeader().setOverlapColumns(overlap);
                            ExternalTableColumnsTab.this.m_pnlRawData.getTextColumnHeader().setEditable(!overlap);
                        } else {
                            ExternalTableColumnsTab.this.m_pnlRawData.setEnabled(overlap);
                            ExternalTableColumnsTab.this.m_pnlRawData.getTextColumnHeader().setOverlapColumns(overlap);
                            ExternalTableColumnsTab.this.m_pnlRawData.getTextColumnHeader().setEditable(!overlap);
                        }
                        break block22;
                    }
                    if (type.equals("Column:BeginPositionChanged") || type.equals("Column:EndPositionChanged")) {
                        TextColumnModel mdl = ExternalTableColumnsTab.this.m_pnlRawData.getTextColumnHeader().getModel();
                        IColumn[] lColumns = ExternalTableColumnsTab.this.m_mdlTable.getColumns();
                        for (int iColumn = 0; iColumn < lColumns.length; ++iColumn) {
                            IColumn oColumn2 = lColumns[iColumn];
                            int begin = oColumn2.getBeginPosition();
                            int end = oColumn2.getEndPosition();
                            if (1 > begin || begin > end) continue;
                            mdl.updateColumn(iColumn, begin, end);
                            if (oColumn2.getModel().isUndoing() || oColumn2.getType() != 0) continue;
                            oColumn2.setLength(end - begin + 1);
                        }
                        break block22;
                    }
                    if (type.equals("Table:ColumnRemoved")) {
                        TextColumnModel mdl = ExternalTableColumnsTab.this.m_pnlRawData.getTextColumnHeader().getModel();
                        IColumn oColumn3 = (IColumn)ev.getData();
                        for (int iRow = 0; iRow <= mdl.getColumnCount(); ++iRow) {
                            if (mdl.getColumnBegin(iRow) != oColumn3.getBeginPosition() || mdl.getColumnEnd(iRow) != oColumn3.getEndPosition()) continue;
                            mdl.deleteColumn(iRow);
                            break block22;
                        }
                        break block22;
                    }
                    if (type.equals("Table:ColumnAdded")) {
                        int iStopPoint;
                        boolean bBeginEndSet;
                        TextColumnModel mdl = ExternalTableColumnsTab.this.m_pnlRawData.getTextColumnHeader().getModel();
                        IColumn oColumn4 = (IColumn)ev.getData();
                        IColumn[] aColumn = ExternalTableColumnsTab.this.m_mdlTable.getColumns();
                        int iColumn = 0;
                        for (iColumn = 0; iColumn < ExternalTableColumnsTab.this.m_mdlTable.getColumnCount(); ++iColumn) {
                            if (!aColumn[iColumn].equals(oColumn4)) continue;
                            mdl.insertColumn(iColumn, oColumn4.getBeginPosition(), oColumn4.getEndPosition());
                            break;
                        }
                        if (oColumn4.getModel().isUndoing()) {
                            return;
                        }
                        boolean bl = bBeginEndSet = aColumn[iColumn].getBeginPosition() > 0 && aColumn[iColumn].getEndPosition() > 0 && aColumn[iColumn].getEndPosition() >= aColumn[iColumn].getBeginPosition();
                        if (this.isColumnOverlapping() && bBeginEndSet) {
                            return;
                        }
                        int n = iStopPoint = this.isColumnOverlapping() ? iColumn + 1 : ExternalTableColumnsTab.this.m_mdlTable.getColumnCount();
                        while (iColumn < iStopPoint) {
                            int iBegin;
                            int n2 = iBegin = aColumn[iColumn].getBeginPosition() <= 0 ? 1 : aColumn[iColumn].getBeginPosition();
                            if (iColumn > 0) {
                                iBegin = Math.max(aColumn[iColumn - 1].getEndPosition() + 1, aColumn[iColumn].getBeginPosition());
                            }
                            int iEnd = !ExternalTableColumnsTab.this.m_mdlTable.isImporting() ? iBegin + aColumn[iColumn].getLength() - 1 : aColumn[iColumn].getEndPosition();
                            this.m_bAdjusting = false;
                            aColumn[iColumn].setBeginPosition(iBegin);
                            aColumn[iColumn].setEndPosition(iEnd);
                            if (aColumn[iColumn].getType() == 0 && ExternalTableColumnsTab.this.m_mdlTable.isImporting()) {
                                aColumn[iColumn].setLength(iEnd - iBegin + 1);
                            }
                            this.m_bAdjusting = true;
                            ++iColumn;
                        }
                    } else if (type.equalsIgnoreCase("Column:TypeChanged") && !(oColumn = (IColumn)ev.getModelObject()).getModel().isUndoing() && ExternalTableColumnsTab.this.m_mdlTable.containsColumn(oColumn) && oColumn.getType() == 0) {
                        oColumn.setLength(oColumn.getEndPosition() - oColumn.getBeginPosition() + 1);
                    }
                }
                finally {
                    this.m_bAdjusting = false;
                    this.m_bUpdateColumnModel = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void textColumnInserted(TextColumnModelEvent e) {
            if (this.m_bAdjusting || !this.m_bUpdateColumnModel) {
                return;
            }
            if (this.isColumnOverlapping()) {
                return;
            }
            try {
                this.m_bAdjusting = true;
                TextColumnModel mdl = ExternalTableColumnsTab.this.m_pnlRawData.getTextColumnHeader().getModel();
                int iColumn = e.getColumn();
                int beginNew = e.getBegin();
                int endNew = e.getEnd();
                if (beginNew > 0 && endNew > 0 && beginNew == endNew + 1) {
                    mdl.updateColumnEnd(iColumn, ++endNew);
                }
                ExternalTableColumnsTab.this.m_mdlTable.getModel().startCompoundUndoable();
                try {
                    IColumn oColumn = ExternalTableColumnsTab.this.m_mdlTable.getModel().getObjectFactory().createNewColumn(ExternalTableColumnsTab.this.m_mdlTable.getID());
                    oColumn.setName(ExternalTableColumnsTab.this.m_pnlColumns.getTableModel().createUniqueNameForNewColumn());
                    oColumn.setBeginPosition(beginNew);
                    oColumn.setEndPosition(endNew);
                    if (oColumn.getType() == 0) {
                        oColumn.setLength(endNew - beginNew + 1);
                    }
                    ExternalTableColumnsTab.this.m_mdlTable.addColumn(iColumn, oColumn);
                }
                catch (IllegalArgumentException ex) {
                    String sMessage = bundle.getString("ExternalTableColumnsTab.Error.InvalidNumericLength");
                    MessageUtil.displayMessage((String)sMessage, (int)0);
                    mdl.deleteColumn(iColumn);
                }
                finally {
                    ExternalTableColumnsTab.this.m_mdlTable.getModel().endCompoundUndoable();
                }
            }
            finally {
                this.m_bAdjusting = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void textColumnUpdated(TextColumnModelEvent e) {
            if (this.m_bAdjusting || !this.m_bUpdateColumnModel) {
                return;
            }
            try {
                TextColumnModel mdl = ExternalTableColumnsTab.this.m_pnlRawData.getTextColumnHeader().getModel();
                this.m_bAdjusting = true;
                int iColumn = e.getColumn();
                int iBegin = e.getNewBegin();
                int iEnd = e.getNewEnd();
                ExternalTableColumnsTab.this.m_mdlTable.getModel().startCompoundUndoable();
                try {
                    IColumn oColumn = ExternalTableColumnsTab.this.m_mdlTable.getColumns()[iColumn];
                    oColumn.setBeginPosition(iBegin);
                    oColumn.setEndPosition(iEnd);
                    if (oColumn.getType() == 0) {
                        oColumn.setLength(iEnd - iBegin + 1);
                    }
                }
                catch (IllegalArgumentException ex) {
                    MessageUtil.displayMessage((String)ex.getMessage(), (int)0);
                    mdl.updateColumn(iColumn, e.getOldBegin(), e.getOldEnd());
                }
                finally {
                    ExternalTableColumnsTab.this.m_mdlTable.getModel().endCompoundUndoable();
                }
            }
            finally {
                this.m_bAdjusting = false;
            }
        }

        @Override
        public void textColumnDeleted(TextColumnModelEvent e) {
            if (this.m_bAdjusting || !this.m_bUpdateColumnModel) {
                return;
            }
            if (this.isColumnOverlapping()) {
                return;
            }
            ExternalTableColumnsTab.this.m_mdlTable.getModel().startCompoundUndoable();
            try {
                this.m_bAdjusting = true;
                int iColumn = e.getColumn();
                ExternalTableColumnsTab.this.m_mdlTable.removeColumn(ExternalTableColumnsTab.this.m_mdlTable.getColumns()[iColumn]);
            }
            finally {
                ExternalTableColumnsTab.this.m_mdlTable.getModel().endCompoundUndoable();
                this.m_bAdjusting = false;
            }
        }

        private boolean isColumnOverlapping() {
            return ((IFixedWidthExternalFile)ExternalTableColumnsTab.this.m_mdlTable.getFile()).isOverlapEnabled();
        }
    }
}

