/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.efi2;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.ServerContext;
import com.sas.wadmin.efi2.AccessMethodTab;
import com.sas.wadmin.efi2.AdvancedFileQuotingTab;
import com.sas.wadmin.efi2.ExternalFileLocationPanel;
import com.sas.wadmin.efi2.ExternalTableDataModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.visuals.WsAppServerPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class ExternalFileTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(ExternalFileTab.class);
    private static final String DEFAULT = "DEFAULT";
    private static final String FTP = "FTP";
    private static final String URL = "URL";
    private ExternalFileLocationPanel m_pnlLocation;
    private WsAppServerPanel m_pnlAppServer;
    private AccessMethodTab m_pnlAccessMethod;
    private AdvancedFileQuotingTab m_pnlAdvancedFile;
    private ExternalTableDataModel m_mdlTable;

    public ExternalFileTab(ExternalTableDataModel mdlTable) {
        this.setHelpProduct("wdb");
        this.setHelpTopic("external_file_location_tab");
        this.initialize(mdlTable, false);
    }

    public ExternalFileTab(ExternalTableDataModel mdlTable, boolean bWizard) {
        this.setHelpProduct("wdb");
        this.setHelpTopic("external_file_location_tab");
        this.initialize(mdlTable, bWizard);
    }

    private void initialize(ExternalTableDataModel mdlTable, boolean bWizard) {
        this.m_mdlTable = mdlTable;
        this.m_pnlLocation = new ExternalFileLocationPanel(mdlTable, false);
        this.m_pnlAppServer = new WsAppServerPanel();
        this.m_pnlAppServer.setBorder((Border)WsUIUtilities.createTitledBorder((String)bundle.getString("ExternalFileTab.TitledBorder.ApplicationServer.txt")));
        this.m_pnlAppServer.setUpdateDefault(false);
        this.m_pnlAccessMethod = new AccessMethodTab(mdlTable, false);
        this.m_pnlAccessMethod.setBorder(WsUIUtilities.createTitledBorder((String)bundle.getString("ExternalFileTab.TitledBorder.AccessMethod.txt")));
        this.m_pnlAdvancedFile = new AdvancedFileQuotingTab(mdlTable);
        this.m_pnlAdvancedFile.setBorder(WsUIUtilities.createTitledBorder((String)bundle.getString("ExternalFileTab.TitledBorder.FileQuotingMethod.txt")));
        this.listenForDataChangesTo((WAPanel)this.m_pnlLocation);
        this.listenForDataChangesTo((WAPanel)this.m_pnlAppServer);
        this.listenForDataChangesTo((WAPanel)this.m_pnlAccessMethod);
        this.listenForDataChangesTo((WAPanel)this.m_pnlAdvancedFile);
        if (!bWizard) {
            cAccessMethodListener lsnr = new cAccessMethodListener();
            this.addPropertyChangeListener(lsnr);
            this.m_pnlAccessMethod.accessMethodValue.addPropertyChangeListener(lsnr);
        }
        this.setLayout(new GridBagLayout());
        this.add((Component)((Object)this.m_pnlLocation), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_pnlAppServer, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_pnlAccessMethod), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_pnlAdvancedFile), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void populateStore() throws MdException, RemoteException {
        this.m_mdlTable.populateStore();
        this.m_pnlAppServer.populateStore();
        this.m_pnlAccessMethod.populateStore();
        this.m_pnlAdvancedFile.populateStore();
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        ServerContext mdoServer = (ServerContext)this.m_mdlTable.getAppServerDC();
        if (mdoServer != null) {
            this.m_pnlAppServer.setSelectedServerFQID(mdoServer.getFQID());
        }
        this.m_pnlLocation.moveDataToView();
        this.m_pnlAppServer.moveDataToView();
        this.m_pnlAccessMethod.moveDataToView();
        this.m_pnlAdvancedFile.moveDataToView();
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.m_pnlLocation.moveDataToStore();
        this.m_pnlAccessMethod.moveDataToStore();
        this.m_pnlAdvancedFile.moveDataToStore();
        this.setDataChanged(false);
    }

    public boolean validateData() {
        if (!this.m_pnlAppServer.validateData()) {
            return false;
        }
        try {
            this.m_pnlAppServer.moveDataToStore();
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "ExternalFileTab:validateData");
            try {
                this.m_pnlAppServer.setReturnStore(store);
                this.m_mdlTable.updateAppServer(this.m_pnlAppServer.getSelectedServer());
            }
            finally {
                store.dispose();
            }
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return this.m_pnlAdvancedFile.validateData() && this.m_pnlAccessMethod.validateData() && this.m_pnlLocation.validateData();
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_pnlLocation.setEditable(bEditable);
        this.m_pnlAppServer.setEditable(bEditable);
        this.m_pnlAccessMethod.setEditable(bEditable);
        this.m_pnlAdvancedFile.setEditable(bEditable);
    }

    public void saveSettingsAndCleanUp() {
        this.m_pnlLocation.saveSettingsAndCleanUp();
        this.m_pnlAppServer.saveSettingsAndCleanUp();
        this.m_pnlAccessMethod.saveSettingsAndCleanUp();
        this.m_pnlAdvancedFile.saveSettingsAndCleanUp();
    }

    protected static interface AccessMethodListener
    extends PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent var1);
    }

    private class cAccessMethodListener
    implements AccessMethodListener {
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getNewValue() != null) {
                boolean accessMethod;
                String lnewValue = e.getNewValue().toString();
                boolean bl = accessMethod = lnewValue.equals(ExternalFileTab.FTP) || lnewValue.equals(ExternalFileTab.URL) || lnewValue.equals(ExternalFileTab.DEFAULT);
                if (accessMethod) {
                    ExternalFileTab.this.m_pnlAdvancedFile.setupButtons(lnewValue);
                }
            }
        }
    }
}

