/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.efi2;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.data.IExternalTable;
import com.sas.etl.models.data.externalfile.IStructuredExternalFile;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IHadoopServer;
import com.sas.etl.models.other.impl.BaseFTPServer;
import com.sas.etl.models.other.impl.BaseHTTPServer;
import com.sas.etl.models.other.impl.BaseHadoopServer;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.MdException;
import com.sas.rio.MVAResultSet;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.apache.commons.configuration.ConfigurationException;

public class ExternalFileLocationPanel2
extends WAPanel {
    private static final WAdminResource bundle = WAdminResource.getBundle(ExternalFileLocationPanel2.class);
    private static final String FileNameKey = "ExternalFileLocationPanel.FileName";
    private static final int FileNameMax = 8;
    private IExternalTable m_mdlTable;
    private IStructuredExternalFile m_mdlFile;
    private JLabel m_lblName;
    private WAComboBox m_cmbName;
    private JCheckBox m_ckbDirectory;
    private JButton m_btnBrowse;
    private WsAbstractAction m_actBrowse;
    private ItemListener m_lsnrFileName;
    private IModelListener m_lsnrModel;

    public ExternalFileLocationPanel2(IExternalTable mdlTable) {
        this.m_mdlTable = mdlTable;
        this.m_mdlFile = mdlTable.getFile();
        this.setHelpProduct("wdb");
        this.setHelpTopic("external_file_location");
        this.initialize();
    }

    protected void initialize() {
        this.m_cmbName = new WAComboBox();
        this.m_cmbName.setEditable(true);
        this.m_cmbName.setPrototypeDisplayValue((Object)"c:\\documents and settings\\YourName\\data.txt");
        this.m_lblName = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbName, (WAdminResource)bundle, (String)"ExternalFileLocationPanel.Label.FileName");
        this.m_ckbDirectory = WsUIUtilities.createCheckBox((WsAbstractToggleAction)new cDirectoryAction());
        this.m_actBrowse = new cBrowseAction();
        this.m_btnBrowse = new JButton((Action)this.m_actBrowse);
        this.m_lsnrFileName = new cItemListener();
        this.m_lsnrModel = new ModelListener();
        this.m_cmbName.addItemListener(this.m_lsnrFileName);
        this.m_mdlTable.getModel().addModelListener(this.m_lsnrModel);
        this.setLayout(new GridBagLayout());
        this.add(this.m_lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_cmbName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.add(this.m_btnBrowse, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add(this.m_ckbDirectory, new GridBagConstraints(1, 1, 4, 1, 1.0, 0.0, 17, 2, new Insets(5, 1, 0, 0), 0, 0));
        this.listenForDataChangesTo((JComboBox)this.m_cmbName);
        this.listenForDataChangesTo(this.m_ckbDirectory);
    }

    public Component getDefaultFocusComponent() {
        return this.m_cmbName;
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_cmbName.removeItemListener(this.m_lsnrFileName);
        this.m_cmbName.removeAllItems();
        this.m_cmbName.loadItems(FileNameKey, 8);
        String sName = this.m_mdlTable.getFile().getFileName();
        if (sName.length() != 0) {
            this.m_cmbName.setSelectedItem((Object)sName);
        }
        this.m_cmbName.addItemListener(this.m_lsnrFileName);
        this.m_ckbDirectory.setSelected(this.m_mdlFile.isDirectory());
        this.m_ckbDirectory.setEnabled(this.isDirectoryEnabled());
        this.updateComponents();
        this.setListeningForChanges(true);
    }

    private boolean isDirectoryEnabled() {
        return this.isEditable() && this.m_mdlFile.getAccessServer() instanceof IHadoopServer;
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.m_cmbName.saveItems(FileNameKey, 8);
        this.setDataChanged(false);
    }

    public void saveSettingsAndCleanUp() {
        this.m_mdlTable.getModel().removeModelListener(this.m_lsnrModel);
    }

    public boolean validateData() {
        block25: {
            String dsString;
            String tName;
            WsAppServer appServer;
            String sName = this.m_cmbName.getText();
            if (sName == null || sName.length() == 0) {
                MessageUtil.displayMessage((String)bundle.getString("ExternalFileLocationPanel.Error.BlankFileName.txt"), (int)0);
                this.m_cmbName.requestFocus();
                return false;
            }
            if (this.m_mdlFile.isDoubleQuoteFilename()) {
                appServer = WsAppServer.createAppServer((String)this.m_mdlFile.getServer().getID());
                if (appServer == null) {
                    return false;
                }
                tName = "";
                dsString = " data work._ETL_Temp; \n length fname $200.; \n fname = \"" + sName + "\"; \nrun;";
                MVAResultSet myTable = null;
                try {
                    appServer.submitSASCode(dsString);
                    dsString = "select fname from work._ETL_Temp";
                    myTable = appServer.submitSQLStatement(dsString);
                    myTable.next();
                    tName = myTable.getString(1).trim();
                    myTable.close();
                }
                catch (SQLException sQLException) {
                }
                catch (WsAppServerCodeException wsAppServerCodeException) {
                }
                catch (WsAppServerFailException wsAppServerFailException) {}
            } else if (this.m_mdlFile.isNoQuoteFilename()) {
                appServer = WsAppServer.createAppServer((String)this.m_mdlFile.getServer().getID());
                if (appServer == null) {
                    return false;
                }
                tName = "";
                dsString = "";
                MVAResultSet myTable = null;
                try {
                    dsString = "select xpath from DICTIONARY.EXTFILES where fileref=\"" + sName.toUpperCase() + "\"";
                    myTable = appServer.submitSQLStatement(dsString);
                    myTable.next();
                    tName = myTable.getString(1).trim();
                    myTable.close();
                }
                catch (SQLException sQLException) {
                }
                catch (WsAppServerFailException wsAppServerFailException) {
                    // empty catch block
                }
            }
            if ((appServer = WsAppServer.createAppServer((String)this.m_mdlFile.getServer().getID())) == null) {
                return false;
            }
            try {
                appServer.doesFileExist(this.m_mdlTable.getAccessMethodFileName(sName), this.m_mdlTable.getAccessMethodNickName(), this.m_mdlTable.getAccessMethodOptions("_temp"), this.m_mdlTable.getAccessMethodPreCode("_temp"));
            }
            catch (BadServerDefinitionException e) {
                int response = MessageUtil.displayMessage((String)bundle.formatString("ExternalFileLocationPanel.Error.GenericError.fmt.txt", (Object)e.getLocalizedMessage()), (int)2, (int)2);
                if (response != 0) {
                    return false;
                }
            }
            catch (CodegenException e) {
                int response = MessageUtil.displayMessage((String)bundle.formatString("ExternalFileLocationPanel.Error.GenericError.fmt.txt", (Object)e.getLocalizedMessage()), (int)2, (int)2);
                if (response != 0) {
                    return false;
                }
            }
            catch (ConfigurationException e) {
                int response = MessageUtil.displayMessage((String)bundle.formatString("ExternalFileLocationPanel.Error.GenericError.fmt.txt", (Object)e.getLocalizedMessage()), (int)2, (int)2);
                if (response != 0) {
                    return false;
                }
            }
            catch (WsAppServerFailException e) {
                int response = MessageUtil.displayMessage((String)bundle.formatString("ExternalFileLocationPanel.Error.GenericError.fmt.txt", (Object)e.getLocalizedMessage()), (int)2, (int)2);
                if (response != 0) {
                    return false;
                }
            }
            catch (GenericError e) {
                if (this.m_mdlFile.isDoubleQuoteFilename() || this.m_mdlFile.isNoQuoteFilename()) {
                    return true;
                }
                int response = MessageUtil.displayMessage((String)bundle.formatString("ExternalFileLocationPanel.Error.GenericError.fmt.txt", (Object)e.getLocalizedMessage()), (int)2, (int)2);
                if (response == 0) break block25;
                return false;
            }
        }
        return true;
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.updateComponents();
    }

    private void updateComponents() {
        this.m_cmbName.setEnabled(this.isEditable());
        boolean isFTPSelected = this.m_mdlFile.getAccessServer() instanceof BaseFTPServer;
        boolean isHTTPSelected = this.m_mdlFile.getAccessServer() instanceof BaseHTTPServer;
        boolean isHadoopSelected = this.m_mdlFile.getAccessServer() instanceof BaseHadoopServer;
        boolean defaultAccess = true;
        if (isFTPSelected || isHTTPSelected || isHadoopSelected) {
            defaultAccess = false;
        }
        this.m_actBrowse.setEnabled(this.isEditable() && defaultAccess);
        this.m_ckbDirectory.setEnabled(this.isDirectoryEnabled());
    }

    private class cDirectoryAction
    extends WsAbstractToggleAction {
        public cDirectoryAction() {
            super(bundle, "ExternalFileLocationPanel.Checkbox.AllFilesInLocation", 0);
        }

        public void actionPerformed(ActionEvent e) {
            ExternalFileLocationPanel2.this.m_mdlFile.setIsDirectory(ExternalFileLocationPanel2.this.m_ckbDirectory.isSelected());
        }
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String type = ev.getType();
            if (type.equals("IFile:FileNameChanged")) {
                for (int iFile = 0; iFile < ExternalFileLocationPanel2.this.m_cmbName.getItemCount(); ++iFile) {
                    if (!ExternalFileLocationPanel2.this.m_cmbName.getItemAt(iFile).equals(ExternalFileLocationPanel2.this.m_mdlFile.getFileName())) continue;
                    ExternalFileLocationPanel2.this.m_cmbName.setSelectedIndex(iFile);
                    return;
                }
                ExternalFileLocationPanel2.this.m_cmbName.addItem((Object)ExternalFileLocationPanel2.this.m_mdlFile.getFileName());
                ExternalFileLocationPanel2.this.m_cmbName.setSelectedItem((Object)ExternalFileLocationPanel2.this.m_mdlFile.getFileName());
            } else if ("ExternalTable:IsDirectoryChanged".equals(type)) {
                ExternalFileLocationPanel2.this.m_ckbDirectory.setSelected((Boolean)ev.getData());
            } else if ("ExternalTable:AccessServerChanged".equals(type)) {
                ExternalFileLocationPanel2.this.updateComponents();
            }
        }
    }

    private class cItemListener
    implements ItemListener {
        private cItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            JComboBox cmb = (JComboBox)e.getItemSelectable();
            if (cmb == ExternalFileLocationPanel2.this.m_cmbName) {
                ExternalFileLocationPanel2.this.m_mdlFile.setFileName(ExternalFileLocationPanel2.this.m_cmbName.getText());
            }
        }
    }

    private class cBrowseAction
    extends WsAbstractAction {
        protected cBrowseAction() {
            super(bundle, "ExternalFileLocationPanel.Action.Browse", false, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            try {
                String filename;
                ExternalFileLocationPanel2.this.setCursor(Cursor.getPredefinedCursor(3));
                WsAppServer appServer = WsAppServer.createAppServer((String)ExternalFileLocationPanel2.this.m_mdlFile.getServer().getID());
                if (appServer == null) {
                    return;
                }
                String strOS = appServer.getOperatingSystem();
                if (strOS.equalsIgnoreCase("OS")) {
                    MessageUtil.displayMessage((String)bundle.getString("ExternalFileLocationPanel.Error.UnableToBrowse.txt"), (int)0);
                    return;
                }
                LinkedHashMap<String, String> mapFileTypes = new LinkedHashMap<String, String>();
                mapFileTypes.put(bundle.getString("ExternalFileLocationPanel.TextFileTypes.txt"), "TXT");
                mapFileTypes.put(bundle.getString("ExternalFileLocationPanel.DelimitedFileTypes.txt"), "CSV");
                mapFileTypes.put(bundle.getString("ExternalFileLocationPanel.DataFileTypes.txt"), "DAT");
                mapFileTypes.put(bundle.getString("ExternalFileLocationPanel.AllFileTypes.txt"), "*");
                String sName = (String)ExternalFileLocationPanel2.this.m_cmbName.getSelectedItem();
                if (sName == null) {
                    sName = "";
                }
                if ((filename = appServer.promptForFilename(bundle.getString("ExternalFileLocationPanel.RemoteFileSelector.Title.txt"), sName, mapFileTypes)) != null) {
                    ExternalFileLocationPanel2.this.m_cmbName.setSelectedItem((Object)filename);
                }
                appServer.close();
            }
            catch (WsAppServerFailException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (GenericError ge) {
                MessageUtil.displayMessage((String)ge.getLocalizedMessage(), (int)0);
            }
            finally {
                ExternalFileLocationPanel2.this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }
}

