/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.efi2;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.ExternalTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Tree;
import com.sas.rio.MVAResultSet;
import com.sas.services.information.metadata.OMRExternalFile;
import com.sas.wadmin.efi2.AccessMethodTab;
import com.sas.wadmin.efi2.AdvancedFileQuotingTab;
import com.sas.wadmin.efi2.ExternalTableDataModel;
import com.sas.wadmin.efi2.RawDataPanel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.visuals.WAGeneralPanel;
import com.sas.workspace.visuals.WsAppServerPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ExternalFileLocationPanel
extends WsDescriptionWizardTab {
    private static final WAdminResource bundle = WAdminResource.getBundle(ExternalFileLocationPanel.class);
    private static final String FileNameKey = "ExternalFileLocationPanel.FileName";
    private static final int FileNameMax = 8;
    private ExternalTableDataModel m_mdlTable;
    private JLabel m_lblName;
    private WAComboBox m_cmbName;
    private JCheckBox m_ckbDirectory;
    private JButton m_btnBrowse;
    private JButton m_btnPreview;
    private JButton m_btnAdvanced;
    private WsAbstractAction m_actBrowse;
    private WsAbstractAction m_actPreview;
    private WsAbstractAction m_actAdvanced;
    private DocumentListener m_lsnrCmbName;

    public ExternalFileLocationPanel(ExternalTableDataModel mdlTable, boolean bWizard) {
        super(bundle.getString("ExternalFileLocationPanel.Description.txt"));
        this.m_mdlTable = mdlTable;
        this.setHelpProduct("wdb");
        this.setHelpTopic("external_file_location");
        this.initialize(bWizard);
    }

    private void initialize(boolean bWizard) {
        this.m_cmbName = new WAComboBox();
        this.m_cmbName.setEditable(true);
        this.m_cmbName.setPrototypeDisplayValue((Object)"c:\\documents and settings\\YourName\\data.txt");
        this.m_lblName = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbName, (WAdminResource)bundle, (String)"ExternalFileLocationPanel.Label.FileName");
        this.m_ckbDirectory = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"ExternalFileLocationPanel.Checkbox.AllFilesInLocation");
        this.m_actBrowse = new cBrowseAction();
        this.m_actPreview = new cPreviewAction();
        this.m_actAdvanced = new cAdvancedAction();
        this.m_actPreview.setEnabled(false);
        this.m_btnBrowse = new JButton((Action)this.m_actBrowse);
        this.m_btnPreview = new JButton((Action)this.m_actPreview);
        this.m_btnAdvanced = new JButton((Action)this.m_actAdvanced);
        this.setLayout(new GridBagLayout());
        this.add(this.m_lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_cmbName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.add(this.m_btnBrowse, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add(this.m_ckbDirectory, new GridBagConstraints(1, 1, 4, 1, 1.0, 0.0, 17, 2, new Insets(5, 1, 0, 0), 0, 0));
        if (bWizard) {
            this.add(this.m_btnPreview, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
            this.add(new JPanel(), new GridBagConstraints(1, 2, 4, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this.m_btnAdvanced, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 1, 0, 0), 0, 0));
        }
        this.listenForDataChangesTo((JComboBox)this.m_cmbName);
        this.listenForDataChangesTo(this.m_ckbDirectory);
        this.m_lsnrCmbName = new cFileNameListener();
        this.m_cmbName.getTextComponent().getDocument().addDocumentListener(this.m_lsnrCmbName);
    }

    public Component getDefaultFocusComponent() {
        return this.m_cmbName;
    }

    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        if (!bSaveToModel) {
            WAWizardDialog dlgWizard = (WAWizardDialog)this.getTopLevelAncestor();
            MdObjectStore store = (MdObjectStore)dlgWizard.getWizardData("OBJECTSTORE");
            WAGeneralPanel generalPanel = (WAGeneralPanel)dlgWizard.getWizardData("GENERALPANEL");
            Tree selectedFolder = generalPanel.getOwningTree();
            dlgWizard.addWizardData("GROUP", (Object)selectedFolder);
            if (dlgWizard.getWizardData("MASTEROBJECT") == null) {
                WAGeneralPanel panel = (WAGeneralPanel)dlgWizard.getWizardData("GENERALPANEL");
                Tree mdoFolder = panel.getOwningTree();
                String sContainerID = null;
                sContainerID = Workspace.getWorkspace().isChangeManagementOn() ? Workspace.getWorkspace().getDefaultRepository().getFQID().substring(9, 17) : mdoFolder.getFQID().substring(0, 8);
                ExternalTable table = (ExternalTable)Workspace.getMdFactory().createComplexMetadataObject(store, panel.getNameComponent().getText(), "ExternalTable", sContainerID);
                table.setDesc(panel.getDescriptionComponent().getText());
                table.setPublicType("ExternalFile");
                table.setUsageVersion(OMRExternalFile.CURRENT_VERSION.encode());
                table.getTrees().add((Object)mdoFolder);
                this.m_mdlTable = (ExternalTableDataModel)((Object)dlgWizard.getWizardData("EFIDATAMODEL"));
                this.m_mdlTable.setCreateNewTable(true);
                this.m_mdlTable.setExternalTable(table);
                String strType = (String)dlgWizard.getWizardData("EFITYPE");
                if (strType != null && strType.equalsIgnoreCase("DELIMITED")) {
                    this.m_mdlTable.setDelimited(true);
                    this.m_mdlTable.setMissover(true);
                } else {
                    this.m_mdlTable.setFixedWidth(true);
                }
                dlgWizard.addWizardData("MASTEROBJECT", (Object)table);
            } else {
                WAGeneralPanel panel = (WAGeneralPanel)dlgWizard.getWizardData("GENERALPANEL");
                Tree mdoFolder = panel.getOwningTree();
                ExternalTable oldtable = (ExternalTable)dlgWizard.getWizardData("MASTEROBJECT");
                if (!Workspace.getWorkspace().isChangeManagementOn()) {
                    String sTableRepositoryID;
                    String sTreeRepositoryID = panel.getOwningTree().getFQID().substring(0, 8);
                    if (!sTreeRepositoryID.equalsIgnoreCase(sTableRepositoryID = oldtable.getFQID().substring(0, 8))) {
                        store.clearObjectsFromStore();
                        ExternalTable newtable = (ExternalTable)Workspace.getMdFactory().createComplexMetadataObject(store, panel.getNameComponent().getText(), "ExternalTable", sTreeRepositoryID);
                        newtable.setPublicType("ExternalFile");
                        newtable.setUsageVersion(OMRExternalFile.CURRENT_VERSION.encode());
                        newtable.getTrees().add((Object)mdoFolder);
                        this.m_mdlTable = (ExternalTableDataModel)((Object)dlgWizard.getWizardData("EFIDATAMODEL"));
                        this.m_mdlTable.setCreateNewTable(true);
                        this.m_mdlTable.setExternalTable(newtable);
                        String strType = (String)dlgWizard.getWizardData("EFITYPE");
                        if (strType != null && strType.equalsIgnoreCase("DELIMITED")) {
                            this.m_mdlTable.setDelimited(true);
                            this.m_mdlTable.setMissover(true);
                        } else {
                            this.m_mdlTable.setFixedWidth(true);
                        }
                        dlgWizard.addWizardData("MASTEROBJECT", (Object)newtable);
                        oldtable = newtable;
                    } else {
                        String strExistingOwningTree;
                        String strNewOwningTree = panel.getOwningTree().getFQID();
                        if (strNewOwningTree != (strExistingOwningTree = ((Tree)oldtable.getTrees().get(0)).getFQID())) {
                            oldtable.getTrees().removeAllElements();
                            oldtable.getTrees().add((Object)panel.getOwningTree());
                        }
                    }
                } else {
                    String strExistingOwningTree;
                    String strNewOwningTree = panel.getOwningTree().getFQID();
                    if (strNewOwningTree != (strExistingOwningTree = ((Tree)oldtable.getTrees().get(0)).getFQID())) {
                        oldtable.getTrees().removeAllElements();
                        oldtable.getTrees().add((Object)panel.getOwningTree());
                    }
                }
                oldtable.setName(panel.getNameComponent().getText());
                oldtable.setDesc(panel.getDescriptionComponent().getText());
            }
            this.moveDataToView();
        } else {
            this.moveDataToStore();
        }
        return true;
    }

    public void onNext() {
        try {
            this.moveDataToStore();
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public void populateStore() throws MdException, RemoteException {
        this.m_mdlTable.populateStore();
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        if (this.m_cmbName.getItemCount() == 0) {
            this.m_cmbName.loadItems(FileNameKey, 8);
            String sName = this.m_mdlTable.getFilename();
            if (sName.length() != 0) {
                this.m_cmbName.setSelectedItem((Object)sName);
            }
        }
        this.m_ckbDirectory.setSelected(this.m_mdlTable.isDirectory());
        this.updateComponents();
        this.m_mdlTable.setSelectedNewFile(false);
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.m_cmbName.saveItems(FileNameKey, 8);
        String sName = this.m_cmbName.getText();
        if (sName == null) {
            sName = "";
        }
        if (!this.m_mdlTable.getFilename().equals(sName)) {
            this.m_mdlTable.setFileName(sName);
            ExternalTable table = this.m_mdlTable.getExternalTable();
            if (table.isNewObject()) {
                // empty if block
            }
        }
        this.m_mdlTable.setIsDirectory(this.m_ckbDirectory.isSelected());
        this.setDataChanged(false);
    }

    public boolean validateData() {
        block21: {
            String tName;
            WsAppServer appServer;
            String sName = this.m_cmbName.getText();
            if (sName == null || sName.length() == 0) {
                MessageUtil.displayMessage((String)bundle.getString("ExternalFileLocationPanel.Error.BlankFileName.txt"), (int)0);
                this.m_cmbName.requestFocus();
                return false;
            }
            if (this.m_mdlTable.isDoubleQuotesEnabled()) {
                appServer = this.m_mdlTable.getAppServer();
                if (appServer == null) {
                    return false;
                }
                tName = "";
                String dsString = " data work._ETL_Temp; \n length fname $200.; \n fname = \"" + sName + "\"; \nrun;";
                MVAResultSet myTable = null;
                try {
                    appServer.submitSASCode(dsString);
                    dsString = "select fname from work._ETL_Temp";
                    myTable = appServer.submitSQLStatement(dsString);
                    myTable.next();
                    tName = myTable.getString(1).trim();
                    myTable.close();
                }
                catch (SQLException sQLException) {
                }
                catch (WsAppServerCodeException wsAppServerCodeException) {
                }
                catch (WsAppServerFailException wsAppServerFailException) {
                    // empty catch block
                }
                this.m_mdlTable.setLogicalFilename(tName);
            } else if (this.m_mdlTable.isNoQuotesEnabled()) {
                appServer = this.m_mdlTable.getAppServer();
                if (appServer == null) {
                    return false;
                }
                tName = "";
                String dsString = "";
                MVAResultSet myTable = null;
                try {
                    dsString = "select xpath from DICTIONARY.EXTFILES where fileref=\"" + sName.toUpperCase() + "\"";
                    myTable = appServer.submitSQLStatement(dsString);
                    myTable.next();
                    tName = myTable.getString(1).trim();
                    myTable.close();
                }
                catch (SQLException sQLException) {
                }
                catch (WsAppServerFailException wsAppServerFailException) {
                    // empty catch block
                }
                this.m_mdlTable.setLogicalFilename(tName);
            } else {
                this.m_mdlTable.setLogicalFilename(sName);
            }
            try {
                boolean exist = this.m_mdlTable.doesFileExist(sName);
                this.m_mdlTable.setFileExists(exist);
            }
            catch (WsAppServerFailException e) {
                this.m_mdlTable.setFileExists(false);
                int response = MessageUtil.displayMessage((String)bundle.formatString("ExternalFileLocationPanel.Error.GenericError.fmt.txt", (Object)e.getLocalizedMessage()), (int)2, (int)2);
                if (response != 0) {
                    return false;
                }
            }
            catch (MdException e) {
                this.m_mdlTable.setFileExists(false);
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
                return false;
            }
            catch (RemoteException e) {
                this.m_mdlTable.setFileExists(false);
                Workspace.handleRemoteException((RemoteException)e);
                return false;
            }
            catch (GenericError e) {
                this.m_mdlTable.setFileExists(false);
                if (this.m_mdlTable.isDoubleQuotesEnabled() || this.m_mdlTable.isNoQuotesEnabled()) {
                    return true;
                }
                int response = MessageUtil.displayMessage((String)bundle.formatString("ExternalFileLocationPanel.Error.GenericError.fmt.txt", (Object)e.getLocalizedMessage()), (int)2, (int)2);
                if (response == 0) break block21;
                return false;
            }
        }
        return true;
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.updateComponents();
    }

    private void updateComponents() {
        this.m_cmbName.setEnabled(this.isEditable());
        this.m_actBrowse.setEnabled(this.isEditable());
        this.m_actBrowse.setEnabled(this.isEditable() && this.m_mdlTable.isDefaultAccessMethod());
        this.m_actPreview.setEnabled(this.isEditable());
    }

    private class cAdvancedAction
    extends WsAbstractAction {
        public cAdvancedAction() {
            super(bundle, "DelimitedExternalTablePanel.Action.Advanced", false, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            WsAppServerPanel tabAppServer = new WsAppServerPanel();
            tabAppServer.setUpdateDefault(false);
            tabAppServer.setHelpProduct("wdb");
            tabAppServer.setHelpTopic("adv_file_loc_server");
            WsAppServer oServer = ExternalFileLocationPanel.this.m_mdlTable.getAppServer(false);
            if (oServer != null) {
                tabAppServer.setSelectedServerFQID(oServer.getServerFQID());
            }
            WAPropertyDialog dlg = new WAPropertyDialog((Frame)Workspace.getWorkspace(), bundle.getString("ExternalFileLocationPanel.AdvancedDialog.Title.txt"), true);
            dlg.addTab(bundle.getString("ExternalFileLocationPanel.AdvancedDialog.ServerTab.Title.txt"), (WAPropertyTab)tabAppServer);
            dlg.addTab(bundle.getString("ExternalFileLocationPanel.AdvancedDialog.AccessMethodTab.Title.txt"), (WAPropertyTab)new AccessMethodTab(ExternalFileLocationPanel.this.m_mdlTable));
            dlg.addTab(bundle.getString("ExternalFileLocationPanel.AdvancedDialog.QuotingTab.Title.txt"), (WAPropertyTab)new AdvancedFileQuotingTab(ExternalFileLocationPanel.this.m_mdlTable));
            dlg.show();
            if (dlg.getReturnValue() == 1) {
                try {
                    MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "ExternalFileLocationPanel:cAdvancedAction");
                    try {
                        tabAppServer.setReturnStore(store);
                        ExternalFileLocationPanel.this.m_mdlTable.updateAppServer(tabAppServer.getSelectedServer());
                    }
                    finally {
                        store.dispose();
                    }
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
            ExternalFileLocationPanel.this.updateComponents();
        }
    }

    private class cFileNameListener
    implements DocumentListener {
        private cFileNameListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updatePreviewAction();
            ExternalFileLocationPanel.this.m_mdlTable.setSelectedNewFile(true);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updatePreviewAction();
            ExternalFileLocationPanel.this.m_mdlTable.setSelectedNewFile(true);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updatePreviewAction();
        }

        protected void updatePreviewAction() {
            String sName = ExternalFileLocationPanel.this.m_cmbName.getText();
            ExternalFileLocationPanel.this.m_actPreview.setEnabled(sName != null && sName.length() > 0);
        }
    }

    private class cPreviewAction
    extends WsAbstractAction {
        protected cPreviewAction() {
            super(bundle, "ExternalFileLocationPanel.Action.Preview", false, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            try {
                ExternalFileLocationPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                String sName = ExternalFileLocationPanel.this.m_cmbName.getText();
                ExternalFileLocationPanel.this.m_mdlTable.setFileName(sName);
                ExternalFileLocationPanel.this.m_mdlTable.doesFileExist(ExternalFileLocationPanel.this.m_mdlTable.getFilename());
                WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.formatString("ExternalFileLocationPanel.Preview.Title.fmt.txt", (Object)ExternalFileLocationPanel.this.m_mdlTable.getFilename()), true);
                dialog.setMainPanel((WAPanel)new RawDataPanel(ExternalFileLocationPanel.this.m_mdlTable));
                dialog.setEditable(false);
                dialog.setOKButtonVisible(true);
                dialog.setCancelButtonVisible(false);
                dialog.setApplyButtonVisible(false);
                dialog.setHelpButtonVisible(false);
                dialog.setResizable(true);
                dialog.show();
            }
            catch (WsAppServerFailException ae) {
                MessageUtil.displayMessage((String)ae.getLocalizedMessage(), (int)0);
            }
            catch (GenericError ge) {
                MessageUtil.displayMessage((String)ge.getLocalizedMessage(), (int)0);
            }
            catch (MdException me) {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            finally {
                ExternalFileLocationPanel.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private class cBrowseAction
    extends WsAbstractAction {
        protected cBrowseAction() {
            super(bundle, "ExternalFileLocationPanel.Action.Browse", false, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            try {
                String filename;
                ExternalFileLocationPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                WsAppServer appServer = ExternalFileLocationPanel.this.m_mdlTable.getAppServer();
                if (appServer == null) {
                    return;
                }
                String strOS = appServer.getOperatingSystem();
                if (strOS.equalsIgnoreCase("OS")) {
                    MessageUtil.displayMessage((String)bundle.getString("ExternalFileLocationPanel.Error.UnableToBrowse.txt"), (int)0);
                    return;
                }
                LinkedHashMap<String, String> mapFileTypes = new LinkedHashMap<String, String>();
                mapFileTypes.put(bundle.getString("ExternalFileLocationPanel.TextFileTypes.txt"), "TXT");
                mapFileTypes.put(bundle.getString("ExternalFileLocationPanel.DelimitedFileTypes.txt"), "CSV");
                mapFileTypes.put(bundle.getString("ExternalFileLocationPanel.DataFileTypes.txt"), "DAT");
                mapFileTypes.put(bundle.getString("ExternalFileLocationPanel.AllFileTypes.txt"), "*");
                String sName = (String)ExternalFileLocationPanel.this.m_cmbName.getSelectedItem();
                if (sName == null) {
                    sName = "";
                }
                if ((filename = appServer.promptForFilename(bundle.getString("ExternalFileLocationPanel.RemoteFileSelector.Title.txt"), sName, mapFileTypes)) != null) {
                    ExternalFileLocationPanel.this.m_cmbName.setSelectedItem((Object)filename);
                }
                appServer.close();
            }
            catch (WsAppServerFailException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (GenericError ge) {
                MessageUtil.displayMessage((String)ge.getLocalizedMessage(), (int)0);
            }
            finally {
                ExternalFileLocationPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }
}

