/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.efi2;

import com.sas.metadata.remote.MdException;
import com.sas.wadmin.efi2.AdvancedExternalFileParametersPanel;
import com.sas.wadmin.efi2.ExternalTableDataModel;
import com.sas.wadmin.efi2.GuessingRowsModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAIntTextField;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.text.JTextComponent;

public class DelimitedExternalTablePanel
extends WsDescriptionWizardTab {
    private static final WAdminResource bundle = WAdminResource.getBundle(DelimitedExternalTablePanel.class);
    private ExternalTableDataModel m_mdlTable;
    private JLabel m_lblDisabled;
    private JLabel m_lblSpaceHolder;
    private JCheckBox m_ckbBlank;
    private JCheckBox m_ckbComma;
    private JCheckBox m_ckbSemicolon;
    private JCheckBox m_ckbTab;
    private JCheckBox m_ckbOthers;
    private JTextField m_txtOthers;
    private JPanel m_pnlDelimiters;
    private JCheckBox m_ckbConsecutiveDelimiters;
    private JCheckBox m_ckbMultipleRowsPerRecord;
    private WAIntTextField m_txtNumberOfColumnsPerRow;
    private JLabel m_lblNumberOfColumnsPerRow;
    private JPanel m_pnlMultipleRowsPerRecord;
    private JRadioButton m_rbnReadNextRecord;
    private JRadioButton m_rbnSetToMissing;
    private JPanel m_pnlMissingValues;
    private JLabel m_lblRecordLength;
    private WAIntTextField m_txtRecordLength;
    private JPanel m_pnlRecordLength;
    private JButton m_btnAdvanced;
    private WsAbstractAction m_actAdvanced;
    private ItemListener m_lsnrCommon;
    private ActionListener m_lsnrFocusMover;
    private boolean m_preserveView;
    private boolean m_properties;

    public DelimitedExternalTablePanel(ExternalTableDataModel mdlTable) {
        super(bundle.getString("DelimitedExternalTablePanel.Description.txt"));
        this.m_mdlTable = mdlTable;
        this.m_preserveView = false;
        this.setHelpProduct("wdb");
        this.setHelpTopic("delimiters_parameters");
        this.initialize(this.m_mdlTable.getExternalTable() != null);
    }

    protected void initialize(boolean bProperties) {
        this.m_properties = bProperties;
        this.m_lblDisabled = new JLabel(bundle.getString("DelimitedExternalTablePanel.Label.Disabled.txt"));
        this.m_lblDisabled.setFont(this.m_lblDisabled.getFont().deriveFont(1));
        this.m_lblDisabled.setVisible(false);
        this.m_lblSpaceHolder = new JLabel(" ");
        this.m_lsnrCommon = new cCommonListener();
        this.m_lsnrFocusMover = new cFocusMover();
        this.createDelimitersPanel();
        this.createMultipleRowsPerRecordPanel(bProperties);
        this.createMissingValuesPanel();
        this.createLogicalRecordLengthPanel();
        this.m_ckbConsecutiveDelimiters = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"DelimitedExternalTablePanel.Checkbox.ConsecutiveDelimiters");
        this.listenForDataChangesTo(this.m_ckbConsecutiveDelimiters);
        this.m_actAdvanced = new cAdvancedAction();
        this.m_btnAdvanced = new JButton((Action)this.m_actAdvanced);
        this.setLayout(new GridBagLayout());
        this.add(this.m_lblDisabled, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this.m_pnlDelimiters, new GridBagConstraints(1, 1, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_ckbConsecutiveDelimiters, new GridBagConstraints(1, 2, 3, 1, 1.0, 0.0, 17, 0, new Insets(15, 0, 0, 0), 0, 0));
        this.add(this.m_pnlMultipleRowsPerRecord, new GridBagConstraints(1, 3, 3, 1, 1.0, 0.0, 17, 0, new Insets(15, 0, 0, 0), 0, 0));
        this.add(this.m_pnlMissingValues, new GridBagConstraints(1, 4, 3, 1, 1.0, 0.0, 17, 2, new Insets(15, 0, 0, 0), 0, 0));
        this.add(this.m_pnlRecordLength, new GridBagConstraints(1, 5, 3, 1, 1.0, 0.0, 17, 0, new Insets(15, 5, 0, 0), 0, 0));
        this.add(this.m_lblSpaceHolder, new GridBagConstraints(1, 6, 3, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(1, 7, 3, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_btnAdvanced, new GridBagConstraints(3, 8, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
    }

    private void createDelimitersPanel() {
        this.m_ckbBlank = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"DelimitedExternalTablePanel.Checkbox.Blank");
        this.m_ckbComma = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"DelimitedExternalTablePanel.Checkbox.Comma");
        this.m_ckbSemicolon = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"DelimitedExternalTablePanel.Checkbox.Semicolon");
        this.m_ckbTab = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"DelimitedExternalTablePanel.Checkbox.Tab");
        this.m_ckbOthers = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"DelimitedExternalTablePanel.Checkbox.Others");
        this.m_ckbOthers.addItemListener(this.m_lsnrCommon);
        this.m_ckbOthers.addActionListener(this.m_lsnrFocusMover);
        this.m_txtOthers = new WATextField(4);
        this.m_txtOthers.setToolTipText(bundle.getString("DelimitedExternalTablePanel.TextField.Others.tip"));
        this.listenForDataChangesTo(this.m_ckbBlank);
        this.listenForDataChangesTo(this.m_ckbComma);
        this.listenForDataChangesTo(this.m_ckbSemicolon);
        this.listenForDataChangesTo(this.m_ckbTab);
        this.listenForDataChangesTo(this.m_ckbOthers);
        this.listenForDataChangesTo(this.m_txtOthers);
        this.m_pnlDelimiters = new JPanel(new GridBagLayout());
        this.m_pnlDelimiters.setBorder(WsUIUtilities.createTitledBorder((String)bundle.getString("DelimitedExternalTablePanel.BorderTitle.Delimiters.txt")));
        this.m_pnlDelimiters.add((Component)this.m_ckbBlank, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlDelimiters.add((Component)this.m_ckbComma, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.m_pnlDelimiters.add((Component)this.m_ckbSemicolon, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.m_pnlDelimiters.add((Component)this.m_ckbTab, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.m_pnlDelimiters.add((Component)this.m_ckbOthers, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlDelimiters.add((Component)this.m_txtOthers, new GridBagConstraints(1, 1, 4, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
    }

    private void createMultipleRowsPerRecordPanel(boolean bProperties) {
        this.m_ckbMultipleRowsPerRecord = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"DelimitedExternalTablePanel.Checkbox.MultipleRowsPerRecord");
        this.m_ckbMultipleRowsPerRecord.addItemListener(this.m_lsnrCommon);
        this.m_ckbMultipleRowsPerRecord.addActionListener(this.m_lsnrFocusMover);
        this.m_txtNumberOfColumnsPerRow = new WAIntTextField();
        this.m_txtNumberOfColumnsPerRow.setValue(1);
        this.m_txtNumberOfColumnsPerRow.setColumns(4);
        this.m_txtNumberOfColumnsPerRow.setEnabled(false);
        this.m_txtNumberOfColumnsPerRow.setEditable(false);
        this.m_lblNumberOfColumnsPerRow = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtNumberOfColumnsPerRow, (WAdminResource)bundle, (String)"DelimitedExternalTablePanel.Label.NumberOfColumnsPerRow");
        this.m_lblNumberOfColumnsPerRow.setEnabled(false);
        this.listenForDataChangesTo(this.m_ckbMultipleRowsPerRecord);
        this.listenForDataChangesTo((JTextComponent)this.m_txtNumberOfColumnsPerRow);
        this.m_pnlMultipleRowsPerRecord = new JPanel(new GridBagLayout());
        this.m_pnlMultipleRowsPerRecord.add((Component)this.m_ckbMultipleRowsPerRecord, new GridBagConstraints(0, 0, 2, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        if (!bProperties) {
            this.m_pnlMultipleRowsPerRecord.add((Component)this.m_lblNumberOfColumnsPerRow, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 23, 0, 0), 0, 0));
            this.m_pnlMultipleRowsPerRecord.add((Component)this.m_txtNumberOfColumnsPerRow, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        }
    }

    private void createMissingValuesPanel() {
        this.m_rbnReadNextRecord = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"DelimitedExternalTablePanel.Radiobutton.ReadNextFileRecord");
        this.m_rbnSetToMissing = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"DelimitedExternalTablePanel.Radiobutton.SetRemainingValuesToMissing");
        this.listenForDataChangesTo(this.m_rbnReadNextRecord);
        this.listenForDataChangesTo(this.m_rbnSetToMissing);
        ButtonGroup grpMissingValues = new ButtonGroup();
        grpMissingValues.add(this.m_rbnReadNextRecord);
        grpMissingValues.add(this.m_rbnSetToMissing);
        this.m_pnlMissingValues = new JPanel(new GridBagLayout());
        this.m_pnlMissingValues.setBorder(WsUIUtilities.createTitledBorder((String)bundle.getString("DelimitedExternalTablePanel.BorderTitle.MissingValues.txt")));
        this.m_pnlMissingValues.add((Component)this.m_rbnSetToMissing, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlMissingValues.add((Component)this.m_rbnReadNextRecord, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void createLogicalRecordLengthPanel() {
        this.m_txtRecordLength = new WAIntTextField();
        this.m_txtRecordLength.setColumns(5);
        this.m_lblRecordLength = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtRecordLength, (WAdminResource)bundle, (String)"DelimitedExternalTablePanel.Label.RecordLength");
        this.listenForDataChangesTo((JTextComponent)this.m_txtRecordLength);
        this.m_pnlRecordLength = new JPanel(new GridBagLayout());
        this.m_pnlRecordLength.add((Component)this.m_lblRecordLength, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlRecordLength.add((Component)this.m_txtRecordLength, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
    }

    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        if (!bSaveToModel) {
            this.moveDataToView();
        } else {
            this.moveDataToStore();
        }
        return true;
    }

    public void onNext() {
        try {
            this.moveDataToStore();
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public void onBack() {
        this.m_preserveView = true;
        this.m_mdlTable.setSelectedNewFile(false);
    }

    public void populateStore() throws MdException, RemoteException {
        this.m_mdlTable.populateStore();
    }

    public void moveDataToView() throws MdException, RemoteException {
        if (this.m_preserveView && !this.m_mdlTable.hasSelectedNewFile()) {
            return;
        }
        this.setListeningForChanges(false);
        StringBuffer sbDelimiters = new StringBuffer(this.m_mdlTable.getDelimiterValue());
        this.m_ckbBlank.setSelected(sbDelimiters.indexOf(" ") != -1);
        this.m_ckbComma.setSelected(sbDelimiters.indexOf(",") != -1);
        this.m_ckbSemicolon.setSelected(sbDelimiters.indexOf(";") != -1);
        this.m_ckbTab.setSelected(sbDelimiters.indexOf("\t") != -1);
        sbDelimiters = new StringBuffer(sbDelimiters.toString().replaceAll("[ ,;\t]", ""));
        if (sbDelimiters.length() > 0) {
            this.m_ckbOthers.setSelected(true);
            this.m_txtOthers.setText(this.removeDuplicates(sbDelimiters.toString()));
        }
        this.m_ckbConsecutiveDelimiters.setSelected(this.m_mdlTable.isConsecDelim());
        this.m_ckbMultipleRowsPerRecord.setSelected(this.m_mdlTable.isMultiPerLine());
        if (this.m_mdlTable.isMissover()) {
            this.m_rbnSetToMissing.setSelected(true);
        } else {
            this.m_rbnReadNextRecord.setSelected(true);
        }
        if (this.m_mdlTable.getLogicalRecordLength() > 0 && !this.m_mdlTable.hasSelectedNewFile()) {
            this.m_txtRecordLength.setValue(this.m_mdlTable.getLogicalRecordLength());
        } else if (this.m_mdlTable.fileExists()) {
            try {
                this.m_mdlTable.loadGuessingRows();
            }
            catch (GuessingRowsModel.StartValueTooLargeException startValueTooLargeException) {
                // empty catch block
            }
            this.m_txtRecordLength.setValue(Math.min(Math.max(ExternalTableDataModel.getDefaultLogicalRecordLength(), this.m_mdlTable.getMaximumGuessingRowLength()), ExternalTableDataModel.getMaximumLogicalRecordLength()));
        } else {
            this.m_txtRecordLength.setValue(ExternalTableDataModel.getDefaultLogicalRecordLength());
        }
        this.updateComponents();
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.m_preserveView = false;
        this.saveDelimiters();
        this.loadDelimiters();
        this.m_mdlTable.setConsecDelim(this.m_ckbConsecutiveDelimiters.isSelected());
        boolean bMulti = this.m_ckbMultipleRowsPerRecord.isSelected();
        this.m_mdlTable.setMultiPerLine(bMulti);
        if (bMulti) {
            this.m_mdlTable.setColumnsPerRecord(this.m_txtNumberOfColumnsPerRow.getValue());
        }
        this.m_mdlTable.setMissover(this.m_rbnSetToMissing.isSelected());
        this.m_mdlTable.setLogicalRecordLength(this.m_txtRecordLength.getValue());
        this.setDataChanged(false);
    }

    public boolean validateData() {
        int response;
        if (this.m_ckbOthers.isSelected() && this.m_txtOthers.getText().length() == 0) {
            MessageUtil.displayMessage((String)bundle.getString("DelimitedExternalTablePanel.Error.OtherDelimiters.txt"), (int)0);
            this.m_txtOthers.requestFocus();
            return false;
        }
        if (this.m_ckbOthers.isSelected() && this.hasDuplicateDelimiters() && (response = MessageUtil.displayMessage((String)bundle.getString("DelimitedExternalTablePanel.Warning.DuplicateDelimiters.txt"), (int)2, (int)2)) != 0) {
            this.m_txtOthers.requestFocus();
            return false;
        }
        if (!(this.m_ckbBlank.isSelected() || this.m_ckbComma.isSelected() || this.m_ckbSemicolon.isSelected() || this.m_ckbTab.isSelected() || this.m_ckbOthers.isSelected())) {
            MessageUtil.displayMessage((String)bundle.getString("DelimitedExternalTablePanel.Error.AtLeastOneDelimiter.txt"), (int)0);
            this.m_ckbBlank.requestFocus();
            return false;
        }
        if (this.m_ckbMultipleRowsPerRecord.isSelected() && this.m_rbnSetToMissing.isSelected()) {
            MessageUtil.displayMessage((String)bundle.getString("DelimitedExternalTablePanel.Error.NumberOfColumnsPerRowMissover.txt"), (int)0);
            this.m_rbnReadNextRecord.requestFocus();
            return false;
        }
        if (!this.m_properties && this.m_ckbMultipleRowsPerRecord.isSelected() && this.m_txtNumberOfColumnsPerRow.getValue() < 1) {
            MessageUtil.displayMessage((String)bundle.getString("DelimitedExternalTablePanel.Error.MultiColumnsTooSmall.txt"), (int)0);
            this.m_txtNumberOfColumnsPerRow.requestFocus();
            return false;
        }
        if (this.m_txtRecordLength.getText().length() > 0) {
            if (this.m_txtRecordLength.getValue() <= 0) {
                MessageUtil.displayMessage((String)bundle.getString("DelimitedExternalTablePanel.Error.InvalidRecordLength.txt"), (int)0);
                this.m_txtRecordLength.requestFocus();
                return false;
            }
            if (this.m_txtRecordLength.getValue() > ExternalTableDataModel.getMaximumLogicalRecordLength()) {
                MessageUtil.displayMessage((String)bundle.getString("DelimitedExternalTablePanel.Error.RecordLengthTooLarge.txt"), (int)0);
                this.m_txtRecordLength.requestFocus();
                return false;
            }
        }
        return true;
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.updateComponents();
    }

    private void updateComponents() {
        boolean bEnabled = this.isEditable() && !this.m_mdlTable.isInfileOverriden();
        this.m_ckbBlank.setEnabled(bEnabled);
        this.m_ckbComma.setEnabled(bEnabled);
        this.m_ckbSemicolon.setEnabled(bEnabled);
        this.m_ckbTab.setEnabled(bEnabled);
        this.m_ckbOthers.setEnabled(bEnabled);
        this.m_txtOthers.setEditable(bEnabled && this.m_ckbOthers.isSelected());
        this.m_txtOthers.setEnabled(!this.m_mdlTable.isInfileOverriden() && this.m_ckbOthers.isSelected());
        this.m_ckbConsecutiveDelimiters.setEnabled(bEnabled);
        this.m_ckbMultipleRowsPerRecord.setEnabled(this.isEditable());
        this.m_rbnReadNextRecord.setEnabled(bEnabled);
        this.m_rbnSetToMissing.setEnabled(bEnabled);
        this.m_lblRecordLength.setEnabled(!this.m_mdlTable.isInfileOverriden());
        this.m_txtRecordLength.setEditable(bEnabled);
        this.m_txtRecordLength.setEnabled(!this.m_mdlTable.isInfileOverriden());
        this.m_lblDisabled.setVisible(this.m_mdlTable.isInfileOverriden());
        this.m_lblSpaceHolder.setVisible(!this.m_mdlTable.isInfileOverriden());
    }

    private String removeDuplicates(String delimiters) {
        StringBuffer newDelimiters = new StringBuffer();
        for (int charIndex = 0; charIndex < delimiters.length(); ++charIndex) {
            if (newDelimiters.indexOf(String.valueOf(delimiters.charAt(charIndex))) != -1) continue;
            newDelimiters.append(delimiters.charAt(charIndex));
        }
        return newDelimiters.toString();
    }

    private boolean hasDuplicateDelimiters() {
        StringBuffer processedDelimiters = new StringBuffer();
        if (this.m_ckbBlank.isSelected()) {
            processedDelimiters.append(' ');
        }
        if (this.m_ckbComma.isSelected()) {
            processedDelimiters.append(',');
        }
        if (this.m_ckbSemicolon.isSelected()) {
            processedDelimiters.append(';');
        }
        if (this.m_ckbTab.isSelected()) {
            processedDelimiters.append('\t');
        }
        String others = this.m_txtOthers.getText();
        for (int charIndex = 0; charIndex < others.length(); ++charIndex) {
            if (processedDelimiters.indexOf(String.valueOf(others.charAt(charIndex))) != -1) {
                return true;
            }
            processedDelimiters.append(others.charAt(charIndex));
        }
        return false;
    }

    private void loadDelimiters() {
        StringBuffer sbDelimiters = new StringBuffer(this.m_mdlTable.getDelimiterValue());
        this.m_ckbBlank.setSelected(sbDelimiters.indexOf(" ") != -1);
        this.m_ckbComma.setSelected(sbDelimiters.indexOf(",") != -1);
        this.m_ckbSemicolon.setSelected(sbDelimiters.indexOf(";") != -1);
        this.m_ckbTab.setSelected(sbDelimiters.indexOf("\t") != -1);
        sbDelimiters = new StringBuffer(sbDelimiters.toString().replaceAll("[ ,;\t]", ""));
        if (sbDelimiters.length() > 0) {
            this.m_ckbOthers.setSelected(true);
            this.m_txtOthers.setText(this.removeDuplicates(sbDelimiters.toString()));
        }
    }

    private void saveDelimiters() throws MdException, RemoteException {
        StringBuffer sbDelimiters = new StringBuffer();
        if (this.m_ckbBlank.isSelected()) {
            sbDelimiters.append(' ');
        }
        if (this.m_ckbComma.isSelected()) {
            sbDelimiters.append(',');
        }
        if (this.m_ckbSemicolon.isSelected()) {
            sbDelimiters.append(';');
        }
        if (this.m_ckbTab.isSelected()) {
            sbDelimiters.append('\t');
        }
        if (this.m_ckbOthers.isSelected()) {
            String others = this.m_txtOthers.getText();
            for (int charIndex = 0; charIndex < others.length(); ++charIndex) {
                if (sbDelimiters.indexOf(String.valueOf(others.charAt(charIndex))) != -1) continue;
                sbDelimiters.append(others.charAt(charIndex));
            }
        }
        this.m_mdlTable.setDelimiterValue(sbDelimiters.toString());
        WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
        appDefaults.setPropertyString("DelimitedExternalTablePanel.Delimiters", sbDelimiters.toString());
    }

    private class cFocusMover
    implements ActionListener {
        private cFocusMover() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (e.getSource() == DelimitedExternalTablePanel.this.m_ckbOthers && DelimitedExternalTablePanel.this.m_ckbOthers.isSelected()) {
                    DelimitedExternalTablePanel.this.m_txtOthers.requestFocus();
                }
                if (e.getSource() == DelimitedExternalTablePanel.this.m_ckbMultipleRowsPerRecord) {
                    if (DelimitedExternalTablePanel.this.m_ckbMultipleRowsPerRecord.isSelected() && DelimitedExternalTablePanel.this.m_mdlTable.getExternalTable().isNewObject()) {
                        DelimitedExternalTablePanel.this.m_txtNumberOfColumnsPerRow.requestFocus();
                    }
                    if (DelimitedExternalTablePanel.this.m_ckbMultipleRowsPerRecord.isSelected()) {
                        DelimitedExternalTablePanel.this.m_rbnReadNextRecord.setSelected(true);
                        DelimitedExternalTablePanel.this.m_rbnReadNextRecord.setEnabled(false);
                        DelimitedExternalTablePanel.this.m_rbnSetToMissing.setSelected(false);
                        DelimitedExternalTablePanel.this.m_rbnSetToMissing.setEnabled(false);
                    } else {
                        DelimitedExternalTablePanel.this.m_rbnReadNextRecord.setEnabled(DelimitedExternalTablePanel.this.isEditable());
                        DelimitedExternalTablePanel.this.m_rbnSetToMissing.setEnabled(DelimitedExternalTablePanel.this.isEditable());
                    }
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    private class cCommonListener
    implements ItemListener {
        private cCommonListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            try {
                boolean bEnabled;
                JToggleButton tbn = (JToggleButton)e.getItemSelectable();
                boolean bl = bEnabled = tbn.isSelected() && DelimitedExternalTablePanel.this.isEditable();
                if (tbn == DelimitedExternalTablePanel.this.m_ckbOthers) {
                    DelimitedExternalTablePanel.this.m_txtOthers.setEditable(bEnabled && !DelimitedExternalTablePanel.this.m_mdlTable.isInfileOverriden());
                    DelimitedExternalTablePanel.this.m_txtOthers.setEnabled(bEnabled && !DelimitedExternalTablePanel.this.m_mdlTable.isInfileOverriden());
                } else if (tbn == DelimitedExternalTablePanel.this.m_ckbMultipleRowsPerRecord && DelimitedExternalTablePanel.this.m_mdlTable.getExternalTable().isNewObject()) {
                    DelimitedExternalTablePanel.this.m_lblNumberOfColumnsPerRow.setEnabled(bEnabled);
                    DelimitedExternalTablePanel.this.m_txtNumberOfColumnsPerRow.setEnabled(bEnabled);
                    DelimitedExternalTablePanel.this.m_txtNumberOfColumnsPerRow.setEditable(bEnabled);
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    private class cAdvancedAction
    extends WsAbstractAction {
        public cAdvancedAction() {
            super(bundle, "DelimitedExternalTablePanel.Action.Advanced", false, false);
        }

        public void actionPerformed(ActionEvent e) {
            if (!DelimitedExternalTablePanel.this.validateData()) {
                return;
            }
            try {
                DelimitedExternalTablePanel.this.moveDataToStore();
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                return;
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("DelimitedExternalTablePanel.AdvancedDialog.Title.txt"), true);
            dlg.setMainPanel((WAPanel)new AdvancedExternalFileParametersPanel(DelimitedExternalTablePanel.this.m_mdlTable));
            dlg.show();
            if (dlg.getReturnValue() == 1) {
                DelimitedExternalTablePanel.this.updateComponents();
            }
        }
    }
}

