/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.efi2;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.ExternalTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStoreUtil;
import com.sas.metadata.remote.Tree;
import com.sas.services.information.metadata.OMRColumn;
import com.sas.wadmin.efi2.AutoColumnsPanel;
import com.sas.wadmin.efi2.ExternalTableDataModel;
import com.sas.wadmin.efi2.FixedWidthRecordTokenizer;
import com.sas.wadmin.efi2.GuessingColumnModel;
import com.sas.wadmin.efi2.GuessingRowsModel;
import com.sas.wadmin.efi2.ImportColumnsPanel;
import com.sas.wadmin.efi2.ProcessedDataPanel;
import com.sas.wadmin.efi2.RawDataPanel;
import com.sas.wadmin.efi2.TextColumnModel;
import com.sas.wadmin.efi2.TextColumnModelEvent;
import com.sas.wadmin.efi2.TextColumnModelListener;
import com.sas.wadmin.model.ColumnsTableModel2;
import com.sas.wadmin.visuals.TableColumnsPanel2;
import com.sas.workspace.DBMSNamesPropertyHandler;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAIntTextField;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAUndoManager;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsButtonsLayout;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.WsSplittableTabbedPane2;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.visuals.WAGeneralPanel;
import com.sas.workspace.visuals.WsEditorPropertyTab;
import com.sas.workspace.visuals.WsLogPropertyTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class ColumnDefinitionsPanel
extends WsDescriptionWizardTab {
    private static final WAdminResource bundle = WAdminResource.getBundle(ColumnDefinitionsPanel.class);
    private ExternalTableDataModel m_mdlTable;
    private cTableColumnsPanel m_pnlColumns;
    private JSplitPane m_pnlSplit;
    private WsSplittableTabbedPane2 m_pnlTabs;
    private JCheckBox m_overlapColumns;
    private RawDataPanel m_pnlRawData;
    private WsEditorPropertyTab m_editorTab;
    private WsLogPropertyTab m_logTab;
    private ProcessedDataPanel m_processedTab;
    private boolean m_bFirstTime;
    private boolean m_preserveView;
    private GuessingRowsModel m_guessingModel;
    private cColumnSelectionAdapter m_lsnrSelection;
    private cColumnModelAdapter m_lsnrModel;
    private String m_strType;

    public ColumnDefinitionsPanel(ExternalTableDataModel mdlTable) {
        this(mdlTable, "DELIMITED");
    }

    public ColumnDefinitionsPanel(ExternalTableDataModel mdlTable, String strType) {
        super(bundle.getString("ColumnDefinitionsPanel.Description.txt"));
        this.m_strType = strType;
        this.m_mdlTable = mdlTable;
        this.m_guessingModel = new GuessingRowsModel(this.m_mdlTable);
        this.m_preserveView = false;
        this.setHelpProduct("shared");
        this.setHelpTopic("columns_tab");
        this.initialize();
    }

    protected void initialize() {
        this.m_bFirstTime = true;
        CompoundBorder brdrCommon = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.m_pnlColumns = new cTableColumnsPanel();
        this.m_pnlColumns.setBorder(brdrCommon);
        this.m_pnlColumns.setWAUndoManager(this.getWAUndoManager());
        this.listenForDataChangesTo(this.m_pnlColumns);
        this.m_pnlRawData = new RawDataPanel(this.m_mdlTable, 4);
        this.m_pnlRawData.getTextColumnHeader().setEditable(false);
        this.m_editorTab = new WsEditorPropertyTab();
        this.m_editorTab.setEditable(false);
        this.m_logTab = new WsLogPropertyTab(1);
        this.m_processedTab = new ProcessedDataPanel(this.m_mdlTable, this);
        Dimension dim = this.m_pnlRawData.getPreferredSize();
        this.m_editorTab.setPreferredSize(dim);
        this.m_logTab.setPreferredSize(dim);
        this.m_processedTab.setPreferredSize(dim);
        this.m_processedTab.setLogTab(this.m_logTab);
        this.m_processedTab.setSourceTab(this.m_editorTab);
        this.m_pnlSplit = new JSplitPane(0, true);
        this.m_pnlSplit.setTopComponent((Component)((Object)this.m_pnlColumns));
        if (this.m_mdlTable.getExternalTable() == null) {
            this.setHelpProduct("wdb");
            this.setHelpTopic("column_definitions_external");
            this.m_pnlTabs = new WsSplittableTabbedPane2(3);
            this.m_pnlTabs.addTab(bundle.getString("RawDataPanel.Label.Tab.txt"), (Component)((Object)this.m_pnlRawData));
            this.m_pnlTabs.addTab(bundle.getString("ProcessedDataPanel.Label.Tab.txt"), (Component)((Object)this.m_processedTab));
            this.m_pnlTabs.addTab(bundle.getString("SourcePanel.Label.Tab.txt"), (Component)this.m_editorTab);
            this.m_pnlTabs.addTab(bundle.getString("LogPanel.Label.Tab.txt"), (Component)this.m_logTab);
            this.m_pnlTabs.setBorder((Border)brdrCommon);
            this.m_pnlSplit.setBottomComponent((Component)this.m_pnlTabs);
        } else {
            this.m_pnlRawData.setBorder(brdrCommon);
            this.m_pnlSplit.setBottomComponent((Component)((Object)this.m_pnlRawData));
        }
        this.setLayout(new BorderLayout());
        this.add(this.m_pnlSplit, "Center");
    }

    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        if (!bSaveToModel) {
            this.populateStore();
            this.moveDataToView();
        } else {
            this.moveDataToStore();
        }
        return true;
    }

    public void onNext() {
        try {
            this.moveDataToStore();
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public void onBack() {
        this.m_preserveView = true;
        this.m_mdlTable.setSelectedNewFile(false);
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.getTopLevelAncestor() instanceof WAWizardDialog) {
            WAWizardDialog dlgWizard = (WAWizardDialog)this.getTopLevelAncestor();
            ExternalTable table = (ExternalTable)dlgWizard.getWizardData("MASTEROBJECT");
            this.m_pnlColumns.setDataTable(table);
        }
        this.m_pnlColumns.populateStore();
        this.m_mdlTable.populateStore();
        this.m_processedTab.populateStore();
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.m_pnlRawData.updateComponents();
        this.m_processedTab.updateComponents();
        this.m_pnlColumns.updateComponents();
        if (this.m_preserveView && !this.m_mdlTable.hasSelectedNewFile()) {
            return;
        }
        this.setListeningForChanges(false);
        if (this.m_bFirstTime) {
            if (this.m_mdlTable.isFixedWidth()) {
                this.m_pnlRawData.getTextColumnHeader().setEditable(this.isEditable());
                this.m_lsnrModel = new cColumnModelAdapter();
                this.m_lsnrModel.m_columnModelMoveDataToView = true;
                this.m_lsnrModel.setOverlapColumns(this.m_mdlTable.isOverlappingColumns());
                this.m_pnlRawData.getTextColumnHeader().getModel().addModelListener(this.m_lsnrModel);
                this.m_pnlColumns.getTableModel().addTableModelListener(this.m_lsnrModel);
                this.m_lsnrSelection = new cColumnSelectionAdapter();
                this.m_pnlRawData.getTextColumnHeader().getSelectionModel().addListSelectionListener(this.m_lsnrSelection);
                this.m_pnlColumns.getTable().getSelectionModel().addListSelectionListener(this.m_lsnrSelection);
            } else if (!this.m_mdlTable.getExternalTable().isNewObject()) {
                this.remove(this.m_pnlSplit);
                this.add((Component)((Object)this.m_pnlColumns));
            }
            this.m_bFirstTime = false;
        } else {
            this.m_pnlRawData.clear();
            this.m_logTab.clear();
            this.m_editorTab.clear();
        }
        this.m_pnlColumns.moveDataToView();
        if (this.m_lsnrModel != null) {
            this.m_lsnrModel.m_columnModelMoveDataToView = false;
        }
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.m_preserveView = false;
        if (this.m_mdlTable.isFixedWidth()) {
            this.m_mdlTable.setOverlapColumns(this.m_overlapColumns.isSelected());
        }
        this.m_pnlColumns.moveDataToStore();
    }

    public String createFinishString() {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append(bundle.getString("ExternalFile.finishinfo.txt"));
        try {
            WAWizardDialog myParent = (WAWizardDialog)this.getTopLevelAncestor();
            strBuf.append("\n");
            strBuf.append(bundle.formatString("ExternalFile.finishinfo.Name.txt", (Object)this.m_mdlTable.getExternalTable().getName()));
            strBuf.append("\n");
            strBuf.append(bundle.formatString("ExternalFile.finishinfo.Desc.txt", (Object)this.m_mdlTable.getExternalTable().getDesc()));
            strBuf.append("\n");
            WAGeneralPanel panel = (WAGeneralPanel)myParent.getWizardData("GENERALPANEL");
            Tree mdoFolder = panel.getOwningTree();
            strBuf.append(bundle.formatString("ExternalFile.finishinfo.Folder.txt", (Object)mdoFolder.getName()));
            strBuf.append("\n");
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return strBuf.toString();
    }

    public boolean validateData() {
        return this.m_pnlColumns.validateData();
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_pnlColumns.setEditable(bEditable);
        this.m_pnlRawData.setEditable(bEditable);
        if (this.m_overlapColumns != null) {
            this.m_overlapColumns.setEnabled(bEditable);
        }
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_editorTab.saveSettingsAndCleanUp();
        this.m_logTab.saveSettingsAndCleanUp();
        this.m_pnlColumns.saveSettingsAndCleanUp();
        this.m_processedTab.saveSettingsAndCleanUp();
        this.m_pnlRawData.saveSettingsAndCleanUp();
        this.m_mdlTable.dispose();
    }

    public boolean canClose() {
        return this.m_processedTab.canClose();
    }

    public void setWAUndoManager(WAUndoManager mgrUndo) {
        super.setWAUndoManager(mgrUndo);
        this.m_pnlColumns.setWAUndoManager(mgrUndo);
    }

    public void loadGuessingRows(int start, int numberOfRecords) throws GuessingRowsModel.StartValueTooLargeException {
        this.m_guessingModel.loadRows(start, numberOfRecords);
    }

    public void guessColumnTypes() {
        try {
            this.m_pnlColumns.getTable().stopCellEditing();
            if (this.m_mdlTable.isFixedWidth() && this.m_pnlColumns.getTableModel().getRowCount() > 0) {
                FixedWidthRecordTokenizer.Interval[] intervals = new FixedWidthRecordTokenizer.Interval[this.m_pnlColumns.getTableModel().getRowCount()];
                for (int index = 0; index < this.m_pnlColumns.getTableModel().getRowCount(); ++index) {
                    int begin = this.m_pnlColumns.getTableModel().getBeginPosition(index);
                    int end = this.m_pnlColumns.getTableModel().getEndPosition(index);
                    intervals[index] = new FixedWidthRecordTokenizer.Interval(begin, end);
                }
                this.m_guessingModel.setIntervals(intervals);
            }
            try {
                GuessingColumnModel columnModel = this.m_guessingModel.getColumns();
                for (int columnIndex = 0; columnIndex < columnModel.getColumnCount(); ++columnIndex) {
                    List lRowValues;
                    GuessingColumnModel.GuessingColumn column = columnModel.getColumn(columnIndex);
                    if (columnIndex < this.m_pnlColumns.getTableModel().getRowCount()) {
                        lRowValues = this.m_pnlColumns.getTableModel().getRowValues(columnIndex);
                        String name = (String)lRowValues.get(0);
                        if (name == null || name.length() <= 0) {
                            lRowValues.set(0, column.getName());
                            lRowValues.set(7, column.getFormat());
                            lRowValues.set(6, column.getInformat());
                            lRowValues.set(3, column.getType());
                        }
                        lRowValues.set(2, new Integer(column.getLength()));
                        lRowValues.set(7, column.getFormat());
                        lRowValues.set(6, column.getInformat());
                        lRowValues.set(3, column.getType());
                        this.m_pnlColumns.getTable().undoableSetRowValues(this.m_pnlColumns.getTable().convertRowIndexToView(columnIndex), lRowValues);
                        continue;
                    }
                    lRowValues = this.m_pnlColumns.getTableModel().createDefaultRowValues();
                    lRowValues.set(0, column.getName());
                    lRowValues.set(2, new Integer(column.getLength()));
                    lRowValues.set(7, column.getFormat());
                    lRowValues.set(6, column.getInformat());
                    lRowValues.set(3, column.getType());
                    String sName = (String)lRowValues.get(0);
                    ExternalTable oTable = this.m_mdlTable.getExternalTable();
                    Column oColumn = (Column)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)oTable.getObjectStore(), sName, "Column", oTable.getRepositoryID());
                    oColumn.setTable((DataTable)oTable);
                    oColumn.setSASColumnName(sName);
                    oColumn.setSASColumnLength(column.getLength());
                    oColumn.setSASColumnType(column.getSASType());
                    oColumn.setIsNullable(1);
                    oColumn.setPublicType("Column");
                    oColumn.setUsageVersion(OMRColumn.CURRENT_VERSION.encode());
                    lRowValues.set(14, oColumn);
                    this.m_pnlColumns.getTable().undoableInsertRow(columnIndex - 1, lRowValues);
                }
            }
            catch (WsAppServerFailException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            }
            catch (GenericError e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public int getColumnCount() {
        return this.m_pnlColumns.getTable().getRowCount();
    }

    private void enableOverlapColumns(boolean overlap) {
        this.m_lsnrModel.setOverlapColumns(overlap);
        this.m_pnlRawData.setEnabled(overlap && this.isEditable());
        this.m_pnlRawData.getTextColumnHeader().setOverlapColumns(overlap);
        this.m_pnlRawData.getTextColumnHeader().setEditable(!overlap);
    }

    private class cOverlapColumnsCheckBoxListener
    implements ActionListener {
        private ColumnsTableModel2 l_mdlColumns;

        private cOverlapColumnsCheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean overlap = ColumnDefinitionsPanel.this.m_overlapColumns.isSelected();
            int eAnswer = 0;
            if (overlap) {
                eAnswer = MessageUtil.displayMessage((String)bundle.getString("ColumnDefinitionsPanel.Warning.OverlapColumns.txt"), (int)2, (int)2);
                if (eAnswer == 0) {
                    ColumnDefinitionsPanel.this.enableOverlapColumns(overlap);
                } else {
                    ColumnDefinitionsPanel.this.m_overlapColumns.setSelected(false);
                }
            } else {
                int overlappingColumn = this.getOverlappingColumn();
                if (overlappingColumn > 0) {
                    MessageUtil.displayMessage((String)bundle.getString("ColumnDefinitionsPanel.Warning.RemainingOverlapColumns.txt"), (int)2, (int)2);
                    ColumnDefinitionsPanel.this.m_overlapColumns.setSelected(true);
                    ColumnDefinitionsPanel.this.m_pnlRawData.getTextColumnHeader().getSelectionModel().setSelectionInterval(overlappingColumn, overlappingColumn);
                } else {
                    ColumnDefinitionsPanel.this.m_lsnrModel.setOverlapColumns(overlap);
                    ColumnDefinitionsPanel.this.m_pnlRawData.setEnabled(overlap);
                    ColumnDefinitionsPanel.this.m_pnlRawData.getTextColumnHeader().setOverlapColumns(overlap);
                    ColumnDefinitionsPanel.this.m_pnlRawData.getTextColumnHeader().setEditable(!overlap);
                }
            }
        }

        public int getOverlappingColumn() {
            int minBegin = 0;
            for (int iRow = 0; iRow < this.l_mdlColumns.getRowCount(); ++iRow) {
                int begin = this.l_mdlColumns.getBeginPosition(iRow);
                int end = this.l_mdlColumns.getEndPosition(iRow);
                if (minBegin > begin) {
                    return iRow;
                }
                minBegin = end + 1;
            }
            return 0;
        }

        public void setColumnModel(ColumnsTableModel2 model) {
            this.l_mdlColumns = model;
        }
    }

    private class cColumnSelectionAdapter
    implements ListSelectionListener {
        private WsTable m_tblColumns;
        private ListSelectionModel m_mdlColumns;
        private ListSelectionModel m_mdlTextColumns;
        private boolean m_bAdjusting;

        public cColumnSelectionAdapter() {
            this.m_tblColumns = ColumnDefinitionsPanel.this.m_pnlColumns.getTable();
            this.m_mdlColumns = this.m_tblColumns.getSelectionModel();
            this.m_mdlTextColumns = ColumnDefinitionsPanel.this.m_pnlRawData.getTextColumnHeader().getSelectionModel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(ListSelectionEvent e) {
            block14: {
                if (this.isAdjusting()) {
                    return;
                }
                if (e.getValueIsAdjusting()) {
                    return;
                }
                try {
                    this.setAdjusting(true);
                    if (e.getSource() == this.m_mdlColumns) {
                        try {
                            this.m_mdlTextColumns.setValueIsAdjusting(true);
                            this.m_mdlTextColumns.clearSelection();
                            int[] aSelectedColumns = this.m_tblColumns.getSelectedRowsFromSelectedCells();
                            this.m_tblColumns.convertRowIndexesToModel(aSelectedColumns);
                            for (int iColumn = 0; iColumn < aSelectedColumns.length; ++iColumn) {
                                this.m_mdlTextColumns.addSelectionInterval(aSelectedColumns[iColumn], aSelectedColumns[iColumn]);
                            }
                            break block14;
                        }
                        finally {
                            this.m_mdlTextColumns.setValueIsAdjusting(false);
                        }
                    }
                    try {
                        this.m_mdlColumns.setValueIsAdjusting(true);
                        this.m_mdlColumns.clearSelection();
                        for (int iColumn = this.m_mdlTextColumns.getMinSelectionIndex(); iColumn <= this.m_mdlTextColumns.getMaxSelectionIndex(); ++iColumn) {
                            if (!this.m_mdlTextColumns.isSelectedIndex(iColumn)) continue;
                            this.m_tblColumns.addRowToSelection(this.m_tblColumns.convertRowIndexToView(iColumn));
                        }
                    }
                    finally {
                        this.m_mdlColumns.setValueIsAdjusting(false);
                    }
                }
                finally {
                    this.setAdjusting(false);
                }
            }
        }

        private void setAdjusting(boolean bAdjusting) {
            this.m_bAdjusting = bAdjusting;
        }

        private boolean isAdjusting() {
            return this.m_bAdjusting;
        }
    }

    private class cColumnModelAdapter
    implements TableModelListener,
    TextColumnModelListener {
        private WsTable m_tblColumns;
        private ColumnsTableModel2 m_mdlColumns;
        private TextColumnModel m_mdlTextColumns;
        private boolean m_bAdjusting;
        private boolean m_bOverlap;
        protected boolean m_columnModelMoveDataToView;

        public cColumnModelAdapter() {
            this.m_tblColumns = ColumnDefinitionsPanel.this.m_pnlColumns.getTable();
            this.m_mdlColumns = ColumnDefinitionsPanel.this.m_pnlColumns.getTableModel();
            this.m_mdlTextColumns = ColumnDefinitionsPanel.this.m_pnlRawData.getTextColumnHeader().getModel();
        }

        public void setOverlapColumns(boolean bool) {
            this.m_bOverlap = bool;
            this.m_mdlColumns.setOverlapColumns(bool);
        }

        public boolean isColumnOverlapping() {
            return this.m_bOverlap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void tableChanged(TableModelEvent e) {
            block18: {
                if (this.isAdjusting()) {
                    return;
                }
                try {
                    this.setAdjusting(true);
                    int eType = e.getType();
                    if (eType == 0) {
                        int iRow = e.getFirstRow();
                        int iCol = e.getColumn();
                        if (iCol == 9 || iCol == 10) {
                            int begin = this.m_mdlColumns.getBeginPosition(iRow);
                            int end = this.m_mdlColumns.getEndPosition(iRow);
                            if (!this.isColumnOverlapping()) {
                                this.updateLength(iRow, begin, end);
                            }
                            this.m_mdlTextColumns.updateColumn(iRow, begin, end);
                        }
                        break block18;
                    }
                    if (eType == -1) {
                        for (int iRow = e.getFirstRow(); iRow <= e.getLastRow(); ++iRow) {
                            this.m_mdlTextColumns.deleteColumn(e.getFirstRow());
                        }
                        break block18;
                    }
                    if (eType != 1) break block18;
                    int iFirstRow = e.getFirstRow();
                    int minBegin = iFirstRow == 0 ? 1 : this.m_mdlColumns.getEndPosition(iFirstRow - 1) + 1;
                    for (int iRow = e.getFirstRow(); iRow < this.m_mdlColumns.getRowCount(); ++iRow) {
                        int begin = this.m_mdlColumns.getBeginPosition(iRow);
                        int end = this.m_mdlColumns.getEndPosition(iRow);
                        if (this.m_columnModelMoveDataToView) {
                            if (iRow <= e.getLastRow()) {
                                this.m_mdlTextColumns.insertColumn(iRow, begin, end);
                                continue;
                            }
                            this.m_mdlTextColumns.updateColumn(iRow, begin, end);
                            continue;
                        }
                        if (begin <= 0 || end < begin) {
                            begin = minBegin;
                            end = begin + this.m_mdlColumns.getLength(iRow) - 1;
                        } else if (!this.isColumnOverlapping()) {
                            int delta = end - begin;
                            begin = Math.max(begin, minBegin);
                            end = begin + delta;
                            this.updateLength(iRow, begin, end);
                        }
                        this.m_mdlColumns.setBeginPosition(iRow, begin);
                        this.m_mdlColumns.setEndPosition(iRow, end);
                        if (iRow <= e.getLastRow()) {
                            this.m_mdlTextColumns.insertColumn(iRow, begin, end);
                        } else {
                            this.m_mdlTextColumns.updateColumn(iRow, begin, end);
                        }
                        if (this.isColumnOverlapping()) {
                            break;
                        }
                        minBegin = end + 1;
                    }
                }
                finally {
                    this.setAdjusting(false);
                }
            }
            this.m_columnModelMoveDataToView = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void textColumnInserted(TextColumnModelEvent e) {
            try {
                if (this.isAdjusting()) {
                    return;
                }
                if (this.isColumnOverlapping()) {
                    return;
                }
                try {
                    this.setAdjusting(true);
                    int iColumn = e.getColumn();
                    int beginNew = e.getBegin();
                    int endNew = e.getEnd();
                    List lRowValues = this.m_mdlColumns.createDefaultRowValues();
                    lRowValues.set(9, new Integer(beginNew));
                    lRowValues.set(10, new Integer(endNew));
                    String sName = (String)lRowValues.get(0);
                    ExternalTable oTable = ColumnDefinitionsPanel.this.m_mdlTable.getExternalTable();
                    Column oColumn = (Column)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)oTable.getObjectStore(), sName, "Column", oTable.getRepositoryID());
                    oColumn.setPublicType("Column");
                    oColumn.setUsageVersion(OMRColumn.CURRENT_VERSION.encode());
                    oColumn.setTable((DataTable)oTable);
                    oColumn.setSASColumnName(sName);
                    oColumn.setIsNullable(1);
                    lRowValues.set(14, oColumn);
                    ColumnDefinitionsPanel.this.m_pnlColumns.getTable().undoableInsertRow(iColumn - 1, lRowValues);
                    this.updateLength(iColumn, beginNew, endNew);
                }
                finally {
                    this.setAdjusting(false);
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void textColumnUpdated(TextColumnModelEvent e) {
            if (this.isAdjusting()) {
                return;
            }
            try {
                this.setAdjusting(true);
                int iColumn = e.getColumn();
                int beginOld = e.getOldBegin();
                int endOld = e.getOldEnd();
                int beginNew = e.getNewBegin();
                int endNew = e.getNewEnd();
                int iViewRow = this.m_tblColumns.convertRowIndexToView(iColumn);
                this.m_tblColumns.clearSelection();
                if (beginOld != beginNew) {
                    int iBeginCol = this.m_tblColumns.convertColumnIndexToView(9);
                    this.m_tblColumns.undoableSetValueAt((Object)new Integer(beginNew), iViewRow, iBeginCol);
                    this.m_tblColumns.addCellToSelection(iViewRow, iBeginCol);
                }
                if (endOld != endNew) {
                    int iEndCol = this.m_tblColumns.convertColumnIndexToView(10);
                    this.m_tblColumns.undoableSetValueAt((Object)new Integer(endNew), iViewRow, iEndCol);
                    this.m_tblColumns.addCellToSelection(iViewRow, iEndCol);
                }
                if (this.isColumnOverlapping()) {
                    this.updateLength(iColumn, beginNew, beginNew);
                } else {
                    this.updateLength(iColumn, beginNew, endNew);
                }
            }
            finally {
                this.setAdjusting(false);
            }
        }

        @Override
        public void textColumnDeleted(TextColumnModelEvent e) {
            if (this.isAdjusting()) {
                return;
            }
            if (this.isColumnOverlapping()) {
                return;
            }
            try {
                this.setAdjusting(true);
                int iColumn = e.getColumn();
                if (iColumn + 1 < this.m_mdlColumns.getRowCount()) {
                    ColumnDefinitionsPanel.this.m_pnlColumns.getTable().undoableDeleteRow(iColumn + 1);
                } else {
                    ColumnDefinitionsPanel.this.m_pnlColumns.getTable().undoableDeleteRow(iColumn);
                }
            }
            finally {
                this.setAdjusting(false);
            }
        }

        private void setAdjusting(boolean bAdjusting) {
            this.m_bAdjusting = bAdjusting;
        }

        private boolean isAdjusting() {
            return this.m_bAdjusting;
        }

        private void updateLength(int iColumn, int begin, int end) {
            String sType = (String)this.m_mdlColumns.getValueAt(iColumn, 3);
            if (WsColumnMetadataUtil.isColumnViewTypeCharacter((String)sType)) {
                this.m_mdlColumns.setValueAt(new Integer(end - begin + 1), iColumn, 2);
            }
        }
    }

    private class cTableColumnsPanel
    extends TableColumnsPanel2 {
        private cOverlapColumnsCheckBoxListener m_overlapColumnsListener;
        private cAutoColumnsAction m_actAutoColumn;
        private ExternalTable m_oTable;
        protected WsAbstractAction m_actAdvancedNew;
        protected JButton m_btnAdvancedNew;

        public cTableColumnsPanel() {
            this.m_bShowColumnImpact = false;
            Dimension size = this.m_scrColumns.getViewport().getPreferredSize();
            size.height = this.m_tblColumns.getRowHeight() * 4;
            this.m_scrColumns.getViewport().setPreferredSize(size);
            if (ColumnDefinitionsPanel.this.m_mdlTable.getExternalTable() == null) {
                this.m_actAutoColumn = this.createAutoColumnsAction();
                JPanel autoColPanel = new JPanel((LayoutManager)new WsButtonsLayout(0, 2));
                JButton autoColButton = new JButton((Action)((Object)this.m_actAutoColumn));
                autoColPanel.add(autoColButton);
                if (ColumnDefinitionsPanel.this.m_strType.equalsIgnoreCase("FIXEDWIDTH")) {
                    this.setupCheckBox();
                    autoColPanel.add(ColumnDefinitionsPanel.this.m_overlapColumns);
                    this.m_actAdvancedNew = this.createAdvancedNewAction();
                    this.m_btnAdvancedNew = this.createTextButton(this.m_actAdvancedNew);
                    this.m_pnlRight.add(this.m_btnAdvancedNew);
                }
                this.m_pnlButtons.add(autoColPanel);
            } else if (ColumnDefinitionsPanel.this.m_mdlTable.isFixedWidth()) {
                this.showOverlapPanel();
            }
        }

        public void setDataTable(ExternalTable oTable) {
            super.setMetadataTable((DataTable)oTable);
            this.m_oTable = oTable;
        }

        protected void showOverlapPanel() {
            this.setupCheckBox();
            JPanel overlapPanel = new JPanel((LayoutManager)new WsButtonsLayout(0, 2));
            overlapPanel.add(ColumnDefinitionsPanel.this.m_overlapColumns);
            this.m_pnlButtons.add(overlapPanel);
        }

        protected void setupCheckBox() {
            ColumnDefinitionsPanel.this.m_overlapColumns = new JCheckBox(bundle.getString("ColumnDefinitionsPanel.CheckBox.Overlap.txt"));
            ColumnDefinitionsPanel.this.m_overlapColumns.setMnemonic(bundle.getString("ColumnDefinitionsPanel.CheckBox.Overlap.mnem").charAt(0));
            ColumnDefinitionsPanel.this.m_overlapColumns.setDisplayedMnemonicIndex(0);
            this.m_overlapColumnsListener = new cOverlapColumnsCheckBoxListener();
            ColumnDefinitionsPanel.this.m_overlapColumns.addActionListener(this.m_overlapColumnsListener);
            this.m_overlapColumnsListener.setColumnModel(this.m_mdlColumns);
            ColumnDefinitionsPanel.this.m_overlapColumns.setSelected(ColumnDefinitionsPanel.this.m_mdlTable.isOverlappingColumns());
        }

        @Override
        protected void removeUnwantedColumns() {
            this.removeColumn(4);
            this.removeColumn(5);
            this.removeColumn(8);
        }

        @Override
        protected void initializeSettingsPrefix() {
            this.m_sSettingsPrefix = null;
        }

        @Override
        public void moveDataToView() throws MdException, RemoteException {
            if (!ColumnDefinitionsPanel.this.m_mdlTable.isFixedWidth()) {
                this.removeColumn(9);
                this.removeColumn(10);
            } else {
                ColumnDefinitionsPanel.this.m_pnlRawData.getTextColumnHeader().setOverlapColumns(ColumnDefinitionsPanel.this.m_mdlTable.isOverlappingColumns());
                ColumnDefinitionsPanel.this.m_pnlRawData.getTextColumnHeader().setEditable(!ColumnDefinitionsPanel.this.m_mdlTable.isOverlappingColumns());
            }
            this.setSortIgnore(ColumnDefinitionsPanel.this.m_mdlTable.isFixedWidth());
            this.setRowsReorderable(!ColumnDefinitionsPanel.this.m_mdlTable.isFixedWidth());
            super.moveDataToView();
        }

        @Override
        public boolean validateData() {
            if (!this.m_tblColumns.stopCellEditing()) {
                return false;
            }
            if (this.m_tblColumns.getRowCount() == 0) {
                int eAnswer = MessageUtil.displayMessage((String)bundle.getString("ColumnDefinitionsPanel.Warning.NoColumns.txt"), (int)2, (int)2);
                return eAnswer == 0;
            }
            if (ColumnDefinitionsPanel.this.m_strType.equalsIgnoreCase("FIXEDWIDTH")) {
                int iContinue;
                boolean bFoundColumnWithoutInformat = false;
                for (int iRow = 0; iRow < this.m_tblColumns.getRowCount(); ++iRow) {
                    int iModelRow = this.m_tblColumns.convertRowIndexToModel(iRow);
                    String sInformat = (String)this.m_mdlColumns.getValueAt(iModelRow, 6);
                    if (!sInformat.equals(WsColumnMetadataUtil.NONE) && sInformat.length() != 0) continue;
                    bFoundColumnWithoutInformat = true;
                    break;
                }
                if (bFoundColumnWithoutInformat && (iContinue = MessageUtil.displayMessage((String)bundle.getString("ColumnDefinitionsPanel.NoInformat.Warning.txt"), (int)2, (int)0)) == 1) {
                    return false;
                }
            }
            return super.validateData();
        }

        public WsTable getTable() {
            return this.m_tblColumns;
        }

        @Override
        protected void updateActions() {
            super.updateActions();
            if (this.m_actAdvancedNew != null) {
                this.m_actAdvancedNew.setEnabled(this.isEditable());
            }
        }

        @Override
        public void updateWorkspaceUIComponents(boolean bActive) {
            super.updateWorkspaceUIComponents(bActive);
            if (this.m_actAdvancedNew != null) {
                this.m_actAdvancedNew.setActive(bActive);
            }
        }

        public cAutoColumnsAction createAutoColumnsAction() {
            return new cAutoColumnsAction();
        }

        @Override
        protected WsAbstractAction createImportAction() {
            return new cImportAction();
        }

        protected WsAbstractAction createAdvancedNewAction() {
            return new cAdvancedNewAction();
        }

        protected void createAdvancedNewRow() {
            cAdvancedNewRowPanel pnl = new cAdvancedNewRowPanel();
            String sAdvancedNewDialogTitle = bundle.getString("ColumnDefinitionsPanel.AdvancedNewRowDialogTitle.txt");
            WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sAdvancedNewDialogTitle, true, (WAPanel)pnl);
            dlg.setResizable(true);
            dlg.setHelpButtonVisible(false);
            dlg.show();
            if (dlg.getReturnValue() == 1 && !pnl.getIsAborted()) {
                String sName = null;
                int iNewRow = pnl.m_index - 1;
                try {
                    List lValues = pnl.saveColumn(this.m_mdlColumns.createDefaultRowValues());
                    this.m_tblColumns.undoableInsertRow(iNewRow - 1, lValues);
                    Workspace.getWorkspace();
                    MdFactory factory = Workspace.getMdFactory();
                    Column oColumn = (Column)factory.createComplexMetadataObject((MdObjectStore)this.m_oTable.getObjectStore(), sName, "Column", this.m_oTable.getRepositoryID());
                    oColumn.setPublicType("Column");
                    oColumn.setUsageVersion(OMRColumn.CURRENT_VERSION.encode());
                    oColumn.setTable((DataTable)this.m_oTable);
                    oColumn.setSASColumnName(sName);
                    this.m_mdlColumns.setValueAt(oColumn, iNewRow, 14);
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException((RemoteException)ex);
                }
            }
        }

        @Override
        public void updateComponents() {
            super.updateComponents();
            if (this.m_actAutoColumn != null) {
                this.m_actAutoColumn.setEnabled(!ColumnDefinitionsPanel.this.m_mdlTable.isUserWritten() && !ColumnDefinitionsPanel.this.m_mdlTable.isInfileOverriden());
            }
        }

        class cAdvancedNewRowPanel
        extends WAPanel {
            private WATextField m_txtName;
            private WATextField m_txtDescription;
            private WAIntTextField m_txtLength;
            private WAComboBox m_cmbType;
            private WAIntTextField m_txtBeginPosition;
            private WAIntTextField m_txtEndPosition;
            private WAIntTextField m_txtIndex;
            private WsAbstractTableColumn m_colName;
            private WsAbstractTableColumn m_colDescription;
            private WsAbstractTableColumn m_colLength;
            private WsAbstractTableColumn m_colType;
            private WsAbstractTableColumn m_colBeginPos;
            private WsAbstractTableColumn m_colEndPos;
            private boolean m_isAborted;
            private String m_name;
            private String m_description;
            private int m_length;
            private int m_beginPos;
            private int m_endPos;
            private int m_index;

            public cAdvancedNewRowPanel() {
                this.initialize();
                this.layoutWidgets();
                this.m_colName = cTableColumnsPanel.this.m_mdlColumns.getColumn(0);
                this.m_colDescription = cTableColumnsPanel.this.m_mdlColumns.getColumn(1);
                this.m_colLength = cTableColumnsPanel.this.m_mdlColumns.getColumn(2);
                this.m_colType = cTableColumnsPanel.this.m_mdlColumns.getColumn(3);
                this.m_colBeginPos = cTableColumnsPanel.this.m_mdlColumns.getColumn(9);
                this.m_colEndPos = cTableColumnsPanel.this.m_mdlColumns.getColumn(10);
                this.m_length = (Integer)this.m_colLength.createDefaultValue();
                int currentSelect = cTableColumnsPanel.this.m_tblColumns.getLastSelectedRow();
                this.m_index = currentSelect + 2;
                this.m_txtName.setText((String)this.m_colName.createDefaultValue());
                this.m_txtDescription.setText((String)this.m_colDescription.createDefaultValue());
                this.m_txtLength.setValue(this.m_length);
                this.m_cmbType.setSelectedItem((Object)((String)this.m_colType.createDefaultValue()));
                this.m_beginPos = currentSelect == -1 ? (Integer)this.m_colBeginPos.createDefaultValue() + 1 : cTableColumnsPanel.this.m_mdlColumns.getEndPosition(currentSelect) + 1;
                this.m_endPos = this.m_beginPos + this.m_length - 1;
                this.m_txtBeginPosition.setValue(this.m_beginPos);
                this.m_txtEndPosition.setValue(this.m_endPos);
                this.m_txtIndex.setValue(this.m_index);
            }

            protected void initialize() {
                this.m_txtName = new WATextField(40);
                this.m_txtDescription = new WATextField(80);
                this.m_txtLength = new WAIntTextField();
                this.m_cmbType = new WAComboBox((Object[])WsColumnMetadataUtil.getViewTypes());
                this.m_txtBeginPosition = new WAIntTextField();
                this.m_txtEndPosition = new WAIntTextField();
                this.m_txtIndex = new WAIntTextField();
                this.m_txtLength.setColumns(20);
                this.m_txtLength.setMinimumSize(new Dimension(100, 20));
                this.m_txtBeginPosition.setColumns(20);
                this.m_txtBeginPosition.setMinimumSize(new Dimension(100, 20));
                this.m_txtEndPosition.setColumns(20);
                this.m_txtEndPosition.setMinimumSize(new Dimension(100, 20));
                this.m_txtIndex.setColumns(20);
                this.m_txtIndex.setMinimumSize(new Dimension(100, 20));
            }

            protected void layoutWidgets() {
                this.setLayout(new GridBagLayout());
                ArrayList<JLabel> lbls = new ArrayList<JLabel>();
                lbls.add(WsUIUtilities.createLabelForComponent((JComponent)this.m_txtName, (String)bundle.getString("cAdvancedNewRowPanel.NameLabel.txt")));
                lbls.add(WsUIUtilities.createLabelForComponent((JComponent)this.m_txtDescription, (String)bundle.getString("cAdvancedNewRowPanel.DescrptionLabel.txt")));
                lbls.add(WsUIUtilities.createLabelForComponent((JComponent)this.m_txtLength, (String)bundle.getString("cAdvancedNewRowPanel.LengthLabel.txt")));
                lbls.add(WsUIUtilities.createLabelForComponent((JComponent)this.m_cmbType, (String)bundle.getString("cAdvancedNewRowPanel.TypeLabel.txt")));
                lbls.add(WsUIUtilities.createLabelForComponent((JComponent)this.m_txtBeginPosition, (String)bundle.getString("cAdvancedNewRowPanel.BeginPositionLabel.txt")));
                lbls.add(WsUIUtilities.createLabelForComponent((JComponent)this.m_txtEndPosition, (String)bundle.getString("cAdvancedNewRowPanel.EndPositionLabel.txt")));
                lbls.add(WsUIUtilities.createLabelForComponent((JComponent)this.m_txtIndex, (String)bundle.getString("cAdvancedNewRowPanel.IndexLabel.txt")));
                GridBagConstraints clbl = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 16, 0, new Insets(5, 5, 5, 5), 0, 0);
                GridBagConstraints ccmp = new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0);
                int count = lbls.size();
                for (int i = 0; i < count; ++i) {
                    JLabel lbl = (JLabel)lbls.get(i);
                    this.add(lbl, clbl);
                    this.add(lbl.getLabelFor(), ccmp);
                    if (i == 1) {
                        ccmp.fill = 0;
                    }
                    clbl.gridy += 2;
                    ccmp.gridy += 2;
                }
            }

            public boolean validateData() {
                boolean isOK = true;
                if (!this.validateValue()) {
                    return false;
                }
                if (!cTableColumnsPanel.this.m_mdlColumns.getOverlappingColumns() && this.getIsOverlapColumn()) {
                    int result = MessageUtil.displayMessage((String)bundle.getString("cAdvancedNewRowPanel.OverlapMsg.msg"), (int)2, (int)1);
                    if (result == 2) {
                        isOK = false;
                    } else if (result == 0) {
                        ColumnDefinitionsPanel.this.m_overlapColumns.setSelected(true);
                        ColumnDefinitionsPanel.this.enableOverlapColumns(true);
                    } else {
                        this.m_isAborted = true;
                    }
                }
                return isOK;
            }

            private boolean validateValue() {
                boolean isOk = true;
                this.m_name = this.m_txtName.getText();
                this.m_description = this.m_txtDescription.getText();
                try {
                    this.m_length = this.m_txtLength.getValue2();
                    this.m_beginPos = this.m_txtBeginPosition.getValue2();
                    this.m_endPos = this.m_txtEndPosition.getValue2();
                    this.m_index = this.m_txtIndex.getValue2();
                    boolean bl = isOk = cTableColumnsPanel.this.m_mdlColumns.validateValueAt(this.m_name, -1, 0) && cTableColumnsPanel.this.m_mdlColumns.validateValueAt(this.m_description, -1, 1) && cTableColumnsPanel.this.m_mdlColumns.validateLengthByType(this.m_length, this.m_cmbType.getSelectedItem().toString());
                    if (isOk) {
                        int maxIndex = cTableColumnsPanel.this.m_mdlColumns.getRowCount() + 1;
                        if (this.m_index < 1 || this.m_index > maxIndex) {
                            isOk = false;
                            MessageUtil.displayMessage((String)bundle.formatString("cAdvancedNewRowPanel.IndexValidation.msg", (Object)maxIndex), (int)2, (int)2);
                        }
                    }
                }
                catch (WAIntTextField.IllegalIntegerException ex) {
                    isOk = false;
                }
                return isOk;
            }

            private boolean getIsOverlapColumn() {
                int rowCount = cTableColumnsPanel.this.m_mdlColumns.getRowCount();
                for (int i = 0; i < rowCount; ++i) {
                    int rBeginPos = cTableColumnsPanel.this.m_mdlColumns.getBeginPosition(i);
                    int rEndPos = cTableColumnsPanel.this.m_mdlColumns.getEndPosition(i);
                    if ((this.m_beginPos > rEndPos || this.m_beginPos < rBeginPos) && (this.m_endPos > rEndPos || this.m_endPos < rBeginPos)) continue;
                    return true;
                }
                return false;
            }

            public boolean getIsAborted() {
                return this.m_isAborted;
            }

            public List saveColumn(List newColumn) {
                newColumn.set(0, this.m_name);
                newColumn.set(1, this.m_description);
                newColumn.set(2, this.m_length);
                newColumn.set(3, this.m_cmbType.getSelectedItem());
                newColumn.set(9, this.m_beginPos);
                newColumn.set(10, this.m_endPos);
                return newColumn;
            }
        }

        protected class cAdvancedNewAction
        extends WsAbstractAction {
            public cAdvancedNewAction() {
                super(bundle, "ColumnDefinitionsPanel.AdvancedNew", false);
            }

            public void actionPerformed(ActionEvent e) {
                cTableColumnsPanel.this.createAdvancedNewRow();
            }
        }

        protected class cAutoColumnsAction
        extends WsAbstractAction {
            public cAutoColumnsAction() {
                super(bundle, "ColumnDefinitionsPanel.Action.AutoColumns", false, false);
            }

            public void actionPerformed(ActionEvent e) {
                if (cTableColumnsPanel.this.getTableModel().getRowCount() == 0 && ColumnDefinitionsPanel.this.m_mdlTable.isFixedWidth()) {
                    MessageUtil.displayMessage((String)bundle.getString("AutoColumnsPanel.Error.NoColumns.txt"), (int)0);
                    return;
                }
                AutoColumnsPanel panel = new AutoColumnsPanel(ColumnDefinitionsPanel.this.m_mdlTable, ColumnDefinitionsPanel.this);
                String dialogTitle = bundle.getString("ColumnDefinitionsPanel.Dialog.AutoColumns.Title.txt");
                WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), dialogTitle, true, (WAPanel)panel);
                dlg.setResizable(true);
                dlg.setHelpProduct("wdb");
                dlg.setHelpTopic("auto_columns");
                dlg.show();
            }
        }

        protected class cImportAction
        extends WsAbstractAction {
            public cImportAction() {
                super(bundle, "ColumnDefinitionsPanel.Action.Import", true, false);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                try {
                    if (!cTableColumnsPanel.this.m_tblColumns.stopCellEditing()) {
                        return;
                    }
                    try {
                        ColumnDefinitionsPanel.this.m_pnlColumns.moveDataToStore();
                    }
                    catch (MdException mde) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Reading");
                    }
                    MdObjectStore storeDialog = Workspace.getMdFactory().createObjectStore();
                    try {
                        ImportColumnsPanel pnl = new ImportColumnsPanel(ColumnDefinitionsPanel.this.m_mdlTable);
                        pnl.setObjectStore(storeDialog);
                        String sImportDialogTitle = bundle.getString("ColumnDefinitionsPanel.Dialog.ImportColumns.Title.txt");
                        WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sImportDialogTitle, true, (WAPanel)pnl);
                        dlg.setResizable(true);
                        dlg.setHelpProduct("shared");
                        dlg.setHelpTopic("import_column_win");
                        dlg.show();
                        if (dlg.getReturnValue() == 1) {
                            List lColumns = pnl.getColumns();
                            if (lColumns == null) {
                                this.updateNames(pnl.getNames());
                            } else {
                                this.addColumns(lColumns);
                            }
                            ColumnDefinitionsPanel.this.m_processedTab.moveDataToView();
                        }
                    }
                    catch (MdException ex) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                    }
                    finally {
                        storeDialog.dispose();
                    }
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }

            private void addColumns(List lColumns) throws MdException, RemoteException {
                MdObjectStore store = (MdObjectStore)cTableColumnsPanel.this.m_oTable.getObjectStore();
                boolean bCaseSensitive = DBMSNamesPropertyHandler.needQuotes((DataTable)cTableColumnsPanel.this.m_oTable);
                int nColumns = lColumns.size();
                ArrayList<List> lRowsValues = new ArrayList<List>(nColumns);
                ArrayList<String> lDuplicateColumns = new ArrayList<String>();
                for (int iColumn = 0; iColumn < nColumns; ++iColumn) {
                    Column oColumn = (Column)lColumns.get(iColumn);
                    String sColumn = oColumn.getName();
                    if (this.isNameDuplicate(sColumn, bCaseSensitive)) {
                        lDuplicateColumns.add(sColumn);
                        continue;
                    }
                    String sName = oColumn.getName();
                    String sType = oColumn.getCMetadataType();
                    String sFQID = ColumnDefinitionsPanel.this.m_mdlTable.getExternalTable().getRepositoryID();
                    Column oNewColumn = (Column)Workspace.getMdFactory().createComplexMetadataObject(store, sName, sType, sFQID);
                    MdStoreUtil.copyObjectAttributes((CMetadata)oColumn, (CMetadata)oNewColumn, (int)1);
                    oNewColumn.setTable((DataTable)cTableColumnsPanel.this.m_oTable);
                    lRowsValues.add(cTableColumnsPanel.this.m_mdlColumns.getRowValuesForColumn(oNewColumn));
                }
                if (!lRowsValues.isEmpty()) {
                    cTableColumnsPanel.this.m_tblColumns.undoableInsertRowsAfterLastSelectedRow(lRowsValues);
                }
                if (lDuplicateColumns.size() > 0) {
                    String sMessage = bundle.getString("ColumnDefinitionsPanel.Warning.DuplicateColumnsRemoved.txt");
                    MessageUtil.displayListMessage((String)sMessage, lDuplicateColumns);
                }
            }

            private void updateNames(List lNames) throws MdException, RemoteException {
                cTableColumnsPanel.this.m_tblColumns.clearSelection();
                MdObjectStore store = (MdObjectStore)cTableColumnsPanel.this.m_oTable.getObjectStore();
                boolean bCaseSensitive = DBMSNamesPropertyHandler.needQuotes((DataTable)cTableColumnsPanel.this.m_oTable);
                ArrayList<String> lDuplicates = new ArrayList<String>();
                int nUpdates = Math.min(lNames.size(), cTableColumnsPanel.this.m_mdlColumns.getRowCount());
                boolean[] baSelect = new boolean[nUpdates];
                for (int iName = 0; iName < nUpdates; ++iName) {
                    String sColumn = (String)lNames.get(iName);
                    if (sColumn.length() == 0) {
                        String sFormat = bundle.getString("ColumnDefinitionsPanel.DefaultColumnName.fmt.txt");
                        Object[] args = new Object[]{new Integer(iName + 1)};
                        sColumn = MessageFormat.format(sFormat, args);
                    }
                    if (sColumn.equals(cTableColumnsPanel.this.m_mdlColumns.getValueAt(iName, 0))) continue;
                    if (this.isNameDuplicate(sColumn, bCaseSensitive)) {
                        lDuplicates.add(sColumn);
                        continue;
                    }
                    cTableColumnsPanel.this.m_mdlColumns.setValueAt(sColumn, iName, 0);
                    baSelect[iName] = true;
                }
                ArrayList<List> lRowsValues = new ArrayList<List>();
                for (int iName = nUpdates; iName < lNames.size(); ++iName) {
                    String sColumn = (String)lNames.get(iName);
                    if (sColumn.length() == 0) {
                        String sFormat = bundle.getString("ColumnDefinitionsPanel.DefaultColumnName.fmt.txt");
                        Object[] args = new Object[]{new Integer(iName + 1)};
                        sColumn = MessageFormat.format(sFormat, args);
                    }
                    if (this.isNameDuplicate(sColumn, bCaseSensitive)) {
                        lDuplicates.add(sColumn);
                        continue;
                    }
                    Column oColumn = (Column)Workspace.getMdFactory().createComplexMetadataObject(store, sColumn, "Column", cTableColumnsPanel.this.m_oTable.getRepositoryID());
                    oColumn.setPublicType("Column");
                    oColumn.setUsageVersion(OMRColumn.CURRENT_VERSION.encode());
                    oColumn.setTable((DataTable)cTableColumnsPanel.this.m_oTable);
                    oColumn.setSASColumnName(sColumn);
                    oColumn.setSASColumnLength(sColumn.length());
                    oColumn.setSASColumnType(WsColumnMetadataUtil.getDataCharacterType());
                    oColumn.setIsNullable(1);
                    lRowsValues.add(cTableColumnsPanel.this.m_mdlColumns.getRowValuesForColumn(oColumn));
                }
                if (lRowsValues.size() > 0) {
                    cTableColumnsPanel.this.m_tblColumns.undoableInsertRows(cTableColumnsPanel.this.m_mdlColumns.getRowCount() - 1, lRowsValues);
                }
                if (lDuplicates.size() > 0) {
                    String sMessage = bundle.getString("ColumnDefinitionsPanel.Warning.DuplicateColumnsRemoved.txt");
                    MessageUtil.displayListMessage((String)sMessage, lDuplicates);
                }
                for (int iRow = nUpdates - 1; iRow >= 0; --iRow) {
                    if (!baSelect[iRow]) continue;
                    cTableColumnsPanel.this.m_tblColumns.addCellToSelection(cTableColumnsPanel.this.m_tblColumns.convertRowIndexToView(iRow), cTableColumnsPanel.this.m_tblColumns.convertColumnIndexToView(0));
                }
            }

            private boolean isNameDuplicate(String sName, boolean bCaseSensitive) {
                for (int iColumn = 0; iColumn < cTableColumnsPanel.this.m_mdlColumns.getRowCount(); ++iColumn) {
                    boolean bEquals;
                    String sColumn = (String)cTableColumnsPanel.this.m_mdlColumns.getValueAt(iColumn, 0);
                    boolean bl = bEquals = bCaseSensitive ? sName.equals(sColumn) : sName.equalsIgnoreCase(sColumn);
                    if (!bEquals) continue;
                    return true;
                }
                return false;
            }
        }
    }
}

