/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.efi2;

import com.sas.wadmin.efi2.COB2SASRunResultFileStructure;
import com.sas.workspace.AppServerException;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsIntegerTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsUIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class COB2SASRunReviewPanel
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(COB2SASRunReviewPanel.class);
    protected WsTable m_tblCOB2SASReview;
    protected cCOB2SASReviewTableModel m_mdlCOB2SASReview;
    String m_logFileName;
    WAPanel m_pnlSaveLogFile;
    private JLabel m_lblSASLog;
    private WAComboBox m_cbSASLogFile;
    private JButton m_btnBrowseFile;
    private WsAbstractAction m_actSASLogFile;
    private static final String SAS_LOGFILES_KEY = "COB2SASRunReviewPanel.Filenames";
    private static final int SAS_LOGFILES_MAX = 10;

    public COB2SASRunReviewPanel() {
        this.initialize();
    }

    protected void initialize() {
        this.setHelpProduct("shared");
        this.setHelpTopic("import_column_win");
        this.m_mdlCOB2SASReview = new cCOB2SASReviewTableModel();
        this.m_tblCOB2SASReview = new WsTable((WsAbstractTableModel)this.m_mdlCOB2SASReview);
        this.m_tblCOB2SASReview.setRowsReorderable(false);
        this.m_tblCOB2SASReview.setRowHoldingEnabled(false);
        this.m_tblCOB2SASReview.setColumnHoldingEnabled(false);
        this.m_tblCOB2SASReview.setColumnsReorderable(false);
        this.m_tblCOB2SASReview.setAutoResizeMode(3);
        this.m_tblCOB2SASReview.setNonEditableCellBackground(UIManager.getColor("TextField.inactiveBackground"));
        this.m_pnlSaveLogFile = new WAPanel();
        this.m_pnlSaveLogFile.setBorder((Border)WsUIUtilities.createTitledBorder((String)bundle.getString("COB2SASRunReviewPanel.TitledBorder.SaveSASLog.txt")));
        this.m_pnlSaveLogFile.setLayout((LayoutManager)new GridBagLayout());
        this.m_cbSASLogFile = new WAComboBox();
        this.m_cbSASLogFile.setEditable(true);
        this.m_lblSASLog = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cbSASLogFile, (WAdminResource)bundle, (String)"COB2SASRunReviewPanel.Label.SASLogFile");
        this.m_actSASLogFile = new cSASLogFileBrowseAction();
        this.m_btnBrowseFile = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actSASLogFile);
        int x = 0;
        int y = 0;
        int w = 1;
        int h = 1;
        double wx = 0.0;
        double wy = 0.0;
        int anchor = 17;
        int fill = 0;
        this.m_pnlSaveLogFile.add((Component)this.m_lblSASLog, (Object)new GridBagConstraints(x, y, w, h, wx, wy, anchor, fill, new Insets(10, 0, 10, 0), 0, 0));
        fill = 2;
        wx = 1.0;
        w = 3;
        this.m_pnlSaveLogFile.add((Component)this.m_cbSASLogFile, (Object)new GridBagConstraints(++x, y, w, h, wx, wy, anchor, fill, new Insets(10, 10, 10, 0), 0, 0));
        fill = 0;
        wx = 0.0;
        w = 1;
        this.m_pnlSaveLogFile.add((Component)this.m_btnBrowseFile, (Object)new GridBagConstraints(x += 3, y, w, h, wx, wy, anchor, fill, new Insets(10, 10, 10, 0), 0, 0));
        JScrollPane scrCOB2SASReview = new JScrollPane((Component)this.m_tblCOB2SASReview);
        this.setPreferredSize(new Dimension(800, 600));
        this.setLayout(new BorderLayout());
        this.add(scrCOB2SASReview, "Center");
        this.add((Component)this.m_pnlSaveLogFile, "South");
    }

    public boolean validateData() {
        return this.m_tblCOB2SASReview.stopCellEditing();
    }

    public void populateStore() {
    }

    public void moveDataToView() {
        this.setListeningForChanges(false);
        this.m_cbSASLogFile.loadItems(SAS_LOGFILES_KEY, 10);
        this.moveDataToModel();
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.m_cbSASLogFile.saveItems(SAS_LOGFILES_KEY, 10);
            this.m_mdlCOB2SASReview.moveDataToStore();
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void moveDataToModel() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.m_mdlCOB2SASReview.moveDataToModel();
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    protected List getCOB2SASReviewValues() {
        return this.m_mdlCOB2SASReview.getNameValues();
    }

    protected void setCOB2SASReviewValues(List lCOB2SASReviewValues) {
        this.m_mdlCOB2SASReview.setNameValues(lCOB2SASReviewValues);
    }

    public String getSASLogFile() {
        return (String)this.m_cbSASLogFile.getSelectedItem();
    }

    protected String promptForSASLogFile(String title, String currDir) {
        File file = null;
        String strDirectory = currDir;
        JFileChooser chooser = new JFileChooser(strDirectory);
        chooser.setFileSelectionMode(0);
        chooser.setDialogTitle(title);
        int retValue = chooser.showOpenDialog(chooser);
        if (retValue == 0) {
            file = chooser.getSelectedFile();
        }
        if (file == null) {
            return null;
        }
        return file.toString();
    }

    protected class cCOB2SASReviewTableModelListener
    implements TableModelListener {
        protected cCOB2SASReviewTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (COB2SASRunReviewPanel.this.isListeningForChanges()) {
                COB2SASRunReviewPanel.this.setDataChanged(true);
            }
            e.getSource();
        }
    }

    private class cSASLogFileBrowseAction
    extends WsAbstractAction {
        public cSASLogFileBrowseAction() {
            super(bundle, "WsSASLogFile.Action.SASLogFileBrowse", false, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            try {
                String logFilename;
                COB2SASRunReviewPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                LinkedHashMap<String, String> mapFileTypes = new LinkedHashMap<String, String>();
                mapFileTypes.put(bundle.getString("WsSASLogFile.LogFileTypes.txt"), "*");
                String sName = (String)COB2SASRunReviewPanel.this.m_cbSASLogFile.getSelectedItem();
                if (sName == null) {
                    sName = "";
                }
                if ((logFilename = COB2SASRunReviewPanel.this.promptForSASLogFile(bundle.getString("WsSASLogFile.BrowseSASLogFile.Title.txt"), sName)) != null) {
                    COB2SASRunReviewPanel.this.m_cbSASLogFile.setSelectedItem((Object)logFilename);
                }
            }
            catch (AppServerException ase) {
                MessageUtil.displayMessage((String)ase.getLocalizedMessage(), (int)0);
                e.getSource();
            }
            finally {
                COB2SASRunReviewPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    class cCOB2SASReviewTableModel
    extends WsAbstractTableModel {
        protected List m_lRowValues = new ArrayList();
        protected static final int sourceFileName_COLUMN = 0;
        protected static final int fileDescriptor_COLUMN = 1;
        protected static final int CSVFileName_COLUMN = 2;
        protected static final int fieldsInCSV_COLUMN = 3;
        protected static final int COLUMN_COUNT = 4;

        public cCOB2SASReviewTableModel() {
            WsStringTableColumn sourceFileName = new WsStringTableColumn(0, bundle.getString("COB2SASRunReviewPanel.CopybookInputCol.title.txt"), 200, 100);
            WsStringTableColumn fileDescriptor = new WsStringTableColumn(1, bundle.getString("COB2SASRunReviewPanel.FileDescriptorCol.title.txt"), 150, 50);
            WsStringTableColumn CSVFileName = new WsStringTableColumn(2, bundle.getString("COB2SASRunReviewPanel.CSVFileName.title.txt"), 300, 100);
            WsIntegerTableColumn fieldsInCSV = new WsIntegerTableColumn(3, bundle.getString("COB2SASRunReviewPanel.FieldCountInCSV.title.txt"), 50);
            this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount()];
            this.m_aColumns[0] = sourceFileName;
            this.m_aColumns[1] = fileDescriptor;
            this.m_aColumns[2] = CSVFileName;
            this.m_aColumns[3] = fieldsInCSV;
            this.m_aColumns[0].setEditable(false);
            this.m_aColumns[1].setEditable(false);
            this.m_aColumns[3].setEditable(false);
        }

        public int getColumnCount() {
            return 4;
        }

        public void populateStore() {
        }

        public void moveDataToModel() {
            this.clear();
            for (int i = 0; i < this.m_lRowValues.size(); ++i) {
                COB2SASRunResultFileStructure fileStruct = (COB2SASRunResultFileStructure)this.m_lRowValues.get(i);
                ArrayList<Object> row = new ArrayList<Object>(4);
                row.add(fileStruct.getSourceFile());
                row.add(fileStruct.getfileDescriptor());
                row.add(fileStruct.getCSVFilePath());
                row.add(new Integer(fileStruct.getNumColumns()));
                this.m_lData.add(row);
            }
            this.fireTableModelPopulated();
        }

        public void moveDataToStore() {
            this.m_lRowValues.clear();
            for (int iRow = 0; iRow < this.getRowCount(); ++iRow) {
                COB2SASRunResultFileStructure row = new COB2SASRunResultFileStructure((String)this.getValueAt(iRow, 0), (String)this.getValueAt(iRow, 1), (String)this.getValueAt(iRow, 2), (Integer)this.getValueAt(iRow, 3));
                this.m_lRowValues.add(iRow, row);
            }
        }

        protected List getNameValues() {
            return this.m_lRowValues;
        }

        protected void setNameValues(List lRowValues) {
            if (lRowValues == null) {
                this.m_lRowValues.clear();
            } else {
                this.m_lRowValues = lRowValues;
            }
        }
    }
}

