/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.efi2;

import com.sas.metadata.remote.MdException;
import com.sas.wadmin.efi2.ColumnDefinitionsPanel;
import com.sas.wadmin.efi2.ExternalTableDataModel;
import com.sas.wadmin.efi2.GuessingRowsModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAIntTextField;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.text.JTextComponent;

public class AutoColumnsPanel
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(AutoColumnsPanel.class);
    private ExternalTableDataModel m_mdlTable;
    private ColumnDefinitionsPanel m_columnsPanel;
    private WAComboBox m_cmbCharacterInformats;
    private WAComboBox m_cmbCharacterFormats;
    private WAComboBox m_cmbNumericInformats;
    private WAComboBox m_cmbNumericFormats;
    private JLabel m_lblCharacterInformats;
    private JLabel m_lblCharacterFormats;
    private JLabel m_lblNumericInformats;
    private JLabel m_lblNumericFormats;
    private JLabel m_lblStartGuessingRecord;
    private WAIntTextField m_txtStartGuessingRecord;
    private WAIntTextField m_txtNumberOfGuessingRecords;
    private JLabel m_lblNumberOfGuessingRecords;
    private JCheckBox m_ckbMultipleRowsPerRecord;
    private WAIntTextField m_txtNumberOfColumnsPerRow;
    private JLabel m_lblNumberOfColumnsPerRow;
    private JPanel m_pnlMultipleRowsPerRecord;
    private ItemListener m_lsnrCommon;
    private ActionListener m_lsnrFocusMover;

    public AutoColumnsPanel(ExternalTableDataModel mdlTable, ColumnDefinitionsPanel columnsPanel) {
        try {
            this.m_mdlTable = mdlTable;
            this.m_columnsPanel = columnsPanel;
            this.setHelpProduct("wdb");
            this.setHelpTopic("auto_columns");
            this.initialize(!this.m_mdlTable.getExternalTable().isNewObject());
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    protected void initialize(boolean bProperties) {
        this.m_lsnrCommon = new cCommonListener();
        this.m_lsnrFocusMover = new cFocusMover();
        this.m_cmbCharacterInformats = new WAComboBox();
        this.m_cmbCharacterFormats = new WAComboBox();
        this.m_cmbNumericInformats = new WAComboBox();
        this.m_cmbNumericFormats = new WAComboBox();
        this.m_cmbCharacterInformats.setEditable(false);
        this.m_cmbCharacterFormats.setEditable(false);
        this.m_cmbNumericInformats.setEditable(false);
        this.m_cmbNumericFormats.setEditable(false);
        this.m_cmbCharacterInformats.addItems((Object[])WsColumnMetadataUtil.getDefaultCharacterInformats());
        this.m_cmbCharacterFormats.addItems((Object[])WsColumnMetadataUtil.getDefaultCharacterFormats());
        this.m_cmbNumericInformats.addItems((Object[])WsColumnMetadataUtil.getDefaultNumericInformats());
        this.m_cmbNumericInformats.insertItemAt((Object)"w.d", 1);
        this.m_cmbNumericFormats.addItems((Object[])WsColumnMetadataUtil.getDefaultNumericFormats());
        this.m_cmbNumericFormats.insertItemAt((Object)"w.d", 1);
        this.m_lblCharacterInformats = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbCharacterInformats, (WAdminResource)bundle, (String)"AutoColumnsPanel.Label.CharacterInformats");
        this.m_lblCharacterFormats = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbCharacterFormats, (WAdminResource)bundle, (String)"AutoColumnsPanel.Label.CharacterFormats");
        this.m_lblNumericInformats = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbNumericInformats, (WAdminResource)bundle, (String)"AutoColumnsPanel.Label.NumericInformats");
        this.m_lblNumericFormats = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbNumericFormats, (WAdminResource)bundle, (String)"AutoColumnsPanel.Label.NumericFormats");
        JPanel pnlCharacter = new JPanel(new GridBagLayout());
        pnlCharacter.setBorder(WsUIUtilities.createTitledBorder((String)bundle.getString("AutoColumnsPanel.BorderTitle.CharacterDefaults.txt")));
        pnlCharacter.add((Component)this.m_lblCharacterInformats, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        pnlCharacter.add((Component)this.m_cmbCharacterInformats, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        pnlCharacter.add((Component)this.m_lblCharacterFormats, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        pnlCharacter.add((Component)this.m_cmbCharacterFormats, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        JPanel pnlNumeric = new JPanel(new GridBagLayout());
        pnlNumeric.setBorder(WsUIUtilities.createTitledBorder((String)bundle.getString("AutoColumnsPanel.BorderTitle.NumericDefaults.txt")));
        pnlNumeric.add((Component)this.m_lblNumericInformats, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        pnlNumeric.add((Component)this.m_cmbNumericInformats, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        pnlNumeric.add((Component)this.m_lblNumericFormats, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        pnlNumeric.add((Component)this.m_cmbNumericFormats, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.m_txtStartGuessingRecord = new WAIntTextField();
        this.m_txtStartGuessingRecord.setColumns(6);
        this.m_lblStartGuessingRecord = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtStartGuessingRecord, (WAdminResource)bundle, (String)"AutoColumnsPanel.Label.StartGuessingRecord");
        this.m_txtNumberOfGuessingRecords = new WAIntTextField();
        this.m_txtNumberOfGuessingRecords.setColumns(6);
        this.m_lblNumberOfGuessingRecords = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtNumberOfGuessingRecords, (WAdminResource)bundle, (String)"AutoColumnsPanel.Label.NumberOfGuessingRecords");
        JPanel pnlGuessingRecords = new JPanel(new GridBagLayout());
        pnlGuessingRecords.setBorder(WsUIUtilities.createTitledBorder((String)bundle.getString("AutoColumnsPanel.BorderTitle.GuessingRecords.txt")));
        pnlGuessingRecords.add((Component)this.m_lblStartGuessingRecord, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        pnlGuessingRecords.add((Component)this.m_txtStartGuessingRecord, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        pnlGuessingRecords.add((Component)this.m_lblNumberOfGuessingRecords, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        pnlGuessingRecords.add((Component)this.m_txtNumberOfGuessingRecords, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.createMultipleRowsPerRecordPanel();
        this.setLayout(new GridBagLayout());
        if (!bProperties) {
            this.add(pnlCharacter, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add(pnlNumeric, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add(pnlGuessingRecords, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this.m_pnlMultipleRowsPerRecord, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.listenForDataChangesTo((JComboBox)this.m_cmbCharacterInformats);
        this.listenForDataChangesTo((JComboBox)this.m_cmbCharacterFormats);
        this.listenForDataChangesTo((JComboBox)this.m_cmbNumericInformats);
        this.listenForDataChangesTo((JComboBox)this.m_cmbNumericFormats);
        this.listenForDataChangesTo((JTextComponent)this.m_txtStartGuessingRecord);
        this.listenForDataChangesTo((JTextComponent)this.m_txtNumberOfGuessingRecords);
    }

    private void createMultipleRowsPerRecordPanel() {
        this.m_ckbMultipleRowsPerRecord = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"AutoColumnsPanel.Checkbox.MultipleRowsPerRecord");
        this.m_ckbMultipleRowsPerRecord.addItemListener(this.m_lsnrCommon);
        this.m_ckbMultipleRowsPerRecord.addActionListener(this.m_lsnrFocusMover);
        this.m_txtNumberOfColumnsPerRow = new WAIntTextField();
        this.m_txtNumberOfColumnsPerRow.setColumns(4);
        this.m_txtNumberOfColumnsPerRow.setEnabled(true);
        this.m_lblNumberOfColumnsPerRow = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtNumberOfColumnsPerRow, (WAdminResource)bundle, (String)"AutoColumnsPanel.Label.NumberOfColumnsPerRow");
        this.m_lblNumberOfColumnsPerRow.setEnabled(true);
        this.listenForDataChangesTo(this.m_ckbMultipleRowsPerRecord);
        this.listenForDataChangesTo((JTextComponent)this.m_txtNumberOfColumnsPerRow);
        this.m_pnlMultipleRowsPerRecord = new JPanel(new GridBagLayout());
        this.m_pnlMultipleRowsPerRecord.setBorder(WsUIUtilities.createTitledBorder((String)bundle.getString("AutoColumnsPanel.BorderTitle.MultipleRows.txt")));
        this.m_pnlMultipleRowsPerRecord.add((Component)this.m_ckbMultipleRowsPerRecord, new GridBagConstraints(0, 0, 2, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlMultipleRowsPerRecord.add((Component)this.m_lblNumberOfColumnsPerRow, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 23, 0, 0), 0, 0));
        this.m_pnlMultipleRowsPerRecord.add((Component)this.m_txtNumberOfColumnsPerRow, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
    }

    public void populateStore() throws MdException, RemoteException {
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_cmbCharacterInformats.setSelectedItem((Object)this.m_mdlTable.getDefaultCharacterInformat());
        this.m_cmbCharacterFormats.setSelectedItem((Object)this.m_mdlTable.getDefaultCharacterFormat());
        this.m_cmbNumericInformats.setSelectedItem((Object)this.m_mdlTable.getDefaultNumericInformat());
        this.m_cmbNumericFormats.setSelectedItem((Object)this.m_mdlTable.getDefaultNumericFormat());
        int iStart = Math.max(this.m_mdlTable.getStartGuessingRecord(), this.m_mdlTable.getStartRecord());
        int nGuess = this.m_mdlTable.getGuessingRecords();
        int nObs = this.m_mdlTable.getNumberObservations();
        if (nObs != 0 && nObs < nGuess) {
            nGuess = nObs;
        }
        this.m_txtNumberOfGuessingRecords.setValue(nGuess);
        this.m_txtStartGuessingRecord.setValue(iStart);
        if (this.m_mdlTable.isDelimited()) {
            this.m_ckbMultipleRowsPerRecord.setEnabled(true);
            this.m_ckbMultipleRowsPerRecord.setSelected(this.m_mdlTable.isMultiPerLine());
            if (!this.m_mdlTable.getExternalTable().isNewObject()) {
                this.m_txtNumberOfColumnsPerRow.setBehavior(2);
                this.m_lblNumberOfColumnsPerRow.setEnabled(false);
            } else if (!this.m_ckbMultipleRowsPerRecord.isSelected()) {
                this.m_txtNumberOfColumnsPerRow.setEnabled(false);
                this.m_lblNumberOfColumnsPerRow.setEnabled(false);
            } else {
                this.m_lblNumberOfColumnsPerRow.setEnabled(true);
                this.m_txtNumberOfColumnsPerRow.setEnabled(true);
            }
            if (this.m_mdlTable.getColumnsPerRecord() > 0) {
                this.m_txtNumberOfColumnsPerRow.setValue(this.m_mdlTable.getColumnsPerRecord());
            }
        } else {
            this.m_ckbMultipleRowsPerRecord.setEnabled(false);
            this.m_txtNumberOfColumnsPerRow.setBehavior(2);
            this.m_lblNumberOfColumnsPerRow.setEnabled(false);
        }
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.m_mdlTable.setDefaultCharacterInformat((String)this.m_cmbCharacterInformats.getSelectedItem());
            this.m_mdlTable.setDefaultCharacterFormat((String)this.m_cmbCharacterFormats.getSelectedItem());
            this.m_mdlTable.setDefaultNumericInformat((String)this.m_cmbNumericInformats.getSelectedItem());
            this.m_mdlTable.setDefaultNumericFormat((String)this.m_cmbNumericFormats.getSelectedItem());
            this.m_mdlTable.setStartGuessingRecord(this.m_txtStartGuessingRecord.getValue());
            this.m_mdlTable.setGuessingRecords(this.m_txtNumberOfGuessingRecords.getValue());
            if (this.m_mdlTable.isDelimited()) {
                boolean bMulti = this.m_ckbMultipleRowsPerRecord.isSelected();
                this.m_mdlTable.setMultiPerLine(bMulti);
                if (bMulti) {
                    this.m_mdlTable.setColumnsPerRecord(this.m_txtNumberOfColumnsPerRow.getValue());
                }
            }
            OpRequestUI cgOpRequestUI = new OpRequestUI((Frame)Workspace.getWorkspace(), bundle.getString("AutoColumnsPanel.Executing.msg.txt"), bundle.getString("AutoColumnsPanel.Executing.title.txt"));
            cgOpRequestUI.setDelayBeforeProgressCancelDialog(500);
            GuessingRunnable guessingRunnable = new GuessingRunnable();
            cgOpRequestUI.execute((Runnable)guessingRunnable);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateData() {
        int startRecord = this.m_txtStartGuessingRecord.getValue();
        int numberOfRows = this.m_txtNumberOfGuessingRecords.getValue();
        try {
            int response;
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (startRecord < 0) {
                MessageUtil.displayMessage((String)bundle.getString("AutoColumnsPanel.Error.MissingStartRecord.txt"), (int)0);
                this.m_txtStartGuessingRecord.requestFocus();
                boolean bl = false;
                return bl;
            }
            if (startRecord == 0) {
                MessageUtil.displayMessage((String)bundle.getString("AutoColumnsPanel.Error.ZeroStartRecord.txt"), (int)0);
                this.m_txtStartGuessingRecord.requestFocus();
                boolean bl = false;
                return bl;
            }
            if (startRecord < this.m_mdlTable.getStartRecord()) {
                MessageUtil.displayMessage((String)bundle.formatString("AutoColumnsPanel.Error.StartGuessingRecordLessThanStartDataRecord.txt", (Object)new Integer(this.m_mdlTable.getStartRecord())), (int)0);
                this.m_txtStartGuessingRecord.requestFocus();
                boolean bl = false;
                return bl;
            }
            if (numberOfRows <= 0) {
                MessageUtil.displayMessage((String)bundle.getString("GuessingRowsModel.Error.ZeroGuessingRows.txt"), (int)0);
                this.m_txtNumberOfGuessingRecords.requestFocus();
                boolean bl = false;
                return bl;
            }
            try {
                this.m_columnsPanel.loadGuessingRows(startRecord, numberOfRows);
            }
            catch (GuessingRowsModel.StartValueTooLargeException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage());
                this.m_txtStartGuessingRecord.requestFocus();
                boolean bl = false;
                this.setCursor(Cursor.getDefaultCursor());
                return bl;
            }
            if (this.m_mdlTable.isDelimited() && this.m_columnsPanel.getColumnCount() > 0 && (response = MessageUtil.displayMessage((String)bundle.getString("AutoColumnsPanel.Warning.OverwriteColumns.txt"), (int)2, (int)2)) != 0) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        return true;
    }

    protected class GuessingRunnable
    implements Runnable {
        protected GuessingRunnable() {
        }

        @Override
        public void run() {
            AutoColumnsPanel.this.m_columnsPanel.guessColumnTypes();
        }
    }

    private class cFocusMover
    implements ActionListener {
        private cFocusMover() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (e.getSource() == AutoColumnsPanel.this.m_ckbMultipleRowsPerRecord && AutoColumnsPanel.this.m_ckbMultipleRowsPerRecord.isSelected() && AutoColumnsPanel.this.m_mdlTable.getExternalTable().isNewObject()) {
                    AutoColumnsPanel.this.m_txtNumberOfColumnsPerRow.requestFocus();
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    private class cCommonListener
    implements ItemListener {
        private cCommonListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            try {
                boolean bEnabled;
                JToggleButton tbn = (JToggleButton)e.getItemSelectable();
                boolean bl = bEnabled = tbn.isSelected() && AutoColumnsPanel.this.isEditable();
                if (tbn == AutoColumnsPanel.this.m_ckbMultipleRowsPerRecord && AutoColumnsPanel.this.m_mdlTable.getExternalTable().isNewObject()) {
                    AutoColumnsPanel.this.m_lblNumberOfColumnsPerRow.setEnabled(bEnabled);
                    AutoColumnsPanel.this.m_txtNumberOfColumnsPerRow.setEnabled(bEnabled);
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }
}

