/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.efi2;

import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.metadata.EFIDataModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class AccessMethodTab
extends WAPropertyTab {
    private static final WAdminResource bundle = WAdminResource.getBundle(AccessMethodTab.class);
    private static final String DEFAULT = "DEFAULT";
    private static final String FTP = "FTP";
    private static final String URL = "URL";
    private static final String HADOOP = "HADOOP";
    private JRadioButton m_rbnDefaultFileSystem;
    private JRadioButton m_rbnNamedPipe;
    private JRadioButton m_rbnFTP;
    private JRadioButton m_rbnURL;
    private JRadioButton m_rbnHadoop;
    private JLabel m_lblFTPServer;
    private WAComboBox m_cmbFTPServer;
    private JLabel m_lblHTTPServer;
    private WAComboBox m_cmbHTTPServer;
    private JLabel m_lblHadoopServer;
    private WAComboBox m_cmbHadoopServer;
    private List m_ftpList;
    private List m_httpList;
    private List m_hadoopList;
    private EFIDataModel m_mdlTable;
    protected JLabel accessMethodValue;

    public AccessMethodTab(EFIDataModel mdlTable, boolean bWizard) {
        this.m_mdlTable = mdlTable;
        this.setHelpProduct("wdb");
        this.setHelpTopic("adv_file_loc_access");
        this.initialize(bWizard);
    }

    public AccessMethodTab(EFIDataModel mdlTable) {
        this.m_mdlTable = mdlTable;
        this.setHelpProduct("wdb");
        this.setHelpTopic("adv_file_loc_access");
        this.initialize(true);
    }

    protected void initialize() {
        this.initialize(true);
    }

    protected void initialize(boolean bWizard) {
        this.m_rbnDefaultFileSystem = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"AccessMethodTab.RadioButton.DefaultFileSystem", (int)5);
        this.m_rbnNamedPipe = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"AccessMethodTab.RadioButton.NamedPipe", (int)5);
        this.m_rbnFTP = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"AccessMethodTab.RadioButton.FTP", (int)5);
        this.m_rbnURL = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"AccessMethodTab.RadioButton.URL", (int)5);
        this.m_rbnHadoop = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"AccessMethodTab.RadioButton.Hadoop", (int)5);
        ButtonGroup grp = new ButtonGroup();
        grp.add(this.m_rbnDefaultFileSystem);
        grp.add(this.m_rbnNamedPipe);
        grp.add(this.m_rbnFTP);
        grp.add(this.m_rbnURL);
        grp.add(this.m_rbnHadoop);
        cItemListener lsnr = new cItemListener();
        this.m_rbnDefaultFileSystem.addItemListener(lsnr);
        this.m_rbnFTP.addItemListener(lsnr);
        this.m_rbnURL.addItemListener(lsnr);
        this.m_rbnHadoop.addItemListener(lsnr);
        this.accessMethodValue = new JLabel(DEFAULT);
        this.m_cmbFTPServer = new WAComboBox(true);
        this.m_cmbFTPServer.setPrototypeDisplayValue((Object)"012345678901234567890");
        this.m_cmbFTPServer.setEnabled(false);
        this.m_lblFTPServer = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbFTPServer, (WAdminResource)bundle, (String)"AccessMethodTab.Label.FTPServer");
        this.m_lblFTPServer.setEnabled(false);
        this.m_cmbHTTPServer = new WAComboBox(true);
        this.m_cmbHTTPServer.setPrototypeDisplayValue((Object)"012345678901234567890");
        this.m_cmbHTTPServer.setEnabled(false);
        this.m_lblHTTPServer = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbHTTPServer, (WAdminResource)bundle, (String)"AccessMethodTab.Label.HTTPServer");
        this.m_lblHTTPServer.setEnabled(false);
        this.m_cmbHadoopServer = new WAComboBox(true);
        this.m_cmbHadoopServer.setPrototypeDisplayValue((Object)"012345678901234567890");
        this.m_cmbHadoopServer.setEnabled(false);
        this.m_lblHadoopServer = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbHadoopServer, (WAdminResource)bundle, (String)"AccessMethodTab.Label.HadoopServer");
        this.m_lblHadoopServer.setEnabled(false);
        this.listenForDataChangesTo(this.m_rbnDefaultFileSystem);
        this.listenForDataChangesTo(this.m_rbnNamedPipe);
        this.listenForDataChangesTo(this.m_rbnFTP);
        this.listenForDataChangesTo(this.m_rbnURL);
        this.listenForDataChangesTo(this.m_rbnHadoop);
        this.listenForDataChangesTo((JComboBox)this.m_cmbFTPServer);
        this.listenForDataChangesTo((JComboBox)this.m_cmbHTTPServer);
        this.listenForDataChangesTo((JComboBox)this.m_cmbHadoopServer);
        this.setLayout(new GridBagLayout());
        this.add(this.m_rbnDefaultFileSystem, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_rbnFTP, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_lblFTPServer, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.m_cmbFTPServer, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_rbnURL, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_lblHTTPServer, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.m_cmbHTTPServer, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_rbnHadoop, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_lblHadoopServer, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.m_cmbHadoopServer, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void populateStore() throws MdException, RemoteException {
        int i;
        this.m_ftpList = this.m_mdlTable.getFtpServers();
        this.m_cmbFTPServer.removeAllItems();
        for (i = 0; i < this.m_ftpList.size(); ++i) {
            this.m_cmbFTPServer.addItem(this.m_ftpList.get(i));
        }
        if (this.m_ftpList.size() > 0) {
            this.m_cmbFTPServer.setSelectedIndex(0);
        }
        this.m_httpList = this.m_mdlTable.getHttpServers();
        this.m_cmbHTTPServer.removeAllItems();
        for (i = 0; i < this.m_httpList.size(); ++i) {
            this.m_cmbHTTPServer.addItem(this.m_httpList.get(i));
        }
        if (this.m_httpList.size() > 0) {
            this.m_cmbHTTPServer.setSelectedIndex(0);
        }
        this.m_hadoopList = this.m_mdlTable.getHadoopServers();
        this.m_cmbHadoopServer.removeAllItems();
        for (i = 0; i < this.m_hadoopList.size(); ++i) {
            this.m_cmbHadoopServer.addItem(this.m_hadoopList.get(i));
        }
        if (this.m_hadoopList.size() > 0) {
            this.m_cmbHadoopServer.setSelectedIndex(0);
        }
        this.m_mdlTable.populateStore();
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        if (this.m_mdlTable.isPipeAccessMethod()) {
            this.m_rbnNamedPipe.setSelected(true);
        } else if (this.m_mdlTable.isFtpAccessMethod()) {
            this.m_rbnFTP.setSelected(true);
            this.m_cmbFTPServer.setSelectedItem((Object)this.m_mdlTable.getFtpServer());
        } else if (this.m_mdlTable.isHttpAccessMethod()) {
            this.m_rbnURL.setSelected(true);
            this.m_cmbHTTPServer.setSelectedItem((Object)this.m_mdlTable.getHttpServer());
        } else if (this.m_mdlTable.isHadoopAccessMethod()) {
            this.m_rbnHadoop.setSelected(true);
            this.m_cmbHadoopServer.setSelectedItem((Object)this.m_mdlTable.getHadoopServer());
        } else {
            this.m_rbnDefaultFileSystem.setSelected(true);
        }
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        if (this.m_rbnDefaultFileSystem.isSelected()) {
            this.m_mdlTable.setDefaultAccessMethod(true);
        } else if (this.m_rbnNamedPipe.isSelected()) {
            this.m_mdlTable.setPipeAccessMethod(true);
        } else if (this.m_rbnFTP.isSelected()) {
            this.m_mdlTable.setFtpAccessMethod(true);
            this.m_mdlTable.setFtpServer((DeployedComponent)this.m_cmbFTPServer.getSelectedItem());
        } else if (this.m_rbnURL.isSelected()) {
            this.m_mdlTable.setHttpAccessMethod(true);
            this.m_mdlTable.setHttpServer((DeployedComponent)this.m_cmbHTTPServer.getSelectedItem());
        } else if (this.m_rbnHadoop.isSelected()) {
            this.m_mdlTable.setHadoopAccessMethod(true);
            this.m_mdlTable.setHadoopServer((DeployedComponent)this.m_cmbHadoopServer.getSelectedItem());
        }
        this.setDataChanged(false);
    }

    public boolean validateData() {
        if (this.m_rbnFTP.isSelected() && this.m_cmbFTPServer.getSelectedIndex() == -1) {
            MessageUtil.displayMessage((String)bundle.getString("AccessMethodTab.Error.FTPServerRequired.txt"), (int)0);
            this.m_cmbFTPServer.requestFocus();
            return false;
        }
        if (this.m_rbnURL.isSelected() && this.m_cmbHTTPServer.getSelectedIndex() == -1) {
            MessageUtil.displayMessage((String)bundle.getString("AccessMethodTab.Error.HTTPServerRequired.txt"), (int)0);
            this.m_cmbHTTPServer.requestFocus();
            return false;
        }
        if (this.m_rbnHadoop.isSelected() && this.m_cmbHadoopServer.getSelectedIndex() == -1) {
            MessageUtil.displayMessage((String)bundle.getString("AccessMethodTab.Error.HadoopServerRequired.txt"), (int)0);
            this.m_cmbHadoopServer.requestFocus();
            return false;
        }
        return true;
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_rbnDefaultFileSystem.setEnabled(bEditable);
        this.m_rbnNamedPipe.setEnabled(bEditable);
        this.m_rbnFTP.setEnabled(bEditable);
        this.m_rbnURL.setEnabled(bEditable);
        this.m_rbnHadoop.setEnabled(bEditable);
        this.m_rbnNamedPipe.setEnabled(false);
    }

    private class cItemListener
    implements ItemListener {
        private cItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            boolean bEnabled;
            JRadioButton rbn = (JRadioButton)e.getItemSelectable();
            boolean bl = bEnabled = rbn.isSelected() && AccessMethodTab.this.isEditable();
            if (rbn == AccessMethodTab.this.m_rbnFTP) {
                AccessMethodTab.this.m_lblFTPServer.setEnabled(bEnabled);
                AccessMethodTab.this.m_cmbFTPServer.setEnabled(bEnabled);
                AccessMethodTab.this.accessMethodValue.setText(AccessMethodTab.FTP);
            } else if (rbn == AccessMethodTab.this.m_rbnURL) {
                AccessMethodTab.this.m_lblHTTPServer.setEnabled(bEnabled);
                AccessMethodTab.this.m_cmbHTTPServer.setEnabled(bEnabled);
                AccessMethodTab.this.accessMethodValue.setText(AccessMethodTab.URL);
            } else if (rbn == AccessMethodTab.this.m_rbnHadoop) {
                AccessMethodTab.this.m_lblHadoopServer.setEnabled(bEnabled);
                AccessMethodTab.this.m_cmbHadoopServer.setEnabled(bEnabled);
                AccessMethodTab.this.accessMethodValue.setText(AccessMethodTab.HADOOP);
            } else {
                AccessMethodTab.this.accessMethodValue.setText(AccessMethodTab.DEFAULT);
            }
        }
    }
}

