/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.efi2;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.data.IExternalTable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.other.IFileAccessServer;
import com.sas.etl.models.other.IServer;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class AccessMethodPanel
extends WAPanel {
    private static final WAdminResource bundle = WAdminResource.getBundle(AccessMethodPanel.class);
    private static final String DEFAULT = "DEFAULT";
    private static final String FTP = "FTP";
    private static final String URL = "URL";
    private static final String HADOOP = "HADOOP";
    private JRadioButton m_rbnDefaultFileSystem;
    private JRadioButton m_rbnNamedPipe;
    private JRadioButton m_rbnFTP;
    private JRadioButton m_rbnURL;
    private JRadioButton m_rbnHadoop;
    private JLabel m_lblFTPServer;
    private WAComboBox m_cmbFTPServer;
    private JLabel m_lblHTTPServer;
    private WAComboBox m_cmbHTTPServer;
    private JLabel m_lblHadoopServer;
    private WAComboBox m_cmbHadoopServer;
    private List m_ftpList;
    private List m_httpList;
    private List m_hadoopList;
    private IExternalTable m_mdlTable;
    private MdObjectStore m_store;
    private ItemListener m_lsnrButtons;
    private ItemListener m_lsnrServers;
    private IModelListener m_lsnrModel;
    protected JLabel accessMethodValue;

    public AccessMethodPanel(IExternalTable mdlTable) {
        this.m_mdlTable = mdlTable;
        this.setHelpProduct("wdb");
        this.setHelpTopic("adv_file_loc_access");
        this.initialize();
    }

    protected void initialize() {
        this.m_rbnDefaultFileSystem = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"AccessMethodTab.RadioButton.DefaultFileSystem", (int)5);
        this.m_rbnNamedPipe = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"AccessMethodTab.RadioButton.NamedPipe", (int)5);
        this.m_rbnFTP = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"AccessMethodTab.RadioButton.FTP", (int)5);
        this.m_rbnURL = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"AccessMethodTab.RadioButton.URL", (int)5);
        this.m_rbnHadoop = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"AccessMethodTab.RadioButton.Hadoop", (int)5);
        ButtonGroup grp = new ButtonGroup();
        grp.add(this.m_rbnDefaultFileSystem);
        grp.add(this.m_rbnNamedPipe);
        grp.add(this.m_rbnFTP);
        grp.add(this.m_rbnURL);
        grp.add(this.m_rbnHadoop);
        this.m_lsnrButtons = new cItemListener();
        this.m_rbnDefaultFileSystem.addItemListener(this.m_lsnrButtons);
        this.m_rbnFTP.addItemListener(this.m_lsnrButtons);
        this.m_rbnURL.addItemListener(this.m_lsnrButtons);
        this.m_rbnHadoop.addItemListener(this.m_lsnrButtons);
        this.m_lsnrServers = new cServerListener();
        this.m_lsnrModel = new ModelListener();
        this.accessMethodValue = new JLabel(DEFAULT);
        this.m_cmbFTPServer = new WAComboBox(true);
        this.m_cmbFTPServer.setPrototypeDisplayValue((Object)"012345678901234567890");
        this.m_cmbFTPServer.setEnabled(false);
        this.m_cmbFTPServer.addItemListener(this.m_lsnrServers);
        this.m_lblFTPServer = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbFTPServer, (WAdminResource)bundle, (String)"AccessMethodTab.Label.FTPServer");
        this.m_lblFTPServer.setEnabled(false);
        this.m_cmbHTTPServer = new WAComboBox(true);
        this.m_cmbHTTPServer.setPrototypeDisplayValue((Object)"012345678901234567890");
        this.m_cmbHTTPServer.setEnabled(false);
        this.m_cmbHTTPServer.addItemListener(this.m_lsnrServers);
        this.m_lblHTTPServer = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbHTTPServer, (WAdminResource)bundle, (String)"AccessMethodTab.Label.HTTPServer");
        this.m_lblHTTPServer.setEnabled(false);
        this.m_cmbHadoopServer = new WAComboBox(true);
        this.m_cmbHadoopServer.setPrototypeDisplayValue((Object)"012345678901234567890");
        this.m_cmbHadoopServer.setEnabled(false);
        this.m_cmbHadoopServer.addItemListener(this.m_lsnrServers);
        this.m_lblHadoopServer = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbHadoopServer, (WAdminResource)bundle, (String)"AccessMethodTab.Label.HadoopServer");
        this.m_lblHadoopServer.setEnabled(false);
        this.listenForDataChangesTo(this.m_rbnDefaultFileSystem);
        this.listenForDataChangesTo(this.m_rbnNamedPipe);
        this.listenForDataChangesTo(this.m_rbnFTP);
        this.listenForDataChangesTo(this.m_rbnURL);
        this.listenForDataChangesTo(this.m_rbnHadoop);
        this.listenForDataChangesTo((JComboBox)this.m_cmbFTPServer);
        this.listenForDataChangesTo((JComboBox)this.m_cmbHTTPServer);
        this.listenForDataChangesTo((JComboBox)this.m_cmbHadoopServer);
        this.setLayout(new GridBagLayout());
        this.add(this.m_rbnDefaultFileSystem, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_rbnFTP, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_lblFTPServer, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.m_cmbFTPServer, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_rbnURL, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_lblHTTPServer, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.m_cmbHTTPServer, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_rbnHadoop, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_lblHadoopServer, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.m_cmbHadoopServer, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(0, 4, 3, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_mdlTable.getModel().addModelListener(this.m_lsnrModel);
    }

    public void setObjectStore(MdObjectStore store) {
        this.m_store = store;
    }

    public MdObjectStore getObjectStore() {
        return this.m_store;
    }

    public void populateStore() throws MdException, RemoteException {
        int i;
        String serverType = "Ftp Server";
        String sOptions = "<XMLSELECT Search=\"@PRODUCTNAME='" + serverType + "'\"/>";
        List lDeployedComp = null;
        this.m_ftpList = lDeployedComp = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_store, "", "ServerComponent", 8588, sOptions);
        for (i = 0; i < this.m_ftpList.size(); ++i) {
            this.m_cmbFTPServer.addItem(this.m_ftpList.get(i));
        }
        if (this.m_ftpList.size() > 0) {
            this.m_cmbFTPServer.setSelectedIndex(0);
        }
        serverType = "Http Server";
        sOptions = "<XMLSELECT Search=\"@PRODUCTNAME='" + serverType + "'\"/>";
        lDeployedComp = null;
        this.m_httpList = lDeployedComp = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_store, "", "ServerComponent", 8588, sOptions);
        for (i = 0; i < this.m_httpList.size(); ++i) {
            this.m_cmbHTTPServer.addItem(this.m_httpList.get(i));
        }
        if (this.m_httpList.size() > 0) {
            this.m_cmbHTTPServer.setSelectedIndex(0);
        }
        serverType = HADOOP;
        sOptions = "<XMLSELECT Search=\"@PRODUCTNAME='" + serverType + "'\"/>";
        lDeployedComp = null;
        this.m_hadoopList = lDeployedComp = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_store, "", "ServerComponent", 8588, sOptions);
        for (i = 0; i < this.m_hadoopList.size(); ++i) {
            this.m_cmbHadoopServer.addItem(this.m_hadoopList.get(i));
        }
        if (this.m_hadoopList.size() > 0) {
            this.m_cmbHadoopServer.setSelectedIndex(0);
        }
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        IFileAccessServer server = this.m_mdlTable.getFile().getAccessServer();
        if (server == null) {
            this.m_rbnDefaultFileSystem.setSelected(true);
        } else if (!(this.selectHTTPServer((IServer)server) || this.selectFTPServer((IServer)server) || this.selectHadoopServer((IServer)server))) {
            this.m_rbnDefaultFileSystem.setSelected(true);
        }
        this.setListeningForChanges(true);
    }

    private boolean selectHTTPServer(IServer server) throws RemoteException {
        for (int i = 0; i < this.m_cmbHTTPServer.getItemCount(); ++i) {
            DeployedComponent dc = (DeployedComponent)this.m_cmbHTTPServer.getItemAt(i);
            if (!dc.getFQID().equals(server.getID())) continue;
            this.m_cmbHTTPServer.setSelectedIndex(i);
            this.m_rbnURL.setSelected(true);
            return true;
        }
        return false;
    }

    private boolean selectFTPServer(IServer server) throws RemoteException {
        for (int i = 0; i < this.m_cmbFTPServer.getItemCount(); ++i) {
            DeployedComponent dc = (DeployedComponent)this.m_cmbFTPServer.getItemAt(i);
            if (!dc.getFQID().equals(server.getID())) continue;
            this.m_cmbFTPServer.setSelectedIndex(i);
            this.m_rbnFTP.setSelected(true);
            return true;
        }
        return false;
    }

    private boolean selectHadoopServer(IServer server) throws RemoteException {
        for (int i = 0; i < this.m_cmbHadoopServer.getItemCount(); ++i) {
            DeployedComponent dc = (DeployedComponent)this.m_cmbHadoopServer.getItemAt(i);
            if (!dc.getFQID().equals(server.getID())) continue;
            this.m_cmbHadoopServer.setSelectedIndex(i);
            this.m_rbnHadoop.setSelected(true);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setModelServer(DeployedComponent dc, String sType) {
        try {
            IFileAccessServer server = null;
            if (dc != null) {
                String serverId = ((ServerComponent)dc).getFQID();
                IModel model = this.m_mdlTable.getModel();
                server = (IFileAccessServer)model.getObject(serverId);
                OMRAdapter omr = new OMRAdapter(model, Workspace.getMdFactory(), "load servers");
                try {
                    if (server == null) {
                        server = (IFileAccessServer)omr.acquireObjectUsingTemplate((Root)dc);
                    } else {
                        server.loadFromOMR(omr);
                    }
                }
                finally {
                    omr.dispose();
                }
            }
            this.m_mdlTable.getFile().setAccessServer(server);
            this.setDataChanged(false);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.setDataChanged(false);
    }

    public void saveSettingsAndCleanUp() {
        this.m_mdlTable.getModel().removeModelListener(this.m_lsnrModel);
    }

    public boolean validateData() {
        if (this.m_rbnFTP.isSelected() && this.m_cmbFTPServer.getSelectedIndex() == -1) {
            MessageUtil.displayMessage((String)bundle.getString("AccessMethodTab.Error.FTPServerRequired.txt"), (int)0);
            this.m_cmbFTPServer.requestFocus();
            return false;
        }
        if (this.m_rbnURL.isSelected() && this.m_cmbHTTPServer.getSelectedIndex() == -1) {
            MessageUtil.displayMessage((String)bundle.getString("AccessMethodTab.Error.HTTPServerRequired.txt"), (int)0);
            this.m_cmbHTTPServer.requestFocus();
            return false;
        }
        if (this.m_rbnHadoop.isSelected() && this.m_cmbHadoopServer.getSelectedIndex() == -1) {
            MessageUtil.displayMessage((String)bundle.getString("AccessMethodTab.Error.HadoopServerRequired.txt"), (int)0);
            this.m_cmbHadoopServer.requestFocus();
            return false;
        }
        return true;
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_rbnDefaultFileSystem.setEnabled(bEditable);
        this.m_rbnNamedPipe.setEnabled(bEditable);
        this.m_rbnFTP.setEnabled(bEditable);
        this.m_rbnURL.setEnabled(bEditable);
        this.m_rbnHadoop.setEnabled(bEditable);
        this.m_rbnNamedPipe.setEnabled(false);
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            try {
                String type = ev.getType();
                if (type.equals("ExternalTable:AccessServerChanged")) {
                    IFileAccessServer server = AccessMethodPanel.this.m_mdlTable.getFile().getAccessServer();
                    if (server == null) {
                        AccessMethodPanel.this.m_rbnDefaultFileSystem.setSelected(true);
                    } else if (!(AccessMethodPanel.this.selectHTTPServer((IServer)server) || AccessMethodPanel.this.selectFTPServer((IServer)server) || AccessMethodPanel.this.selectHadoopServer((IServer)server))) {
                        AccessMethodPanel.this.m_rbnDefaultFileSystem.setSelected(true);
                    }
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    private class cServerListener
    implements ItemListener {
        private cServerListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 2) {
                return;
            }
            WAComboBox cmb = (WAComboBox)e.getItemSelectable();
            if (cmb == AccessMethodPanel.this.m_cmbFTPServer && AccessMethodPanel.this.m_rbnFTP.isSelected()) {
                AccessMethodPanel.this.setModelServer((DeployedComponent)AccessMethodPanel.this.m_cmbFTPServer.getSelectedItem(), AccessMethodPanel.FTP);
            } else if (cmb == AccessMethodPanel.this.m_cmbHTTPServer && AccessMethodPanel.this.m_rbnURL.isSelected()) {
                AccessMethodPanel.this.setModelServer((DeployedComponent)AccessMethodPanel.this.m_cmbHTTPServer.getSelectedItem(), AccessMethodPanel.URL);
            } else if (cmb == AccessMethodPanel.this.m_cmbHadoopServer && AccessMethodPanel.this.m_rbnHadoop.isSelected()) {
                AccessMethodPanel.this.setModelServer((DeployedComponent)AccessMethodPanel.this.m_cmbHadoopServer.getSelectedItem(), AccessMethodPanel.HADOOP);
            }
        }
    }

    private class cItemListener
    implements ItemListener {
        private cItemListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void itemStateChanged(ItemEvent e) {
            JRadioButton rbn = (JRadioButton)e.getItemSelectable();
            boolean bEnabled = rbn.isSelected() && AccessMethodPanel.this.isEditable();
            AccessMethodPanel.this.m_mdlTable.getModel().startCompoundUndoable();
            try {
                if (rbn == AccessMethodPanel.this.m_rbnFTP) {
                    AccessMethodPanel.this.m_lblFTPServer.setEnabled(bEnabled);
                    AccessMethodPanel.this.m_cmbFTPServer.setEnabled(bEnabled);
                    if (bEnabled) {
                        AccessMethodPanel.this.setModelServer((DeployedComponent)AccessMethodPanel.this.m_cmbFTPServer.getSelectedItem(), AccessMethodPanel.FTP);
                    }
                } else if (rbn == AccessMethodPanel.this.m_rbnURL) {
                    AccessMethodPanel.this.m_lblHTTPServer.setEnabled(bEnabled);
                    AccessMethodPanel.this.m_cmbHTTPServer.setEnabled(bEnabled);
                    if (bEnabled) {
                        AccessMethodPanel.this.setModelServer((DeployedComponent)AccessMethodPanel.this.m_cmbHTTPServer.getSelectedItem(), AccessMethodPanel.URL);
                    }
                } else if (rbn == AccessMethodPanel.this.m_rbnHadoop) {
                    AccessMethodPanel.this.m_lblHadoopServer.setEnabled(bEnabled);
                    AccessMethodPanel.this.m_cmbHadoopServer.setEnabled(bEnabled);
                    if (bEnabled) {
                        AccessMethodPanel.this.setModelServer((DeployedComponent)AccessMethodPanel.this.m_cmbHadoopServer.getSelectedItem(), AccessMethodPanel.HADOOP);
                    }
                } else if (bEnabled) {
                    AccessMethodPanel.this.setModelServer(null, AccessMethodPanel.DEFAULT);
                }
            }
            finally {
                AccessMethodPanel.this.m_mdlTable.getModel().endCompoundUndoable();
            }
        }
    }
}

