/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.changeanalysis;

import com.sas.iom.SAS.IBinaryStream;
import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IFileref;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.StreamOpenMode;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.OctetSeqHolder;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.Tree;
import com.sas.wadmin.changeanalysis.BridgeAPIException;
import com.sas.wadmin.changeanalysis.BridgeConversionModel;
import com.sas.wadmin.changeanalysis.CWMConversionException;
import com.sas.workspace.DBMSNamesPropertyHandler;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.visuals.WsAppServerPanel;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.LinkedHashMap;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.omg.CORBA.StringHolder;

public class RecomparisonModel {
    private static WAdminResource bundle = WAdminResource.getBundle(RecomparisonModel.class);
    public static final String CWMFormat = "CWM";
    private Root m_repository;
    private String m_fileName;
    private String m_fileServerFQID;
    private Tree m_group;
    private String m_appServerFQID;
    private Root m_target;
    private SASLibrary m_shareLibrary;
    private String m_bridgeName;
    private BridgeConversionModel m_bridgeConversionModel;
    private LinkedHashMap m_bridgeOptions;
    private String m_localFileName;
    private MdObjectStore m_store;

    public Root getRepository() {
        return this.m_repository;
    }

    public void setRepository(Root repository) {
        this.m_repository = repository;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public void setFileName(String fileName) {
        this.m_fileName = fileName;
    }

    public String getFileServerFQID() {
        return this.m_fileServerFQID;
    }

    public void setFileServerFQID(String fileServerFQID) {
        this.m_fileServerFQID = fileServerFQID;
    }

    public Root getTarget() {
        return this.m_target;
    }

    public void setTarget(Root target) {
        if (!(target instanceof SASLibrary) && !(target instanceof DeployedComponent)) {
            throw new IllegalArgumentException("Expecting SASLibrary or DeployedComponent, got: " + target.getClass().getName());
        }
        this.m_target = target;
    }

    public Tree getGroup() {
        return this.m_group;
    }

    public void setGroup(Tree group) {
        this.m_group = group;
    }

    public String getAppServerFQID() {
        return this.m_appServerFQID;
    }

    public void setAppServerFQID(String appServerFQID) {
        this.m_appServerFQID = appServerFQID;
    }

    public SASLibrary getShareLibrary() {
        return this.m_shareLibrary;
    }

    public void setShareLibrary(SASLibrary shareLibrary) {
        this.m_shareLibrary = shareLibrary;
    }

    public LinkedHashMap getBridgeOptions() {
        return this.m_bridgeOptions;
    }

    public void setBridgeOptions(LinkedHashMap bridgeOptions) {
        this.m_bridgeOptions = bridgeOptions;
    }

    public String getWriteXML() throws CWMConversionException, MdException, RemoteException, BridgeAPIException {
        if (!this.transferRemoteFile()) {
            return null;
        }
        if (this.m_bridgeName != null) {
            if (this.m_bridgeConversionModel == null) {
                this.m_bridgeConversionModel = new BridgeConversionModel(this);
            }
            return this.m_bridgeConversionModel.getWriteXML();
        }
        String schemaResult = this.isSchemaInFile();
        Workspace.getDefaultLogger().debug((Object)schemaResult);
        if (!schemaResult.equals("true")) {
            if (schemaResult.equals("false")) {
                throw new CWMConversionException(bundle.getString("RecomparisonModel.NoSchema.Error.txt"));
            }
            throw new CWMConversionException(schemaResult);
        }
        String inXML = this.convertCWMToOMI(this.getLocalFileName());
        return inXML;
    }

    public Object[] getConvertArgs(String fileName) throws CWMConversionException, MdException, RemoteException {
        MdFactory objFactory = Workspace.getMdFactory();
        this.m_store = objFactory.createObjectStore();
        String reposid = this.m_repository.getFQID();
        String g_specchar = DBMSNamesPropertyHandler.getGlobalSpecCharValue();
        String g_case = DBMSNamesPropertyHandler.getGlobalCaseValue();
        Object[] obj = new Object[]{fileName, this.m_store, reposid, this.m_group, g_specchar, g_case, (SASLibrary)this.m_target};
        return obj;
    }

    public MdObjectStore getStore() {
        return this.m_store;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String convertCWMToOMI(String fileName) throws CWMConversionException, MdException, RemoteException {
        String inXML = "";
        String xslfile = "com/sas/wadmin/changeanalysis/res/cwm_to_oma10.xsl";
        InputStream fileStream = this.getClass().getClassLoader().getResourceAsStream(xslfile);
        try {
            StringWriter outWriter = new StringWriter();
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(new StreamSource(fileStream));
            transformer.setParameter("appid", this.m_appServerFQID);
            transformer.setParameter("apptype", "ServerContext");
            if (this.m_target instanceof DeployedComponent) {
                String classid;
                DeployedComponent server = (DeployedComponent)this.m_target;
                transformer.setParameter("dbid", server.getId());
                AssociationList connections = server.getSourceConnections();
                Connection connection = (Connection)connections.get(0);
                transformer.setParameter("connid", connection.getId());
                if (connection instanceof SASClientConnection) {
                    transformer.setParameter("conntype", "SASClientConnection");
                } else {
                    transformer.setParameter("conntype", "TCPIPConnection");
                }
                String engine = server.getClassIdentifier();
                if (engine.startsWith("DB2")) {
                    engine = "DB2";
                }
                if (!(classid = server.getClassIdentifier()).equalsIgnoreCase("SHARE")) {
                    transformer.setParameter("importType", "DBMS");
                    transformer.setParameter("engine", engine);
                }
            } else if (this.m_target instanceof SASLibrary) {
                transformer.setParameter("engine", "BASE");
                transformer.setParameter("importType", "SAS");
                SASLibrary library = (SASLibrary)this.m_target;
                String saslibid = library.getId();
                String libengine = library.getEngine();
                if (libengine.equalsIgnoreCase("REMOTE")) {
                    AssociationList packages = library.getUsingPackages();
                    if (packages.size() <= 0) throw new CWMConversionException(bundle.getString("RecomparisonModel.InvalidRemoteLibrary.txt"));
                    DeployedDataPackage dpackage = (DeployedDataPackage)packages.get(0);
                    if (dpackage instanceof SASLibrary) {
                        int isDB = ((SASLibrary)dpackage).getIsDBMSLibname();
                        if (isDB == 1) {
                            AssociationList dbpackages = dpackage.getUsingPackages();
                            if (dbpackages.size() > 0) {
                                DeployedDataPackage dbpackage = (DeployedDataPackage)dbpackages.get(0);
                                transformer.setParameter("libid", dbpackage.getId());
                                if (dbpackage instanceof DatabaseSchema) {
                                    transformer.setParameter("schematype", "DatabaseSchema");
                                } else {
                                    transformer.setParameter("schematype", "SASLibrary");
                                }
                            } else {
                                transformer.setParameter("libid", saslibid);
                                transformer.setParameter("schematype", "SASLibrary");
                            }
                        } else {
                            transformer.setParameter("libid", dpackage.getFQID());
                            transformer.setParameter("schematype", "SASLibrary");
                        }
                    }
                } else {
                    transformer.setParameter("libid", saslibid);
                    transformer.setParameter("schematype", "SASLibrary");
                }
            }
            transformer.setParameter("repid", this.m_repository.getFQID());
            if (this.m_group != null) {
                transformer.setParameter("treeid", this.m_group.getFQID());
            } else {
                transformer.setParameter("treeid", "");
            }
            String g_specchar = DBMSNamesPropertyHandler.getGlobalSpecCharValue();
            String g_case = DBMSNamesPropertyHandler.getGlobalCaseValue();
            transformer.setParameter("case", g_case);
            transformer.setParameter("specchar", g_specchar);
            transformer.transform(new StreamSource(fileName), new StreamResult(outWriter));
            inXML = outWriter.toString();
            transformer = null;
            factory = null;
            return inXML;
        }
        catch (TransformerConfigurationException e) {
            throw new CWMConversionException(e.getLocalizedMessage());
        }
        catch (TransformerException e) {
            throw new CWMConversionException(e.getLocalizedMessage());
        }
        finally {
            try {
                fileStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String isSchemaInFile() {
        String inXML;
        String xslfile = "com/sas/wadmin/changeanalysis/res/schema.xsl";
        InputStream fileStream = this.getClass().getClassLoader().getResourceAsStream(xslfile);
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(new StreamSource(fileStream));
            StringWriter outWriter = new StringWriter();
            transformer.transform(new StreamSource(this.m_localFileName), new StreamResult(outWriter));
            inXML = outWriter.toString();
        }
        catch (TransformerException e) {
            String errorMessage = e.getMessage();
            if (errorMessage.indexOf(".dtd\" not found") > 0) {
                String string = bundle.getString("RecomparisonModel.NoDtd.Error.txt");
                return string;
            }
            String string = errorMessage;
            return string;
        }
        finally {
            try {
                if (fileStream != null) {
                    fileStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return inXML;
    }

    public String getBridgeName() {
        return this.m_bridgeName;
    }

    public void setBridgeName(String bridgeName) throws BridgeAPIException {
        this.m_bridgeName = bridgeName;
        if (bridgeName.equalsIgnoreCase(CWMFormat)) {
            return;
        }
        if (this.m_bridgeConversionModel == null) {
            this.m_bridgeConversionModel = new BridgeConversionModel(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transferRemoteFile() {
        if (this.m_fileServerFQID == null || this.m_fileServerFQID.equalsIgnoreCase(WsAppServerPanel.Local)) {
            this.m_localFileName = this.m_fileName;
            return true;
        }
        int suffixPosition = this.m_fileName.lastIndexOf(46);
        String suffix = "";
        if (suffixPosition > 0 && suffixPosition < this.m_fileName.length() - 1) {
            suffix = this.m_fileName.substring(suffixPosition);
        }
        WsAppServer appServer = null;
        try {
            String encoding;
            File localFile = File.createTempFile("MIm", suffix);
            this.m_localFileName = localFile.getAbsolutePath();
            localFile.deleteOnExit();
            appServer = WsAppServer.createAppServer((String)this.m_fileServerFQID);
            if (appServer == null) {
                boolean bl = false;
                return bl;
            }
            if (!appServer.isOpen()) {
                appServer.open();
            }
            String options = !(encoding = "").equals("") ? "encoding=" + encoding : "";
            IWorkspace workspace = appServer.getWorkspace();
            IFileService fileService = workspace.FileService();
            IFileref fileRef = fileService.AssignFileref("TempRef", "DISK", this.m_fileName, options, new StringHolder());
            IBinaryStream binaryStream = fileRef.OpenBinaryStream(StreamOpenMode.StreamOpenModeForReading);
            OctetSeqHolder binaryData = new OctetSeqHolder();
            DataOutputStream out = new DataOutputStream(new FileOutputStream(localFile));
            try {
                binaryStream.Read(1024, binaryData);
                while (binaryData.value.length > 0) {
                    out.write(binaryData.value);
                    binaryStream.Read(1024, binaryData);
                }
            }
            finally {
                out.flush();
                out.close();
                try {
                    binaryStream.Close();
                }
                catch (GenericError genericError) {}
            }
        }
        catch (IOException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            boolean bl = false;
            return bl;
        }
        catch (GenericError e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            boolean bl = false;
            return bl;
        }
        catch (WsAppServerFailException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            boolean bl = false;
            return bl;
        }
        finally {
            if (appServer != null) {
                appServer.dispose();
            }
        }
        return true;
    }

    protected String getLocalFileName() {
        if (this.m_localFileName != null && this.m_localFileName.length() > 0) {
            return this.m_localFileName;
        }
        return this.m_fileName;
    }
}

