/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.changeanalysis;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.changeanalysis.ComparisonResultsException;
import com.sas.wadmin.changeanalysis.DifferencesInterface;
import com.sas.wadmin.model.tree.CustomTreeModel;
import com.sas.wadmin.model.tree.DefaultFolderNode;
import com.sas.wadmin.model.tree.DefaultNodeFactory;
import com.sas.wadmin.model.tree.DefaultRepositoryFolderNode;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceTree;
import com.sas.workspace.WorkspaceTreeModel;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsTreeNode;
import com.sas.workspace.tree.WsNodeFactory;
import com.sas.workspace.tree.WsNodeFilter;
import com.sas.workspace.tree.WsTreeModel;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.help.UnsupportedOperationException;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class DifferencesTreeModel
extends CustomTreeModel {
    private static WAdminResource bundle = WAdminResource.getBundle(DifferencesTreeModel.class);
    public static final int SOURCE = 0;
    public static final int TARGET = 1;
    public static final int BOTH = 2;
    private boolean m_bDifferencesOnly;
    private DifferencesInterface m_mdlDifferences;
    private String[][] m_saObjects;
    private String m_sNewGroupFQID;
    private List m_lNewObjectNodes;

    public DifferencesTreeModel() {
        this.setNodeFilter(this.createDefaultNodeFilter());
    }

    @Override
    public void moveDataToModel() throws MdException, RemoteException {
        ((WsTreeNode)this.getRoot()).expand();
    }

    public void setDifferencesOnly(boolean bDifferencesOnly) {
        this.m_bDifferencesOnly = bDifferencesOnly;
        this.updateChildren((WsTreeNode)this.getRoot());
    }

    public boolean isDifferencesOnly() {
        return this.m_bDifferencesOnly;
    }

    protected DifferencesInterface getDifferencesModel() {
        return this.m_mdlDifferences;
    }

    protected void setDifferencesModel(DifferencesInterface mdlDifferences) throws WsAppServerCodeException, ComparisonResultsException, MdException, RemoteException {
        this.m_mdlDifferences = mdlDifferences;
        this.m_saObjects = mdlDifferences.getComparedObjects();
        this.m_sNewGroupFQID = this.getDifferencesModel().getGroupForNewObjects();
    }

    protected String getGroupForNewObjects() {
        return this.m_sNewGroupFQID;
    }

    private void updateChildren(WsTreeNode node) {
        if (node instanceof HidingParentNode) {
            ((HidingParentNode)node).updateChildren();
        } else {
            node.expand();
            for (int iChild = 0; iChild < node.getChildCount(); ++iChild) {
                this.updateChildren((WsTreeNode)node.getChildAt(iChild));
            }
        }
    }

    public void removeChild(WsTreeNode nodeChild) {
        WsTreeNode nodeParent = (WsTreeNode)nodeChild.getParent();
        if (nodeParent instanceof HidingParentNode && nodeChild instanceof HidableChildNode) {
            nodeParent.removeChild(nodeChild);
        }
        super.removeChild(nodeChild);
    }

    @Override
    protected WsNodeFactory createDefaultNodeFactory() {
        return new cNodeFactory(this);
    }

    protected WsNodeFilter createDefaultNodeFilter() {
        return new cNodeFilter(this);
    }

    private int findComparedObject(String sFQID, String sType) {
        if (this.m_saObjects == null) {
            return -1;
        }
        for (int iObject = 0; iObject < this.m_saObjects.length; ++iObject) {
            if (!sFQID.equals(this.getComparedObjectFQID(iObject)) || !sType.equals(this.getComparedObjectType(iObject))) continue;
            return iObject;
        }
        return -1;
    }

    protected boolean isComparedObject(String sFQID, String sType) {
        return this.findComparedObject(sFQID, sType) != -1;
    }

    protected String getComparedObjectFQID(int iObject) {
        return this.m_saObjects[iObject][0];
    }

    protected String getComparedObjectType(int iObject) {
        return this.m_saObjects[iObject][1];
    }

    protected int getComparedObjectLocation(int iObject) {
        return DifferencesTreeModel.convertLocation(this.m_saObjects[iObject][2]);
    }

    protected List getNewObjectNodes() throws WsAppServerCodeException, ComparisonResultsException, MdException, RemoteException {
        if (this.m_lNewObjectNodes == null) {
            this.m_lNewObjectNodes = new ArrayList();
            for (int iObject = 0; iObject < this.m_saObjects.length; ++iObject) {
                if (!this.m_saObjects[iObject][2].equals("S")) continue;
                String sType = this.m_saObjects[iObject][1];
                String sFQID = this.m_saObjects[iObject][0];
                String[] saNames = this.getDifferencesModel().getAttributeValues(sFQID, sType, "Name");
                if (sType.compareTo("PhysicalTable") == 0) {
                    saNames = this.getDifferencesModel().getAttributeValues(sFQID, sType, "SASTableName");
                }
                String sName = saNames[0].length() != 0 ? saNames[0] : saNames[1];
                CheckableDataNode node = new CheckableDataNode(sName, sFQID, sType);
                node.setLocation(0);
                node.setChanged(this.getDifferencesModel().hasObjectChanged(sFQID, sType));
                this.m_lNewObjectNodes.add(node);
            }
        }
        return this.m_lNewObjectNodes;
    }

    public void addChild(final WsTreeNode nodeNew, final WsTreeNode nodeParent) {
        if (SwingUtilities.isEventDispatchThread()) {
            int iChild;
            int nChildren = nodeParent.getChildCount();
            if (nodeParent.isSorted()) {
                for (iChild = 0; iChild < nChildren; ++iChild) {
                    WsTreeNode nodeChild = (WsTreeNode)nodeParent.getChildAt(iChild);
                    if (this.getComparator().compare(nodeChild, nodeNew) <= 0) {
                        continue;
                    }
                    break;
                }
            } else {
                iChild = nChildren;
            }
            if (nodeNew instanceof cForeignKeyColumnNode) {
                cForeignKeyColumnNode foreignKeyColumnNode = (cForeignKeyColumnNode)nodeNew;
                foreignKeyColumnNode.setTreeModel((WsTreeModel)this, nodeParent);
            } else {
                nodeNew.setTreeModel((WsTreeModel)this);
            }
            this.insertNodeInto((MutableTreeNode)nodeNew, (MutableTreeNode)nodeParent, iChild);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DifferencesTreeModel.this.addChild(nodeNew, nodeParent);
                    }
                });
            }
            catch (InterruptedException ex) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
            }
        }
    }

    protected static int convertLocation(String sWhere) {
        if (sWhere.equals("S")) {
            return 0;
        }
        if (sWhere.equals("T")) {
            return 1;
        }
        return 2;
    }

    protected static String convertLocation(int eLocation) {
        if (eLocation == 0) {
            return "S";
        }
        if (eLocation == 1) {
            return "T";
        }
        return "B";
    }

    protected static class cUniqueKeyAndTableNode
    extends DataNode {
        private String[] m_saUKTableNames;

        public cUniqueKeyAndTableNode(String sName, String sID) {
            super(sName, sID, "UniqueKey");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setTreeModel(WsTreeModel mdlTree) {
            this.m_saUKTableNames = new String[2];
            this.m_saUKTableNames[0] = "";
            this.m_saUKTableNames[1] = "";
            try {
                super.setTreeModel(mdlTree);
                if (mdlTree != null) {
                    String[][] saTables = this.getDifferencesModel().getAssociation(this.getFQID(), this.getType(), "Table");
                    for (int iTable = 0; iTable < saTables.length; ++iTable) {
                        String sUKTableFQID = saTables[iTable][0];
                        String sUKTableTupe = saTables[iTable][1];
                        String sUKTableWhere = saTables[iTable][2];
                        String[] saNames = this.getDifferencesModel().getAttributeValues(sUKTableFQID, sUKTableTupe, "Name");
                        if (!sUKTableWhere.equals("T")) {
                            this.m_saUKTableNames[0] = saNames[0];
                        }
                        if (!sUKTableWhere.equals("S")) {
                            this.m_saUKTableNames[1] = saNames[1];
                        }
                        if (!sUKTableWhere.equals("T")) continue;
                        this.m_saUKTableNames[0] = saNames[1];
                    }
                }
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            catch (WsAppServerCodeException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (ComparisonResultsException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
        }

        @Override
        public String getName(int eLocation) {
            return bundle.formatString("DifferencesTreeModel.UniqueKeyAndTable.Name.fmt.txt", (Object)super.getName(eLocation), (Object)this.m_saUKTableNames[eLocation]);
        }
    }

    protected static class cForeignKeyColumnNode
    extends cColumnNode {
        private String[] m_saUKColumnNames;

        public cForeignKeyColumnNode(String sName, String sID) {
            super(sName, sID);
        }

        public void setTreeModel(WsTreeModel mdlTree, WsTreeNode parentNode) {
            this.m_saUKColumnNames = new String[2];
            this.m_saUKColumnNames[0] = "";
            this.m_saUKColumnNames[1] = "";
            super.setTreeModel(mdlTree);
            try {
                if (mdlTree != null) {
                    DataNode nodeKey = (DataNode)((Object)parentNode.getParent());
                    String[][] saKAs = this.getDifferencesModel().getAssociation(nodeKey.getFQID(), nodeKey.getType(), "KeyAssociations");
                    for (int iKA = 0; iKA < saKAs.length; ++iKA) {
                        String sKAFQID = saKAs[iKA][0];
                        String[][] saFKColumns = this.getDifferencesModel().getAssociation(sKAFQID, "KeyAssociation", "ForeignKeyColumn");
                        if (saFKColumns.length <= 0 || !saFKColumns[0][0].equals(this.getFQID())) continue;
                        String[][] saUKColumns = this.getDifferencesModel().getAssociation(sKAFQID, "KeyAssociation", "UniqueKeyColumn");
                        for (int iUKColumn = 0; iUKColumn < saUKColumns.length; ++iUKColumn) {
                            String sUKColumnFQID = saUKColumns[iUKColumn][0];
                            String sUKColumnWhere = saUKColumns[iUKColumn][2];
                            String[] saUKColumnNames = this.getDifferencesModel().getAttributeValues(sUKColumnFQID, "Column", "Name");
                            if (!sUKColumnWhere.equals("T")) {
                                this.m_saUKColumnNames[0] = saUKColumnNames[0];
                            }
                            if (!sUKColumnWhere.equals("S")) {
                                this.m_saUKColumnNames[1] = saUKColumnNames[1];
                            }
                            if (!sUKColumnWhere.equals("T")) continue;
                            this.m_saUKColumnNames[0] = saUKColumnNames[1];
                        }
                    }
                }
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            catch (WsAppServerCodeException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (ComparisonResultsException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
        }

        @Override
        public String getName(int eLocation) {
            return bundle.formatString("DifferencesTreeModel.ForeignKeyColumn.Name.fmt.txt", (Object)super.getName(eLocation), (Object)this.m_saUKColumnNames[eLocation]);
        }
    }

    protected static class cColumnNode
    extends DataNode {
        private Icon[] m_aIcons = new Icon[2];

        public cColumnNode(String sName, String sID) {
            super(sName, sID, "Column", AppIconFactory.getInstance().getIconForPublicType("Column"));
        }

        @Override
        public void setTreeModel(WsTreeModel mdlTree) {
            try {
                super.setTreeModel(mdlTree);
                if (mdlTree != null) {
                    String[] saColumnTypes = this.getDifferencesModel().getAttributeValues(this.getFQID(), this.getType(), "SASColumnType");
                    if (saColumnTypes[1] != null && saColumnTypes[1].length() != 0) {
                        this.m_aIcons[1] = WsColumnMetadataUtil.getColumnTypeIcon((String)saColumnTypes[1]);
                    }
                    this.m_aIcons[0] = saColumnTypes[0] != null && saColumnTypes[0].length() != 0 ? WsColumnMetadataUtil.getColumnTypeIcon((String)saColumnTypes[0]) : this.m_aIcons[1];
                }
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            catch (WsAppServerCodeException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (ComparisonResultsException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
        }

        @Override
        public Icon getIcon(int eLocation) {
            return this.m_aIcons[eLocation];
        }
    }

    protected static class CheckableDataNode
    extends DataNode
    implements CheckableNode {
        public CheckableDataNode(String sName, String sID, String sType) {
            super(sName, sID, sType);
        }

        @Override
        public boolean isCheckable() {
            return true;
        }

        @Override
        public boolean hasCheckableChildren() {
            return false;
        }
    }

    protected static class DataNode
    extends BaseNode {
        private String m_sFQID;
        private String m_sType;
        private String[] m_saNames;

        public DataNode(String sName, String sFQID, String sType, Icon icon) {
            super(sName);
            this.m_sFQID = sFQID;
            this.m_sType = sType;
            this.setIcon(icon);
            this.setSorted(false);
        }

        public DataNode(String sName, String sFQID, String sType) {
            super(sName);
            this.m_sFQID = sFQID;
            this.m_sType = sType;
            bundle;
            this.setIcon(WAdminResource.getTypeIcon((String)sType, (boolean)true));
            this.setSorted(false);
        }

        public void setTreeModel(WsTreeModel mdl) {
            try {
                super.setTreeModel(mdl);
                if (mdl != null) {
                    this.m_saNames = this.getDifferencesModel().getAttributeValues(this.getFQID(), this.getType(), "Name");
                    if (this.getLocation() == 0) {
                        this.m_saNames[1] = this.m_saNames[0];
                    } else if (this.getLocation() == 1) {
                        this.m_saNames[0] = this.m_saNames[1];
                    }
                    this.m_sName = this.m_saNames[1];
                }
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            catch (WsAppServerCodeException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (ComparisonResultsException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
        }

        public String getFQID() {
            return this.m_sFQID;
        }

        public String getType() {
            return this.m_sType;
        }

        @Override
        public String getName(int eLocation) {
            return this.m_saNames[eLocation];
        }

        DifferencesInterface getDifferencesModel() {
            return ((DifferencesTreeModel)this.getTreeModel()).getDifferencesModel();
        }

        protected cNodeFactory getNodeFactory() {
            return (cNodeFactory)((CustomTreeModel)this.getTreeModel()).getNodeFactory();
        }

        public void addChildren() {
            try {
                String[] saAttrs = this.getDifferencesModel().getAttributes(this.getType());
                for (int iAttr = 0; iAttr < saAttrs.length; ++iAttr) {
                    String sAttr = saAttrs[iAttr];
                    boolean bChanged = this.getDifferencesModel().hasAttributeChanged(this.getFQID(), this.getType(), sAttr);
                    String[] saValues = this.getDifferencesModel().getAttributeValues(this.getFQID(), this.getType(), sAttr);
                    cAttrNode nodeAttr = new cAttrNode(sAttr, saValues);
                    nodeAttr.setChanged(bChanged);
                    nodeAttr.setLocation(this.getLocation());
                    this.addChild(nodeAttr);
                }
                String[] saAssocs = this.getDifferencesModel().getAssociations(this.getType());
                for (int iAssoc = 0; iAssoc < saAssocs.length; ++iAssoc) {
                    String sAssoc = saAssocs[iAssoc];
                    boolean bChanged = this.getDifferencesModel().hasAssociationChanged(this.getFQID(), this.getType(), sAssoc);
                    cAssocNode nodeAssoc = new cAssocNode(sAssoc);
                    nodeAssoc.setChanged(bChanged);
                    nodeAssoc.setLocation(this.getLocation());
                    this.addChild(nodeAssoc);
                    String[][] saObjects = this.getDifferencesModel().getAssociation(this.getFQID(), this.getType(), sAssoc);
                    for (int iObject = 0; iObject < saObjects.length; ++iObject) {
                        String sFQID = saObjects[iObject][0];
                        String sType = saObjects[iObject][1];
                        String sWhere = saObjects[iObject][2];
                        DataNode nodeObject = (DataNode)this.getNodeFactory().createNode(sFQID, sType, nodeAssoc);
                        bChanged = this.getDifferencesModel().hasObjectChanged(sFQID, sType);
                        nodeObject.setLocation(DifferencesTreeModel.convertLocation(sWhere));
                        nodeObject.setChanged(bChanged);
                        nodeAssoc.addChild(nodeObject);
                    }
                }
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            catch (WsAppServerCodeException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (ComparisonResultsException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
        }
    }

    protected static class cAssocNode
    extends BaseNode {
        private static final Icon iconNormal = WorkspaceTree.getClosedFolderIcon();
        private static final Icon iconExpanded = WorkspaceTree.getOpenedFolderIcon();

        public cAssocNode(String sAssoc) {
            super(sAssoc);
            this.setSorted(false);
        }

        public Icon getIcon(boolean bExpanded) {
            return bExpanded ? iconExpanded : iconNormal;
        }
    }

    protected static class cAttrNode
    extends BaseNode {
        private String[] m_saValues;

        public cAttrNode(String sAttr, String[] saValues) {
            super(sAttr);
            this.m_saValues = saValues;
            this.setAllowsChildren(false);
        }

        @Override
        public String getName(int eLocation) {
            String sValue = this.m_saValues[eLocation];
            return bundle.formatString("DifferencesTreeModel.Attribute.Name.fmt.txt", (Object)this.getName(), (Object)sValue);
        }
    }

    protected static class BaseNode
    extends WsTreeNode
    implements HidableChildNode {
        private int m_eLocation;
        private boolean m_bChanged;

        public BaseNode(String sName) {
            super(sName);
        }

        public void setLocation(int eLocation) {
            this.m_eLocation = eLocation;
        }

        public int getLocation() {
            return this.m_eLocation;
        }

        public void setChanged(boolean bChanged) {
            this.m_bChanged = bChanged;
        }

        public boolean hasChanged() {
            return this.m_bChanged;
        }

        @Override
        public boolean isHidden() {
            return ((DifferencesTreeModel)this.getTreeModel()).isDifferencesOnly() && !this.hasChanged();
        }

        public String getName(int eLocation) {
            return this.getName();
        }

        public Icon getIcon(int eLocation) {
            return this.getIcon();
        }
    }

    protected static class cRepositoryNode
    extends DefaultRepositoryFolderNode
    implements CheckableNode,
    HidingParentNode {
        private HiddenChildrenAdapter m_adapter = new HiddenChildrenAdapter((WsTreeNode)this);

        public cRepositoryNode(Root mdoRepository) {
            super(mdoRepository);
        }

        @Override
        public boolean isCheckable() {
            return true;
        }

        @Override
        public boolean hasCheckableChildren() {
            return true;
        }

        public boolean isHidden() {
            this.expand();
            for (int iChild = 0; iChild < this.getChildCount(); ++iChild) {
                if (((HidableChildNode)((Object)this.getChildAt(iChild))).isHidden()) continue;
                return false;
            }
            return true;
        }

        public void addChild(WsTreeNode nodeChild) {
            this.m_adapter.addChild(nodeChild);
        }

        public void removeChild(WsTreeNode nodeChild) {
            this.m_adapter.removeChild(nodeChild);
        }

        @Override
        public void updateChildren() {
            this.m_adapter.updateChildren();
        }
    }

    protected static class cTreeNode
    extends DefaultFolderNode
    implements CheckableNode,
    HidingParentNode,
    HidableChildNode {
        private HiddenChildrenAdapter m_adapter = new HiddenChildrenAdapter((WsTreeNode)this);

        public cTreeNode(FolderInterface lobFolder, Tree mdoTree) {
            super(lobFolder, (Root)mdoTree);
        }

        @Override
        public boolean isCheckable() {
            return true;
        }

        @Override
        public boolean hasCheckableChildren() {
            return true;
        }

        @Override
        public boolean isHidden() {
            this.expand();
            for (int iChild = 0; iChild < this.getChildCount(); ++iChild) {
                if (((HidableChildNode)((Object)this.getChildAt(iChild))).isHidden()) continue;
                return false;
            }
            return true;
        }

        public void addChild(WsTreeNode nodeChild) {
            this.m_adapter.addChild(nodeChild);
        }

        public void removeChild(WsTreeNode nodeChild) {
            this.m_adapter.removeChild(nodeChild);
        }

        @Override
        public void updateChildren() {
            this.m_adapter.updateChildren();
        }

        @Override
        public void addChildren() {
            super.addChildren();
            this.updateChildren();
        }
    }

    protected static class cNewTreeNode
    extends cTreeNode {
        public cNewTreeNode(FolderInterface lobFolder, Tree mdoTree) {
            super(lobFolder, mdoTree);
        }

        @Override
        public void addChildren() {
            try {
                List lNewNodes = ((DifferencesTreeModel)this.getTreeModel()).getNewObjectNodes();
                for (int iNode = 0; iNode < lNewNodes.size(); ++iNode) {
                    this.addChild((WsTreeNode)lNewNodes.get(iNode));
                }
                super.addChildren();
                this.updateChildren();
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            catch (WsAppServerCodeException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (ComparisonResultsException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
        }
    }

    private static class HiddenChildrenAdapter {
        private WorkspaceTreeModel m_mdlTree;
        private WsTreeNode m_nodeParent;
        private List m_lChildren;

        public HiddenChildrenAdapter(WsTreeNode nodeParent) {
            if (!(nodeParent instanceof HidingParentNode)) {
                throw new UnsupportedOperationException("Can not crate a HiddenChildAdapter for a node that is not a HidingParentNode");
            }
            this.m_nodeParent = nodeParent;
            this.m_lChildren = new ArrayList(4);
        }

        public void addChild(WsTreeNode nodeChild) {
            if (this.m_mdlTree == null) {
                this.m_mdlTree = (DifferencesTreeModel)this.m_nodeParent.getTreeModel();
            }
            if (!(nodeChild instanceof HidableChildNode)) {
                throw new UnsupportedOperationException("Can not add a child to HiddenChildAdapter that is not a HidableChildNode");
            }
            this.m_lChildren.add(nodeChild);
            this.m_mdlTree.addChild(nodeChild, this.m_nodeParent);
        }

        public void removeChild(WsTreeNode nodeChild) {
            if (!(nodeChild instanceof HidableChildNode)) {
                throw new UnsupportedOperationException("Can not add a child to HiddenChildAdapter that is not a HidableChildNode");
            }
            this.m_lChildren.remove(nodeChild);
        }

        public void updateChildren() {
            for (int iChild = 0; iChild < this.m_lChildren.size(); ++iChild) {
                WsTreeNode nodeChild = (WsTreeNode)this.m_lChildren.get(iChild);
                if (nodeChild instanceof HidingParentNode) {
                    ((HidingParentNode)nodeChild).updateChildren();
                }
                if (((HidableChildNode)nodeChild).isHidden()) {
                    if (!this.m_nodeParent.isNodeChild((TreeNode)nodeChild)) continue;
                    this.m_mdlTree.removeNodeFromParent((MutableTreeNode)nodeChild);
                    continue;
                }
                if (this.m_nodeParent.isNodeChild((TreeNode)nodeChild)) continue;
                this.addChild(nodeChild, iChild);
            }
        }

        private void addChild(WsTreeNode nodeChild, int iChild) {
            if (this.m_nodeParent.isSorted()) {
                this.m_mdlTree.addChild(nodeChild, this.m_nodeParent);
            } else {
                this.m_mdlTree.insertNodeInto((MutableTreeNode)nodeChild, (MutableTreeNode)this.m_nodeParent, iChild);
            }
        }
    }

    private static class cErrorNode
    extends WsTreeNode
    implements HidableChildNode {
        cErrorNode() {
            super("Error");
        }

        @Override
        public boolean isHidden() {
            return false;
        }
    }

    private static interface HidingParentNode {
        public void updateChildren();
    }

    private static interface HidableChildNode {
        public boolean isHidden();
    }

    protected static interface CheckableNode {
        public boolean isCheckable();

        public boolean hasCheckableChildren();
    }

    protected static class cNodeFactory
    extends DefaultNodeFactory {
        private DifferencesTreeModel m_mdlTree;

        public cNodeFactory(DifferencesTreeModel mdlTree) {
            this.m_mdlTree = mdlTree;
        }

        @Override
        public WsTreeNode createRepositoryFolderNode(Root mdo, WsTreeNode nodeParent) {
            return new cRepositoryNode(mdo);
        }

        @Override
        public WsTreeNode createRootFolderNode(Root mdoRootFolder, WsTreeNode nodeParent) throws MdException, RemoteException {
            return this.createFolderNode(mdoRootFolder, nodeParent);
        }

        @Override
        public WsTreeNode createFolderNode(Root mdoFolder, WsTreeNode nodeParent) throws MdException, RemoteException {
            try {
                FolderInterface lobFolder = (FolderInterface)Factory.getInstance().getObject(mdoFolder);
                if (mdoFolder.getFQID().equals(this.m_mdlTree.getGroupForNewObjects())) {
                    return new cNewTreeNode(lobFolder, (Tree)mdoFolder);
                }
                return new cTreeNode(lobFolder, (Tree)mdoFolder);
            }
            catch (LogicalTypeException ex) {
                throw new MdException(ex.getMessage());
            }
        }

        @Override
        public WsTreeNode createObjectNode(Root mdo, WsTreeNode nodeParent) throws MdException, RemoteException {
            try {
                String sFQID = mdo.getFQID();
                String sType = mdo.getCMetadataType();
                int iObject = this.m_mdlTree.findComparedObject(sFQID, sType);
                if (iObject != -1) {
                    String[] saNames = this.m_mdlTree.getDifferencesModel().getAttributeValues(sFQID, sType, "Name");
                    if (sType.compareTo("PhysicalTable") == 0) {
                        saNames = this.m_mdlTree.getDifferencesModel().getAttributeValues(sFQID, sType, "SASTableName");
                    }
                    String sName = saNames[0].length() != 0 ? saNames[0] : saNames[1];
                    CheckableDataNode node = new CheckableDataNode(sName, sFQID, sType);
                    node.setLocation(this.m_mdlTree.getComparedObjectLocation(iObject));
                    node.setChanged(this.m_mdlTree.getDifferencesModel().hasObjectChanged(sFQID, sType));
                    return node;
                }
            }
            catch (ComparisonResultsException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            catch (WsAppServerCodeException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            return new cErrorNode();
        }

        public WsTreeNode createNode(String sFQID, String sType, WsTreeNode nodeParent) throws MdException, RemoteException, WsAppServerCodeException, ComparisonResultsException {
            DataNode node;
            String[] saNames = this.m_mdlTree.getDifferencesModel().getAttributeValues(sFQID, sType, "Name");
            String sName = saNames[0].length() != 0 ? saNames[0] : saNames[1];
            String sGrandParentType = ((DataNode)((Object)nodeParent.getParent())).getType();
            if (sType.equals("Column")) {
                String sSASColumnName;
                saNames = this.m_mdlTree.getDifferencesModel().getAttributeValues(sFQID, sType, "SASColumnName");
                String string = sSASColumnName = saNames[0].length() != 0 ? saNames[0] : saNames[1];
                if (sGrandParentType.equals("ForeignKey")) {
                    node = new cForeignKeyColumnNode(sSASColumnName, sFQID);
                    node.setAllowsChildren(false);
                } else {
                    node = new cColumnNode(sSASColumnName, sFQID);
                    node.setAllowsChildren(sGrandParentType.equals("PhysicalTable"));
                }
            } else if (sType.equals("Index")) {
                node = new DataNode(sName, sFQID, sType, AppIconFactory.getInstance().getIconForPrivateType("Type:Index"));
            } else if (sType.equals("ForeignKey")) {
                node = new DataNode(sName, sFQID, sType, AppIconFactory.getInstance().getIconForPrivateType("Type:ForeignKey"));
            } else if (sType.equals("UniqueKey")) {
                if (sGrandParentType.equals("PhysicalTable")) {
                    node = new DataNode(sName, sFQID, sType, AppIconFactory.getInstance().getIconForPrivateType("Type:UniqueKey"));
                    node.setAllowsChildren(true);
                } else {
                    node = new cUniqueKeyAndTableNode(sName, sFQID);
                    node.setAllowsChildren(false);
                }
            } else {
                node = new DataNode(sName, sFQID, sType);
            }
            node.setChanged(this.m_mdlTree.getDifferencesModel().hasObjectChanged(sFQID, sType));
            return node;
        }
    }

    protected static class cNodeFilter
    implements WsNodeFilter {
        DifferencesTreeModel m_mdlTree;

        public cNodeFilter(DifferencesTreeModel mdlTree) {
            this.m_mdlTree = mdlTree;
        }

        public boolean accept(Root mdo, WsTreeNode nodeParent) {
            try {
                String sFQID = mdo.getFQID();
                String sType = mdo.getCMetadataType();
                if (sType.equals("Environment") || sType.equals("Root")) {
                    return true;
                }
                if (sType.equals("Tree")) {
                    return this.isGroupShown((Tree)mdo);
                }
                if (this.m_mdlTree.findComparedObject(sFQID, sType) != -1) {
                    return true;
                }
            }
            catch (WsAppServerCodeException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (ComparisonResultsException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            return false;
        }

        protected boolean isGroupShown(Tree mdoTree) throws WsAppServerCodeException, ComparisonResultsException {
            try {
                if (mdoTree.getFQID().equals(this.m_mdlTree.getGroupForNewObjects()) && this.m_mdlTree.getNewObjectNodes().size() > 0) {
                    return true;
                }
                AssociationList lMembers = mdoTree.getMembers();
                for (int iMember = 0; iMember < lMembers.size(); ++iMember) {
                    String sType;
                    Root mdoMember = (Root)lMembers.get(iMember);
                    String sFQID = mdoMember.getFQID();
                    if (this.m_mdlTree.findComparedObject(sFQID, sType = mdoMember.getCMetadataType()) == -1) continue;
                    return true;
                }
                AssociationList lSubTrees = mdoTree.getSubTrees();
                for (int iSubTree = 0; iSubTree < lSubTrees.size(); ++iSubTree) {
                    if (!this.isGroupShown((Tree)lSubTrees.get(iSubTree))) continue;
                    return true;
                }
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            return false;
        }
    }
}

