/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.changeanalysis;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Person;
import com.sas.metadata.remote.ResponsibleParty;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.wadmin.changeanalysis.ComparisonResultsException;
import com.sas.wadmin.changeanalysis.ComparisonResultsModel;
import com.sas.wadmin.changeanalysis.ComparisonResultsOptionsPanel;
import com.sas.wadmin.changeanalysis.DifferencesView;
import com.sas.wadmin.visuals.SASLibraryTreeNode;
import com.sas.wadmin.visuals.SASLibraryView;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceTreeModel;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsDataTreeNode;
import com.sas.workspace.WsOMAView;
import com.sas.workspace.WsTreeNode;
import com.sas.workspace.WsViewFactory;
import com.sas.workspace.tree.WsTreeModel;
import com.sas.workspace.visuals.ResponsiblePartyTableModel;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreeNode;

public class ComparisonResultsTreeModel
extends WorkspaceTreeModel {
    private static WAdminResource bundle = WAdminResource.getBundle(ComparisonResultsTreeModel.class);

    public ComparisonResultsTreeModel() {
        super(new WsTreeNode("dummy"));
        this.setName("ComparisonResultsTreeModel");
    }

    public void initialize() {
        WsTreeNode nodeRoot = this.createDefaultRootNode();
        nodeRoot.setAllowsChildren(true);
        this.setRoot(nodeRoot);
    }

    public void setRoot(WsTreeNode node) {
        node.setTreeModel((WsTreeModel)this);
        super.setRoot((TreeNode)node);
    }

    protected WsTreeNode createDefaultRootNode() {
        return new DefaultRootNode();
    }

    protected void populateObjects(List lObjects) {
        try {
            for (int iObject = 0; iObject < lObjects.size(); ++iObject) {
                Root mdo = (Root)lObjects.get(iObject);
                if (mdo == null) continue;
                String sType = mdo.getCMetadataType();
                if (sType.equals("Tree")) {
                    ((Tree)mdo).setTreeType(ComparisonResultsTreeModel.getMetadataSimple("Tree", mdo.getFQID(), "TreeType"));
                    continue;
                }
                if (!sType.equals("SASLibrary")) continue;
                ArrayList<String> lAssocs = new ArrayList<String>(1);
                lAssocs.add("Trees");
                String sTemplate = "<Templates><Tree><ParentTree/></Tree></Templates>";
                int fFlags = 268;
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)mdo, null, lAssocs, sTemplate, fFlags);
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    protected void handleObjectsCheckedIn(ArrayList lObjects) {
        try {
            String sProjectRepositoryId = Workspace.getWorkspace().getProjectRepositoryId();
            WsTreeNode nodeRoot = (WsTreeNode)this.getRoot();
            for (int iChild = nodeRoot.getChildCount() - 1; iChild >= 0; --iChild) {
                WsTreeNode nodeChild = (WsTreeNode)nodeRoot.getChildAt(iChild);
                String sFQID = nodeChild.getFQID();
                if (sFQID == null || !sFQID.subSequence(0, 8).equals(sProjectRepositoryId)) continue;
                this.removeChild(nodeChild);
            }
            super.handleObjectsCheckedIn(lObjects);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    private static Date createDate(String sSecondsSince1Jan1960) {
        return ComparisonResultsTreeModel.createDate(Double.parseDouble(sSecondsSince1Jan1960));
    }

    private static Date createDate(double secondsSince1Jan1960) {
        double secondsSince1Jan1970 = secondsSince1Jan1960 - 3.156192E8;
        long millisecondsSince1Jan1970 = (long)(secondsSince1Jan1970 * 1000.0);
        return new Date(millisecondsSince1Jan1970);
    }

    private static String getMetadataSimple(String sType, String sFQID, String sAttr) throws MdException, RemoteException {
        ArrayList<String> lAttrs = new ArrayList<String>();
        lAttrs.add(sAttr);
        List lValues = Workspace.getMdFactory().getOMIUtil().getMetadataSimple(sType, sFQID, lAttrs);
        return (String)lValues.get(0);
    }

    protected static class RecomparisonRunnable
    implements Runnable {
        private ComparisonResultsModel m_comparisonModel;
        private boolean m_showSASLog;
        private boolean m_wasSuccessful;
        private boolean m_loginCanceled;
        private String m_errorMessage;

        public RecomparisonRunnable(ComparisonResultsModel comparisonModel) {
            this.m_comparisonModel = comparisonModel;
            this.m_showSASLog = false;
            this.m_wasSuccessful = true;
            this.m_loginCanceled = false;
        }

        @Override
        public void run() {
            try {
                this.m_wasSuccessful = this.m_comparisonModel.reCompare();
            }
            catch (ComparisonResultsException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
                this.m_wasSuccessful = false;
                if (e.getExceptionType() == 5 || e.getExceptionType() == 4) {
                    this.m_loginCanceled = true;
                }
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
                this.m_wasSuccessful = false;
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            catch (WsAppServerCodeException e) {
                this.m_errorMessage = e.getLocalizedMessage();
                this.m_showSASLog = true;
            }
        }

        public boolean showSASLogWithErrors() {
            return this.m_showSASLog;
        }

        public boolean wasSuccessful() {
            return this.m_wasSuccessful;
        }

        public boolean loginCanceled() {
            return this.m_loginCanceled;
        }

        public String getErrorMessage() {
            return this.m_errorMessage;
        }
    }

    protected static abstract class BaseNode
    extends WsTreeNode {
        public BaseNode(String sName, Icon icon) {
            super(sName);
            this.setIcon(icon);
        }

        public int getChildCount() {
            if (!this.hasExpanded()) {
                this.setHasExpanded(true);
                this.addChildren();
            }
            return super.getChildCount();
        }

        public abstract void addChildren();
    }

    protected static class LibraryNode
    extends SASLibraryTreeNode {
        private String sResourceKey;

        public LibraryNode(CMetadata mdoLibrary) {
            super(mdoLibrary);
            this.setDeleteable(false);
            this.setPropertiesViewClass(SASLibraryView.class);
        }

        public void setLibraryUse(String sUse) {
            try {
                if (sUse.equals("CompResultLibrary")) {
                    this.sResourceKey = "ComparisonResultsTreeModel.ResultsLibraryNode.fmt.txt";
                } else if (sUse.equals("CompResultTarget")) {
                    this.sResourceKey = "ComparisonResultsTreeModel.TargetLibraryNode.fmt.txt";
                }
                this.setName(this.getMetadata().getName());
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }

        public void setName(String sName) {
            try {
                this.m_sName = bundle.formatString(this.sResourceKey, (Object)this.getMetadata().getName());
                this.getTreeModel().nodeChanged((TreeNode)((Object)this));
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }

        @Override
        public boolean isRenameable() {
            return false;
        }
    }

    protected static class ServerNode
    extends WsTreeNode {
        public ServerNode(String sName) {
            super(sName);
            bundle;
            this.setIcon(WAdminResource.getTypeIcon((String)"ServerComponent", (boolean)true));
            this.setAllowsChildren(false);
        }
    }

    protected static class PartyNode
    extends WsTreeNode {
        public PartyNode(ResponsibleParty mdoParty, Person mdoPerson) {
            super("");
            try {
                this.setName(bundle.formatString("ComparisonResultsTreeModel.PartyNode.fmt", (Object)ResponsiblePartyTableModel.getViewRole((ResponsibleParty)mdoParty), (Object)(mdoPerson != null ? mdoPerson.getName() : bundle.getString("ComparisonResultsTreeModel.Missing.txt"))));
                this.setIcon(bundle.getImageIcon("ComparisonResultsTreeModel.Person.image"));
                this.setAllowsChildren(false);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    protected static class DateNode
    extends WsTreeNode {
        private static DateFormat s_fmtDate = DateFormat.getDateTimeInstance(2, 2);

        public DateNode(String sDescription, Date date) {
            super(sDescription + s_fmtDate.format(date));
            this.setIcon(bundle.getImageIcon("ComparisonResultsTreeModel.TimeStamp.image"));
            this.setAllowsChildren(false);
        }
    }

    protected static class ResultNode
    extends WsDataTreeNode {
        private static WsAbstractAction s_actComparison = new cComparisonAction();
        private static WsAbstractAction s_actViewDifferences = new cViewDifferencesAction();
        private static WsAbstractAction s_actViewActivity = new cViewActivityAction();
        private static WsAbstractAction s_actApply = new cApplyAction();
        private static WsAbstractAction s_actRecompare = new cRecompareAction();
        private static ResultNode s_nodeActive;

        public ResultNode(CMetadata mdoResult) {
            super(mdoResult);
            this.setIcon(bundle.getImageIcon("ComparisonResultsTreeModel.Tree.image"));
            this.setSorted(false);
        }

        public JPopupMenu getPopupMenu(WAdminResource aBundle) {
            JPopupMenu mnuPopup = super.getPopupMenu(aBundle);
            mnuPopup.addSeparator();
            mnuPopup.add((Action)s_actViewDifferences);
            mnuPopup.add((Action)s_actViewActivity);
            mnuPopup.add((Action)s_actApply);
            mnuPopup.add((Action)s_actRecompare);
            return mnuPopup;
        }

        public WsOMAView onProperties() {
            try {
                MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "ComparisonResultsTreeModel.Properties");
                Tree mdoTree = (Tree)Workspace.getMdFactory().createComplexMetadataObject(store, this.getMetadata());
                ComparisonResultsModel mdl = new ComparisonResultsModel(mdoTree);
                ComparisonResultsOptionsPanel pnlOptions = new ComparisonResultsOptionsPanel(mdl, false);
                WAPropertyDialog dlg = new WAPropertyDialog((Frame)Workspace.getWorkspace(), bundle.getString("ComparisonResultsTreeModel.OptionDialog.title.txt"), true);
                dlg.setMainPanel((WAPanel)pnlOptions);
                dlg.setMetadataObject((CMetadata)mdoTree);
                dlg.show();
                return null;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void delete() {
            try {
                MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "ComparisonResultsTreeModel.Delete");
                Tree mdoTree = (Tree)Workspace.getMdFactory().createComplexMetadataObject(store, this.getMetadata());
                ComparisonResultsModel mdl = new ComparisonResultsModel(mdoTree);
                try {
                    mdl.populateStore();
                    mdl.moveDataToModel();
                    mdl.delete();
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                }
                catch (ComparisonResultsException e) {
                    if (e.getExceptionType() != 2) {
                        MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
                    } else {
                        int choice = MessageUtil.displayMessage((String)bundle.formatString("ComparisonResultsTreeModel.DeleteError.txt", (Object)e.getLocalizedMessage()), (int)0, (int)0);
                        if (choice == 0) {
                            try {
                                mdl.deleteComparisonResultTreeObjects();
                            }
                            catch (MdException ex) {
                                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                            }
                            catch (RemoteException re) {
                                Workspace.handleRemoteException((RemoteException)re);
                            }
                        }
                    }
                }
                catch (WsAppServerCodeException e) {
                    mdl.showSASLogDialog(e.getLocalizedMessage(), 0);
                }
                finally {
                    mdl.dispose();
                    store.dispose();
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChildren() {
            try {
                this.setHasExpanded(true);
                MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "ComparisonResultsTreeModel:ResultNode.createChild");
                try {
                    Tree mdoResult = (Tree)Workspace.getMdFactory().createComplexMetadataObject(store, this.getMetadata());
                    StringBuffer sbTemplate = new StringBuffer();
                    sbTemplate.append("<Templates>");
                    sbTemplate.append("<Tree><TimeStamps/><Members/><SubTrees/><ResponsibleParties/></Tree>");
                    sbTemplate.append("<ResponsibleParty><Persons/></ResponsibleParty>");
                    sbTemplate.append("</Templates>");
                    int fFlags = 67109132;
                    Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)mdoResult, null, null, sbTemplate.toString(), fFlags);
                    DateNode nodeDate = new DateNode(bundle.getString("ComparisonResultsTreeModel.CreatedDateNode.txt"), ComparisonResultsTreeModel.createDate(mdoResult.getMetadataCreated()));
                    this.addChild(nodeDate);
                    AssociationList lParties = mdoResult.getResponsibleParties();
                    for (int iParty = 0; iParty < lParties.size(); ++iParty) {
                        ResponsibleParty mdoParty = (ResponsibleParty)lParties.get(iParty);
                        String role = mdoParty.getRole();
                        if (role == null || !role.equals("OWNER")) continue;
                        AssociationList lPersons = mdoParty.getPersons();
                        Person mdoPerson = lPersons.isEmpty() ? null : (Person)lPersons.get(0);
                        this.addChild(new PartyNode(mdoParty, mdoPerson));
                    }
                    AssociationList lSubTrees = mdoResult.getSubTrees();
                    for (int iSubTree = 0; iSubTree < lSubTrees.size(); ++iSubTree) {
                        Tree mdoTree = (Tree)lSubTrees.get(iSubTree);
                        String sTreeType = mdoTree.getTreeType();
                        AssociationList lMembers = mdoTree.getMembers();
                        for (int iMember = 0; iMember < lMembers.size(); ++iMember) {
                            Root mdoMember = (Root)lMembers.get(iMember);
                            String sMemberType = mdoMember.getCMetadataType();
                            if (sMemberType.equals("SASLibrary")) {
                                LibraryNode nodeLibrary = (LibraryNode)this.createChild(Workspace.getMdFactory().createSimpleMetadataObject((CMetadata)mdoMember));
                                this.addChild((WsTreeNode)nodeLibrary);
                                nodeLibrary.setLibraryUse(sTreeType);
                                nodeLibrary.setLogicalObject(Factory.getInstance().getObject(mdoMember));
                                continue;
                            }
                            if (!sMemberType.equals("ServerComponent")) continue;
                            this.addChild(this.createChild((CMetadata)mdoMember));
                        }
                    }
                }
                catch (LogicalTypeException ex) {
                    MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
                }
                finally {
                    store.dispose();
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }

        public WsTreeNode createChild(CMetadata mdo) {
            try {
                String sType = mdo.getCMetadataType();
                if (sType.equals("SASLibrary")) {
                    LibraryNode nodeLibrary = new LibraryNode(mdo);
                    nodeLibrary.setAllowsChildren(false);
                    return nodeLibrary;
                }
                if (sType.equals("ServerComponent")) {
                    ServerNode nodeServer = new ServerNode(mdo.getName());
                    return nodeServer;
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            return null;
        }

        public boolean isValidParentFor(CMetadata mdo) {
            block5: {
                try {
                    String sType = mdo.getCMetadataType();
                    if (!sType.equals("SASLibrary")) break block5;
                    try {
                        AssociationList lTrees = ((SASLibrary)mdo).getTrees();
                        for (int iTree = 0; iTree < lTrees.size(); ++iTree) {
                            Tree mdoParent = ((Tree)lTrees.get(iTree)).getParentTree();
                            if (mdoParent == null || !mdoParent.getFQID().equals(this.getFQID())) continue;
                            return true;
                        }
                    }
                    catch (MdException ex) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
                    }
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException((RemoteException)ex);
                }
            }
            return false;
        }

        public void updateWorkspaceUIComponents(boolean bActive) {
            s_actComparison.setActive(bActive);
            s_actViewDifferences.setActive(bActive);
            s_actViewActivity.setActive(bActive);
            s_actApply.setActive(bActive);
            s_actRecompare.setActive(bActive);
            this.m_actProperties.setActive(bActive);
            s_nodeActive = bActive ? this : null;
        }

        public void doDefaultAction() {
            WsViewFactory.showView((CMetadata)this.getMetadata(), DifferencesView.class);
        }

        protected static class cRecompareAction
        extends WsAbstractAction {
            public cRecompareAction() {
                super(bundle, "ComparisonResultsTreeModel.Action.Recompare", 2);
                this.setMenuSupportId("comprecompare");
                this.setHidable(true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent ev) {
                try {
                    MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "ComparisonResultsTreeModel.Recompare");
                    Tree mdoTree = (Tree)Workspace.getMdFactory().createComplexMetadataObject(store, s_nodeActive.getMetadata());
                    ComparisonResultsModel mdl = new ComparisonResultsModel(mdoTree);
                    try {
                        mdl.populateStore();
                        mdl.moveDataToModel();
                        OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace(), bundle.getString("ComparisonResultsTreeModel.Recomparison.ProgressIndicator.Message.txt"), bundle.getString("ComparisonResultsTreeModel.Recomparison.ProgressIndicator.Title.txt"));
                        request.setDelayBeforeProgressCancelDialog(500);
                        request.setProgressShownOnStatusBar(false);
                        RecomparisonRunnable recomparisonRunnable = new RecomparisonRunnable(mdl);
                        request.execute((Runnable)recomparisonRunnable);
                        if (!recomparisonRunnable.loginCanceled()) {
                            if (recomparisonRunnable.showSASLogWithErrors()) {
                                mdl.showSASLogDialog(recomparisonRunnable.getErrorMessage(), 0);
                            } else if (recomparisonRunnable.wasSuccessful()) {
                                mdl.showSASLogDialog();
                            }
                        }
                    }
                    catch (ComparisonResultsException e) {
                        MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
                    }
                    catch (MdException e) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
                    }
                    finally {
                        mdl.dispose();
                        store.dispose();
                    }
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException((RemoteException)ex);
                }
            }
        }

        protected static class cApplyAction
        extends WsAbstractAction {
            public cApplyAction() {
                super(bundle, "ComparisonResultsTreeModel.Action.Apply", 2);
                this.setMenuSupportId("compapplychanges");
                this.setHidable(true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent ev) {
                try {
                    MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "ComparisonResultsTreeModel.Apply");
                    Tree mdoTree = (Tree)Workspace.getMdFactory().createComplexMetadataObject(store, s_nodeActive.getMetadata());
                    ComparisonResultsModel mdl = new ComparisonResultsModel(mdoTree);
                    try {
                        mdl.populateStore();
                        mdl.moveDataToModel();
                        mdl.apply();
                    }
                    catch (MdException ex) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                    }
                    catch (ComparisonResultsException e) {
                        MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
                    }
                    catch (WsAppServerCodeException e) {
                        mdl.showSASLogDialog(e.getLocalizedMessage(), 0);
                    }
                    catch (ServiceException se) {
                        MessageUtil.displayServiceExceptionMessage((ServiceException)se);
                    }
                    finally {
                        mdl.dispose();
                        store.dispose();
                    }
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException((RemoteException)ex);
                }
            }
        }

        protected static class cViewActivityAction
        extends WsAbstractAction {
            public cViewActivityAction() {
                super(bundle, "ComparisonResultsTreeModel.Action.ViewActivity", 1);
                this.setMenuSupportId("compviewactivity");
                this.setHidable(true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent ev) {
                try {
                    MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "ComparisonResultsTreeModel.ViewActivity");
                    Tree mdoTree = (Tree)Workspace.getMdFactory().createComplexMetadataObject(store, s_nodeActive.getMetadata());
                    ComparisonResultsModel mdl = new ComparisonResultsModel(mdoTree);
                    try {
                        mdl.populateStore();
                        mdl.moveDataToModel();
                        mdl.viewActivityLog();
                    }
                    catch (MdException ex) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
                    }
                    catch (ComparisonResultsException ex) {
                        MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
                    }
                    finally {
                        mdl.dispose();
                        store.dispose();
                    }
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException((RemoteException)ex);
                }
            }
        }

        protected static class cViewDifferencesAction
        extends WsAbstractAction {
            public cViewDifferencesAction() {
                super(bundle, "ComparisonResultsTreeModel.Action.ViewDifferences", 2);
                this.setMenuSupportId("compviewdifferences");
                this.setHidable(true);
            }

            public void actionPerformed(ActionEvent ev) {
                WsViewFactory.showView((CMetadata)s_nodeActive.getMetadata(), DifferencesView.class);
            }
        }

        protected static class cComparisonAction
        extends WsAbstractAction {
            public cComparisonAction() {
                this.setMenuSupportId("comparisonmenu");
                this.setHidable(true);
            }

            public void actionPerformed(ActionEvent ev) {
            }
        }
    }

    protected static class DefaultRootNode
    extends BaseNode {
        public DefaultRootNode() {
            super("", null);
            this.setSorted(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addChildren() {
            try {
                this.setHasExpanded(true);
                MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "ComparisonResultsTreeModel");
                try {
                    String sCheckinRepositoryFQID = Workspace.getWorkspace().getCheckinRepository().getFQID();
                    String sDefaultRepositoryFQID = Workspace.getWorkspace().getDefaultRepository().getFQID();
                    ArrayList<String> lRepositoryFQIDs = new ArrayList<String>(2);
                    lRepositoryFQIDs.add(sCheckinRepositoryFQID);
                    if (!sCheckinRepositoryFQID.equals(sDefaultRepositoryFQID)) {
                        lRepositoryFQIDs.add(sDefaultRepositoryFQID);
                    }
                    StringBuffer sbOptions = new StringBuffer();
                    sbOptions.append("<XMLSELECT Search=\"*[@TreeType='");
                    sbOptions.append("ComparisonResult");
                    sbOptions.append("']\"/>");
                    int fFlags = 67109256;
                    for (int iRepository = 0; iRepository < lRepositoryFQIDs.size(); ++iRepository) {
                        String sRepositoryFQID = (String)lRepositoryFQIDs.get(iRepository);
                        List lResults = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, sRepositoryFQID, "Tree", fFlags, sbOptions.toString());
                        for (int iResult = 0; iResult < lResults.size(); ++iResult) {
                            Tree mdoResult = (Tree)lResults.get(iResult);
                            this.addChild(this.createChild(Workspace.getMdFactory().createSimpleMetadataObject((CMetadata)mdoResult)));
                        }
                    }
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
                }
                finally {
                    store.dispose();
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }

        public WsTreeNode createChild(CMetadata mdo) {
            return new ResultNode(mdo);
        }

        public boolean isValidParentFor(CMetadata mdo) {
            try {
                if (!mdo.getCMetadataType().equals("Tree")) {
                    return false;
                }
                Tree mdoTree = (Tree)mdo;
                return mdoTree.getTreeType().equals("ComparisonResult");
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
                return false;
            }
        }
    }
}

