/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.changeanalysis;

import com.sas.entities.GUID;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectAttribute;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Person;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.ResponsibleParty;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.Tree;
import com.sas.rio.MVAResultSet;
import com.sas.services.ServiceException;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.OMRColumn;
import com.sas.services.information.metadata.OMRPhysicalTable;
import com.sas.visuals.util.XMLUtility;
import com.sas.wadmin.app.ChangeManagementUtil;
import com.sas.wadmin.changeanalysis.BridgeAPIException;
import com.sas.wadmin.changeanalysis.CWMConversionException;
import com.sas.wadmin.changeanalysis.ComparisonResultsCodegen;
import com.sas.wadmin.changeanalysis.ComparisonResultsException;
import com.sas.wadmin.changeanalysis.DifferencesInterface;
import com.sas.wadmin.changeanalysis.RecomparisonModel;
import com.sas.wadmin.changeanalysis.SASOutputDialog;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.ProjectUtil;
import com.sas.workspace.PropertyHandler;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsAppServerLibraryException;
import com.sas.workspace.changemanagement.CMListenerManager;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleObjectImpl;
import com.sas.workspace.visuals.MetadataMIMBCheckBoxDialog;
import com.sas.workspace.visuals.SASLogDialog;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.rmi.RemoteException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;

public class ComparisonResultsModel
implements DifferencesInterface {
    private static WAdminResource bundle = WAdminResource.getBundle(ComparisonResultsModel.class);
    private Tree m_oTree;
    private MdObjectStore m_store;
    private String m_reposId;
    private String m_compareReposId;
    private SASLibrary m_library;
    private String m_libraryPath;
    private File m_oSourceFile;
    private File m_oCustomFile;
    private String m_GUID;
    private String m_personName;
    private ComparisonResultsCodegen m_code;
    private String m_metaUserName;
    private String m_metaPassword;
    private String m_lastUpdated;
    private List m_duplicates = new ArrayList();
    private Root m_targetLocation;
    private Tree m_targetGroup;
    private WsAppServer m_appServer;
    private int m_intIdentifier;
    private String m_sourceOMIXML;
    private String m_sourceOMIXMLFileName;
    private String m_targetOMIXMLFileName;
    private boolean m_bWizard;
    private boolean m_bStorePopulated;
    private boolean m_bSourceMappingFileMoved = false;
    private boolean m_bTargetMappingFileMoved = false;
    private String m_sourceName;
    private String m_sourceExtension;
    private String m_sourcePath;
    private String m_sourceServerContextFQID;
    private String m_customName;
    private String m_customDelimiter;
    private boolean m_bCustomDictionary = false;
    private String m_customOption;
    private String m_autoAddOption;
    private String m_deltasOption;
    private String m_ignoreCaseOption;
    private String m_recompareOverwrite;
    private String m_removeAllOption;
    private String m_removeEntriesOption;
    private String m_etlsVersion;
    private String m_bridgeName;
    private LinkedHashMap m_bridgeOptions;
    private boolean m_bBridge = false;
    private String m_getAttsFQID = "";
    private List m_lAttributes = new ArrayList();
    private List m_lApplyItems;
    private Map m_mapProjectIDs;
    private Map m_mapNewIDs;
    private Map m_mapNewObjects;
    private Map m_mapChangedObjects;
    private List m_lForeignKeysToDelete;
    private boolean m_bFirstPass;
    private StringBuffer m_applyActivityCode;
    public static final String TREETYPE = "ComparisonResult";
    public static final String LIBRARYTREETYPE = "CompResultLibrary";
    public static final String TARGETLOCTREETYPE = "CompResultTarget";
    private static final String CRDUNIQUEIDENTIFIER = "ComparisonResultId";
    private static final String CUSTOMEFFDELIMITER = "CustomDelimiter";
    private static final String OPTIONS = "ComparisonResultOptions";
    private static final String BRIDGENAME = "BridgeName";
    private static final String BRIDGES = "BridgeOptions";
    protected static final String SOURCETOCAMAPFILE = "SourceOMItoCAMap.xml";
    protected static final String TARGETTOCAMAPFILE = "TargetOMItoCAMap.xml";
    protected static final String DBTARGETTOCAMAPFILE = "DBTargetOMItoCAMap.xml";
    protected static final String SOURCEOMIFILENAME = "SourceOMI";
    protected static final String TARGETOMIFILENAME = "TargetOMI";
    protected static final String REQUESTTARGET = "RequestTarget";
    protected static final String SOURCEFILETEXTROLE = "Source";
    protected static final String CUSTOMEFFTEXTROLE = "CustomDictionary";
    protected static final String DELTAONLY = "DeltaOnly";
    protected static final String IGNORECASE = "IgnoreCase";
    protected static final String RECOMPAREOVERWRITE = "RecompareOverwrite";
    protected static final String REMOVEALL = "RemoveAll";
    protected static final String REMOVELOGENTRIES = "RemoveLogEntries";
    protected static final String USECUSTOMDICTIONARY = "UseCustomDictionary";
    protected static final String AUTOADDTOCUSTOMEFF = "AutoAddToCustom";
    private static final String ETLSVERSIONROLE = "ETLSVersion";
    private static final String ETLSVERSION = "3.3";
    protected static final String COMPAREDOBJECTS = "etls_comparedobjects";
    protected static final String ATTRIBUTESDATASET = "etls_atts";
    protected static final String ASSOCIATIONCHANGED = "etls_asnchg";
    protected static final String ASSOCIATIONSDATASET = "etls_assns";
    protected static final String DUPLICATESDATASET = "etls_duplicates";
    protected static final String CHANGEACTIVITY = "Change";
    protected static final String DELETEACTIVITY = "Delete";
    protected static final String NEWACTIVITY = "New";
    protected static final String CREATEDACTIVITY = "Created";
    protected static final String RECOMPAREACTIVITY = "Recompare";
    private static final String APPLIED = "A";
    private static final String REMOVED = "R";
    private boolean m_bDeleteMissingItems;

    public ComparisonResultsModel(Tree oTree) {
        try {
            this.m_oTree = oTree;
            this.m_store = (MdObjectStore)this.m_oTree.getObjectStore();
            this.m_reposId = oTree.getRepositoryID();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public ComparisonResultsModel(boolean isWizard) {
        this.m_bWizard = isWizard;
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        ArrayList<String> complex = new ArrayList<String>();
        complex.add("PropertySets");
        complex.add("SubTrees");
        complex.add("Members");
        StringBuffer template = new StringBuffer();
        template.append("<Templates>").append("<Tree><Members>").append("<File><DeployedComponents/><UsingPackages/></File>").append("</Members>").append("<SubTrees><Tree><Members>").append("<SASLibrary><DeployedComponents/><UsingPackages/></SASLibrary>").append("<ServerComponent/>").append("</Members></Tree></SubTrees>").append("<PropertySets>").append("<PropertySet><SetProperties/></PropertySet>").append("</PropertySets>").append("<ReponsibleParties/></Tree>").append("<ServerComponent><DataPackages/><SourceConnections/></ServerComponent>").append("</Templates>");
        Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((MdStore)this.m_store, "Tree", this.m_oTree.getFQID(), null, complex, template.toString(), 18444);
        this.setStorePopulated(true);
    }

    public void moveDataToModel() throws MdException, RemoteException, ComparisonResultsException {
        AssociationList lDepComps;
        this.m_oSourceFile = this.getFileFromTree(SOURCEFILETEXTROLE);
        if (this.m_oSourceFile == null) {
            return;
        }
        this.m_sourceExtension = this.m_oSourceFile.getFileExtension();
        this.m_sourceName = this.m_oSourceFile.getFileName();
        AssociationList alDirs = this.m_oSourceFile.getUsingPackages();
        if (!alDirs.isEmpty()) {
            this.m_sourcePath = ((Directory)alDirs.get(0)).getDirectoryName();
        }
        if (!(lDepComps = this.m_oSourceFile.getDeployedComponents()).isEmpty()) {
            this.m_sourceServerContextFQID = ((ServerContext)lDepComps.get(0)).getFQID();
        }
        this.m_targetLocation = this.getTargetLocationFromTree();
        this.m_targetGroup = this.getTargetGroupFromTree();
        this.m_oCustomFile = this.getFileFromTree(CUSTOMEFFTEXTROLE);
        if (this.m_oCustomFile != null) {
            this.m_customName = this.m_oCustomFile.getFileName();
            this.m_customDelimiter = this.getCustomExternalFormatFileDelimiter(this.m_oCustomFile);
        }
        this.getGUIDFromTree();
        this.getOptionsFromTree();
        this.getAllBridgeOptionsFromTree();
        this.setRepositoryId(Workspace.getWorkspace().getDefaultRepository().getFQID());
        this.m_library = this.getLibraryFromTree();
        if (this.m_library == null) {
            throw new ComparisonResultsException(bundle.getString("ComparisonResultsModel.NoLibraryFound.error.txt"), 2);
        }
        this.setLibraryPath();
        this.m_code = new ComparisonResultsCodegen(this);
        if (this.m_appServer == null) {
            this.m_appServer = this.findAppServer(this.m_library);
        }
        if (this.m_appServer == null) {
            throw new ComparisonResultsException(bundle.getString("ComparisonResultsModel.NoAppServer.error.txt"), 2);
        }
    }

    public void moveDataToStore(MdObjectStore store, String reposId) throws MdException, RemoteException, ComparisonResultsException {
        this.m_store = store;
        this.setRepositoryId(reposId);
        if (this.m_bWizard) {
            this.m_oTree = this.createMainTree(this.m_sourceName, store, reposId);
            this.addLibraryToTree();
            this.setLibraryPath();
            this.createSourceFileAndAddToTree();
            this.addTargetLocationAndGroupToTree();
            if (this.m_bCustomDictionary) {
                this.createCustomFileAndAddToTree();
            }
            this.addAllOptionsToTree();
            if (this.m_bBridge) {
                this.addAllBridgeOptionsToTree();
            }
            if (this.m_appServer == null) {
                this.m_appServer = this.findAppServer(this.m_library);
                if (this.m_appServer == null) {
                    throw new ComparisonResultsException(bundle.getString("ComparisonResultsModel.NoAppServer.error.txt"), 2);
                }
            }
            this.m_code = new ComparisonResultsCodegen(this);
        }
    }

    @Override
    public void dispose() {
        if (this.m_appServer != null) {
            this.m_appServer.dispose();
        }
    }

    public void setStorePopulated(boolean bStorePopulated) {
        this.m_bStorePopulated = bStorePopulated;
    }

    public boolean isStorePopulated() {
        return this.m_bStorePopulated;
    }

    public boolean isWizard() {
        return this.m_bWizard;
    }

    public Tree getTree() {
        return this.m_oTree;
    }

    public void setLibrary(SASLibrary library) {
        this.m_library = library;
    }

    public SASLibrary getLibrary() {
        return this.m_library;
    }

    protected String getLibraryReference() {
        try {
            if (this.m_library == null) {
                return "";
            }
            return this.m_library.getLibref();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return "";
        }
    }

    public Root getSASLibraryForNewTable(String table_ID) throws ComparisonResultsException, MdException, RemoteException, WsAppServerCodeException {
        Root object = null;
        StringBuffer code = new StringBuffer();
        code.append("Select SASLibrary_ID from &sourceTables");
        code.append(" where table_id='");
        code.append(table_ID.trim());
        code.append("'");
        code.append("\n");
        List tables = this.getSASDatasetFromSelectStatement(code.toString());
        String strFQID = (String)((List)tables.get(0)).get(0);
        if (strFQID.length() > 0) {
            object = !this.isSASLibraryTargetLocation() ? (Root)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, null, "", "ServerComponent", strFQID) : (Root)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, null, "", "SASLibrary", strFQID);
        }
        return object;
    }

    protected String getLibraryPath() {
        return this.m_libraryPath;
    }

    public WsAppServer getAppServer() {
        return this.m_appServer;
    }

    public void setAppServer(WsAppServer appServer) {
        this.m_appServer = appServer;
    }

    protected String getMetadataUserName() {
        return this.m_metaUserName;
    }

    protected String getMetadataPassword() {
        return this.m_metaPassword;
    }

    public String getRepositoryId() {
        return this.m_reposId;
    }

    public String getComparisonRepositoryId() {
        return this.m_compareReposId;
    }

    public void setRepositoryId(String reposId) {
        try {
            this.m_reposId = reposId.length() > 0 ? reposId : this.m_oTree.getRepositoryID();
            CMetadata projRep = Workspace.getWorkspace().getProjectRepository();
            if (projRep != null) {
                if (this.m_reposId.equalsIgnoreCase(projRep.getFQID())) {
                    this.m_compareReposId = Workspace.getWorkspace().getCheckinRepository().getFQID();
                }
            } else {
                this.m_compareReposId = this.m_reposId;
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public File getSourceFile() {
        return this.m_oSourceFile;
    }

    public void setSourceFile(String fullFileName, String serverContextFQID) {
        this.m_sourceServerContextFQID = serverContextFQID;
        int loc = fullFileName.lastIndexOf(".");
        this.m_sourceExtension = fullFileName.substring(loc + 1);
        int loc2 = fullFileName.lastIndexOf("\\");
        if (loc2 < 0) {
            loc2 = fullFileName.lastIndexOf("/");
        }
        this.m_sourceName = fullFileName.substring(loc2 + 1);
        this.m_sourcePath = fullFileName.substring(0, loc2 + 1);
    }

    public Root getTargetLocation() {
        return this.m_targetLocation;
    }

    public boolean isSASLibraryTargetLocation() {
        try {
            return this.m_targetLocation.getCMetadataType().equalsIgnoreCase("SASLibrary");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    protected List getDatabaseSchemaObjects() throws ComparisonResultsException, MdException, RemoteException, WsAppServerCodeException {
        AssociationList tgtSchemaObjects;
        StringBuffer code = new StringBuffer();
        code.append("select unique schemaname from ").append(this.getLibraryReference()).append(".&ETLS&src&schema&etls_tblid");
        ArrayList<DatabaseSchema> matchedobjects = new ArrayList<DatabaseSchema>();
        ArrayList<String> srcSchemaNames = new ArrayList<String>();
        try {
            this.assignLibrary();
            MVAResultSet rsltSet = this.m_appServer.submitSQLStatement(code.toString());
            if (rsltSet != null) {
                while (rsltSet.next()) {
                    srcSchemaNames.add(rsltSet.getString(1).trim());
                }
                rsltSet.close();
            }
        }
        catch (SQLException e) {
            throw new ComparisonResultsException(e.getLocalizedMessage());
        }
        catch (WsAppServerFailException e) {
            throw new ComparisonResultsException(e.getLocalizedMessage());
        }
        if (this.isWizard()) {
            StringBuffer template = new StringBuffer();
            template.append("<Templates>").append("<ServerComponent><DataPackages/><SourceConnections/></ServerComponent>").append("</Templates>");
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((MdStore)this.m_store, "ServerComponent", this.m_targetLocation.getFQID(), null, null, template.toString(), 18444);
        }
        if ((tgtSchemaObjects = ((ServerComponent)this.m_targetLocation).getDataPackages()).isEmpty() && !this.isSASLibraryTargetLocation()) {
            throw new ComparisonResultsException(bundle.getString("ComparisonResultsModel.MissingSchemaInSource.txt"));
        }
        for (int i = 0; i < srcSchemaNames.size(); ++i) {
            String schemaName = (String)srcSchemaNames.get(i);
            boolean isFound = false;
            for (int j = 0; j < tgtSchemaObjects.size(); ++j) {
                DatabaseSchema oSchema = (DatabaseSchema)tgtSchemaObjects.get(j);
                if (!schemaName.equals(oSchema.getSchemaName())) continue;
                isFound = true;
                matchedobjects.add(oSchema);
                break;
            }
            if (isFound) continue;
            throw new ComparisonResultsException(bundle.getString("ComparisonResultsModel.DBMSSchemaNoFound.txt"));
        }
        return matchedobjects;
    }

    public void setTargetLocation(Root object) {
        this.m_targetLocation = object;
    }

    public Tree getTargetGroup() {
        return this.m_targetGroup;
    }

    public void setTargetGroup(Tree group) {
        this.m_targetGroup = group;
    }

    public void setTargetLocationAndGroup(Root object, Tree group) {
        this.m_targetLocation = object;
        this.m_targetGroup = group;
    }

    public int getComparisonIdentifier() throws WsAppServerCodeException, MdException, RemoteException, ComparisonResultsException {
        try {
            String code = this.m_code.getIdentifierSelectCode();
            this.assignLibrary();
            MVAResultSet rsltSet = this.m_appServer.submitSQLStatement(code);
            if (rsltSet != null) {
                while (rsltSet.next()) {
                    this.m_intIdentifier = rsltSet.getInt(1);
                }
                rsltSet.close();
            }
        }
        catch (WsAppServerFailException me) {
            throw new ComparisonResultsException(me.getLocalizedMessage());
        }
        catch (SQLException e) {
            throw new ComparisonResultsException(e.getLocalizedMessage());
        }
        return this.m_intIdentifier;
    }

    public void setComparisonIdentifier(int identifier) {
        this.m_intIdentifier = identifier;
    }

    @Override
    public String getLastComparisonUpdatedDate() throws ComparisonResultsException, MdException, RemoteException, WsAppServerCodeException {
        if (this.m_appServer == null) {
            return "";
        }
        try {
            if (this.m_lastUpdated == null) {
                String code = this.m_code.getLastUpdatedDateCode();
                this.assignLibrary();
                MVAResultSet rsltSet = this.m_appServer.submitSQLStatement(code);
                if (rsltSet != null) {
                    while (rsltSet.next()) {
                        this.m_lastUpdated = rsltSet.getString(1);
                    }
                    rsltSet.close();
                }
            }
        }
        catch (WsAppServerFailException e) {
            throw new ComparisonResultsException(e.getLocalizedMessage());
        }
        catch (SQLException e) {
            throw new ComparisonResultsException(e.getLocalizedMessage());
        }
        return this.m_lastUpdated;
    }

    public File getCustomFile() {
        return this.m_oCustomFile;
    }

    public String getCustomExternalFormatFileName() {
        return this.m_customName;
    }

    public String getCustomExternalFormatFileDelimiter() {
        return this.m_customDelimiter;
    }

    public void setCustomExternalFormatFile(String fullFileName, String delimiter) {
        this.m_bCustomDictionary = true;
        this.m_customName = fullFileName;
        this.m_customDelimiter = delimiter;
    }

    protected void setCustomExternalFormatFileDelimiter(File file, String delimiter) throws MdException, RemoteException {
        PropertyHandler props = new PropertyHandler((Root)file, CUSTOMEFFDELIMITER, true);
        props.setSpecificProperty(CUSTOMEFFDELIMITER, delimiter);
    }

    public boolean useCustomDictionary() {
        return this.m_bCustomDictionary;
    }

    public void setOption(String type, String value) {
        if (type.equalsIgnoreCase(DELTAONLY)) {
            this.m_deltasOption = value;
        } else if (type.equalsIgnoreCase(IGNORECASE)) {
            this.m_ignoreCaseOption = value;
        } else if (type.equalsIgnoreCase(RECOMPAREOVERWRITE)) {
            this.m_recompareOverwrite = value;
        } else if (type.equalsIgnoreCase(USECUSTOMDICTIONARY)) {
            this.m_customOption = value;
        } else if (type.equalsIgnoreCase(AUTOADDTOCUSTOMEFF)) {
            this.m_autoAddOption = value;
        }
    }

    public String getETLSVersion() {
        return this.m_etlsVersion;
    }

    public boolean isDeltaOnly() {
        if (this.m_deltasOption == null) {
            return true;
        }
        return this.m_deltasOption.equalsIgnoreCase("YES");
    }

    public boolean isIgnoreCaseSensitive() {
        if (this.m_ignoreCaseOption == null) {
            return true;
        }
        return this.m_ignoreCaseOption.equalsIgnoreCase("YES");
    }

    public boolean isRecompareOverwriteData() {
        if (this.m_recompareOverwrite == null) {
            return false;
        }
        return this.m_recompareOverwrite.equalsIgnoreCase("YES");
    }

    public boolean isRemoveAllObjectsFromComparisonResultData() {
        if (this.m_removeAllOption == null) {
            return false;
        }
        return this.m_removeAllOption.equalsIgnoreCase("YES");
    }

    public boolean isRemoveAllLogEntries() {
        if (this.m_removeEntriesOption == null) {
            return false;
        }
        return this.m_removeEntriesOption.equalsIgnoreCase("YES");
    }

    public boolean isAutoAddToCustom() {
        return this.m_autoAddOption.equalsIgnoreCase("YES");
    }

    public String getBridgeName() {
        return this.m_bridgeName;
    }

    public void setBridgeName(String bridge) {
        this.m_bridgeName = bridge;
    }

    public LinkedHashMap getBridgeOptions() {
        return this.m_bridgeOptions;
    }

    public void setBridgeOptions(LinkedHashMap bridgeOptions) {
        this.m_bridgeOptions = bridgeOptions;
    }

    public void setIsBridge(boolean isBridges) {
        this.m_bBridge = isBridges;
    }

    public boolean isBridge() {
        return this.m_bBridge;
    }

    public String getGUID() {
        return this.m_GUID;
    }

    public boolean hasSourceXSLMappingBeenMoved() {
        return this.m_bSourceMappingFileMoved;
    }

    public boolean hasTargetXSLMappingBeenMoved() {
        return this.m_bTargetMappingFileMoved;
    }

    protected void setSourceOMIXMLFileName(String filename) {
        this.m_sourceOMIXMLFileName = filename;
    }

    protected String getSourceOMIXMLFileName() {
        return this.m_sourceOMIXMLFileName;
    }

    protected void setTargetOMIXMLFileName(String filename) {
        this.m_targetOMIXMLFileName = filename;
    }

    protected String getTargetOMIXMLFileName() {
        return this.m_targetOMIXMLFileName;
    }

    protected String getXMLFilename(String name) throws WsAppServerCodeException, MdException, RemoteException, ComparisonResultsException {
        int newNum = this.getComparisonIdentifier();
        StringBuffer sbValue = new StringBuffer(name);
        sbValue.append(Integer.toString(newNum));
        sbValue.append(".xml");
        return sbValue.toString();
    }

    public void setSourceOMIXMLString(String omiXML) {
        this.m_sourceOMIXML = omiXML;
    }

    public String getSourceOMIXMLString() {
        return this.m_sourceOMIXML;
    }

    @Override
    public MdObjectStore getStore() {
        return this.m_store;
    }

    @Override
    public String getGroupForNewObjects() {
        try {
            if (this.m_targetGroup != null) {
                return this.m_targetGroup.getFQID();
            }
            return "";
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return "";
        }
    }

    public void setComparisonJob(String name, Tree group) throws MdException, RemoteException {
    }

    @Override
    public String[][] getComparedObjects() throws ComparisonResultsException, MdException, RemoteException, WsAppServerCodeException {
        List tables = new ArrayList();
        String[][] objects = null;
        try {
            this.assignLibrary();
            if (this.m_code == null) {
                return null;
            }
            String macroCode = this.m_code.getDiffViewerSASMacros();
            this.m_appServer.submitSASCode(macroCode);
            if (this.hasDuplicates()) {
                throw new ComparisonResultsException(bundle.getString("ComparisonResultsModel.Duplicates.error.txt"), 3);
            }
            StringBuffer code = new StringBuffer();
            code.append("Select * from &modlAllObjects").append(" where (metadataType = '").append("PhysicalTable").append("'   ").append(" and state ne '").append(APPLIED).append("' ");
            if (this.isDeltaOnly()) {
                code.append(" and code <> 'T'  ");
            }
            code.append(")\n");
            tables = this.getSASDatasetFromSelectStatement(code.toString());
            int size = tables.size();
            objects = new String[size][4];
            for (int i = 0; i < size; ++i) {
                ArrayList row = (ArrayList)tables.get(i);
                objects[i][0] = (String)row.get(2);
                objects[i][1] = (String)row.get(1);
                objects[i][2] = (String)row.get(0);
                objects[i][3] = (String)row.get(3);
            }
        }
        catch (WsAppServerFailException wsfe) {
            throw new ComparisonResultsException(wsfe.getLocalizedMessage());
        }
        return objects;
    }

    public boolean hasDuplicates() throws ComparisonResultsException, MdException, RemoteException, WsAppServerCodeException {
        String[][] dups = this.getDuplicateObjects();
        for (int i = 0; i < dups.length; ++i) {
            StringBuffer sbDupObject = new StringBuffer(dups[i][1]);
            sbDupObject.append(" (").append(dups[i][0]).append(")");
            this.m_duplicates.add(sbDupObject.toString());
        }
        return dups.length > 0;
    }

    public List getDuplicateMessageList() {
        return this.m_duplicates;
    }

    public String[][] getDuplicateObjects() throws ComparisonResultsException, MdException, RemoteException, WsAppServerCodeException {
        String libRef = this.getLibraryReference();
        List tables = new ArrayList();
        String[][] objects = null;
        try {
            tables = this.getSASDatasetAsList(DUPLICATESDATASET, libRef);
        }
        catch (SQLException se) {
            throw new ComparisonResultsException(se.getLocalizedMessage());
        }
        catch (WsAppServerFailException wsfe) {
            throw new ComparisonResultsException(wsfe.getLocalizedMessage());
        }
        int size = tables.size();
        objects = new String[size][3];
        for (int i = 0; i < size; ++i) {
            ArrayList row = (ArrayList)tables.get(i);
            objects[i][0] = (String)row.get(0);
            objects[i][1] = (String)row.get(1);
            objects[i][2] = (String)row.get(2);
        }
        return objects;
    }

    public void setComparedObjectState(List lObjects, String sState) throws ComparisonResultsException, WsAppServerCodeException {
        StringBuffer code = new StringBuffer();
        code.append("data etls_objState;\n");
        code.append("   length id $17.;\n");
        code.append("   length newstate $1.;\n");
        code.append("   input id $ newstate $;\n");
        code.append("   datalines;\n");
        for (int iObject = 0; iObject < lObjects.size(); ++iObject) {
            code.append((String)lObjects.get(iObject));
            code.append(" ");
            code.append(sState);
            code.append("\n");
        }
        code.append(";\n");
        code.append("run;\n");
        code.append("data &modlAllObjects;\n");
        code.append("   set etls_objState;  \n");
        code.append("   modify &modlAllObjects key=id;\n");
        code.append("   state=newstate;  \n");
        code.append("   if _iorc_=0 then replace;  \n");
        code.append("run;\n");
        try {
            this.m_appServer.submitSASCode(code.toString());
        }
        catch (WsAppServerFailException e) {
            throw new ComparisonResultsException(e.getLocalizedMessage());
        }
    }

    public String getComparedObjectState(String sFQID) throws ComparisonResultsException, MdException, RemoteException, WsAppServerCodeException {
        StringBuffer code = new StringBuffer();
        code.append("Select state from &modlAllObjects").append(" where (id = '").append(sFQID).append("')\n");
        List tables = this.getSASDatasetFromSelectStatement(code.toString());
        String sState = null;
        if (tables.size() > 0) {
            sState = (String)((ArrayList)tables.get(0)).get(0);
        }
        return sState;
    }

    @Override
    public String[] getAttributes(String sType) {
        if (sType.equals("PhysicalTable")) {
            return new String[]{"Name", "Desc", "SASTableName", "TableName", "DBMSType"};
        }
        if (sType.equals("Column")) {
            return new String[]{"Name", "Desc", "SASColumnName", "SASColumnType", "SASColumnLength", "SASFormat", "SASInformat", "IsNullable"};
        }
        if (sType.equals("Index")) {
            return new String[]{"Name", "Desc", "IndexName", "IsUnique", "IsNoMiss"};
        }
        if (sType.equals("UniqueKey")) {
            return new String[]{"Name", "Desc", "IsPrimary"};
        }
        if (sType.equals("ForeignKey")) {
            return new String[]{"Name", "Desc"};
        }
        if (sType.equals("KeyAssociation")) {
            return new String[]{"Name", "Desc"};
        }
        throw new UnsupportedOperationException("Invalid type (" + sType + ") specified in getAttributes");
    }

    @Override
    public String[] getAssociations(String sType) {
        if (sType.equals("PhysicalTable")) {
            return new String[]{"Columns", "Indexes", "UniqueKeys", "ForeignKeys"};
        }
        if (sType.equals("UniqueKey")) {
            return new String[]{"KeyedColumns"};
        }
        if (sType.equals("ForeignKey")) {
            return new String[]{"KeyedColumns", "PartnerUniqueKey", "KeyAssociations"};
        }
        if (sType.equals("Index")) {
            return new String[]{"Columns"};
        }
        if (sType.equals("Column")) {
            return new String[0];
        }
        if (sType.equals("KeyAssociation")) {
            return new String[]{"UniqueKeyColumn", "ForeignKeyColumn"};
        }
        throw new UnsupportedOperationException("Invalid type (" + sType + ") specified in getAssociations");
    }

    @Override
    public boolean hasObjectChanged(String sFQID, String sType) throws WsAppServerCodeException, MdException, RemoteException, ComparisonResultsException {
        String libRef = this.getLibraryReference();
        StringBuffer code = new StringBuffer();
        code.append("Select * from ");
        code.append(libRef);
        code.append(".");
        code.append(this.suffixVersion(COMPAREDOBJECTS));
        code.append(" where id=\"");
        code.append(sFQID);
        code.append("\" and Changed=\"T\" ");
        code.append("\n");
        List tables = this.getSASDatasetFromSelectStatement(code.toString());
        int size = tables.size();
        return size > 0;
    }

    @Override
    public boolean hasAttributeChanged(String sFQID, String sType, String sAttribute) throws WsAppServerCodeException, MdException, RemoteException, ComparisonResultsException {
        String[] attributeValues = this.getAttributeValues(sFQID, sType, sAttribute);
        boolean bAttributeChanged = true;
        if (this.isIgnoreCaseSensitive()) {
            if (attributeValues[0].trim().compareToIgnoreCase(attributeValues[1].trim()) == 0) {
                bAttributeChanged = false;
            }
        } else if (attributeValues[0].trim().compareTo(attributeValues[1].trim()) == 0) {
            bAttributeChanged = false;
        }
        return bAttributeChanged;
    }

    @Override
    public boolean hasAssociationChanged(String sFQID, String sType, String sAssociation) throws WsAppServerCodeException, MdException, RemoteException, ComparisonResultsException {
        StringBuffer code = new StringBuffer();
        code.append("%hasAssociationChanged(");
        code.append(sFQID);
        code.append(",\"");
        code.append(sType);
        code.append("\", \"");
        code.append(sAssociation);
        code.append("\" );\n");
        try {
            this.m_appServer.submitSASCode(code.toString());
        }
        catch (WsAppServerFailException e) {
            throw new ComparisonResultsException(e.getLocalizedMessage());
        }
        code = new StringBuffer();
        code.append("Select * from work.");
        code.append(this.suffixVersion(ASSOCIATIONCHANGED));
        code.append("\n");
        List tables = this.getSASDatasetFromSelectStatement(code.toString());
        int size = tables.size();
        return size > 0;
    }

    @Override
    public String[] getAttributeValues(String sFQID, String sType, String sAttribute) throws WsAppServerCodeException, MdException, RemoteException, ComparisonResultsException {
        String[] saValues = new String[]{"", ""};
        if (this.m_getAttsFQID.compareToIgnoreCase(sFQID) != 0) {
            this.runGetAttributesMacro(sFQID, sType);
            this.m_getAttsFQID = sFQID;
            this.m_lAttributes = this.getArrayListOfAttributes();
        }
        for (int i = 0; i < this.m_lAttributes.size(); ++i) {
            String attribute = (String)((List)this.m_lAttributes.get(i)).get(0);
            if (attribute.compareToIgnoreCase(sAttribute) != 0) continue;
            saValues[0] = (String)((List)this.m_lAttributes.get(i)).get(1);
            saValues[1] = (String)((List)this.m_lAttributes.get(i)).get(2);
            break;
        }
        return saValues;
    }

    @Override
    public String[][] getAssociation(String sFQID, String sType, String sAssociation) throws WsAppServerCodeException, MdException, RemoteException, ComparisonResultsException {
        StringBuffer sb = new StringBuffer();
        sb.append("%getAssociations(");
        sb.append(sFQID);
        sb.append(",");
        sb.append(sType);
        sb.append(",");
        sb.append(sAssociation);
        sb.append(");\n");
        try {
            this.m_appServer.submitSASCode(sb.toString());
        }
        catch (WsAppServerFailException e) {
            throw new ComparisonResultsException(e.getLocalizedMessage());
        }
        List tables = new ArrayList();
        try {
            tables = this.getSASDatasetAsList(ASSOCIATIONSDATASET, "work");
        }
        catch (SQLException se) {
            throw new ComparisonResultsException(se.getLocalizedMessage());
        }
        catch (WsAppServerFailException wsfe) {
            throw new ComparisonResultsException(wsfe.getLocalizedMessage());
        }
        int size = tables.size();
        String[][] objects = new String[size][4];
        for (int i = 0; i < size; ++i) {
            ArrayList row = (ArrayList)tables.get(i);
            objects[i][0] = (String)row.get(2);
            objects[i][1] = (String)row.get(1);
            objects[i][2] = (String)row.get(0);
        }
        return objects;
    }

    public void substituteNewID(String[][] saID) throws ComparisonResultsException, WsAppServerCodeException {
        String macroCode = this.m_code.substituteID();
        StringBuffer code = new StringBuffer();
        code.append("%let dsWithNewIDs=WORK.ETLS_NEWIDS;\n").append("data &dsWithNewIDs;\n").append("LENGTH METATYPE $18.;\n").append("LENGTH OLD_ID $18.;\n").append("LENGTH NEW_ID $18.;\n").append("\n").append("INPUT METATYPE $ OLD_ID $ NEW_ID $;\n").append("\n").append("DATALINES;\n");
        for (int iRow = 0; iRow < saID.length; ++iRow) {
            code.append(saID[iRow][0]).append(" ").append(saID[iRow][1]).append(" ").append(saID[iRow][2]).append("\n");
        }
        code.append(";\n").append("RUN;\n").append("\n").append("PROC SORT DATA=&dsWithNewIDs;\n").append("   BY OLD_ID;\n").append("RUN;\n").append("\n");
        code.append(macroCode);
        try {
            this.m_appServer.submitSASCode(code.toString());
        }
        catch (WsAppServerFailException e) {
            throw new ComparisonResultsException(e.getLocalizedMessage());
        }
    }

    public boolean isDeleteMissingItems() {
        return this.m_bDeleteMissingItems;
    }

    public void setDeleteMissingItems(boolean bDeleteMissingItems) {
        this.m_bDeleteMissingItems = bDeleteMissingItems;
    }

    public void runComparison() throws ComparisonResultsException, MdException, RemoteException, WsAppServerCodeException {
        this.runComparison(false);
    }

    private void runComparison(boolean isRecompare) throws ComparisonResultsException, MdException, RemoteException, WsAppServerCodeException {
        if (this.m_code == null) {
            this.m_code = new ComparisonResultsCodegen(this);
        }
        if (this.m_personName == null || this.m_personName.equalsIgnoreCase(bundle.getString("ComparisonResultsModel.NoPersonObject.txt"))) {
            this.m_personName = this.m_metaUserName;
        }
        try {
            this.m_appServer.openSASCodeSession();
            this.assignLibrary();
            StringBuffer code = new StringBuffer();
            code.append(this.m_code.getHouseKeepingCode(isRecompare));
            this.m_appServer.submitSASCode(code.toString());
            this.writeSourceXMLFileToWorkArea();
            this.moveSourceXSLMapFile();
            this.moveTargetXSLMapFile();
            code = new StringBuffer();
            code.append(this.m_code.getSourceExtractCode());
            this.m_appServer.submitSASCode(code.toString());
            code = new StringBuffer();
            code.append(this.m_code.getTargetExtractCode());
            this.m_appServer.submitSASCode(code.toString());
            code = new StringBuffer();
            code.append(this.m_code.getComparisonCode());
            String activityLog = this.m_code.getInsertIntoActivityTableMacro();
            code.append(activityLog);
            String activityCode = "";
            activityCode = isRecompare ? RECOMPAREACTIVITY : CREATEDACTIVITY;
            String activityLogInsert = this.m_code.getInsertIntoActivityTableMacroCall(this.m_GUID, activityCode, this.m_oTree.getFQID(), this.m_oTree.getCMetadataType(), this.m_oTree.getName(), bundle.getString("ComparisonResultsModel.RunComparisonActivityDesc.txt"), "", "", "", Workspace.getWorkspace().getUsername());
            code.append(activityLogInsert);
            this.m_appServer.submitSASCode(code.toString());
        }
        catch (WsAppServerFailException wase) {
            throw new ComparisonResultsException(wase.getLocalizedMessage(), 5);
        }
        catch (MdException ex) {
            throw new ComparisonResultsException(ex.getLocalizedMessage());
        }
    }

    public boolean reCompare() throws ComparisonResultsException, MdException, RemoteException, WsAppServerCodeException {
        RecomparisonModel reCompModel = new RecomparisonModel();
        reCompModel.setAppServerFQID(this.m_appServer.getServerFQID());
        String qualFileName = this.m_sourcePath + this.m_sourceName;
        reCompModel.setFileName(qualFileName);
        reCompModel.setFileServerFQID(this.m_sourceServerContextFQID);
        reCompModel.setGroup(this.m_targetGroup);
        reCompModel.setTarget(this.m_targetLocation);
        reCompModel.setBridgeOptions(this.m_bridgeOptions);
        reCompModel.setRepository((Root)Workspace.getWorkspace().getDefaultRepository());
        try {
            String writeXML;
            if (this.m_bridgeName != null && this.m_bridgeName.length() > 0) {
                reCompModel.setBridgeName(this.m_bridgeName);
            }
            if ((writeXML = reCompModel.getWriteXML()) == null) {
                return false;
            }
            this.setSourceOMIXMLString(writeXML);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
            return false;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        catch (CWMConversionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            return false;
        }
        catch (BridgeAPIException e) {
            MetadataMIMBCheckBoxDialog dlgMIMBError = new MetadataMIMBCheckBoxDialog((JFrame)Workspace.getWorkspace());
            dlgMIMBError.doShow(false);
            return false;
        }
        this.runComparison(true);
        return true;
    }

    public void apply() throws MdException, RemoteException, ComparisonResultsException, WsAppServerCodeException, ServiceException {
        this.applyImpl(this.getComparedObjects());
    }

    public List apply(String[][] saObjects) throws WsAppServerCodeException, MdException, RemoteException, ComparisonResultsException, ServiceException {
        return this.applyImpl(saObjects);
    }

    public void remove(String[][] saObjects) throws WsAppServerCodeException, ComparisonResultsException {
        ArrayList<String> lFQIDs = new ArrayList<String>(saObjects.length);
        for (int iObject = 0; iObject < saObjects.length; ++iObject) {
            lFQIDs.add(saObjects[iObject][0]);
        }
        this.setComparedObjectState(lFQIDs, REMOVED);
    }

    public void delete() throws ComparisonResultsException, MdException, RemoteException, WsAppServerCodeException {
        this.deleteComparisonResultTreeObjects();
        this.deleteTables();
    }

    public void deleteComparisonResultTreeObjects() throws MdException, RemoteException {
        AssociationList lsubTrees;
        AssociationList lReposParties;
        StringBuffer sTemplate = new StringBuffer();
        sTemplate.append("<File><UsingPackages><Directory/></UsingPackages></File>");
        if (this.m_oSourceFile != null) {
            Workspace.getMdFactory().deleteMetadataObjects((CMetadata)this.m_oSourceFile, sTemplate.toString());
        }
        if (this.m_oCustomFile != null) {
            Workspace.getMdFactory().deleteMetadataObjects((CMetadata)this.m_oCustomFile, sTemplate.toString());
        }
        if (!(lReposParties = this.m_oTree.getResponsibleParties()).isEmpty()) {
            ResponsibleParty responsParty = (ResponsibleParty)lReposParties.get(0);
            Workspace.getMdFactory().deleteMetadataObject((CMetadata)responsParty);
        }
        if (!(lsubTrees = this.m_oTree.getSubTrees()).isEmpty()) {
            for (int i = 0; i < lsubTrees.size(); ++i) {
                Tree tree = (Tree)lsubTrees.get(i);
                tree.getMembers().removeAllElements();
                this.m_store.deleteObject((CMetadata)tree);
            }
        }
        this.m_store.updatedMetadataAll();
        sTemplate = new StringBuffer();
        sTemplate.append("<Tree><PropertySets><SetProperties><OwningType/>").append("</SetProperties><Properties><OwningType/></Properties>").append("</PropertySets></Tree>");
        Workspace.getMdFactory().deleteMetadataObjects((CMetadata)this.m_oTree, sTemplate.toString());
    }

    private void deleteTables() throws ComparisonResultsException, MdException, RemoteException, WsAppServerCodeException {
        try {
            if (this.m_code == null) {
                return;
            }
            String selectCode = this.m_code.getAllIndentifersSelectCode();
            this.assignLibrary();
            ArrayList<String> alIdentifiers = new ArrayList<String>();
            MVAResultSet rsltSet = this.m_appServer.submitSQLStatement(selectCode);
            if (rsltSet != null) {
                while (rsltSet.next()) {
                    alIdentifiers.add(Integer.toString(rsltSet.getInt(1)));
                }
                rsltSet.close();
            }
            StringBuffer code = new StringBuffer();
            code.append(this.m_code.getDeleteSASMacros());
            for (int i = 0; i < alIdentifiers.size(); ++i) {
                code.append(this.m_code.getDeleteAllTableMacroCall(Integer.parseInt((String)alIdentifiers.get(i))));
            }
            code.append(this.m_code.getInsertIntoActivityTableMacroCall(this.m_GUID, DELETEACTIVITY, this.m_oTree.getFQID(), this.m_oTree.getCMetadataType(), this.m_oTree.getName(), bundle.getString("ComparisonResultsModel.ComparisonDeletedActivity.txt"), "", "", "", Workspace.getWorkspace().getUsername()));
            this.m_appServer.submitSASCode(code.toString());
        }
        catch (WsAppServerFailException e) {
            throw new ComparisonResultsException(e.getLocalizedMessage());
        }
        catch (SQLException e) {
            throw new ComparisonResultsException(e.getLocalizedMessage());
        }
        catch (MdException ex) {
            throw new ComparisonResultsException(ex.getLocalizedMessage());
        }
    }

    public void viewActivityLog() {
        try {
            this.assignLibrary();
            this.m_appServer.submitSASCode(this.m_code.getViewActivityCode());
            this.showSASOutputDialog();
        }
        catch (WsAppServerFailException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        catch (WsAppServerCodeException e) {
            this.showSASLogDialog(e.getLocalizedMessage(), 0);
        }
        catch (MdException me) {
            MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        catch (ComparisonResultsException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        finally {
            this.m_appServer.close();
        }
    }

    private List applyImpl(String[][] saObjects) throws WsAppServerCodeException, MdException, RemoteException, ComparisonResultsException, ServiceException {
        boolean brc;
        int eRC;
        String sTitle;
        String sMessage;
        Item[] aItems = this.convertToItems(saObjects);
        this.m_applyActivityCode = new StringBuffer();
        boolean bCM = Workspace.getWorkspace().getProjectRepositoryId() != null;
        ArrayList<Item> lItemsToChange = new ArrayList<Item>();
        ArrayList<Item> lItemsToCheckOut = new ArrayList<Item>();
        ArrayList<Item> lItemsLockedByOthers = new ArrayList<Item>();
        for (int iItem = 0; iItem < aItems.length; ++iItem) {
            Item item = aItems[iItem];
            if (!bCM || item.m_sLocation.equals("S")) {
                lItemsToChange.add(item);
                continue;
            }
            item.m_sLockedByFQID = ProjectUtil.getLockedByFQID((String)item.m_sType, (String)item.m_sFQID);
            if (item.m_sLockedByFQID == null) {
                lItemsToChange.add(item);
                lItemsToCheckOut.add(item);
                continue;
            }
            item.m_sLockedByName = ProjectUtil.getLockedByName((String)item.m_sType, (String)item.m_sFQID);
            lItemsLockedByOthers.add(item);
        }
        if (lItemsLockedByOthers.size() > 0) {
            ArrayList<String> lDisplay = new ArrayList<String>(lItemsLockedByOthers.size());
            for (int iItem = 0; iItem < lItemsLockedByOthers.size(); ++iItem) {
                Item item = (Item)lItemsLockedByOthers.get(iItem);
                lDisplay.add(bundle.formatString("ComparisonResultsModel.ObjectOwner.fmt.txt", (Object)item.m_sName, (Object)item.m_sLockedByName));
            }
            sMessage = bundle.getString("ComparisonResultsModel.LockedObjects.Message.txt");
            eRC = MessageUtil.displayListMessage((String)sMessage, lDisplay, (String)(sTitle = bundle.getString("ComparisonResultsModel.LockedObjects.Title.txt")), (int)2, (int)2);
            if (eRC != 0) {
                return null;
            }
        }
        if (!(brc = this.checkForForeignKeysToDelete(aItems))) {
            return null;
        }
        if (lItemsToCheckOut.size() > 0) {
            sMessage = bundle.getString("ComparisonResultsModel.CheckOutObjects.Message.txt");
            eRC = MessageUtil.displayListMessage((String)sMessage, lItemsToCheckOut, (String)(sTitle = bundle.getString("ComparisonResultsModel.CheckOutObjects.Title.txt")), (int)2, (int)2);
            if (eRC != 0) {
                return null;
            }
            this.m_mapProjectIDs = this.checkOutItems(lItemsToCheckOut);
        }
        if (lItemsToChange.size() > 0 && (eRC = MessageUtil.displayListMessage((String)(sMessage = bundle.getString("ComparisonResultsModel.ApplyChanges.Message.txt")), lItemsToChange, (String)(sTitle = bundle.getString("ComparisonResultsModel.ApplyChanges.Title.txt")), (int)1, (int)2)) == 0) {
            this.m_lApplyItems = lItemsToChange;
            this.m_mapChangedObjects = new HashMap();
            this.m_mapNewIDs = new HashMap();
            sMessage = bundle.getString("ComparisonResultsModel.ApplyingChangeMessagePrototype.txt");
            sTitle = bundle.getString("ComparisonResultsModel.ApplyingChangeTitle.txt");
            OpRequestUI op = new OpRequestUI((Frame)Workspace.getWorkspace(), sMessage, sTitle);
            op.setDelayBeforeProgressCancelDialog(500);
            ApplyRunnable run = new ApplyRunnable(op);
            op.execute((Runnable)run);
            if (run.wasSuccessful()) {
                ArrayList<String> lCurrFQIDs = new ArrayList<String>(this.m_lApplyItems.size());
                ArrayList<String> lOrigFQIDs = new ArrayList<String>(this.m_lApplyItems.size());
                for (int iItem = 0; iItem < this.m_lApplyItems.size(); ++iItem) {
                    Item item = (Item)this.m_lApplyItems.get(iItem);
                    lCurrFQIDs.add(item.m_sFQID);
                    lOrigFQIDs.add(item.m_sOrigFQID);
                }
                this.setComparedObjectState(lCurrFQIDs, APPLIED);
                this.submitApplyActivityToLog();
                return lOrigFQIDs;
            }
            if (run.codegenError()) {
                this.showSASLogDialog(run.getCodegenErrorMessage(), 0);
            }
        }
        return null;
    }

    private Item[] convertToItems(String[][] saObjects) throws WsAppServerCodeException, MdException, RemoteException, ComparisonResultsException {
        Item[] aObjects = new Item[saObjects.length];
        for (int iObject = 0; iObject < saObjects.length; ++iObject) {
            aObjects[iObject] = new Item(saObjects[iObject], this);
        }
        return aObjects;
    }

    private Map checkOutItems(List lItems) throws MdException, RemoteException, ServiceException {
        SimpleObject[] aObjects = new SimpleObject[lItems.size()];
        for (int iItem = 0; iItem < lItems.size(); ++iItem) {
            Item item = (Item)lItems.get(iItem);
            ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
            String sKey = item.m_sFQID + "/" + item.m_sType;
            BrowseMetadataInterface mi = server.browseFetch(sKey, null);
            String sPublicType = (String)mi.get("PublicType");
            SimpleObjectImpl simpleObject = new SimpleObjectImpl(item.m_sName, item.m_sFQID, item.m_sType, sPublicType);
            aObjects[iItem] = simpleObject;
        }
        ChangeManagementUtil.checkOut(aObjects);
        CMListenerManager cmManager = CMListenerManager.getInstance();
        Map primaryToProjectMap = null;
        if (cmManager != null) {
            primaryToProjectMap = cmManager.getPrimaryToProjectMap();
        }
        return primaryToProjectMap;
    }

    private List checkTablesUniqueKeys(Item item, Item[] aItems) throws WsAppServerCodeException, ComparisonResultsException, MdException, RemoteException {
        ArrayList<String> lProblems = new ArrayList<String>();
        String[][] saUKs = this.getAssociation(item.m_sFQID, item.m_sType, "UniqueKeys");
        for (int iUK = 0; iUK < saUKs.length; ++iUK) {
            if (saUKs[iUK][2].equals("T") || !this.hasObjectChanged(saUKs[iUK][0], saUKs[iUK][1])) continue;
            String[][] saFKs = this.getAssociation(saUKs[iUK][0], saUKs[iUK][1], "ForeignKeys");
            for (int iFK = 0; iFK < saFKs.length; ++iFK) {
                String sFKName;
                if (saFKs[iFK][2].equals("T") && this.isDeleteMissingItems()) continue;
                String[][] saTables = this.getAssociation(saFKs[iFK][0], saFKs[iFK][1], "Table");
                if (saTables.length < 1) {
                    String sUKName = this.getAttributeValues(saUKs[iUK][0], saUKs[iUK][1], "Name")[0];
                    sFKName = this.getAttributeValues(saFKs[iFK][0], saFKs[iFK][1], "Name")[0];
                    String sMessage = bundle.formatString("ComparisonResultsModel.MissingForeignKeyTable.fmt.txt", (Object)sFKName, (Object)sUKName, (Object)item.m_sName);
                    lProblems.add(sMessage);
                    this.m_lForeignKeysToDelete.add(saFKs[iFK][0]);
                    continue;
                }
                if (this.findItem(aItems, saTables[0][0]) != -1) continue;
                String[] saFKNames = this.getAttributeValues(saFKs[iFK][0], saFKs[iFK][1], "Name");
                sFKName = saFKNames[0].length() != 0 ? saFKNames[0] : saFKNames[1];
                String sUKName = this.getAttributeValues(saUKs[iUK][0], saUKs[iUK][1], "Name")[0];
                String sFKTableName = this.getAttributeValues(saTables[0][0], saTables[0][1], "Name")[0];
                String sMessage = bundle.formatString("ComparisonResultsModel.ForeignKeyUniqueKey.fmt.txt", (Object)sFKName, (Object)sFKTableName, (Object)sUKName, (Object)item.m_sName);
                lProblems.add(sMessage);
                this.m_lForeignKeysToDelete.add(saFKs[iFK][0]);
            }
        }
        return lProblems;
    }

    private List checkTablesForeignKeys(Item item, Item[] aItems) throws WsAppServerCodeException, ComparisonResultsException, MdException, RemoteException {
        ArrayList<String> lProblems = new ArrayList<String>();
        String[][] saFKs = this.getAssociation(item.m_sFQID, item.m_sType, "ForeignKeys");
        for (int iFK = 0; iFK < saFKs.length; ++iFK) {
            String sUKName;
            String sFKName;
            if (saFKs[iFK][2].equals("T") || !this.hasObjectChanged(saFKs[iFK][0], saFKs[iFK][1])) continue;
            String[][] saUKs = this.getAssociation(saFKs[iFK][0], saFKs[iFK][1], "PartnerUniqueKey");
            if (saUKs.length < 1) {
                String sFKName2 = this.getAttributeValues(saFKs[iFK][0], saFKs[iFK][1], "Name")[0];
                String sMessage = bundle.formatString("ComparisonResultsModel.MissingUniqueKey.fmt.txt", (Object)sFKName2, (Object)item.m_sName);
                lProblems.add(sMessage);
                this.m_lForeignKeysToDelete.add(saFKs[iFK][0]);
                continue;
            }
            if (!this.hasObjectChanged(saUKs[0][0], saUKs[0][1])) continue;
            String[][] saTables = this.getAssociation(saUKs[0][0], saUKs[0][1], "Table");
            if (saTables.length < 1) {
                sFKName = this.getAttributeValues(saFKs[iFK][0], saFKs[iFK][1], "Name")[0];
                sUKName = this.getAttributeValues(saUKs[0][0], saUKs[0][1], "Name")[0];
                String sMessage = bundle.formatString("ComparisonResultsModel.MissingUniqueKeyTable.fmt.txt", (Object)sFKName, (Object)item.m_sName, (Object)sUKName);
                lProblems.add(sMessage);
                this.m_lForeignKeysToDelete.add(saFKs[iFK][0]);
                continue;
            }
            if (this.findItem(aItems, saTables[0][0]) != -1) continue;
            sFKName = this.getAttributeValues(saFKs[iFK][0], saFKs[iFK][1], "Name")[0];
            sUKName = this.getAttributeValues(saUKs[0][0], saUKs[0][1], "Name")[0];
            String sTableName = this.getAttributeValues(saTables[0][0], saTables[0][1], "Name")[0];
            String sMessage = bundle.formatString("ComparisonResultsModel.ForeignKeyUniqueKey.fmt.txt", (Object)sFKName, (Object)item.m_sName, (Object)sUKName, (Object)sTableName);
            lProblems.add(sMessage);
            this.m_lForeignKeysToDelete.add(saFKs[iFK][0]);
        }
        return lProblems;
    }

    private boolean checkForForeignKeysToDelete(Item[] aItems) throws WsAppServerCodeException, ComparisonResultsException, MdException, RemoteException {
        String sTitle;
        this.m_lForeignKeysToDelete = new ArrayList();
        ArrayList lProblems = new ArrayList();
        for (int iItem = 0; iItem < aItems.length; ++iItem) {
            if (!aItems[iItem].m_sType.equals("PhysicalTable")) continue;
            lProblems.addAll(this.checkTablesUniqueKeys(aItems[iItem], aItems));
            lProblems.addAll(this.checkTablesForeignKeys(aItems[iItem], aItems));
        }
        if (lProblems.isEmpty()) {
            return true;
        }
        String sMessage = bundle.getString("ComparisonResultsModel.ForeignKeysWillBeDeleted.Message.txt");
        int eRC = MessageUtil.displayListMessage((String)sMessage, lProblems, (String)(sTitle = bundle.getString("ComparsionResultsModel.ForeignKeysWillBeDeleted.Title.txt")), (int)2, (int)2);
        return eRC == 0;
    }

    private int findItem(Item[] aItems, String sFQID) {
        for (int iItem = 0; iItem < aItems.length; ++iItem) {
            if (!aItems[iItem].m_sFQID.equals(sFQID)) continue;
            return iItem;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyChangesFirstPass(Item item) throws ComparisonResultsException, WsAppServerCodeException, MdException, RemoteException, ServiceException, WsAppServerFailException, ConnectionFactoryException {
        if (item.m_sLocation.equals("T")) {
            if (this.isDeleteMissingItems()) {
                try {
                    CMetadata mdoProject;
                    WAdminResource metabundle = WAdminResource.getBundle(MdFactory.class);
                    String sRemoveTemplate = metabundle.getRawString("RemoveTemplate." + item.m_sType + ".notrans.txt");
                    if (sRemoveTemplate == null) {
                        sRemoveTemplate = "";
                    }
                    if ((mdoProject = Workspace.getWorkspace().getProjectRepository()) != null) {
                        if (this.m_mapProjectIDs != null) {
                            String sFQID = (String)this.m_mapProjectIDs.get(item.m_sFQID);
                            String sType = item.m_sType;
                            if (sFQID != null) {
                                Workspace.getMdFactory().deleteMetadataObjects("", sType, sFQID, sRemoveTemplate);
                            } else {
                                Workspace.getMdFactory().deleteMetadataObjects("", item.m_sType, item.m_sFQID, sRemoveTemplate);
                            }
                            CMListenerManager cmManager = CMListenerManager.getInstance();
                            if (cmManager != null && sFQID != null && sFQID.length() > 0 && sType.length() > 0) {
                                cmManager.checkInDeletedObject(item.m_sFQID, sType);
                            }
                        }
                    } else {
                        Workspace.getMdFactory().deleteMetadataObjects("", item.m_sType, item.m_sFQID, sRemoveTemplate);
                    }
                    this.addApplyActivityRecordToBuffer(DELETEACTIVITY, item.m_sFQID, item.m_sType, item.m_sName, bundle.getString("ComparisonResultsModel.ObjectDeletedActivity.txt"), item.m_sFQID, item.m_sType, item.m_sName);
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Deleting");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
                catch (ServiceException ex) {
                    Workspace.handleServiceException((ServiceException)ex);
                }
                catch (WsAppServerFailException ex) {
                    MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
                }
            }
        } else {
            this.m_mapNewObjects = new HashMap();
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "Apply:" + item.m_sFQID);
            try {
                String sGroupForNewObjects;
                Root mdoRoot;
                Root mdoObject = this.applyChanges(store, item.m_sFQID, item.m_sType, item.m_sLocation);
                if (item.m_sType.equals("PhysicalTable") && mdoObject.isNewObject() && (mdoRoot = this.getSASLibraryForNewTable(item.m_sFQID)) != null) {
                    ((PhysicalTable)mdoObject).getTablePackages().add((Object)mdoRoot);
                }
                if ((sGroupForNewObjects = this.getGroupForNewObjects()).length() != 0 && mdoObject.isNewObject()) {
                    Tree mdoTree = (Tree)Workspace.getMdFactory().createComplexMetadataObject(store, "", "Tree", sGroupForNewObjects);
                    mdoObject.getTrees().add((Object)mdoTree);
                }
                store.updatedMetadataAll();
                this.updateNewIDs(item);
            }
            finally {
                this.m_mapNewObjects.clear();
                this.m_mapNewObjects = null;
                store.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyChangesSecondPass(Item item) throws ComparisonResultsException, WsAppServerCodeException, MdException, RemoteException, WsAppServerFailException, ServiceException, ConnectionFactoryException {
        if (item.m_sLocation.equals("T")) {
            return;
        }
        if (item.m_sType.equals("PhysicalTable")) {
            if (!this.hasAssociationChanged(item.m_sFQID, item.m_sType, "ForeignKeys")) {
                return;
            }
            this.m_mapNewObjects = new HashMap();
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "Apply:" + item.m_sFQID);
            try {
                String sName = this.getAttributeValues(item.m_sFQID, item.m_sType, "Name")[0];
                String sFQID = (String)this.m_mapNewIDs.get(item.m_sOrigFQID);
                if (sFQID == null) {
                    sFQID = this.m_mapProjectIDs != null ? (String)this.m_mapProjectIDs.get(item.m_sFQID) : item.m_sFQID;
                }
                PhysicalTable mdoTable = (PhysicalTable)Workspace.getMdFactory().createComplexMetadataObject(store, sName, item.m_sType, sFQID);
                mdoTable.setPublicType("Table");
                mdoTable.setUsageVersion(OMRPhysicalTable.CURRENT_VERSION.encode());
                AssociationList lForeignKeys = mdoTable.getForeignKeys();
                lForeignKeys.clear();
                String[][] saForeignKeys = this.getAssociation(item.m_sFQID, item.m_sType, "ForeignKeys");
                for (int iForeignKey = 0; iForeignKey < saForeignKeys.length; ++iForeignKey) {
                    String sForeignKeyFQID = saForeignKeys[iForeignKey][0];
                    String sForeignKeyType = saForeignKeys[iForeignKey][1];
                    String sAssocWhere = saForeignKeys[iForeignKey][2];
                    if (this.m_lForeignKeysToDelete.contains(sForeignKeyFQID)) continue;
                    if (!sAssocWhere.equals("T") || !this.isDeleteMissingItems()) {
                        lForeignKeys.add(this.applyChanges(store, sForeignKeyFQID, sForeignKeyType, sAssocWhere));
                    }
                    String sForeignKeyName = this.getAttributeValues(item.m_sFQID, item.m_sType, "Name")[0];
                    this.addApplyActivityRecordToBuffer(CHANGEACTIVITY, item.m_sFQID, item.m_sType, sName, bundle.getString("ComparisonResultsModel.AssociationChangedActivity.txt"), sForeignKeyFQID, sForeignKeyType, sForeignKeyName);
                }
                store.updatedMetadataAll();
                this.updateNewIDs(item);
            }
            finally {
                this.m_mapNewObjects.clear();
                this.m_mapNewObjects = null;
                store.dispose();
            }
        }
    }

    private Root applyChanges(MdObjectStore store, String sFQID, String sType, String sLocation) throws ComparisonResultsException, WsAppServerCodeException, MdException, RemoteException, ServiceException, WsAppServerFailException, ConnectionFactoryException {
        String sRealFQID;
        boolean bNew;
        String[] saNames = this.getAttributeValues(sFQID, sType, "Name");
        String sName = sLocation.equals("T") ? saNames[1] : saNames[0];
        boolean bChanged = this.hasObjectChanged(sFQID, sType);
        boolean bl = bNew = sFQID.indexOf(36) != -1 || sType.equals("UniqueKey") && this.m_bFirstPass && bChanged || sType.equals("ForeignKey") && bChanged || sType.equals("KeyAssociation");
        if (bNew) {
            sRealFQID = (String)this.m_mapNewIDs.get(sFQID);
            if (sRealFQID == null) {
                sRealFQID = Workspace.getWorkspace().getDefaultRepositoryId();
            }
        } else if (this.m_mapProjectIDs != null) {
            sRealFQID = (String)this.m_mapProjectIDs.get(sFQID);
            if (sRealFQID == null) {
                sRealFQID = sFQID;
            }
        } else {
            sRealFQID = sFQID;
        }
        Root mdoObject = (Root)Workspace.getMdFactory().createComplexMetadataObject(store, sName, sType, sRealFQID);
        if (bNew) {
            if (sType.equals("PhysicalTable")) {
                ((PrimaryType)mdoObject).setPublicType("Table");
                if (mdoObject instanceof PhysicalTable) {
                    PhysicalTable table = (PhysicalTable)mdoObject;
                    table.setMemberType("DATA");
                }
                ((PrimaryType)mdoObject).setUsageVersion(OMRPhysicalTable.CURRENT_VERSION.encode());
            } else if (sType.equals("Column")) {
                ((PrimaryType)mdoObject).setPublicType("Column");
                ((PrimaryType)mdoObject).setUsageVersion(OMRColumn.CURRENT_VERSION.encode());
            }
        }
        if (this.m_mapChangedObjects.containsKey(sFQID)) {
            return mdoObject;
        }
        this.m_mapChangedObjects.put(sFQID, null);
        if (bNew) {
            this.m_mapNewIDs.put(sFQID, mdoObject.getFQID());
            this.m_mapNewObjects.put(sFQID, mdoObject);
        } else if (sLocation.equals("T") || !bChanged) {
            return mdoObject;
        }
        HashMap<String, MdObjectAttribute> mapAttrs = new HashMap<String, MdObjectAttribute>();
        String[] saAttrs = this.getAttributes(sType);
        for (int iAttr = 0; iAttr < saAttrs.length; ++iAttr) {
            String sAttr = saAttrs[iAttr];
            if (!bNew && !this.hasAttributeChanged(sFQID, sType, sAttr)) continue;
            String[] saValues = this.getAttributeValues(sFQID, sType, sAttr);
            String sValue = sLocation.equals("T") ? saValues[1] : saValues[0];
            MdObjectAttribute attr = new MdObjectAttribute(sAttr, 1, sValue);
            mapAttrs.put(sAttr, attr);
            this.addApplyActivityRecordToBuffer(CHANGEACTIVITY, sFQID, sType, sName, bundle.formatString("ComparisonResultsModel.AttributeChangedActivity.txt", (Object)sAttr), sFQID, sType, sName);
        }
        mdoObject.setAttrs(mapAttrs);
        if (bNew) {
            List lSrcExtAttrs = this.getAssociatedExtensions(sFQID);
            AssociationList lExtAttrs = mdoObject.getMdObjectAssociation("Extensions");
            for (int a = 0; a < lSrcExtAttrs.size(); ++a) {
                ArrayList row = (ArrayList)lSrcExtAttrs.get(a);
                String sAttrName = (String)row.get(1);
                String sAttrValue = (String)row.get(3);
                Extension extObject = (Extension)Workspace.getMdFactory().createComplexMetadataObject(store, sAttrName, "Extension", Workspace.getWorkspace().getDefaultRepositoryId());
                extObject.setValue(sAttrValue);
                lExtAttrs.add(extObject);
            }
        }
        String[] saAssocs = this.getAssociations(sType);
        for (int iAssoc = 0; iAssoc < saAssocs.length; ++iAssoc) {
            String sAssoc = saAssocs[iAssoc];
            if (sAssoc.equals("ForeignKeys") || !bNew && !this.hasAssociationChanged(sFQID, sType, sAssoc)) continue;
            AssociationList lAssocObjects = mdoObject.getMdObjectAssociation(sAssoc);
            lAssocObjects.clear();
            String[][] saAssocObjects = this.getAssociation(sFQID, sType, sAssoc);
            for (int iAssocObject = 0; iAssocObject < saAssocObjects.length; ++iAssocObject) {
                String sAssocObjectFQID = saAssocObjects[iAssocObject][0];
                String sAssocObjectType = saAssocObjects[iAssocObject][1];
                String sAssocWhere = saAssocObjects[iAssocObject][2];
                if (!sAssocWhere.equals("T") || !this.isDeleteMissingItems()) {
                    Root mdoAssocObject = this.applyChanges(store, sAssocObjectFQID, sAssocObjectType, sAssocWhere);
                    lAssocObjects.add(mdoAssocObject);
                }
                String sAssocObjectName = this.getAttributeValues(sFQID, sType, "Name")[0];
                this.addApplyActivityRecordToBuffer(CHANGEACTIVITY, sFQID, sType, sName, bundle.getString("ComparisonResultsModel.AssociationChangedActivity.txt"), sAssocObjectFQID, sAssocObjectType, sAssocObjectName);
            }
        }
        return mdoObject;
    }

    private void updateNewIDs(Item item) throws ComparisonResultsException, WsAppServerCodeException {
        try {
            Iterator iterKeys = this.m_mapNewObjects.keySet().iterator();
            String[][] saIDs = new String[this.m_mapNewObjects.keySet().size()][3];
            int iID = 0;
            while (iterKeys.hasNext()) {
                String sOrigID = (String)iterKeys.next();
                Root mdo = (Root)this.m_mapNewObjects.get(sOrigID);
                String sRealID = mdo.getFQID();
                saIDs[iID][0] = mdo.getCMetadataType();
                saIDs[iID][1] = sOrigID;
                saIDs[iID][2] = sRealID;
                ++iID;
                this.m_mapNewIDs.put(sOrigID, sRealID);
                this.m_mapChangedObjects.remove(sOrigID);
                this.m_mapChangedObjects.put(sRealID, null);
                if (!sOrigID.equals(item.m_sFQID)) continue;
                item.m_sFQID = sRealID;
            }
            this.substituteNewID(saIDs);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    private void addApplyActivityRecordToBuffer(String activityCode, String strFQID, String type, String name, String desc, String parentFQID, String parentType, String parentName) throws MdException, WsAppServerFailException, RemoteException, ServiceException, ConnectionFactoryException {
        this.m_applyActivityCode.append(this.m_code.getInsertIntoActivityTableMacroCall(this.m_GUID, activityCode, strFQID, type, name, desc, parentFQID, parentType, parentName, Workspace.getWorkspace().getUsername()));
    }

    private void submitApplyActivityToLog() {
        try {
            this.m_appServer.submitSASCode(this.m_applyActivityCode.toString());
        }
        catch (WsAppServerFailException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        catch (WsAppServerCodeException e) {
            this.showSASLogDialog(e.getLocalizedMessage(), 0);
        }
    }

    public void removeCustomFileFromStore() throws MdException, RemoteException {
        String strTemplate = "<File><PropertySets><SetProperties><OwningType/></SetProperties><Properties><OwningType/></Properties></PropertySets></File";
        this.m_store.removeObjectFromStore((CMetadata)this.m_oCustomFile, strTemplate);
    }

    protected String suffixVersion(String prefix) throws WsAppServerCodeException, MdException, RemoteException, ComparisonResultsException {
        StringBuffer sbValue = new StringBuffer(prefix);
        sbValue.append(Integer.toString(this.getComparisonIdentifier()));
        return sbValue.toString();
    }

    private List getSASDatasetAsList(String datasetName, String libRef) throws SQLException, WsAppServerFailException, WsAppServerCodeException, MdException, RemoteException, ComparisonResultsException {
        StringBuffer code = new StringBuffer();
        code.append("Select * from ");
        code.append(libRef);
        code.append(".");
        code.append(this.suffixVersion(datasetName));
        code.append("\n");
        return this.getSASDatasetFromSelectStatement(code.toString());
    }

    private List getSASDatasetFromSelectStatement(String selectStatement) throws ComparisonResultsException, MdException, RemoteException, WsAppServerCodeException {
        ResultSetMetaData metadata = null;
        int colCount = 0;
        this.assignLibrary();
        ArrayList alColumns = new ArrayList(50);
        this.assignLibrary();
        try {
            MVAResultSet rsltSet = this.m_appServer.submitSQLStatement(selectStatement);
            if (rsltSet != null) {
                metadata = rsltSet.getMetaData();
                colCount = metadata.getColumnCount();
                while (rsltSet.next()) {
                    ArrayList<String> alRow = new ArrayList<String>(colCount);
                    for (int i = 1; i <= colCount; ++i) {
                        String value = rsltSet.getString(i);
                        if (value != null) {
                            value = value.trim();
                        }
                        alRow.add(value);
                    }
                    alColumns.add(alRow);
                }
                rsltSet.close();
            }
        }
        catch (SQLException e) {
            throw new ComparisonResultsException(e.getLocalizedMessage());
        }
        catch (WsAppServerFailException e) {
            throw new ComparisonResultsException(e.getLocalizedMessage());
        }
        return alColumns;
    }

    private List getArrayListOfAttributes() throws WsAppServerCodeException, MdException, RemoteException, ComparisonResultsException {
        ResultSetMetaData m_metadata = null;
        int colCount = 0;
        ArrayList lAttributes = new ArrayList(50);
        StringBuffer sbSubmitStmt = new StringBuffer();
        sbSubmitStmt.append("Select * from ");
        sbSubmitStmt.append(this.suffixVersion(ATTRIBUTESDATASET));
        sbSubmitStmt.append("\n");
        this.assignLibrary();
        MVAResultSet rsltSet = null;
        try {
            rsltSet = this.m_appServer.submitSQLStatement(sbSubmitStmt.toString());
        }
        catch (WsAppServerFailException e) {
            throw new ComparisonResultsException(e.getLocalizedMessage());
        }
        if (rsltSet != null) {
            try {
                m_metadata = rsltSet.getMetaData();
                colCount = m_metadata.getColumnCount();
                while (rsltSet.next()) {
                    ArrayList<String> alRow = new ArrayList<String>(colCount);
                    for (int i = 1; i <= colCount; ++i) {
                        String value = rsltSet.getString(i);
                        if (value != null) {
                            value = value.trim();
                        }
                        alRow.add(value);
                    }
                    lAttributes.add(alRow);
                }
                rsltSet.close();
            }
            catch (SQLException e) {
                throw new ComparisonResultsException(e.getLocalizedMessage());
            }
        }
        return lAttributes;
    }

    private void runGetAttributesMacro(String fqid, String metadataType) throws ComparisonResultsException, WsAppServerCodeException {
        try {
            StringBuffer code = new StringBuffer();
            code.append("%getAttributes(\"").append(fqid).append("\", ").append(metadataType).append(", ").append("&caseSensitive);\n");
            this.m_appServer.submitSASCode(code.toString());
        }
        catch (WsAppServerFailException e) {
            throw new ComparisonResultsException(e.getLocalizedMessage());
        }
    }

    private WsAppServer findAppServer(SASLibrary library) throws MdException, RemoteException {
        ServerContext server = null;
        String defaultServerId = WsAppServer.getDefaultAppServerFQID();
        if (library != null) {
            AssociationList alservers = library.getDeployedComponents();
            if (alservers.isEmpty()) {
                if (defaultServerId.length() == 0) {
                    return WsAppServer.createDefaultAppServer((boolean)true);
                }
                server = (ServerContext)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, null, "", "ServerContext", defaultServerId);
                return WsAppServer.createAppServer((ServerContext)server);
            }
            if (alservers.size() == 1) {
                return WsAppServer.createAppServer((ServerContext)((ServerContext)alservers.get(0)));
            }
            if (defaultServerId.length() != 0) {
                for (int i = 0; i < alservers.size(); ++i) {
                    ServerContext iServer = (ServerContext)alservers.get(i);
                    if (!iServer.getFQID().equalsIgnoreCase(defaultServerId)) continue;
                    return WsAppServer.createAppServer((ServerContext)iServer);
                }
                return WsAppServer.createAppServer((ServerContext)((ServerContext)alservers.get(0)));
            }
            return WsAppServer.createAppServer((ServerContext)((ServerContext)alservers.get(0)));
        }
        return null;
    }

    protected void assignLibrary() throws ComparisonResultsException, MdException, RemoteException, WsAppServerCodeException {
        if (this.m_library == null) {
            return;
        }
        try {
            if (!this.m_appServer.isLibrefAssigned(this.getLibraryReference())) {
                this.m_appServer.assignLibref(this.m_library);
            }
        }
        catch (WsAppServerFailException e) {
            throw new ComparisonResultsException(e.getLocalizedMessage());
        }
        catch (WsAppServerLibraryException e) {
            throw new ComparisonResultsException(e.getLocalizedMessage());
        }
    }

    protected boolean hasSASTable(String datasetName) throws ComparisonResultsException, MdException, RemoteException, WsAppServerCodeException {
        boolean bControllerTables = false;
        try {
            this.assignLibrary();
            String filename = this.m_appServer.getPathToFile(this.getLibraryReference(), datasetName) + ".sas7bdat";
            bControllerTables = this.m_appServer.doesFileExist(filename);
        }
        catch (GenericError e) {
            return false;
        }
        catch (WsAppServerFailException e) {
            throw new ComparisonResultsException(e.getLocalizedMessage());
        }
        return bControllerTables;
    }

    public void showSASLogDialog() {
        this.showSASLogDialog(bundle.getString("ComparisonResultsModel.RunSuccessfulViewLog.txt"), 1);
    }

    public void showSASLogDialog(String message, int iMessageType) {
        int choice = MessageUtil.displayMessage((String)message, (int)iMessageType, (int)0);
        if (choice == 0) {
            SASLogDialog dlg = new SASLogDialog((Frame)Workspace.getWorkspace(), bundle.getString("ComparisonResultsModel.SASLog.title.txt"), true, this.m_appServer);
            dlg.show();
        }
    }

    protected void showSASOutputDialog() {
        SASOutputDialog dialog = new SASOutputDialog((Frame)Workspace.getWorkspace(), bundle.getString("ComparisonResultsModel.SASOutput.title.txt"), true, this.m_appServer);
        dialog.show();
    }

    private Tree createMainTree(String name, MdObjectStore store, String reposId) throws MdException, RemoteException {
        String repos = reposId.substring(9, 17);
        Tree tree = (Tree)Workspace.getMdFactory().createComplexMetadataObject(store, name, "Tree", repos);
        tree.setTreeType(TREETYPE);
        this.m_GUID = GUID.newGUID();
        PropertyHandler props = new PropertyHandler((Root)tree, CRDUNIQUEIDENTIFIER, true);
        props.setSpecificProperty(CRDUNIQUEIDENTIFIER, this.m_GUID);
        Person oPerson = (Person)Workspace.getMdFactory().createComplexMetadataObject(store, Workspace.getWorkspace().getUsername(), "Person", Workspace.getWorkspace().getMyIdentityID());
        this.m_personName = oPerson != null ? oPerson.getName() : bundle.getString("ComparisonResultsModel.GeneralObject.Name.txt");
        String rpName = bundle.formatString("ComparisonResultsModel.ObjectName.txt", (Object)this.m_personName);
        ResponsibleParty reponsParty = (ResponsibleParty)Workspace.getMdFactory().createComplexMetadataObject(store, rpName, "ResponsibleParty", repos);
        reponsParty.setRole("OWNER");
        if (oPerson != null) {
            reponsParty.getPersons().add((Object)oPerson);
        }
        tree.getResponsibleParties().add((Object)reponsParty);
        return tree;
    }

    private void createSourceFileAndAddToTree() throws MdException, RemoteException {
        String reposId = this.m_reposId.substring(9, 17);
        File file = (File)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, bundle.formatString("ComparisonResultsModel.ObjectName.txt", (Object)this.m_sourceName), "File", reposId);
        file.setTextRole(SOURCEFILETEXTROLE);
        file.setFileName(this.m_sourceName);
        file.setFileExtension(this.m_sourceExtension);
        if (this.m_sourceServerContextFQID != null) {
            ServerContext server = (ServerContext)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_oTree.getObjectStore(), null, "", "ServerContext", this.m_sourceServerContextFQID);
            file.getDeployedComponents().add((Object)server);
        }
        Directory dir = (Directory)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, this.m_sourcePath, "Directory", reposId);
        dir.setDirectoryName(this.m_sourcePath);
        file.getUsingPackages().add((Object)dir);
        this.m_oTree.getMembers().add((Object)file);
    }

    protected void createCustomFileAndAddToTree() throws MdException, RemoteException {
        String reposId = this.m_reposId.substring(9, 17);
        File file = (File)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, bundle.formatString("ComparisonResultsModel.ObjectName.txt", (Object)this.m_customName), "File", reposId);
        file.setTextRole(CUSTOMEFFTEXTROLE);
        file.setFileName(this.m_customName);
        PropertyHandler props = new PropertyHandler((Root)file, CUSTOMEFFDELIMITER, true);
        props.setSpecificProperty(CUSTOMEFFDELIMITER, this.m_customDelimiter);
        this.m_oTree.getMembers().add((Object)file);
    }

    private File getFileFromTree(String type) throws MdException, RemoteException {
        AssociationList members = this.m_oTree.getMembers();
        for (int i = 0; i < members.size(); ++i) {
            Root member = (Root)members.get(i);
            if (!member.getCMetadataType().equalsIgnoreCase("File") || !((File)member).getTextRole().equals(type)) continue;
            return (File)member;
        }
        return null;
    }

    private void addTargetLocationAndGroupToTree() throws MdException, RemoteException {
        String reposId = this.m_reposId.substring(9, 17);
        Tree tree = (Tree)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_oTree.getObjectStore(), bundle.formatString("ComparisonResultsModel.ObjectName.txt", (Object)bundle.getString("ComparisonResultsModel.TargetTree.txt")), "Tree", reposId);
        tree.setTreeType(TARGETLOCTREETYPE);
        tree.setParentTree(this.m_oTree);
        tree.getMembers().add((Object)this.m_targetLocation);
        if (this.m_targetGroup != null) {
            tree.getMembers().add((Object)this.m_targetGroup);
        }
    }

    private Root getTargetLocationFromTree() throws MdException, RemoteException {
        AssociationList subTrees = this.m_oTree.getSubTrees();
        Tree oTree = null;
        for (int i = 0; i < subTrees.size(); ++i) {
            Tree tree = (Tree)subTrees.get(i);
            if (!tree.getTreeType().equalsIgnoreCase(TARGETLOCTREETYPE)) continue;
            oTree = tree;
            break;
        }
        if (oTree != null) {
            AssociationList members = oTree.getMembers();
            for (int j = 0; j < members.size(); ++j) {
                Root object = (Root)members.get(j);
                if (object.getCMetadataType().equalsIgnoreCase("Tree")) continue;
                return object;
            }
        }
        return null;
    }

    private Tree getTargetGroupFromTree() throws MdException, RemoteException {
        AssociationList subTrees = this.m_oTree.getSubTrees();
        Tree foundTree = null;
        for (int i = 0; i < subTrees.size(); ++i) {
            Tree tree = (Tree)subTrees.get(i);
            if (!tree.getTreeType().equalsIgnoreCase(TARGETLOCTREETYPE)) continue;
            foundTree = tree;
            break;
        }
        if (foundTree != null) {
            AssociationList members = foundTree.getMembers();
            for (int j = 0; j < members.size(); ++j) {
                Root object = (Root)members.get(j);
                if (!object.getCMetadataType().equalsIgnoreCase("Tree")) continue;
                return (Tree)object;
            }
        }
        return null;
    }

    private void addLibraryToTree() throws MdException, RemoteException {
        String reposId = this.m_reposId.substring(9, 17);
        Tree tree = (Tree)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_oTree.getObjectStore(), bundle.formatString("ComparisonResultsModel.ObjectName.txt", (Object)bundle.getString("ComparisonResultsModel.CRDLibraryTree.txt")), "Tree", reposId);
        tree.setTreeType(LIBRARYTREETYPE);
        tree.setParentTree(this.m_oTree);
        tree.getMembers().add((Object)this.m_library);
    }

    private void setLibraryPath() throws MdException, RemoteException {
        String path = "";
        AssociationList alDirectories = this.m_library.getUsingPackages();
        if (!alDirectories.isEmpty()) {
            Directory dir = (Directory)alDirectories.get(0);
            path = dir.getDirectoryName();
        }
        this.m_libraryPath = path + "/";
    }

    private SASLibrary getLibraryFromTree() throws MdException, RemoteException {
        AssociationList members;
        AssociationList subTrees = this.m_oTree.getSubTrees();
        Tree oTree = null;
        for (int i = 0; i < subTrees.size(); ++i) {
            Tree tree = (Tree)subTrees.get(i);
            if (!tree.getTreeType().equalsIgnoreCase(LIBRARYTREETYPE)) continue;
            oTree = tree;
            break;
        }
        if (oTree != null && !(members = oTree.getMembers()).isEmpty()) {
            return (SASLibrary)members.get(0);
        }
        return null;
    }

    private void getGUIDFromTree() throws MdException, RemoteException {
        PropertyHandler props = new PropertyHandler((Root)this.m_oTree, CRDUNIQUEIDENTIFIER, true);
        this.m_GUID = props.getSpecificOptionValue(CRDUNIQUEIDENTIFIER);
    }

    protected void addAllOptionsToTree() throws MdException, RemoteException {
        PropertyHandler props = new PropertyHandler((Root)this.m_oTree, OPTIONS, true);
        props.setSpecificProperty(DELTAONLY, this.m_deltasOption);
        props.setSpecificProperty(IGNORECASE, this.m_ignoreCaseOption);
        props.setSpecificProperty(RECOMPAREOVERWRITE, this.m_recompareOverwrite);
        props.setSpecificProperty(ETLSVERSIONROLE, ETLSVERSION);
        if (this.m_bCustomDictionary) {
            props.setSpecificProperty(USECUSTOMDICTIONARY, this.m_customOption);
            props.setSpecificProperty(AUTOADDTOCUSTOMEFF, this.m_autoAddOption);
        }
    }

    private void getOptionsFromTree() throws MdException, RemoteException {
        PropertyHandler props = new PropertyHandler((Root)this.m_oTree, OPTIONS, true);
        this.m_deltasOption = props.getSpecificOptionValue(DELTAONLY);
        if (this.m_deltasOption.length() == 0) {
            this.m_deltasOption = "YES";
        }
        this.m_ignoreCaseOption = props.getSpecificOptionValue(IGNORECASE);
        if (this.m_ignoreCaseOption.length() == 0) {
            this.m_ignoreCaseOption = "YES";
        }
        this.m_recompareOverwrite = props.getSpecificOptionValue(RECOMPAREOVERWRITE);
        if (this.m_recompareOverwrite.length() == 0) {
            this.m_recompareOverwrite = "NO";
        }
        this.m_customOption = props.getSpecificOptionValue(USECUSTOMDICTIONARY);
        if (this.m_customOption.length() == 0) {
            this.m_customOption = "NO";
        }
        this.m_autoAddOption = props.getSpecificOptionValue(AUTOADDTOCUSTOMEFF);
        if (this.m_autoAddOption.length() == 0) {
            this.m_autoAddOption = "NO";
        }
        this.m_etlsVersion = props.getSpecificOptionValue(ETLSVERSIONROLE);
    }

    private String getCustomExternalFormatFileDelimiter(File file) throws MdException, RemoteException {
        PropertyHandler props = new PropertyHandler((Root)file, CUSTOMEFFDELIMITER, true);
        return props.getSpecificOptionValue(CUSTOMEFFDELIMITER);
    }

    private void addAllBridgeOptionsToTree() throws MdException, RemoteException {
        PropertyHandler props = new PropertyHandler((Root)this.m_oTree, BRIDGES, true);
        for (int i = 0; i < this.m_bridgeOptions.size(); ++i) {
            Set optKeys = this.m_bridgeOptions.keySet();
            for (String optName : optKeys) {
                props.setSpecificProperty(optName, (String)this.m_bridgeOptions.get(optName));
            }
        }
        props = new PropertyHandler((Root)this.m_oTree, BRIDGENAME, true);
        props.setSpecificProperty(BRIDGENAME, this.m_bridgeName);
    }

    private void getAllBridgeOptionsFromTree() throws MdException, RemoteException {
        PropertyHandler props = new PropertyHandler((Root)this.m_oTree, BRIDGES, true);
        AssociationList alProps = props.getPropertyList();
        if (alProps != null && !alProps.isEmpty()) {
            this.m_bridgeOptions = new LinkedHashMap(alProps.size());
            for (int i = 0; i < alProps.size(); ++i) {
                Property property = (Property)alProps.get(i);
                this.m_bridgeOptions.put(property.getName(), property.getDefaultValue());
            }
        }
        props = new PropertyHandler((Root)this.m_oTree, BRIDGENAME, true);
        this.m_bridgeName = props.getSpecificOptionValue(BRIDGENAME);
    }

    private void moveSourceXSLMapFile() {
        this.moveXSLMapToWorkArea(SOURCETOCAMAPFILE);
    }

    private void moveTargetXSLMapFile() {
        if (this.isSASLibraryTargetLocation()) {
            this.moveXSLMapToWorkArea(TARGETTOCAMAPFILE);
        } else {
            this.moveXSLMapToWorkArea(DBTARGETTOCAMAPFILE);
        }
    }

    private void moveXSLMapToWorkArea(String xslFileName) {
        try {
            String filename = "com/sas/wadmin/changeanalysis/res/" + xslFileName;
            URL url = XMLUtility.urlFromFile((String)filename);
            InputStream inputStream = url.openStream();
            BufferedReader ds = new BufferedReader(new InputStreamReader(inputStream));
            String strXML = "";
            String buf = null;
            while ((buf = ds.readLine()) != null) {
                strXML = strXML + buf;
            }
            String path = this.getLibraryPath();
            this.writeTextFileToWorkArea(strXML, xslFileName, path);
            if (xslFileName.equalsIgnoreCase(SOURCETOCAMAPFILE)) {
                this.m_bSourceMappingFileMoved = true;
            } else {
                this.m_bTargetMappingFileMoved = true;
            }
        }
        catch (IOException e) {
            MessageUtil.displayMessage((String)e.toString(), (int)0);
            if (xslFileName.equalsIgnoreCase(SOURCETOCAMAPFILE)) {
                this.m_bSourceMappingFileMoved = false;
            } else {
                this.m_bTargetMappingFileMoved = false;
            }
            return;
        }
    }

    protected void writeSourceXMLFileToWorkArea() throws WsAppServerCodeException, MdException, RemoteException, ComparisonResultsException {
        StringBuffer sbXML = new StringBuffer();
        sbXML.append("<GetMetadataObjects><Objects>").append(this.m_sourceOMIXML).append("</Objects></GetMetadataObjects>");
        this.assignLibrary();
        String name = this.getXMLFilename(SOURCEOMIFILENAME);
        String qualifiedName = this.getLibraryPath() + name;
        this.setSourceOMIXMLFileName(qualifiedName);
        this.writeTextFileToWorkArea(sbXML.toString(), name, this.getLibraryPath());
    }

    private void writeTextFileToWorkArea(String strWrite, String filename, String dirName) {
        try {
            byte[] convertedFile = this.m_appServer.convertToBinaryUsingServerEncoding(strWrite);
            StringBuffer fullName = new StringBuffer(dirName);
            fullName.append(filename);
            this.m_appServer.writeBinaryFile(convertedFile, fullName.toString(), "");
        }
        catch (WsAppServerFailException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        catch (GenericError e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        catch (UnsupportedEncodingException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
    }

    public List getAssociatedExtensions(String sFQID) throws WsAppServerCodeException, MdException, RemoteException, ComparisonResultsException {
        String libRef = this.getLibraryReference();
        StringBuffer code = new StringBuffer();
        code.append("Select * from ");
        code.append(libRef);
        code.append(".");
        code.append(this.suffixVersion("etls_sextension"));
        code.append(" where obj_ref=\"");
        code.append(sFQID);
        code.append("\n");
        List tables = this.getSASDatasetFromSelectStatement(code.toString());
        return tables;
    }

    private static final class Item {
        protected String m_sFQID;
        protected String m_sOrigFQID;
        protected String m_sType;
        protected String m_sLocation;
        protected boolean m_bChanged;
        protected String m_sName;
        protected String m_sLockedByFQID;
        protected String m_sLockedByName;

        public Item(String[] saValues, ComparisonResultsModel mdl) throws WsAppServerCodeException, MdException, RemoteException, ComparisonResultsException {
            this.m_sFQID = saValues[0];
            this.m_sOrigFQID = saValues[0];
            this.m_sType = saValues[1];
            this.m_sLocation = saValues[2];
            this.m_bChanged = mdl.hasObjectChanged(this.m_sFQID, this.m_sType);
            String[] saNames = mdl.getAttributeValues(this.m_sFQID, this.m_sType, "Name");
            this.m_sName = saNames[0];
            if (this.m_sName == null || this.m_sName.length() == 0) {
                this.m_sName = saNames[1];
            }
        }

        public String toString() {
            return this.m_sName;
        }
    }

    private class ApplyRunnable
    implements Runnable {
        private OpRequestUI m_op;
        private boolean m_bStop;
        private boolean m_bSuccess;
        private boolean m_bCodegenError;
        private String m_bCodegenErrorMessage;

        public ApplyRunnable(OpRequestUI op) {
            this.m_op = op;
        }

        @Override
        public void run() {
            try {
                Item item;
                Integer i;
                int iItem;
                ComparisonResultsModel.this.m_bFirstPass = true;
                Integer n = new Integer(ComparisonResultsModel.this.m_lApplyItems.size());
                String sPass = bundle.getString("ComparisonResultsModel.ApplyingChangeFirstPass.txt");
                for (iItem = 0; iItem < ComparisonResultsModel.this.m_lApplyItems.size(); ++iItem) {
                    i = new Integer(iItem + 1);
                    this.m_op.setMessage(bundle.formatString("ComparisonResultsModel.ApplyingChangeMessage.fmt.txt", (Object)i, (Object)n, (Object)sPass));
                    item = (Item)ComparisonResultsModel.this.m_lApplyItems.get(iItem);
                    ComparisonResultsModel.this.applyChangesFirstPass(item);
                    if (this.m_bStop) break;
                }
                ComparisonResultsModel.this.m_bFirstPass = false;
                sPass = bundle.getString("ComparisonResultsModel.ApplyingChangeSecondPass.txt");
                for (iItem = 0; iItem < ComparisonResultsModel.this.m_lApplyItems.size(); ++iItem) {
                    i = new Integer(iItem + 1);
                    this.m_op.setMessage(bundle.formatString("ComparisonResultsModel.ApplyingChangeMessage.fmt.txt", (Object)i, (Object)n, (Object)sPass));
                    item = (Item)ComparisonResultsModel.this.m_lApplyItems.get(iItem);
                    ComparisonResultsModel.this.applyChangesSecondPass(item);
                    if (this.m_bStop) break;
                }
                if (!this.m_bStop) {
                    this.m_bSuccess = true;
                }
            }
            catch (ComparisonResultsException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (WsAppServerCodeException ex) {
                this.m_bCodegenError = true;
                this.m_bCodegenErrorMessage = ex.getLocalizedMessage();
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            catch (WsAppServerFailException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (ServiceException ex) {
                Workspace.handleServiceException((ServiceException)ex);
            }
            catch (ConnectionFactoryException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
        }

        public void stop() {
            this.m_bStop = true;
        }

        public boolean wasSuccessful() {
            return this.m_bSuccess;
        }

        public boolean codegenError() {
            return this.m_bCodegenError;
        }

        public String getCodegenErrorMessage() {
            return this.m_bCodegenErrorMessage;
        }
    }
}

