/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.changeanalysis;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.SASLibrary;
import com.sas.wadmin.changeanalysis.BridgeAPIException;
import com.sas.wadmin.changeanalysis.CWMConversionException;
import com.sas.wadmin.changeanalysis.RecomparisonModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.LinkedHashMap;
import java.util.List;

public class BridgeConversionModel {
    private Object m_conversionModel;
    private RecomparisonModel m_recomparisonModel;

    public BridgeConversionModel(RecomparisonModel recomparisonModel) throws BridgeAPIException {
        this.m_recomparisonModel = recomparisonModel;
        try {
            ClassLoader loader = Workspace.getWorkspace().getPluginLoader().getClassLoader("com.sas.CWMImport.CWMImporter");
            Class<?> clsPlugin = Class.forName("com.sas.CWMImport.BridgeConversionModel", true, loader);
            this.m_conversionModel = clsPlugin.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new BridgeAPIException(null);
        }
        catch (NoClassDefFoundError e) {
            throw new BridgeAPIException(null);
        }
        catch (IllegalAccessException e) {
            throw new BridgeAPIException(null);
        }
        catch (InstantiationException e) {
            throw new BridgeAPIException(null);
        }
    }

    public String getWriteXML() throws CWMConversionException, MdException, RemoteException, BridgeAPIException {
        String importTool = this.m_recomparisonModel.getBridgeName();
        String importFile = this.m_recomparisonModel.getLocalFileName();
        LinkedHashMap importOptions = this.m_recomparisonModel.getBridgeOptions();
        File fileObj = new File(Workspace.getWorkspace().getDefaultPath() + "\\MIimptmp.xml");
        try {
            fileObj.createNewFile();
        }
        catch (IOException e) {
            String message = e.getMessage();
            if (message != null) {
                MessageUtil.displayMessage((String)message, (int)2);
            }
            return null;
        }
        String exportFile = fileObj.toString();
        try {
            Method mthdGetWriteXML = this.m_conversionModel.getClass().getMethod("getWriteXML", String.class, String.class, LinkedHashMap.class, String.class);
            mthdGetWriteXML.invoke(this.m_conversionModel, importFile, importTool, importOptions, exportFile);
            Method mthdConverttoSAS = this.m_conversionModel.getClass().getMethod("converttoSAS", String.class, MdObjectStore.class, String.class, CMetadata.class, String.class, String.class, SASLibrary.class);
            mthdConverttoSAS.invoke(this.m_conversionModel, this.m_recomparisonModel.getConvertArgs(exportFile));
        }
        catch (NoSuchMethodException e) {
            throw new BridgeAPIException(null);
        }
        catch (IllegalAccessException e) {
            throw new BridgeAPIException(null);
        }
        catch (InvocationTargetException e) {
            throw new CWMConversionException(e.getTargetException().getLocalizedMessage());
        }
        String inXML = null;
        MdObjectStore store = this.m_recomparisonModel.getStore();
        List newObjs = store.getNewObjects();
        if (newObjs.size() > 1) {
            inXML = store.createXMLforStore();
        }
        return inXML;
    }
}

