/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.app.actions;

import com.sas.wadmin.app.AppViewFactory;
import com.sas.wadmin.app.TransportUtil;
import com.sas.wadmin.app.actions.AbstractSelectionAction;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.models.SimpleObject;

public class ViewLineageAction
extends AbstractSelectionAction {
    private static final WAdminResource bundle = WAdminResource.getBundle(ViewLineageAction.class);

    public ViewLineageAction() {
        super(bundle, "AppActionsManager.Action.FileViewLineage", 256);
    }

    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        SimpleObject[] aObjects = new SimpleObject[aSelectedObjects.length];
        System.arraycopy(aSelectedObjects, 0, aObjects, 0, aSelectedObjects.length);
        SimpleObject selectedObject = aObjects[0];
        try {
            String completeURL = "";
            String baseURL = Workspace.getWorkspace().getAppDefaultsFile().getPropertyString("Workspace.ImpactAnalysisURL");
            String subjectID = selectedObject.getID();
            String subjectType = selectedObject.getPublicType();
            String subjectName = selectedObject.getName();
            String module = "relationships";
            String metadataType = selectedObject.getMetadataType();
            subjectType = "32";
            if (metadataType.equalsIgnoreCase("ExternalTable")) {
                subjectType = "223";
            }
            completeURL = completeURL + baseURL + "#subjectID=" + subjectID + "/" + metadataType + "&subjectType=" + subjectType + "&module=" + module + "&subjectName=" + subjectName;
            AppViewFactory.getInstance().showURL(this.sanitizeURL(completeURL));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String sanitizeURL(String incoming) {
        return incoming.replaceAll("\\s", "%20");
    }

    @Override
    protected boolean isSelectionValid(Object[] aSelectedObjects) {
        if (aSelectedObjects.length != 1) {
            return false;
        }
        for (int iSelectedObject = 0; iSelectedObject < aSelectedObjects.length; ++iSelectedObject) {
            if (aSelectedObjects[iSelectedObject] instanceof SimpleObject && this.isSupportedType(aSelectedObjects)) continue;
            return false;
        }
        SimpleObject[] aObjects = new SimpleObject[aSelectedObjects.length];
        System.arraycopy(aSelectedObjects, 0, aObjects, 0, aSelectedObjects.length);
        return TransportUtil.areObjectsTransportable(aObjects);
    }

    public boolean isValidForContext(WsActionContextInterface context) {
        String contextType = context.getType();
        if (contextType.equals("DiagramTab") || contextType.equals("CheckoutsTree")) {
            return false;
        }
        if (context.getSelectedObjects().length != 1) {
            return false;
        }
        if (!(context.getSelectedObjects()[0] instanceof SimpleObject) || !this.isSupportedType(context.getSelectedObjects())) {
            return false;
        }
        return this.isSelectionValid(context.getSelectedObjects());
    }

    private boolean isSupportedType(Object[] aSelectedObjects) {
        return ((SimpleObject)aSelectedObjects[0]).getPublicType().equals("Table") || ((SimpleObject)aSelectedObjects[0]).getPublicType().equals("ExternalFile");
    }
}

