/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.app.actions;

import com.sas.etl.models.IComplexPersistableObject;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.visuals.UpgradeLogicalObjectVersionUI;
import com.sas.metadata.remote.MdException;
import com.sas.util.UsageVersion;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.app.VersionedObjectManager;
import com.sas.wadmin.app.actions.AbstractSelectionAction;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractApplicationActionsManager;
import com.sas.workspace.WsAbstractVersionedObjectManager;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.WsSelectionProvider;
import com.sas.workspace.models.SimpleObject;
import java.rmi.RemoteException;

public class UpgradeLogicalObjectAction
extends AbstractSelectionAction {
    private static final long serialVersionUID = 4972104012965636926L;
    private static final WAdminResource bundle = WAdminResource.getBundle(UpgradeLogicalObjectAction.class);

    public UpgradeLogicalObjectAction() {
        super(bundle, "AppActionsManager.ContextAction.UpgradeLogical", 256);
        this.setMenuSupportId("Context:Upgrade");
    }

    @Override
    protected void actionPerformed(Object[] selectedObjects) {
        WsSelectionProvider selectionProvider;
        LogicalObjectInterface[] los = null;
        try {
            los = ObjectConverter.getInstance().convertToLogicalObjects(selectedObjects);
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (MdException e) {
            Workspace.getDefaultLogger().error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (LogicalTypeException e) {
            Workspace.getDefaultLogger().error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        UpgradeLogicalObjectVersionUI ui = new UpgradeLogicalObjectVersionUI();
        ui.executeLogicalVersionUpgrade(los);
        WsAbstractApplicationActionsManager actionsMgr = WsAbstractApplicationActionsManager.getInstance();
        if (actionsMgr != null && (selectionProvider = actionsMgr.getSelectionProvider()) != null) {
            Object[] aSelectedObjects = selectionProvider.getSelectedObjects();
            this.setEnabled(this.isSelectionValid(aSelectedObjects));
            return;
        }
        this.setEnabled(false);
    }

    @Override
    protected boolean isSelectionValid(Object[] selectedObjects) {
        if (selectedObjects.length == 0) {
            return false;
        }
        for (int iObject = 0; iObject < selectedObjects.length; ++iObject) {
            if (!(selectedObjects[iObject] instanceof SimpleObject)) {
                return false;
            }
            SimpleObject sObject = (SimpleObject)selectedObjects[iObject];
            if (UpgradeLogicalObjectAction.isUpgradeable(sObject)) continue;
            return false;
        }
        return true;
    }

    public boolean isValidForContext(WsActionContextInterface context) {
        String contextType = context.getType();
        if ("DiagramTab".equals(contextType)) {
            return false;
        }
        Object[] aObjects = context.getSelectedObjects();
        if (aObjects.length == 0) {
            return false;
        }
        for (int iObject = 0; iObject < aObjects.length; ++iObject) {
            if (!(aObjects[iObject] instanceof SimpleObject)) {
                return false;
            }
            SimpleObject sObject = (SimpleObject)aObjects[iObject];
            if (UpgradeLogicalObjectAction.isSupportedForVersioning(sObject)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSupportedForVersioning(SimpleObject sObject) {
        boolean returnValue = true;
        String publicType = sObject.getPublicType();
        if (publicType != null && publicType.length() > 0) {
            WsAbstractVersionedObjectManager vMgr = VersionedObjectManager.getInstance();
            if (vMgr != null) {
                UsageVersion uv = vMgr.getMinimumSupportedVersion(publicType);
                if (uv == null) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return returnValue;
    }

    public static boolean isUpgradeable(SimpleObject sObject) {
        boolean returnValue = true;
        String sType = sObject.getPublicType();
        if (sType == null || sType.length() == 0) {
            return false;
        }
        LogicalObjectInterface lo = null;
        try {
            lo = ObjectConverter.getInstance().convertToLogicalObject(sObject);
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (MdException e) {
            Workspace.getDefaultLogger().error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (LogicalTypeException e) {
            Workspace.getDefaultLogger().error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        if (lo != null) {
            if (!WsAbstractVersionedObjectManager.isUpgradeable((String)sType, (UsageVersion)lo.getUsageVersion())) {
                return false;
            }
        } else {
            return false;
        }
        return returnValue;
    }

    public static boolean isVersionSupported(String publicType, IComplexPersistableObject obj) {
        boolean returnValue = true;
        if (publicType != null && publicType.length() > 0) {
            UsageVersion instanceVersion = obj.getArchitectureVersionNumber();
            TypeInterface ti = null;
            try {
                ti = Factory.getInstance().getTypeInterface(publicType);
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
            catch (LogicalTypeException e) {
                Workspace.getDefaultLogger().error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            if (instanceVersion != null && ti != null) {
                WsAbstractVersionedObjectManager objInst = VersionedObjectManager.getInstance();
                returnValue = UpgradeLogicalObjectAction.isValidVersion(publicType, instanceVersion, ti, objInst);
            }
        }
        return returnValue;
    }

    private static boolean isValidVersion(String publicType, UsageVersion instanceVersion, TypeInterface ti, WsAbstractVersionedObjectManager objInst) {
        boolean returnValue = true;
        if (objInst != null && !objInst.isVersionSupported(publicType, instanceVersion)) {
            returnValue = false;
            String details = bundle.formatString("OpenSelectedObjectsAction.VersionNotSupported.Message.txt", (Object)instanceVersion.toString(), (Object)ti.getDisplayType());
            MessageUtil.displayDetailsMessage((String)bundle.getString("OpenSelectedObjectsAction.OpenNotSupported.Message.txt"), (String)details);
        }
        return returnValue;
    }

    public static boolean isVersionSupported(SimpleObject obj) {
        boolean returnValue = true;
        if (obj != null) {
            try {
                String publicType;
                LogicalObjectInterface lo = ObjectConverter.getInstance().convertToLogicalObject(obj);
                if (lo != null && (publicType = lo.getTypeInterface().getPublicType()) != null && publicType.length() > 0) {
                    UsageVersion instanceVersion = lo.getUsageVersion();
                    WsAbstractVersionedObjectManager objInst = VersionedObjectManager.getInstance();
                    returnValue = UpgradeLogicalObjectAction.isValidVersion(publicType, instanceVersion, lo.getTypeInterface(), objInst);
                }
            }
            catch (MdException me) {
                Workspace.getDefaultLogger().error((Object)me.getLocalizedMessage(), (Throwable)me);
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
            catch (LogicalTypeException e) {
                Workspace.getDefaultLogger().error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return returnValue;
    }
}

