/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.app.actions;

import com.sas.metadata.promotion.visuals.CopyListListener;
import com.sas.metadata.promotion.visuals.CopyPasteUtil;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.wadmin.app.TransportUtil;
import com.sas.wadmin.app.actions.AbstractSelectionAction;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractApplicationActionsManager;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.WsSelectionProvider;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleObjectImpl;
import com.sas.workspace.visuals.tree.TransformationsTree;
import java.rmi.RemoteException;

class PasteSpecialAction
extends AbstractSelectionAction {
    private static final WAdminResource bundle = WAdminResource.getBundle(PasteSpecialAction.class);

    public PasteSpecialAction() {
        super(bundle, "AppActionsManager.Action.EditPasteSpecial", 257);
        CopyPasteUtil.addCopyListListener((CopyListListener)new CopyListListener(){

            public void copyListChanged() {
                WsSelectionProvider selectionProvider;
                WsAbstractApplicationActionsManager actionsMgr = WsAbstractApplicationActionsManager.getInstance();
                if (actionsMgr != null && (selectionProvider = actionsMgr.getSelectionProvider()) != null) {
                    Object[] aSelectedObjects = selectionProvider.getSelectedObjects();
                    PasteSpecialAction.this.setEnabled(PasteSpecialAction.this.isSelectionValid(aSelectedObjects));
                    return;
                }
                PasteSpecialAction.this.setEnabled(false);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        if (this.getSelectionProvider() instanceof TransformationsTree) {
            try {
                MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "PasteSpecialAction:actionPerformed");
                try {
                    Tree tree = WsMetadataUtil.getDefaultFolder((MdObjectStore)store);
                    if (tree != null) {
                        SimpleObjectImpl folder = new SimpleObjectImpl(tree.getName(), tree.getFQID(), tree.getCMetadataType(), tree.getPublicType());
                        String sCategory = aSelectedObjects.length == 1 && aSelectedObjects[0] instanceof String ? (String)aSelectedObjects[0] : "";
                        TransportUtil.doPasteSpecial((SimpleObject)folder, sCategory);
                    }
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                }
                catch (ServiceException se) {
                    MessageUtil.displayServiceExceptionMessage((ServiceException)se);
                }
                finally {
                    store.dispose();
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        } else if (aSelectedObjects.length == 0) {
            TransportUtil.doPasteSpecial();
        } else {
            TransportUtil.doPasteSpecial((SimpleObject)aSelectedObjects[0]);
        }
    }

    @Override
    protected boolean isSelectionValid(Object[] aSelectedObjects) {
        if (!CopyPasteUtil.isPasteAllowed()) {
            return false;
        }
        if (aSelectedObjects.length == 0) {
            return true;
        }
        if (aSelectedObjects.length == 1) {
            Object obj = aSelectedObjects[0];
            if (obj instanceof SimpleObject && "Folder".equals(((SimpleObject)aSelectedObjects[0]).getPublicType())) {
                return true;
            }
            if (obj instanceof String) {
                return true;
            }
        }
        return false;
    }

    public boolean isValidForContext(WsActionContextInterface context) {
        if ("InventoryTree".equals(context.getType())) {
            return false;
        }
        if ("DiagramTab".equals(context.getType())) {
            return false;
        }
        Object[] aObjects = context.getSelectedObjects();
        if ("TransformationsTree".equals(context.getType()) && aObjects.length == 1 && aObjects[0] instanceof String) {
            return true;
        }
        for (int iObject = 0; iObject < aObjects.length; ++iObject) {
            if (aObjects[iObject] instanceof SimpleObject && "Folder".equals(((SimpleObject)aObjects[iObject]).getPublicType())) continue;
            return false;
        }
        return true;
    }
}

