/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.app.actions;

import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Tree;
import com.sas.wadmin.app.actions.AbstractSelectionAction;
import com.sas.wadmin.plugins.NewObjectInterface;
import com.sas.wadmin.visuals.NewObjectWizard;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.models.SimpleObject;
import java.awt.Frame;
import java.rmi.RemoteException;
import javax.swing.Icon;

class NewObjectPluginAction
extends AbstractSelectionAction {
    private static final WAdminResource bundle = WAdminResource.getBundle(NewObjectPluginAction.class);
    private NewObjectInterface m_plugin;

    public NewObjectPluginAction(String sText, Icon icon, NewObjectInterface plugin) {
        this.m_plugin = plugin;
        this.setText(plugin.getName());
        this.setIcon(plugin.getIcon());
    }

    public NewObjectPluginAction(NewObjectInterface plugin) {
        this.m_plugin = plugin;
        this.setText(plugin.getName());
        this.setIcon(plugin.getIcon());
    }

    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        try {
            SimpleObject obj;
            String sTitle = bundle.formatString("NewObjectPluginAction.DialogTitle.fmt.txt", (Object)this.m_plugin.getName());
            NewObjectWizard wiz = new NewObjectWizard((Frame)Workspace.getWorkspace(), sTitle, this.m_plugin, null);
            Tree mdoFolder = null;
            if (aSelectedObjects != null && aSelectedObjects.length > 0 && aSelectedObjects[0] instanceof SimpleObject && "Folder".equals((obj = (SimpleObject)aSelectedObjects[0]).getPublicType())) {
                MdObjectStore store = (MdObjectStore)wiz.getWizardData("OBJECTSTORE");
                mdoFolder = (Tree)Workspace.getMdFactory().createComplexMetadataObject(store, obj.getName(), obj.getMetadataType(), obj.getID());
            }
            wiz.addWizardData("GROUP", mdoFolder);
            wiz.show();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    @Override
    protected boolean isSelectionValid(Object[] aSelectedObjects) {
        return true;
    }

    public boolean isValidForContext(WsActionContextInterface context) {
        return true;
    }

    @Override
    protected boolean isEnabledWhenNoSelectionProvider() {
        return true;
    }
}

