/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.app.actions;

import com.sas.etl.models.IComplexPersistableObject;
import com.sas.etl.models.IModel;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.job.IJob;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.app.TransportUtil;
import com.sas.wadmin.app.actions.AbstractSelectionAction;
import com.sas.wadmin.jobeditor.diagram.DiagramTab;
import com.sas.wadmin.jobeditor.diagram.copypaste.CopyContainer;
import com.sas.wadmin.jobeditor.diagram.copypaste.PFDObjectSelection;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramLink;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramNode;
import com.sas.wadmin.jobeditor.diagram.shapes.IDiagramStickyNote;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.WsSelectionProvider;
import com.sas.workspace.models.SimpleObject;
import java.awt.Point;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;

class JobCopyAction
extends AbstractSelectionAction {
    private static final WAdminResource bundle = WAdminResource.getBundle(JobCopyAction.class);
    public static final Class[] COPY_ABLED_TYPES = new Class[]{IPersistableObject.class, IDiagramStickyNote.class, IDiagramLink.class};

    public JobCopyAction() {
        super(bundle, "AppActionsManager.Action.EditCopy", 0);
        this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:Copy"));
    }

    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        WsSelectionProvider provider = this.getSelectionProvider();
        if (!(provider instanceof DiagramTab)) {
            this.actionPerformedForCopy(aSelectedObjects);
            return;
        }
        DiagramTab diagram = (DiagramTab)provider;
        ArrayList<IComplexPersistableObject> primlst = new ArrayList<IComplexPersistableObject>();
        ArrayList<IDiagramStickyNote> notes = new ArrayList<IDiagramStickyNote>();
        PFDPrimitive[] prims = diagram.getDiagramPanel().getSelectedPrimitives();
        ArrayList<Point> cpxpts = new ArrayList<Point>();
        ArrayList<Point> notepts = new ArrayList<Point>();
        for (int i = 0; i < prims.length; ++i) {
            if (prims[i] instanceof IDiagramNode) {
                primlst.add((IComplexPersistableObject)((IDiagramNode)prims[i]).getObject());
                cpxpts.add(prims[i].getLocation());
                continue;
            }
            if (!(prims[i] instanceof IDiagramStickyNote)) continue;
            notes.add((IDiagramStickyNote)prims[i]);
            notepts.add(prims[i].getLocation());
        }
        PFDObjectSelection ct = new PFDObjectSelection(null);
        try {
            ct.copyObjects((IModel)diagram.getDiagramPanel().getJobModel(), Workspace.getMdFactory(), new CopyContainer(primlst.toArray(new IPersistableObject[primlst.size()]), cpxpts.toArray(new Point[cpxpts.size()]), notes.toArray(new IDiagramStickyNote[notes.size()]), notepts.toArray(new Point[notepts.size()])));
            diagram.getDiagramPanel().getSelectionModel().addPrimitives(diagram.getDiagramPanel().getSelectedPrimitives());
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
            ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)e);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)e);
        }
        catch (IOException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            ModelLogger.getDefaultLogger().error((Object)"IOException", (Throwable)e);
        }
    }

    @Override
    protected boolean isSelectionValid(Object[] aSelectedObjects) {
        WsSelectionProvider provider = this.getSelectionProvider();
        if (!(provider instanceof DiagramTab)) {
            return this.isSelectionValidForCopy(aSelectedObjects);
        }
        return JobCopyAction.isValid(aSelectedObjects);
    }

    public static boolean isValid(Object[] aSelectedObjects) {
        if (aSelectedObjects == null || aSelectedObjects.length == 0) {
            return false;
        }
        for (int iSelectedObject = 0; iSelectedObject < aSelectedObjects.length; ++iSelectedObject) {
            if (JobCopyAction.isValid(aSelectedObjects[iSelectedObject])) continue;
            return false;
        }
        return true;
    }

    public static boolean isValid(Object aSelectedObject) {
        for (Class c : COPY_ABLED_TYPES) {
            if (aSelectedObject instanceof IJob || !c.isAssignableFrom(aSelectedObject.getClass())) continue;
            return true;
        }
        return false;
    }

    public boolean isValidForContext(WsActionContextInterface context) {
        WsSelectionProvider provider = this.getSelectionProvider();
        if (!(provider instanceof DiagramTab)) {
            return this.isSelectionValidForCopy(context.getSelectedObjects());
        }
        return JobCopyAction.isCopyValidForContext(context);
    }

    public static boolean isCopyValidForContext(WsActionContextInterface context) {
        return "DiagramTab".equals(context.getType()) && JobCopyAction.isValid(context.getSelectedObjects());
    }

    protected boolean isSelectionValidForCopy(Object[] aSelectedObjects) {
        for (int iSelectedObject = 0; iSelectedObject < aSelectedObjects.length; ++iSelectedObject) {
            if (aSelectedObjects[iSelectedObject] instanceof SimpleObject) continue;
            return false;
        }
        SimpleObject[] aObjects = new SimpleObject[aSelectedObjects.length];
        System.arraycopy(aSelectedObjects, 0, aObjects, 0, aSelectedObjects.length);
        return TransportUtil.areObjectsTransportable(aObjects);
    }

    protected void actionPerformedForCopy(Object[] aSelectedObjects) {
        SimpleObject[] aObjects = new SimpleObject[aSelectedObjects.length];
        System.arraycopy(aSelectedObjects, 0, aObjects, 0, aSelectedObjects.length);
        TransportUtil.doCopy(aObjects);
    }
}

