/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.app.actions;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.app.actions.AbstractSelectionAction;
import com.sas.wadmin.sascodeimporter.SASCodeImporterTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.models.SimpleObject;
import java.awt.Frame;
import java.rmi.RemoteException;

public class ImportSASCodeAction
extends AbstractSelectionAction {
    private static final WAdminResource bundle = WAdminResource.getBundle(ImportSASCodeAction.class);

    public ImportSASCodeAction() {
        super(bundle, "AppActionsManager.Action.ImportSASCode", 257);
        this.setEnabled(true);
    }

    @Override
    protected void actionPerformed(Object[] selectedObjects) {
        SimpleObject aObject = null;
        if (selectedObjects != null && selectedObjects.length == 1 && selectedObjects[0] instanceof SimpleObject && "Folder".equals(((SimpleObject)selectedObjects[0]).getPublicType())) {
            aObject = (SimpleObject)selectedObjects[0];
        }
        this.handleAction(aObject);
    }

    @Override
    protected boolean isSelectionValid(Object[] aSelectedObjects) {
        if (aSelectedObjects.length == 0) {
            return true;
        }
        if (aSelectedObjects.length == 1) {
            Object obj = aSelectedObjects[0];
            if (obj instanceof SimpleObject && "Folder".equals(((SimpleObject)aSelectedObjects[0]).getPublicType())) {
                return true;
            }
            if (obj instanceof String) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isEnabledWhenNoSelectionProvider() {
        return true;
    }

    public boolean isValidForContext(WsActionContextInterface context) {
        if ("InventoryTree".equals(context.getType())) {
            return false;
        }
        if ("DiagramTab".equals(context.getType())) {
            return false;
        }
        Object[] aObjects = context.getSelectedObjects();
        for (int iObject = 0; iObject < aObjects.length; ++iObject) {
            if (aObjects[iObject] instanceof SimpleObject && "Folder".equals(((SimpleObject)aObjects[iObject]).getPublicType())) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAction(SimpleObject folder) {
        WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("ImportSASCodeAction.Dialog.Title.txt"), true);
        dlg.setOKButtonVisible(true);
        dlg.setCancelButtonVisible(true);
        dlg.setCloseButtonVisible(false);
        SASCodeImporterTab panel = new SASCodeImporterTab();
        try {
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "ImportSASCodeAction");
            try {
                if (folder != null) {
                    panel.setFolder((Tree)ObjectConverter.getInstance().convertToJOMAObject(store, folder));
                } else {
                    panel.setFolder(WsMetadataUtil.getDefaultFolder((MdObjectStore)store));
                }
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
            Workspace.getDefaultLogger().error((Object)"RemoteException", (Throwable)e);
        }
        catch (ServiceException e) {
            Workspace.handleServiceException((ServiceException)e);
            Workspace.getDefaultLogger().error((Object)"ServiceException", (Throwable)e);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            Workspace.getDefaultLogger().error((Object)"MdException", (Throwable)e);
        }
        dlg.setMainPanel((WAPanel)panel);
        dlg.setResizable(true);
        dlg.show();
    }
}

