/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.app.actions;

import com.sas.wadmin.app.AppDialogFactory;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.app.TransportUtil;
import com.sas.wadmin.app.actions.AbstractSelectionAction;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.models.SimpleObject;

class ExportSASPackageAction
extends AbstractSelectionAction {
    private static final WAdminResource bundle = WAdminResource.getBundle(ExportSASPackageAction.class);

    public ExportSASPackageAction() {
        super(bundle, "AppActionsManager.Action.FileExportSASPackage", 0);
        this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:Export"));
    }

    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        if (aSelectedObjects.length == 0) {
            AppDialogFactory.getInstance().showExportSASPackageDialog();
        } else {
            SimpleObject[] aObjects = new SimpleObject[aSelectedObjects.length];
            System.arraycopy(aSelectedObjects, 0, aObjects, 0, aSelectedObjects.length);
            AppDialogFactory.getInstance().showExportSASPackageDialog(aObjects);
        }
    }

    @Override
    protected boolean isSelectionValid(Object[] aSelectedObjects) {
        if (aSelectedObjects.length == 0) {
            return true;
        }
        for (int iSelectedObject = 0; iSelectedObject < aSelectedObjects.length; ++iSelectedObject) {
            if (aSelectedObjects[iSelectedObject] instanceof SimpleObject) continue;
            return false;
        }
        SimpleObject[] aObjects = new SimpleObject[aSelectedObjects.length];
        System.arraycopy(aSelectedObjects, 0, aObjects, 0, aSelectedObjects.length);
        return TransportUtil.areObjectsTransportable(aObjects);
    }

    public boolean isValidForContext(WsActionContextInterface context) {
        if ("DiagramTab".equals(context.getType())) {
            return false;
        }
        if (("InventoryTree".equals(context.getType()) || "TransformationsTree".equals(context.getType())) && context.getSelectedObjects().length == 0) {
            return false;
        }
        return this.isSelectionValid(context.getSelectedObjects());
    }
}

