/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.app.actions;

import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractApplicationActionsManager;
import com.sas.workspace.WsSelectionChangedEvent;
import com.sas.workspace.WsSelectionChangedListener;
import com.sas.workspace.WsSelectionProvider;
import java.awt.event.ActionEvent;

abstract class AbstractSelectionAction
extends WsAbstractAction
implements WsSelectionChangedListener,
WsAbstractApplicationActionsManager.ContextualAction,
WsAbstractApplicationActionsManager.SelectionAction {
    private WsSelectionProvider m_provider;

    public AbstractSelectionAction() {
        this.setEnabled(this.isEnabledWhenNoSelectionProvider());
    }

    public AbstractSelectionAction(WAdminResource bundle, String sResourceKey, int fFlags) {
        super(bundle, sResourceKey, fFlags);
        this.setEnabled(this.isEnabledWhenNoSelectionProvider());
    }

    protected abstract boolean isSelectionValid(Object[] var1);

    protected abstract void actionPerformed(Object[] var1);

    public void setSelectionProvider(WsSelectionProvider provider) {
        if (provider != null) {
            this.m_provider = provider;
            this.m_provider.addSelectionChangedListener((WsSelectionChangedListener)this);
            this.setEnabled(this.isSelectionValid(this.m_provider.getSelectedObjects()));
        } else {
            this.m_provider.removeSelectionChangedListener((WsSelectionChangedListener)this);
            this.setEnabled(this.isEnabledWhenNoSelectionProvider());
            this.m_provider = null;
        }
    }

    public WsSelectionProvider getSelectionProvider() {
        return this.m_provider;
    }

    public void actionPerformed(ActionEvent ev) {
        if (!this.isEnabledWhenNoSelectionProvider() && this.m_provider == null) {
            throw new UnsupportedOperationException("Action performed occurred when no selection provider is attached");
        }
        Object[] aSelectedObjects = this.m_provider != null ? this.m_provider.getSelectedObjects() : null;
        this.actionPerformed(aSelectedObjects);
    }

    public void selectionChanged(WsSelectionChangedEvent ev) {
        this.setEnabled(this.isSelectionValid(this.m_provider.getSelectedObjects()));
    }

    protected boolean isEnabledWhenNoSelectionProvider() {
        return false;
    }
}

