/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.app;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.promotion.visuals.CopyPasteUtil;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.metadata.GeneratedTransformationUtilities;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.ContainedByFolderFilter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Map;

public class TransportUtil {
    private static TypeInterface[] m_aSupportedTypes;

    private TransportUtil() {
    }

    public static boolean areObjectsTransportable(SimpleObject[] aObjects) {
        if (aObjects.length == 0) {
            return false;
        }
        try {
            LogicalObjectInterface[] aLOBs = ObjectConverter.getInstance().convertToLogicalObjects(aObjects);
            for (int iObject = 0; iObject < aObjects.length; ++iObject) {
                if (aLOBs[iObject] == null) {
                    return false;
                }
                if (!aLOBs[iObject].isExportAllowed()) {
                    return false;
                }
                if (ContainedByFolderFilter.accept((String)aLOBs[iObject].getTypeInterface().getPublicType())) continue;
                return false;
            }
            return true;
        }
        catch (LogicalTypeException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            return false;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            return false;
        }
    }

    public static void doCopy(SimpleObject[] aObjects) {
        try {
            LogicalObjectInterface[] aLogicalObjects = ObjectConverter.getInstance().convertToLogicalObjects(aObjects);
            CopyPasteUtil.copy((SimpleLogicalObjectInterface[])aLogicalObjects);
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        catch (LogicalTypeException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public static void doPaste() {
        try {
            TransportUtil.doPaste(TransportUtil.getRootFolder());
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        catch (LogicalTypeException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)ex);
        }
    }

    public static void doPaste(SimpleObject folder) {
        try {
            FolderInterface target = (FolderInterface)ObjectConverter.getInstance().convertToLogicalObject(folder);
            TransportUtil.doPaste(target);
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        catch (LogicalTypeException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public static void doPaste(SimpleObject folder, String sCategory) {
        TransportUtil.doPaste(folder);
        if (CopyPasteUtil.objectsWerePasted()) {
            TransportUtil.updateTransformationPaths(CopyPasteUtil.getObjectsPasted(), sCategory);
        }
    }

    private static void doPaste(FolderInterface target) throws RemoteException {
        String sTargetRepos = null;
        if (Workspace.getWorkspace().isChangeManagementOn()) {
            sTargetRepos = Workspace.getWorkspace().getProjectRepository().getFQID();
        }
        CopyPasteUtil.paste((FolderInterface)target, (TypeInterface[])m_aSupportedTypes, (String)sTargetRepos);
        if (CopyPasteUtil.objectsWerePasted()) {
            TransportUtil.generateObjectsModifiedEvent(CopyPasteUtil.getObjectsPasted());
        }
    }

    public static void doPasteSpecial() {
        try {
            TransportUtil.doPasteSpecial(TransportUtil.getRootFolder());
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        catch (LogicalTypeException ex) {
            int status = Workspace.getWorkspace().checkMetadataServerStatus(true);
            if (status != Workspace.SERVERSTATUS_RECONNECTED) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)ex);
        }
    }

    public static void doPasteSpecial(SimpleObject folder) {
        try {
            FolderInterface target = (FolderInterface)ObjectConverter.getInstance().convertToLogicalObject(folder);
            TransportUtil.doPasteSpecial(target);
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        catch (LogicalTypeException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public static void doPasteSpecial(SimpleObject folder, String sCategory) {
        TransportUtil.doPasteSpecial(folder);
        if (CopyPasteUtil.objectsWerePasted()) {
            TransportUtil.updateTransformationPaths(CopyPasteUtil.getObjectsPasted(), sCategory);
        }
    }

    private static void doPasteSpecial(FolderInterface target) throws RemoteException {
        String sTargetRepos = null;
        if (Workspace.getWorkspace().isChangeManagementOn()) {
            sTargetRepos = Workspace.getWorkspace().getProjectRepository().getFQID();
        }
        CopyPasteUtil.pasteSpecial((FolderInterface)target, (TypeInterface[])m_aSupportedTypes, (String)sTargetRepos);
        if (CopyPasteUtil.objectsWerePasted()) {
            TransportUtil.generateObjectsModifiedEvent(CopyPasteUtil.getObjectsPasted());
        }
    }

    private static FolderInterface getRootFolder() throws LogicalTypeException, MdException, RemoteException, ServiceException {
        ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
        Root bipService = (Root)server.getRootFolder().getRepositoryEntity();
        return (FolderInterface)ObjectConverter.getInstance().convertToLogicalObject(bipService);
    }

    public static void generateObjectsModifiedEvent(Map mapNewObjects) throws RemoteException {
        MdFactory factory = Workspace.getMdFactory();
        factory.fireMdObjectsModified(new MdFactoryEvent(factory, mapNewObjects));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateTransformationPaths(Map mapObjects, String sCategory) {
        try {
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "WAdminTree_Process:updateTransformationPaths");
            try {
                ArrayList lObjectIDs = new ArrayList(mapObjects.keySet());
                for (String sFQID : lObjectIDs) {
                    String sType = (String)mapObjects.get(sFQID);
                    if (!"Prototype".equals(sType)) continue;
                    Root transform = (Root)Workspace.getMdFactory().createComplexMetadataObject(store, null, sType, sFQID);
                    GeneratedTransformationUtilities.setProcessTreePath((Root)transform, (String)sCategory);
                }
                store.updatedMetadataAll();
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    static {
        try {
            m_aSupportedTypes = Factory.getInstance().getTypesSupported();
        }
        catch (LogicalTypeException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }
}

