/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.app;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdFactoryListener;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleObjectImpl;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ObjectConverter {
    private static ObjectConverter s_instance;
    private Map m_mapObjects = new HashMap();
    private boolean m_bListening = false;
    private MetadataFactoryListener m_listener;

    private ObjectConverter() {
    }

    public static ObjectConverter getInstance() {
        if (s_instance == null) {
            s_instance = new ObjectConverter();
        }
        return s_instance;
    }

    public void clearObjectCache() {
        this.m_mapObjects.clear();
        try {
            Workspace.getMdFactory().removeMdFactoryListener((MdFactoryListener)this.m_listener);
            this.m_bListening = false;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public SimpleObject convertToSimpleObject(PrimaryType mdo) throws RemoteException {
        String sID = mdo.getFQID();
        String sName = mdo.getName();
        String sMetadataType = mdo.getCMetadataType();
        String sPublicType = mdo.getPublicType();
        if (sName.length() == 0) {
            throw new IllegalArgumentException("Name in JOMA object is not populated=" + mdo);
        }
        if (sPublicType.length() == 0) {
            throw new IllegalArgumentException("PublicType in JOMA object is not populated=" + mdo);
        }
        return new SimpleObjectImpl(sName, sID, sMetadataType, sPublicType);
    }

    public Root convertToJOMAObject(MdObjectStore store, SimpleObject obj) throws MdException, RemoteException {
        return this.convertToJOMAObject(store, obj, null);
    }

    public Root convertToJOMAObject(MdObjectStore store, SimpleObject obj, String sTemplate) throws MdException, RemoteException {
        Root mdo;
        String sType = obj.getMetadataType();
        String sFQID = obj.getID();
        String sName = obj.getName();
        String sTemplateToPassIn = "";
        int iOptionsToPassIn = 8;
        if (sTemplate != null && sTemplate.length() > 0) {
            sTemplateToPassIn = sTemplate;
            iOptionsToPassIn |= 4;
        }
        if (!(mdo = (Root)Workspace.getMdFactory().createComplexMetadataObject(store, sName, sType, sFQID)).isNewObject()) {
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)mdo, null, null, sTemplateToPassIn, iOptionsToPassIn);
        }
        return mdo;
    }

    public Root[] convertToJOMAObjects(MdObjectStore store, SimpleObject[] aObjects) throws MdException, RemoteException {
        Root[] aJOMAObjects = new Root[aObjects.length];
        for (int iObject = 0; iObject < aObjects.length; ++iObject) {
            aJOMAObjects[iObject] = this.convertToJOMAObject(store, aObjects[iObject]);
        }
        return aJOMAObjects;
    }

    public LogicalObjectInterface convertToLogicalObject(SimpleObject obj) throws RemoteException, MdException, LogicalTypeException {
        LogicalObjectInterface lob = (LogicalObjectInterface)this.m_mapObjects.get(obj.getID());
        if (lob != null) {
            return lob;
        }
        return this.createLogicalObjects(new SimpleObject[]{obj})[0];
    }

    public LogicalObjectInterface convertToLogicalObject(Root mdo) throws RemoteException, MdException, LogicalTypeException {
        LogicalObjectInterface lob = (LogicalObjectInterface)this.m_mapObjects.get(mdo.getFQID());
        if (lob != null) {
            return lob;
        }
        return this.createLogicalObjects(new Root[]{mdo})[0];
    }

    public LogicalObjectInterface[] convertToLogicalObjects(Object[] aObjects) throws RemoteException, MdException, LogicalTypeException {
        SimpleObject[] aSimples = new SimpleObject[aObjects.length];
        System.arraycopy(aObjects, 0, aSimples, 0, aObjects.length);
        return this.convertToLogicalObjects(aSimples);
    }

    public LogicalObjectInterface[] convertToLogicalObjects(SimpleObject[] aObjects) throws RemoteException, MdException, LogicalTypeException {
        ArrayList<SimpleObject> lUnfoundObjects = new ArrayList<SimpleObject>();
        LogicalObjectInterface[] aLOBs = new LogicalObjectInterface[aObjects.length];
        for (int iObject = 0; iObject < aObjects.length; ++iObject) {
            if (!aObjects[iObject].isPublicObject()) continue;
            aLOBs[iObject] = (LogicalObjectInterface)this.m_mapObjects.get(aObjects[iObject].getID());
            if (aLOBs[iObject] != null) continue;
            lUnfoundObjects.add(aObjects[iObject]);
        }
        if (lUnfoundObjects.isEmpty()) {
            return aLOBs;
        }
        SimpleObject[] aNewObjects = lUnfoundObjects.toArray(new SimpleObject[lUnfoundObjects.size()]);
        LogicalObjectInterface[] aNewLOBs = this.createLogicalObjects(aNewObjects);
        int iNewLOB = 0;
        for (int iObject = 0; iObject < aObjects.length; ++iObject) {
            if (aLOBs[iObject] != null || !aObjects[iObject].isPublicObject()) continue;
            aLOBs[iObject] = aNewLOBs[iNewLOB++];
        }
        return aLOBs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogicalObjectInterface[] createLogicalObjects(SimpleObject[] aObjects) throws MdException, RemoteException, LogicalTypeException {
        MdFactory factory = Workspace.getMdFactory();
        MdObjectStore store = factory.createObjectStore(null, "ObjectConverter");
        try {
            Root[] aJOMAObjects = this.convertToJOMAObjects(store, aObjects);
            LogicalObjectInterface[] logicalObjectInterfaceArray = this.createLogicalObjects(aJOMAObjects);
            return logicalObjectInterfaceArray;
        }
        finally {
            store.dispose();
        }
    }

    private LogicalObjectInterface[] createLogicalObjects(Root[] aObjects) throws MdException, RemoteException, LogicalTypeException {
        if (!this.m_bListening) {
            this.installListeners();
            this.m_bListening = true;
        }
        LogicalObjectInterface[] aLOBs = new LogicalObjectInterface[aObjects.length];
        for (int iObject = 0; iObject < aObjects.length; ++iObject) {
            LogicalObjectInterface lob;
            aLOBs[iObject] = lob = Factory.getInstance().getObject(aObjects[iObject]);
            this.m_mapObjects.put(aObjects[iObject].getFQID(), lob);
        }
        return aLOBs;
    }

    private void populateStore(MdStore store, Root[] aObjects) throws LogicalTypeException, MdException, RemoteException {
        StringBuffer sbXML = new StringBuffer();
        int fFlags = 256;
        for (int iObject = 0; iObject < aObjects.length; ++iObject) {
            Root mdo = aObjects[iObject];
            if (mdo.isNewObject()) continue;
            sbXML.append("<");
            sbXML.append(mdo.getCMetadataType());
            sbXML.append(" Id=\"");
            sbXML.append(mdo.getFQID());
            sbXML.append("\" Name=\"\" ChangeState=\"\" LockedBy=\"\" UsageVersion=\"\" PublicType=\"\" ></");
            sbXML.append(mdo.getCMetadataType());
            sbXML.append(">");
        }
        if (sbXML.length() == 0) {
            return;
        }
        Workspace.getMdFactory().getOMIUtil().getMetadataObjects(store, sbXML.toString(), null, fFlags);
    }

    private void installListeners() {
        try {
            if (this.m_listener == null) {
                this.m_listener = new MetadataFactoryListener();
            }
            Workspace.getMdFactory().addMdFactoryListener((MdFactoryListener)this.m_listener);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateModifiedObjects(Map mapObjects) {
        Set setKeys = mapObjects.keySet();
        String[] aKeys = setKeys.toArray(new String[setKeys.size()]);
        ArrayList lObjects = new ArrayList();
        for (int iKey = 0; iKey < aKeys.length; ++iKey) {
            Object obj = this.m_mapObjects.get(aKeys[iKey]);
            if (obj == null) continue;
            lObjects.add(obj);
        }
        if (lObjects.isEmpty()) {
            return;
        }
        MdFactory factory = Workspace.getMdFactory();
        try {
            MdObjectStore store = factory.createObjectStore(null, "updateModifiedObjects");
            try {
                LogicalObjectInterface lob;
                int iObject;
                Root[] aMDOs = new Root[lObjects.size()];
                for (iObject = 0; iObject < lObjects.size(); ++iObject) {
                    lob = (LogicalObjectInterface)lObjects.get(iObject);
                    aMDOs[iObject] = (Root)factory.createComplexMetadataObject(store, "", lob.getTypeInterface().getMetadataType(), lob.getID());
                }
                this.populateStore((MdStore)store, aMDOs);
                for (iObject = 0; iObject < lObjects.size(); ++iObject) {
                    lob = (LogicalObjectInterface)lObjects.get(iObject);
                    lob.refresh(aMDOs[iObject]);
                }
            }
            catch (LogicalTypeException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    private void removeDeletedObjects(String[] aObjectIDs) {
        for (int iObjectID = 0; iObjectID < aObjectIDs.length; ++iObjectID) {
            this.m_mapObjects.remove(aObjectIDs[iObjectID]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PathUrl[] convertToPathURLs(SimpleObject[] aObjects) throws ServiceException, RemoteException {
        PathUrl[] aPaths = new PathUrl[aObjects.length];
        ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
        ChildServerInterface transaction = server.newChild(true);
        try {
            for (int i = 0; i < aObjects.length; ++i) {
                SimpleObject object = aObjects[i];
                MetadataInterface metadata = transaction.fetch(object.getID() + "/" + object.getMetadataType(), true);
                aPaths[i] = metadata.getPathUrl();
            }
        }
        finally {
            transaction.destroy();
        }
        return aPaths;
    }

    private class MetadataFactoryListener
    implements MdFactoryListener {
        private MetadataFactoryListener() {
        }

        public void MdObjectsCreated(MdFactoryEvent ev) {
        }

        public void MdObjectsModified(MdFactoryEvent ev) {
            ObjectConverter.this.updateModifiedObjects(ev.getObjectMap());
        }

        public void MdObjectsDeleted(MdFactoryEvent ev) {
            ObjectConverter.this.removeDeletedObjects(ev.getObjectIDs());
        }
    }
}

