/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.app;

import com.sas.etl.models.IComplexPersistableObject;
import com.sas.etl.models.IExtendedAttributesContainer;
import com.sas.etl.models.IModel;
import com.sas.etl.models.INotesAndDocumentsContainer;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.data.IExternalTable;
import com.sas.etl.models.data.IParametersContainer;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.BaseModel;
import com.sas.etl.models.job.ICodeGenerator;
import com.sas.etl.models.job.IConditionActionSetContainer;
import com.sas.etl.models.job.IJob;
import com.sas.etl.models.job.IPrePostCode;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.SmartObjectFactoryInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.unknown.UnknownType;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.app.PropertyTabFactoryPluginInterface;
import com.sas.wadmin.app.actions.UpgradeLogicalObjectAction;
import com.sas.wadmin.efi2.ExternalFileParametersTab2;
import com.sas.wadmin.efi2.ExternalFileTab2;
import com.sas.wadmin.efi2.ExternalTableColumnsTab;
import com.sas.wadmin.efi2.UserWrittenExternalTablePanel2;
import com.sas.wadmin.visuals.DocumentView;
import com.sas.wadmin.visuals.ExternalTableView;
import com.sas.wadmin.visuals.FolderPropertiesView;
import com.sas.wadmin.visuals.JobView;
import com.sas.wadmin.visuals.LogicalObjectPropertiesView;
import com.sas.wadmin.visuals.MacroPluginPropertiesView;
import com.sas.wadmin.visuals.PhysicalTableView;
import com.sas.wadmin.visuals.SASLibraryView;
import com.sas.wadmin.visuals.TextStoreView;
import com.sas.wadmin.visuals.WAExtAttrPropertyTab;
import com.sas.wadmin.visuals.common.ColumnsTab;
import com.sas.wadmin.visuals.common.ConditionActionsTab;
import com.sas.wadmin.visuals.common.ExtendedAttributesTab;
import com.sas.wadmin.visuals.common.GeneralTab;
import com.sas.wadmin.visuals.common.IndexesTab;
import com.sas.wadmin.visuals.common.KeysTab;
import com.sas.wadmin.visuals.common.ModelUndoManager;
import com.sas.wadmin.visuals.common.NotesTab;
import com.sas.wadmin.visuals.common.OptionsTab;
import com.sas.wadmin.visuals.common.ParameterTab;
import com.sas.wadmin.visuals.common.PhysicalStorageTab;
import com.sas.wadmin.visuals.common.PrePostCodeTab;
import com.sas.wadmin.visuals.common.ProcessTab;
import com.sas.wadmin.visuals.common.TableOptionsTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAPropertyTabGroup;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATabbedPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceOMAView;
import com.sas.workspace.WsLockManager;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.plugins.MetadataVisualsPluginInterface;
import com.sas.workspace.plugins.PluginViewInterface;
import com.sas.workspace.visuals.WsGenericGeneralPropertyTab;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class AppPropertiesDialogFactory {
    private static final WAdminResource bundle = WAdminResource.getBundle(AppPropertiesDialogFactory.class);
    private static AppPropertiesDialogFactory s_instance;
    private static final String SHOW_ADVANCED_TABS_KEY = "Workspace.ShowAdvancedPropertyTabs";
    private static final String MAXIMUM_UNDOS_KEY = "AppPropertiesDialogFactory.MaximumUndos";

    public static void setUserPreferenceToShowAdvancedTabs(boolean bShowAdvancedTabs) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(SHOW_ADVANCED_TABS_KEY, bShowAdvancedTabs);
    }

    public static boolean isUserPreferenceToShowAdvancedTabs() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(SHOW_ADVANCED_TABS_KEY, true);
    }

    public static void setUserPreferenceForUndoLimit(int nUndos) {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyInt(MAXIMUM_UNDOS_KEY, nUndos);
    }

    public static int getUserPreferenceForUndoLimit() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyInt(MAXIMUM_UNDOS_KEY, 50);
    }

    public static void setInstance(AppPropertiesDialogFactory instance) {
        s_instance = instance;
    }

    public static AppPropertiesDialogFactory getInstance() {
        return s_instance;
    }

    public int showPropertiesDialog(Window wdwParent, SimpleObject object) {
        String sType = object.getPublicType();
        if (!UpgradeLogicalObjectAction.isVersionSupported(object)) {
            return -1;
        }
        if ("Table".equals(sType) || "ExternalFile".equals(sType) || "Job".equals(sType)) {
            return this.showNewPropertiesDialog(wdwParent, object);
        }
        return this.showOldPropertiesDialog(wdwParent, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int showPropertiesDialog(Window wdwParent, IModel model, IComplexPersistableObject object) {
        String publicType = object.getPublicType();
        if (!UpgradeLogicalObjectAction.isVersionSupported(publicType, object)) {
            return -1;
        }
        UndoManager mgrOld = model.getUndoManager();
        ModelUndoManager mgrNew = new ModelUndoManager();
        model.setUndoManager((UndoManager)((Object)mgrNew));
        try {
            int eRC = this.showModelPropertiesDialog(wdwParent, object, false);
            ((UndoManager)((Object)mgrNew)).end();
            if (((UndoManager)((Object)mgrNew)).canUndo()) {
                if (eRC == 1) {
                    mgrOld.addEdit((UndoableEdit)((Object)mgrNew));
                } else {
                    ((UndoManager)((Object)mgrNew)).undo();
                }
            }
            int n = eRC;
            return n;
        }
        finally {
            model.setUndoManager(mgrOld);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int showNewPropertiesDialog(Window wdwParent, SimpleObject object) {
        wdwParent.setCursor(Cursor.getPredefinedCursor(3));
        try {
            IComplexPersistableObject obj = this.createModelObject(object);
            try {
                if (this.loadModelObject((IObject)obj)) {
                    int n = this.showModelPropertiesDialog(wdwParent, obj, true);
                    return n;
                }
            }
            finally {
                obj.getModel().dispose();
            }
        }
        finally {
            wdwParent.setCursor(Cursor.getDefaultCursor());
        }
        return -1;
    }

    private int showModelPropertiesDialog(Window wdwParent, IComplexPersistableObject object, boolean bPrimary) {
        WAPanel pnlMain = this.createMainPanel((IObject)object);
        if (pnlMain != null) {
            PropertiesDialog dlg = wdwParent instanceof JFrame ? new PropertiesDialog((JFrame)wdwParent, (IObject)object, pnlMain, bPrimary) : new PropertiesDialog((JDialog)wdwParent, (IObject)object, pnlMain, bPrimary);
            dlg.setResizable(true);
            dlg.setMainPanel(pnlMain);
            dlg.setUndoManager(object.getModel().getUndoManager());
            dlg.setSettingsName(object.getPublicType());
            boolean bEditable = bPrimary ? !(!object.getModel().isEditable() || "Job".equals(object.getPublicType()) && WsLockManager.getInstance().isLocked(object.getID())) : object.getModel().isEditable() && Workspace.isObjectEditable((SimpleObject)object);
            dlg.setEditable(bEditable);
            dlg.show();
            return dlg.getReturnValue();
        }
        return -1;
    }

    private IComplexPersistableObject createModelObject(SimpleObject obj) {
        IPhysicalTable object;
        boolean bEditable = Workspace.isObjectEditable((SimpleObject)obj);
        BaseModel mdl = new BaseModel();
        mdl.setDebugName(obj.getName() + " Properties");
        mdl.setEditable(bEditable);
        mdl.setUndoSupported(bEditable);
        String sType = obj.getPublicType();
        if ("Table".equals(sType)) {
            object = mdl.getObjectFactory().createPhysicalTable(obj.getID());
        } else if ("ExternalFile".equals(sType)) {
            object = mdl.getObjectFactory().createExternalTable(obj.getID());
        } else if ("Job".equals(sType)) {
            object = mdl.getObjectFactory().createJob(obj.getID());
        } else {
            throw new UnsupportedOperationException("Unsupported type for createModel: " + sType);
        }
        object.setName(obj.getName());
        object.setChanged(false);
        mdl.setMainObject((IPersistableObject)object);
        mdl.setUndoManager((UndoManager)((Object)new ModelUndoManager()));
        mdl.getUndoManager().setLimit(AppPropertiesDialogFactory.getUserPreferenceForUndoLimit());
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadModelObject(IObject obj) {
        IModel mdl = obj.getModel();
        mdl.setModelEventsEnabled(false);
        try {
            LoadRunnable run = new LoadRunnable(mdl);
            OpRequestUI op = new OpRequestUI();
            op.setTitle(obj.getName());
            op.setMessage(bundle.getString("AppPropertiesDialogFactory.Loading.Title.txt"));
            op.execute((Runnable)run);
            boolean bl = run.wasSuccessful();
            return bl;
        }
        finally {
            mdl.setModelEventsEnabled(true);
        }
    }

    private WAPanel createMainPanel(IObject obj) {
        if (obj instanceof IPhysicalTable) {
            return this.createPhysicalTableMainPanel((IPhysicalTable)obj);
        }
        if (obj instanceof IExternalTable) {
            return this.createExternalTableMainPanel((IExternalTable)obj);
        }
        if (obj instanceof IJob) {
            return this.createJobMainPanel((IJob)obj);
        }
        throw new UnsupportedOperationException("Unsupported type for createMainPanel: " + obj + " (" + obj.getClass() + ")");
    }

    private WAPanel createJobMainPanel(IJob job) {
        IPromptModel mdlOptions = null;
        try {
            mdlOptions = job.getOptionModel();
        }
        catch (FileNotFoundException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage());
        }
        catch (RemoteException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage());
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)ex);
        }
        catch (ServerConnectionException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage());
        }
        catch (IOException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage());
        }
        catch (ParserConfigurationException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage());
        }
        catch (SAXException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage());
        }
        catch (MdException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage());
        }
        if (mdlOptions == null) {
            return null;
        }
        WATabbedPanel pnlTabs = new WATabbedPanel();
        pnlTabs.setUndoManager(job.getModel().getUndoManager());
        pnlTabs.addTab((WAPropertyTab)new GeneralTab((IObject)job, true, true));
        pnlTabs.addTab((WAPropertyTab)new ProcessTab((ICodeGenerator)job, false, false));
        pnlTabs.addTab((WAPropertyTab)new PrePostCodeTab((IPrePostCode)job));
        pnlTabs.addTab((WAPropertyTab)new ConditionActionsTab((IConditionActionSetContainer)job));
        pnlTabs.addTab((WAPropertyTab)new ParameterTab((IParametersContainer)job, true, ParameterTab.DEFAULT_PARAMETER_HELPID, null));
        pnlTabs.addTab((WAPropertyTab)new OptionsTab(mdlOptions, "options_tab_job", false));
        pnlTabs.addTab((WAPropertyTab)new NotesTab((INotesAndDocumentsContainer)job));
        this.addAdvancedTabs(pnlTabs, (IComplexPersistableObject)job);
        this.addPluginTabs(pnlTabs, (IComplexPersistableObject)job);
        return pnlTabs;
    }

    private WAPanel createPhysicalTableMainPanel(IPhysicalTable table) {
        PropertyTabsPanel pnlTabs = new PropertyTabsPanel();
        pnlTabs.setUndoManager(table.getModel().getUndoManager());
        pnlTabs.addTab(new GeneralTab((IObject)table, true, true));
        pnlTabs.addTab(new ColumnsTab((ITable)table));
        pnlTabs.addTab(new IndexesTab(table));
        pnlTabs.addTab(new KeysTab(table));
        pnlTabs.addTab(new ParameterTab((IParametersContainer)table));
        pnlTabs.addTab(new PhysicalStorageTab(table));
        pnlTabs.addTab(new TableOptionsTab(table));
        pnlTabs.addTab(new NotesTab((INotesAndDocumentsContainer)table));
        this.addAdvancedTabs(pnlTabs, (IComplexPersistableObject)table);
        this.addPluginTabs(pnlTabs, (IComplexPersistableObject)table);
        return pnlTabs;
    }

    private WAPanel createExternalTableMainPanel(IExternalTable table) {
        WATabbedPanel pnlTabs = new WATabbedPanel();
        pnlTabs.setUndoManager(table.getModel().getUndoManager());
        pnlTabs.addTab((WAPropertyTab)new GeneralTab((IObject)table, true, true));
        if (!table.isUsingUserWrittenCode()) {
            pnlTabs.addTab((WAPropertyTab)new ExternalFileTab2(table));
            pnlTabs.addTab((WAPropertyTab)new ExternalFileParametersTab2(table));
        } else {
            pnlTabs.addTab((WAPropertyTab)new UserWrittenExternalTablePanel2(table));
        }
        pnlTabs.addTab((WAPropertyTab)new ExternalTableColumnsTab(table));
        pnlTabs.addTab((WAPropertyTab)new ParameterTab((IParametersContainer)table));
        pnlTabs.addTab((WAPropertyTab)new NotesTab((INotesAndDocumentsContainer)table));
        this.addAdvancedTabs(pnlTabs, (IComplexPersistableObject)table);
        this.addPluginTabs(pnlTabs, (IComplexPersistableObject)table);
        return pnlTabs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int showOldPropertiesDialog(Window wdwParent, SimpleObject object) {
        ChildServerInterface transaction;
        String sTitle = bundle.formatString("AppPropertiesDialogFactory.PropertiesDialog.Title.fmt", (Object)object.getName());
        WAPropertyDialog dlg = wdwParent instanceof JFrame ? new WAPropertyDialog((Frame)((JFrame)wdwParent), sTitle, true) : new WAPropertyDialog((Dialog)((JDialog)wdwParent), sTitle, true);
        dlg.setResizable(true);
        wdwParent.setCursor(Cursor.getPredefinedCursor(3));
        LogicalObjectInterface lob = ObjectConverter.getInstance().convertToLogicalObject(object);
        if (lob != null && Factory.getInstance().isSmartObjectBasedDialog(lob)) {
            SmartObjectFactoryInterface factory = (SmartObjectFactoryInterface)lob.getTypeInterface().getObjectFactory();
            transaction = Workspace.getWorkspace().getConnectionManager().getMetadataServer().newChild(true);
            String sKey = lob.getID() + "/" + lob.getTypeInterface().getMetadataType();
            MetadataInterface mdiObject = transaction.fetch(sKey, true);
            dlg.setMetadataServiceObject(mdiObject);
            dlg.setMainPanel(this.createMetadataServiceObjectMainPanel(lob, factory, mdiObject, transaction));
            dlg.setSettingsName(lob.getTypeInterface().getPublicType());
            dlg.show();
            transaction = null;
            int n = dlg.getReturnValue();
            return n;
        }
        MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, sTitle);
        {
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
                return -1;
            }
            catch (LogicalTypeException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
                return -1;
            }
            catch (ServiceException ex) {
                Workspace.handleServiceException((ServiceException)ex);
                return -1;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
                return -1;
            }
            try {
                LogicalObjectPropertiesView view;
                Root mdo = ObjectConverter.getInstance().convertToJOMAObject(store, object);
                dlg.setMetadataObject((CMetadata)mdo);
                String sType = object.getPublicType();
                if ("Table".equals(sType)) {
                    this.addTabsFromView(dlg, new PhysicalTableView(), mdo);
                } else if ("Job".equals(sType)) {
                    this.addTabsFromView(dlg, new JobView(), mdo);
                } else if ("ExternalFile".equals(sType)) {
                    this.addTabsFromView(dlg, new ExternalTableView(), mdo);
                } else if ("Library".equals(sType)) {
                    this.addTabsFromView(dlg, new SASLibraryView(), mdo);
                } else if ("Note".equals(sType)) {
                    this.addTabsFromView(dlg, new TextStoreView(), mdo);
                } else if ("Document".equals(sType)) {
                    this.addTabsFromView(dlg, new DocumentView(), mdo);
                } else if ("GeneratedTransform".equals(sType)) {
                    dlg.setEditable(dlg.isEditable() && this.isOKToEditGeneratedTransformation(object));
                    this.addTabsFromView(dlg, new MacroPluginPropertiesView(), mdo);
                } else if ("Folder".equals(sType)) {
                    view = new FolderPropertiesView();
                    view.setMetadata(mdo);
                    view.setLogicalObject(lob);
                    dlg.setMainPanel(view.createMainPanel());
                    this.addPluginTabs(dlg, mdo);
                } else {
                    if (lob == null) {
                        TypeInterface unknown = UnknownType.getInstance((Factory)Factory.getInstance());
                        lob = unknown.getObjectFactory().createItemFromMetadataObject(mdo);
                    }
                    view = new LogicalObjectPropertiesView();
                    view.setMetadata(mdo);
                    view.setLogicalObject(lob);
                    dlg.setMainPanel(view.createMainPanel());
                    this.addPluginTabs(dlg, mdo);
                }
                dlg.setSettingsName(sType);
                dlg.show();
                int n = dlg.getReturnValue();
                return n;
            }
            finally {
                store.dispose();
                Workspace.getWorkspace().getMdObjectFactory().dumpDetailHashMap();
            }
        }
        finally {
            if (transaction != null) {
                transaction.destroy();
            }
        }
        finally {
            wdwParent.setCursor(Cursor.getDefaultCursor());
        }
    }

    private WAPanel createMetadataServiceObjectMainPanel(LogicalObjectInterface lob, SmartObjectFactoryInterface factory, MetadataInterface mdiObject, ChildServerInterface transaction) throws ServiceException, RemoteException, MdException {
        PropertyTabsPanel pnlTabs = new PropertyTabsPanel();
        Root mdoOjbect = (Root)mdiObject.getRepositoryEntity();
        List tabs = factory.getPropertyTabs(lob, transaction, mdiObject, mdoOjbect, null);
        for (WAPropertyTab tab : tabs) {
            if (!AppPropertiesDialogFactory.isUserPreferenceToShowAdvancedTabs() && (tab instanceof WsGenericGeneralPropertyTab || tab instanceof WAExtAttrPropertyTab)) continue;
            pnlTabs.addTab(tab.getName(), tab);
        }
        if (AppPropertiesDialogFactory.isUserPreferenceToShowAdvancedTabs()) {
            this.addAuthorizationPluginTab((WATabbedPanel)pnlTabs, mdoOjbect);
        }
        return pnlTabs;
    }

    private void addTabsFromView(WAPropertyDialog dlg, WorkspaceOMAView view, Root mdo) {
        view.setMetadata(mdo);
        WAPropertyTabGroup tabs = view.createView();
        for (int iTab = 0; iTab < tabs.getTabCount(); ++iTab) {
            dlg.addTab(tabs.getTitleAt(iTab), tabs.getTabAt(iTab));
        }
        this.addPluginTabs(dlg, mdo);
    }

    private void addPluginTabs(WAPropertyDialog dlg, Root mdo) {
        List lPlugins = Workspace.getWorkspace().getPluginLoader().getPlugins(MetadataVisualsPluginInterface.class);
        for (int iPlugin = 0; iPlugin < lPlugins.size(); ++iPlugin) {
            MetadataVisualsPluginInterface plugTabs = (MetadataVisualsPluginInterface)lPlugins.get(iPlugin);
            ArrayList lTabs = plugTabs.getPropertyTabs((CMetadata)mdo);
            if (lTabs == null) continue;
            for (int iTab = 0; iTab < lTabs.size(); ++iTab) {
                WAPropertyTab tab = (WAPropertyTab)lTabs.get(iTab);
                dlg.addTab(tab.getTitle(), tab.getIcon(), tab, tab.getToolTipText());
            }
        }
    }

    private boolean isOKToEditGeneratedTransformation(SimpleObject transform) {
        if (WsLockManager.getInstance().isLocked(transform.getID())) {
            String sName = transform.getName();
            String sMessage = bundle.formatString("AppPropertiesDialogFactory.Message.GeneratedTransformation.fmt.txt", (Object)sName);
            MessageUtil.displayMessage((String)sMessage, (String)sName, (int)1);
            return false;
        }
        return true;
    }

    private void addAdvancedTabs(WATabbedPanel pnlTabs, IComplexPersistableObject obj) {
        if (!AppPropertiesDialogFactory.isUserPreferenceToShowAdvancedTabs()) {
            return;
        }
        pnlTabs.addTab((WAPropertyTab)new ExtendedAttributesTab((IExtendedAttributesContainer)obj));
        this.addAuthorizationPluginTab(pnlTabs, (IPersistableObject)obj);
    }

    public void addPluginTabs(WATabbedPanel pnlTabs, IComplexPersistableObject obj) {
        List lPlugins = Workspace.getWorkspace().getPluginLoader().getPlugins(PropertyTabFactoryPluginInterface.class);
        for (int iPlugin = 0; iPlugin < lPlugins.size(); ++iPlugin) {
            PropertyTabFactoryPluginInterface plugin = (PropertyTabFactoryPluginInterface)lPlugins.get(iPlugin);
            WAPropertyTab[] aTabs = plugin.createTabs(obj);
            if (aTabs == null) continue;
            for (int iTab = 0; iTab < aTabs.length; ++iTab) {
                pnlTabs.addTab(aTabs[iTab]);
            }
        }
    }

    private void addAuthorizationPluginTab(WATabbedPanel pnlTabs, IPersistableObject obj) {
        try {
            Root mdo = ((BaseModel)obj.getModel()).getOMRObject(obj, Workspace.getMdFactory());
            this.addAuthorizationPluginTab(pnlTabs, mdo);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    private void addAuthorizationPluginTab(WATabbedPanel pnlTabs, Root mdo) {
        ArrayList lPlugins = Workspace.getWorkspace().getPluginLoader().getPlugins("com.sas.wadmin.plugins.authtab.AuthorizationTabPluginInterface", true);
        for (int iPlugin = 0; iPlugin < lPlugins.size(); ++iPlugin) {
            PluginViewInterface plugin = (PluginViewInterface)lPlugins.get(iPlugin);
            ArrayList lTabs = plugin.getPropertyTabs((CMetadata)mdo);
            if (lTabs == null) continue;
            for (int iTab = 0; iTab < lTabs.size(); ++iTab) {
                pnlTabs.addTab((WAPropertyTab)lTabs.get(iTab));
            }
        }
    }

    private static abstract class AbstractWasSuccessfulRunnable
    implements Runnable {
        private boolean m_bSuccessful;

        private AbstractWasSuccessfulRunnable() {
        }

        public boolean wasSuccessful() {
            return this.m_bSuccessful;
        }

        protected void setSuccessful(boolean bSuccessful) {
            this.m_bSuccessful = bSuccessful;
        }
    }

    private static class SaveRunnable
    extends AbstractWasSuccessfulRunnable {
        private IModel m_mdl;

        public SaveRunnable(IModel mdl) {
            this.m_mdl = mdl;
        }

        @Override
        public void run() {
            this.setSuccessful(false);
            try {
                this.m_mdl.saveToOMR(Workspace.getMdFactory());
                this.setSuccessful(true);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)new MdException((Throwable)ex), (String)"Writing");
            }
        }
    }

    private static class LoadRunnable
    extends AbstractWasSuccessfulRunnable {
        private IModel m_mdl;

        public LoadRunnable(IModel mdl) {
            this.m_mdl = mdl;
        }

        @Override
        public void run() {
            this.setSuccessful(false);
            try {
                this.m_mdl.loadFromOMR(Workspace.getMdFactory());
                this.setSuccessful(true);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)new MdException((Throwable)ex), (String)"Reading");
            }
        }
    }

    private static class PropertiesDialog
    extends WAStandardDialog {
        private IObject m_object;
        private boolean m_bSaveModel;

        public PropertiesDialog(Dialog dlgOwner, IObject object, WAPanel pnlMain, boolean bPrimary) {
            super(dlgOwner, bundle.formatString("AppPropertiesDialogFactory.PropertiesDialog.Title.fmt", (Object)object.getName()), true, pnlMain);
            this.m_object = object;
            this.m_bSaveModel = bPrimary;
        }

        public PropertiesDialog(Frame frmOwner, IObject object, WAPanel pnlMain, boolean bPrimary) {
            super(frmOwner, bundle.formatString("AppPropertiesDialogFactory.PropertiesDialog.Title.fmt", (Object)object.getName()), true, pnlMain);
            this.m_object = object;
            this.m_bSaveModel = bPrimary;
        }

        protected boolean doDataExchange(boolean bSaveToModel) {
            try {
                if (bSaveToModel) {
                    this.getMainPanel().moveDataToStore();
                    if (this.hasDataChanged() && this.m_bSaveModel) {
                        this.saveModelObject();
                    }
                } else {
                    this.getMainPanel().populateStore();
                    this.getMainPanel().moveDataToView();
                }
                return true;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            catch (MdException ex) {
                String sAccess = bSaveToModel ? "Writing" : "Reading";
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)sAccess);
            }
            return false;
        }

        private boolean saveModelObject() {
            SaveRunnable run = new SaveRunnable(this.m_object.getModel());
            OpRequestUI op = new OpRequestUI();
            op.setTitle(this.m_object.getName());
            op.setMessage(bundle.getString("AppPropertiesDialogFactory.Saving.Title.txt"));
            op.execute((Runnable)run);
            return run.wasSuccessful();
        }
    }

    private static class PropertyTabsPanel
    extends WATabbedPanel {
        private PropertyTabsPanel() {
        }

        protected void populateStoreWrapper(WAPropertyTab tab) {
            try {
                tab.populateStore();
                this.moveTabDataToView(tab);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
        }
    }
}

