/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.analysis;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractIconFactory;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsComponentPrinter;
import com.sas.workspace.WsComponentPrinterFactory;
import com.sas.workspace.WsTitledPageFormat;
import com.sas.workspace.WsUIUtilities;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.rmi.RemoteException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public abstract class AbstractImpactAnalysisTab
extends WAPropertyTab {
    private static final WAdminResource bundle = WAdminResource.getBundle(AbstractImpactAnalysisTab.class);
    public static final int USAGE = 0;
    public static final int DATA_FLOW = 1;
    public static final int DATA_LINEAGE = 2;
    private Root m_mdo;
    private int m_eAnalysisType;
    private JToolBar m_barTools;
    private JPanel m_pnlViews;
    private CardLayout m_cards;
    private WAPropertyTab m_tabReport;
    private WAPropertyTab m_tabGraph;
    private WAPropertyTab m_tabCurrent;
    private static final String REPORT = "Report";
    private static final String GRAPH = "Graph";
    private boolean m_bActive;

    public AbstractImpactAnalysisTab(Root mdo) {
        this.m_mdo = mdo;
        this.m_eAnalysisType = 0;
        this.initialize();
    }

    public AbstractImpactAnalysisTab(Root mdo, int eAnalysisType) {
        this.m_mdo = mdo;
        this.m_eAnalysisType = eAnalysisType;
        this.initialize();
    }

    protected Root getObject() {
        return this.m_mdo;
    }

    protected int getAnalysisType() {
        return this.m_eAnalysisType;
    }

    protected void initialize() {
        String sKey = this.m_eAnalysisType == 1 ? "AbstractImpactAnalysisTab.Name.DataFlow.txt" : (this.m_eAnalysisType == 2 ? "AbstractImpactAnalysisTab.Name.DataLineage.txt" : "AbstractImpactAnalysisTab.Name.Usage.txt");
        this.setName(bundle.getString(sKey));
        JButton btnReport = WsUIUtilities.createFlatToggleToolButton((WsAbstractToggleAction)new ReportAction());
        JButton btnGraph = WsUIUtilities.createFlatToggleToolButton((WsAbstractToggleAction)new GraphAction());
        JButton btnPrint = WsUIUtilities.createFlatToolButton((WsAbstractAction)new PrintAction());
        ButtonGroup grp = new ButtonGroup();
        grp.add(btnReport);
        grp.add(btnGraph);
        btnReport.setSelected(true);
        this.m_barTools = WsUIUtilities.createToolBar();
        this.m_barTools.add(btnReport);
        this.m_barTools.add(btnGraph);
        this.m_barTools.addSeparator();
        this.m_barTools.add(btnPrint);
        this.m_tabReport = this.createReportComponent();
        this.m_tabGraph = this.createGraphComponent();
        this.m_cards = new CardLayout();
        this.m_pnlViews = new JPanel(this.m_cards);
        this.m_pnlViews.add((Component)this.m_tabReport, REPORT);
        this.m_pnlViews.add((Component)this.m_tabGraph, GRAPH);
        this.m_tabCurrent = this.m_tabReport;
        this.setLayout(new BorderLayout());
        this.add(this.m_barTools, "North");
        this.add(this.m_pnlViews, "Center");
        this.setHelpProduct("wdb");
        if (this.m_eAnalysisType == 1) {
            this.setHelpTopic("impact_analysis_win");
        } else {
            this.setHelpTopic("impact_analysis_rev");
        }
    }

    protected abstract WAPropertyTab createReportComponent();

    protected abstract WAPropertyTab createGraphComponent();

    public void populateStore() throws MdException, RemoteException {
        this.m_tabReport.populateStore();
        this.m_tabGraph.populateStore();
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        this.m_tabCurrent.updateWorkspaceUIComponents(bActive);
        this.m_bActive = bActive;
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.m_tabReport.moveDataToView();
    }

    public void saveSettingsAndCleanUp() {
        this.m_tabGraph.saveSettingsAndCleanUp();
        this.m_tabReport.saveSettingsAndCleanUp();
    }

    private void showGraph() {
        try {
            this.m_tabGraph.moveDataToView();
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        if (this.m_bActive) {
            this.m_tabCurrent.updateWorkspaceUIComponents(false);
        }
        this.m_cards.show(this.m_pnlViews, GRAPH);
        this.m_tabCurrent = this.m_tabGraph;
        if (this.m_bActive) {
            this.m_tabCurrent.updateWorkspaceUIComponents(true);
        }
    }

    private void showReport() {
        if (this.m_bActive) {
            this.m_tabCurrent.updateWorkspaceUIComponents(false);
        }
        this.m_cards.show(this.m_pnlViews, REPORT);
        this.m_tabCurrent = this.m_tabReport;
        if (this.m_bActive) {
            this.m_tabCurrent.updateWorkspaceUIComponents(true);
        }
    }

    protected void handlePrint() {
        PrinterJob pjob = PrinterJob.getPrinterJob();
        if (!Workspace.getWorkspace().isPrinterConnected(pjob)) {
            return;
        }
        String sTitle = " ";
        try {
            sTitle = bundle.formatString("AbstractImpactAnalysisTab.DefaultImpactPrintJobName.txt", (Object)this.m_mdo.getName());
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        pjob.setJobName(sTitle);
        WsTitledPageFormat pageFormat = new WsTitledPageFormat(sTitle);
        WsComponentPrinter printer = WsComponentPrinterFactory.createComponentPrinter((JComponent)((Object)this), (PageFormat)pageFormat, (boolean)false);
        pjob.setPageable((Pageable)printer);
        if (pjob.printDialog()) {
            try {
                pjob.print();
            }
            catch (PrinterException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (String)bundle.getString("AbstractImpactAnalysisTab.DefaultImpactPrintJobName.PrintErrorTitle.txt"), (int)0);
            }
        }
        printer.dispose();
    }

    private class PrintAction
    extends WsAbstractAction {
        public PrintAction() {
            super(bundle, "AbstractImpactAnalysisTab.Action.Print", 16);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:Print"));
        }

        public void actionPerformed(ActionEvent ev) {
            AbstractImpactAnalysisTab.this.handlePrint();
        }
    }

    private class GraphAction
    extends WsAbstractToggleAction {
        public GraphAction() {
            super(bundle, "AbstractImpactAnalysisTab.Action.Graph", 16);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("DiagramView"));
        }

        public void actionPerformed(ActionEvent ev) {
            AbstractImpactAnalysisTab.this.showGraph();
        }
    }

    private class ReportAction
    extends WsAbstractToggleAction {
        public ReportAction() {
            super(bundle, "AbstractImpactAnalysisTab.Action.Report", 16);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("ReportView"));
        }

        public void actionPerformed(ActionEvent ev) {
            AbstractImpactAnalysisTab.this.showReport();
        }
    }
}

