/*
 * Decompiled with CFR 0.152.
 */
package com.sas.codegen;

import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.Deployment;
import com.sas.codegen.PhysicalTableCG;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.StepPrecedence;
import com.sas.metadata.remote.TransformationStep;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;

public class WorkTableCG
extends PhysicalTableCG {
    private static WAdminResource bundle = WAdminResource.getBundle(WorkTableCG.class);
    private static final String TRANSFER_ROLE = "SASDATATRANSFER";
    public static final String WORK_LIBRARY = "Temp Work Library";

    public static void getWorkLib(CodegenRequest cgReq, Deployment bestDeployment, PhysicalTable table) throws MdException, RemoteException {
        SASLibrary lib = (SASLibrary)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)table.getObjectStore(), null, WORK_LIBRARY, "SASLibrary", table.getRepositoryID());
        lib.setLibref("work");
        lib.setIsPreassigned(1);
        table.getTablePackages().add((Object)lib);
        CodeGenUtil.getCodeGenClass((CMetadata)lib);
        if (bestDeployment == null) {
            WorkTableCG workCG = (WorkTableCG)CodeGenUtil.getCodeGenClass((CMetadata)table);
            bestDeployment = workCG.getBestDeployment(cgReq);
        }
        bestDeployment.setLibrary(lib);
        DeployedComponent iDataHost = WorkTableCG.getDataHost(cgReq, table);
        bestDeployment.setHost(iDataHost);
        AssociationList lAssocDC = new AssociationList("DeployedComponents", (Object)iDataHost);
        lib.setDeployedComponents(lAssocDC);
    }

    public static DeployedComponent getDataHost(CodegenRequest cgReq, PhysicalTable table) throws MdException, RemoteException {
        Object dataHost = null;
        String errMsg = "WorkTableCG.NoTargetClassifierMaps.msg.txt";
        AssociationList lTMaps = table.getTargetClassifierMaps(false);
        try {
            ClassifierMap myCM = null;
            TransformationStep myTS = null;
            if (!lTMaps.isEmpty()) {
                int size = lTMaps.size();
                for (int i = 0; i < size; ++i) {
                    ClassifierMap map = (ClassifierMap)lTMaps.get(i);
                    if (map.getSteps().isEmpty()) continue;
                    myCM = map;
                    myTS = (TransformationStep)myCM.getSteps().get(0);
                    break;
                }
            }
            if (myTS != null && myTS.getTransformRole().toUpperCase().indexOf(TRANSFER_ROLE) == -1) {
                errMsg = "WorkTableCG.NoComputeLocations.msg.txt";
                AssociationList hosts = myTS.getComputeLocations();
                dataHost = hosts.size() > 0 ? (DeployedComponent)hosts.get(0) : cgReq.getAppServerContext();
                return dataHost;
            }
            errMsg = "WorkTableCG.NoPredecessorDependencies.msg.txt";
            AssociationList lPrec = myTS.getPredecessorDependencies();
            StepPrecedence prec = (StepPrecedence)lPrec.get(0);
            errMsg = "WorkTableCG.NoSuccessors.msg.txt";
            AssociationList temp = prec.getSuccessors();
            TransformationStep nextStep = (TransformationStep)temp.get(0);
            if (nextStep.getTransformRole().toUpperCase().indexOf(TRANSFER_ROLE) > -1) {
                return cgReq.getAppServerContext();
            }
            errMsg = "WorkTableCG.NoClassifierMaps.msg.txt";
            AssociationList lCMaps = nextStep.getTransformations();
            ClassifierMap classifierMap = (ClassifierMap)lCMaps.get(0);
            errMsg = "WorkTableCG.NoComputeLocations.msg.txt";
            AssociationList nHosts = classifierMap.getComputeLocations();
            dataHost = (DeployedComponent)nHosts.get(0);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new CodegenException(bundle.getString(errMsg));
        }
        return dataHost;
    }
}

