/*
 * Decompiled with CFR 0.152.
 */
package com.sas.codegen;

import com.sas.editor.LogListHolder;
import com.sas.editor.LogListViewer;
import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.job.ICodeGenerationEnvironment;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.sql.ISourceTable;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IServer;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.visuals.common.CodeGenerationEnvironmentFactory;
import com.sas.wadmin.visuals.common.ModelUIUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.visuals.SASLogDialog;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.JLabel;

public class ValidateSASCode {
    private static WAdminResource bundle = WAdminResource.getBundle(ValidateSASCode.class);
    private WsAppServer m_defaultAppserver;
    private LogListViewer m_lSASLog;
    private String m_sOptions;
    private String m_sPreExpression;
    private String m_sClause;
    private String m_sExpression;
    private String m_sPostExpression;
    private String m_sSelectBegin;
    private String m_sSelectFromClause;
    protected List m_lITable = new ArrayList();
    private boolean m_generateAccessPaths = true;
    public static String WHERE = "where";
    private boolean m_bValidateSelect = false;

    public void addTables(ITable[] tables) {
        for (int iTable = 0; iTable < tables.length; ++iTable) {
            this.m_lITable.add(tables[iTable]);
        }
    }

    public void addTables(IColumn[] columns) {
        for (int iCol = 0; iCol < columns.length; ++iCol) {
            this.m_lITable.add(columns[iCol].getTable());
        }
    }

    public void removeDuplicateTables() {
        LinkedHashSet set = new LinkedHashSet();
        set.addAll(this.m_lITable);
        this.m_lITable = new ArrayList(set);
    }

    public List removeDuplicateStrings(List items) {
        LinkedHashSet set = new LinkedHashSet();
        set.addAll(items);
        return new ArrayList(set);
    }

    public List getTables() {
        return this.m_lITable;
    }

    public void setTables(List lITables) {
        this.m_lITable = lITables;
    }

    public ICodeSegment addAccessPaths(ICodeSegment codeSegment) throws MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, CodegenException, ServerException {
        List lTables = this.getTables();
        boolean bQuoting = false;
        for (int iTable = 0; iTable < lTables.size(); ++iTable) {
            IPhysicalTable table;
            if (lTables.get(iTable) instanceof IPhysicalTable) {
                table = (IPhysicalTable)lTables.get(iTable);
                if (table.isQuoted()) {
                    bQuoting = true;
                }
                table.genAccessPath(codeSegment, false, 0, null);
                if (table instanceof IWorkTable) {
                    codeSegment = table.getDBMSType().create(codeSegment, table, false, false, false, false, null, null);
                }
            } else if (lTables.get(iTable) instanceof ISourceTable) {
                ITable aliasTable;
                table = (ISourceTable)lTables.get(iTable);
                if (table.isQuoted()) {
                    bQuoting = true;
                }
                if ((aliasTable = table.getAliasedTable()) != null && aliasTable instanceof IPhysicalTable) {
                    IPhysicalTable physicalTable = (IPhysicalTable)aliasTable;
                    if (physicalTable.isQuoted()) {
                        bQuoting = true;
                    }
                    physicalTable.genAccessPath(codeSegment, false, 0, null);
                    if (physicalTable instanceof IWorkTable) {
                        codeSegment = physicalTable.getDBMSType().create(codeSegment, physicalTable, false, false, false, false, null, null);
                    }
                }
            }
            if (!bQuoting || codeSegment.isQuoting()) continue;
            codeSegment.genValidvarnameOptionAny(false);
            codeSegment.setQuoting(true);
        }
        return codeSegment;
    }

    public WsAppServer getWsAppServer() {
        if (this.m_defaultAppserver != null) {
            return this.m_defaultAppserver;
        }
        this.m_defaultAppserver = WsAppServer.createDefaultAppServer((boolean)true);
        if (this.m_defaultAppserver == null) {
            MessageUtil.displayMessage((String)bundle.getString("ValidateSASCode.NoAppserverError.txt"), (String)bundle.getString("ValidateSASCode.AppserverError.title.txt"), (int)0);
            return null;
        }
        try {
            this.m_defaultAppserver.open();
        }
        catch (WsAppServerFailException failException) {
            try {
                String msg = bundle.formatString("ValidateSASCode.CannotOpenAppserverError.txt", (Object)this.m_defaultAppserver.getServerName());
                MessageUtil.displayMessage((String)msg, (String)bundle.getString("ValidateSASCode.CannotOpenAppserverError.title.txt"), (int)0);
            }
            catch (RemoteException ex) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
            }
            this.m_defaultAppserver = null;
            return null;
        }
        return this.m_defaultAppserver;
    }

    private IServer acquireModelForSASAppServer(IObject table) {
        IModel model = table.getModel();
        try {
            return ModelUIUtilities.getServerForAppServer(model, this.getWsAppServer());
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return null;
    }

    public ICodeGenerationEnvironment getCGEnvironment() {
        if (this.m_lITable == null || this.m_lITable.size() == 0) {
            return null;
        }
        IServer server = this.acquireModelForSASAppServer((IObject)((ITable)this.m_lITable.get(0)));
        CodeGenerationEnvironmentFactory factory = CodeGenerationEnvironmentFactory.getInstance();
        return factory.createCodeGenerationEnvironment(null, server);
    }

    private String generateSASCode() throws MdException, RemoteException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        ICodeGenerationEnvironment codeGenerationEnvironment = this.getCGEnvironment();
        codeGenerationEnvironment.setGenerateRCSetCalls(false);
        ICodeSegment codeSegment = codeGenerationEnvironment.createNewCodeSegment((IObject)((ITable)this.m_lITable.get(0)));
        if (this.m_generateAccessPaths) {
            codeSegment = this.addAccessPaths(codeSegment);
        }
        if (this.getValidateSelect()) {
            codeSegment.addSourceCode(this.getSelectBegin());
            codeSegment.addSourceCode(this.getExpression());
            codeSegment.addSourceCode(this.getSelectFromClause());
        } else {
            codeSegment.addSourceCode(this.getPreExpression());
            codeSegment.indent();
            codeSegment.addSourceCode(this.getClause()).addSourceCode(" ");
            codeSegment.addSourceCode(this.getExpression());
            codeSegment.addSourceCode(";\n");
            codeSegment.unIndent();
            codeSegment.addSourceCode(this.getPostExpression());
        }
        codeSegment.addSourceCode(this.getErrorCode());
        return codeSegment.toString();
    }

    private String getErrorCode() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n/* Reset obs= so that macro variable can be read later*/\n");
        sb.append("options obs=max;\n");
        sb.append("\n/* Show error code and read it to detect syntax errors.  Error code of 1012 is invalid syntax. */\n");
        sb.append("%put &syserr;\n");
        return sb.toString();
    }

    private String submitSASCode(OpRequestUI request) throws SQLException, WsAppServerFailException, RemoteException, MdException, BadServerDefinitionException, BadLibraryDefinitionException, CodegenException, ServerException {
        if (this.getWsAppServer() == null) {
            return null;
        }
        try {
            this.getWsAppServer().submitSASCode(this.generateSASCode());
            return this.getReturnCode();
        }
        catch (WsAppServerFailException failException) {
            return this.getReturnCode();
        }
        catch (WsAppServerCodeException e) {
            return this.getReturnCode();
        }
    }

    public String getReturnCode() throws SQLException, WsAppServerFailException {
        String sReturnCode = null;
        sReturnCode = this.getWsAppServer().getMacroVariableValue("syserr");
        return sReturnCode;
    }

    public LogListViewer getSASLog() {
        if (this.m_lSASLog != null) {
            return this.m_lSASLog;
        }
        String[] strArray = new String[]{""};
        Integer[] intArray = new Integer[]{new Integer(5)};
        this.m_lSASLog = new LogListViewer(5, new LogListHolder(strArray, intArray), Workspace.getWorkspace().getCodeEditorDefaults());
        this.m_lSASLog.setDefaults(Workspace.getWorkspace().getCodeEditorDefaults());
        return this.m_lSASLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doValidate() {
        try {
            this.getWsAppServer();
            cBacgroundThread backgroundThread = null;
            if (this.m_defaultAppserver != null) {
                String str1 = bundle.getString("ValidateSASCode.ProgressIndicator.Message.txt");
                String str2 = bundle.getString("ValidateSASCode.ProgressIndicator.Title.txt");
                OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace(), str1, str2);
                JLabel messageLabel = null;
                messageLabel = str1.length() > str2.length() ? new JLabel(str1) : new JLabel(str2);
                request.setMessagePreferredSize(messageLabel.getPreferredSize());
                request.setDelayBeforeProgressCancelDialog(500);
                request.setProgressShownOnStatusBar(true);
                backgroundThread = new cBacgroundThread(request);
                try {
                    request.executeWithCancel((Runnable)backgroundThread);
                }
                catch (InterruptedException e) {
                    this.cleanUp();
                    return;
                }
            }
            if (this.m_defaultAppserver == null || backgroundThread.getSASRunStatus() == null) {
                MessageUtil.displayMessage((String)bundle.getString("ValidateSASCode.CannotCheck.txt"), (String)bundle.getString("ValidateSASCode.CannotCheck.title.txt"), (int)0);
            } else if (backgroundThread.getSASRunStatus().compareToIgnoreCase("1012") == 0) {
                int showMessage = MessageUtil.displayMessage((String)bundle.getString("ValidateSASCode.InvalidSASLog.txt"), (String)bundle.getString("ValidateSASCode.Expression.title.txt"), (int)0, (int)0);
                this.showSASLog(showMessage);
            } else {
                int showMessage = MessageUtil.displayMessage((String)bundle.getString("ValidateSASCode.ValidSASLog.txt"), (String)bundle.getString("ValidateSASCode.Expression.title.txt"), (int)1, (int)0);
                this.showSASLog(showMessage);
            }
        }
        finally {
            this.cleanUp();
        }
    }

    public void showSASLog(int showMessage) {
        if (showMessage == 0) {
            SASLogDialog logDlg = new SASLogDialog((Frame)Workspace.getWorkspace(), bundle.getString("ValidateSASCode.SASLog.Title.txt"), true, this.getWsAppServer());
            logDlg.setResizable(true);
            logDlg.show();
        }
    }

    private void cleanUp() {
        if (this.m_defaultAppserver != null) {
            this.m_defaultAppserver.close();
            this.m_defaultAppserver.dispose();
            this.m_defaultAppserver = null;
        }
        if (this.m_lSASLog != null) {
            this.m_lSASLog.cleanup();
            this.m_lSASLog = null;
        }
    }

    public String getPreExpression() {
        return this.m_sPreExpression;
    }

    public void setPreExpression(String preExpression) {
        this.m_sPreExpression = preExpression;
    }

    public void setClause(String sClause) {
        this.m_sClause = sClause;
    }

    public String getClause() {
        return this.m_sClause;
    }

    public String getExpression() {
        return this.m_sExpression;
    }

    public void setExpression(String expression) {
        this.m_sExpression = expression;
    }

    public String getPostExpression() {
        return this.m_sPostExpression;
    }

    public void setPostExpression(String PostExpression) {
        this.m_sPostExpression = PostExpression;
    }

    public String getSelectBegin() {
        return this.m_sSelectBegin;
    }

    public void setSelectBegin(String beginSelect) {
        this.m_sSelectBegin = beginSelect;
    }

    public String getSelectFromClause() {
        return this.m_sSelectFromClause;
    }

    public void setSelectFromClause(String selectFromClause) {
        this.m_sSelectFromClause = selectFromClause;
    }

    public boolean getValidateSelect() {
        return this.m_bValidateSelect;
    }

    public void setValidateSelect(boolean validateSelect) {
        this.m_bValidateSelect = validateSelect;
    }

    private class cBacgroundThread
    implements Runnable {
        private OpRequestUI m_request;
        private String m_bRunStatus;

        public cBacgroundThread(OpRequestUI request) {
            this.m_request = request;
        }

        @Override
        public void run() {
            Thread.currentThread().setName("ValidateExpression");
            try {
                this.m_bRunStatus = ValidateSASCode.this.submitSASCode(this.m_request);
            }
            catch (SQLException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage());
            }
            catch (WsAppServerFailException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage());
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
            catch (BadLibraryDefinitionException ex2) {
                MessageUtil.displayMessage((String)ex2.getLocalizedMessage());
            }
            catch (BadServerDefinitionException ex2) {
                MessageUtil.displayMessage((String)ex2.getLocalizedMessage());
            }
            catch (CodegenException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage());
            }
            catch (ServerException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage());
            }
        }

        public String getSASRunStatus() {
            return this.m_bRunStatus;
        }
    }
}

