/*
 * Decompiled with CFR 0.152.
 */
package com.sas.codegen;

import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.DataTableCG;
import com.sas.codegen.PhysicalTableCG;
import com.sas.codegen.TransformationActivityCG;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.StepPrecedence;
import com.sas.metadata.remote.TransformationStep;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.OptionsPropertyHandler;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.ServerSupport;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.util.Stack;

public class Transfer {
    private static WAdminResource bundle = WAdminResource.getBundle(Transfer.class);
    private static final String TRANSFER_OPTIONS = "TransferOptions";
    private static final String REMOTE_MACRO = "etls_remoteMacro";

    private Transfer() {
    }

    public static void executeUtility(CodegenRequest cgReq, ClassifierMap classifierMap) throws MdException, RemoteException {
        cgReq.checkSourceAndTarget(classifierMap);
        cgReq.checkTargetsForExternalTable(classifierMap);
        cgReq.checkSourcesForExternalTable(classifierMap);
        TransformationStep step = (TransformationStep)classifierMap.getSteps().get(0);
        AssociationList lSPs = step.getPredecessorDependencies();
        StepPrecedence sp = null;
        if (lSPs.size() <= 0) {
            throw new CodegenException(bundle.getString("Transfer.NoTarget.msg.txt"));
        }
        sp = (StepPrecedence)lSPs.get(0);
        TransformationStep nextStep = (TransformationStep)sp.getSuccessors().get(0);
        if (TransformationActivityCG.isTransferStep(nextStep)) {
            throw new CodegenException(bundle.getString("Transfer.ConsecutiveTransfers.msg.txt"));
        }
        ServerContext currentServer = cgReq.getCurrentServer();
        ServerContext prevServer = TransformationActivityCG.getPreviousServer(step, currentServer);
        ServerContext nextServer = TransformationActivityCG.getNextServer(step, currentServer);
        ServerContext localServer = null;
        SASLibrary localLibrary = null;
        ServerContext remoteServer = null;
        SASLibrary remoteLibrary = null;
        ServerSupport serverSupport = null;
        ServerSupport currentServerSupp = null;
        boolean noneAreLocal = false;
        boolean bothAreLocal = false;
        String proc = null;
        boolean fTargetIsLocal = true;
        DataTable sourceTable = cgReq.getSourceTable(classifierMap);
        DataTable targetTable = cgReq.getTargetTable(classifierMap);
        if (targetTable.getTablePackages().size() == 0) {
            throw new CodegenException(bundle.formatString("Transfer.NoLibraryForTable.msg.txt", (Object)step));
        }
        if (prevServer.getId().equals(nextServer.getId())) {
            bothAreLocal = true;
            localServer = currentServer;
            remoteServer = nextServer;
            localLibrary = LibraryUtil.getLibrary((DataTable)targetTable, (ServerContext)localServer);
            remoteLibrary = LibraryUtil.getLibrary((DataTable)sourceTable, (ServerContext)remoteServer);
            fTargetIsLocal = true;
            cgReq.addCommentLine(bundle.getString("Transfer.NoTransferPerformed.msg.txt"));
        } else if (nextServer.getId().equals(currentServer.getId())) {
            remoteServer = prevServer;
            localServer = nextServer;
            proc = "download";
            localLibrary = LibraryUtil.getLibrary((DataTable)targetTable, (ServerContext)localServer);
            remoteLibrary = LibraryUtil.getLibrary((DataTable)sourceTable, (ServerContext)remoteServer);
            fTargetIsLocal = true;
        } else if (prevServer.getId().equals(currentServer.getId())) {
            remoteServer = nextServer;
            localServer = prevServer;
            proc = "upload";
            localLibrary = LibraryUtil.getLibrary((DataTable)sourceTable, (ServerContext)localServer);
            remoteLibrary = LibraryUtil.getLibrary((DataTable)targetTable, (ServerContext)remoteServer);
            fTargetIsLocal = false;
        } else {
            remoteServer = nextServer;
            localServer = prevServer;
            proc = "upload";
            noneAreLocal = true;
            localLibrary = LibraryUtil.getLibrary((DataTable)sourceTable, (ServerContext)localServer);
            remoteLibrary = LibraryUtil.getLibrary((DataTable)targetTable, (ServerContext)remoteServer);
            fTargetIsLocal = false;
        }
        Stack rsubmitStack = new Stack();
        cgReq.genSystemOptions((AbstractTransformation)classifierMap);
        if (noneAreLocal && Transfer.genSignonAndRsubmit(cgReq, classifierMap, currentServerSupp = new ServerSupport(localServer, currentServer), rsubmitStack)) {
            cgReq.setCurrentServer((DeployedComponent)localServer);
        }
        if (!bothAreLocal) {
            cgReq.addSourceCode(LibraryUtil.accessPath((SASLibrary)localLibrary, (ServerContext)localServer));
            if (fTargetIsLocal) {
                cgReq.genTableDelete(targetTable);
            }
        }
        if (localServer != null && Transfer.genSignonAndRsubmit(cgReq, classifierMap, serverSupport = new ServerSupport(remoteServer, localServer), rsubmitStack)) {
            cgReq.setCurrentServer((DeployedComponent)remoteServer);
        }
        if (bothAreLocal) {
            cgReq.addSourceCode(LibraryUtil.accessPath((SASLibrary)localLibrary, (ServerContext)remoteServer));
            if (fTargetIsLocal) {
                cgReq.genTableDelete(targetTable);
            }
        }
        cgReq.addSourceCode(LibraryUtil.accessPath((SASLibrary)remoteLibrary, (ServerContext)remoteServer));
        if (!fTargetIsLocal) {
            cgReq.genTableDelete(targetTable);
        }
        cgReq.genSyslast(classifierMap);
        OptionsPropertyHandler OP = new OptionsPropertyHandler((Root)step);
        String dsOptions = OP.getSpecificOptionValue(TRANSFER_OPTIONS);
        PhysicalTableCG sourceTableCG = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)sourceTable);
        String sourceOptions = sourceTableCG.getSourceTableOptions(true);
        if (bothAreLocal) {
            DataTableCG targetTableCG = (DataTableCG)CodeGenUtil.getCodeGenClass((CMetadata)targetTable);
            String targetTableName = targetTableCG.getDataLocation(cgReq);
            cgReq.addSourceCode("data " + targetTableName + " / view = " + targetTableName + ";\n").indent().addSourceCode("set &SYSLAST " + sourceOptions + ";\n").unIndent().addSourceCode("run;\n").genRCSetCall("&syserr");
            cgReq.setCurrentServer((DeployedComponent)localServer);
        } else if (localServer != null) {
            DataTableCG targetTableCG = (DataTableCG)CodeGenUtil.getCodeGenClass((CMetadata)targetTable);
            String targetTableName = targetTableCG.getDataLocation(cgReq);
            cgReq.addSourceCode("proc " + proc + " data = &SYSLAST " + sourceOptions + " \n").addSourceCode("     out = " + targetTableName);
            if (dsOptions != null && dsOptions.length() > 0) {
                cgReq.addSourceCode("\n").addSourceCode("     ").addSourceCode(dsOptions);
            }
            cgReq.addSourceCode(";\n");
            cgReq.addSourceCode("run;\n");
            cgReq.genRCSetCall("&syserr");
            Transfer.genRemoteSubmitEnding(cgReq, rsubmitStack);
            cgReq.setCurrentServer((DeployedComponent)localServer);
        }
        if (noneAreLocal) {
            Transfer.genRemoteSubmitEnding(cgReq, rsubmitStack);
            cgReq.setCurrentServer((DeployedComponent)currentServer);
        }
        if (!rsubmitStack.isEmpty()) {
            Transfer.genRemoteSubmitEnding(cgReq, rsubmitStack);
            cgReq.setCurrentServer((DeployedComponent)localServer);
        }
    }

    private static CodegenRequest genRemoteSubmitEnding(CodegenRequest cgReq, Stack rsubmitStack) throws MdException, RemoteException {
        Object server = rsubmitStack.pop();
        if (server != null) {
            ServerSupport serverSupport = (ServerSupport)server;
            cgReq.genReturnCodeRemoteEnding();
            cgReq.unIndent();
            cgReq.addSourceCode("%mend ").addSourceCode(REMOTE_MACRO).addSourceCode("; \n").addSourceCode("%").addSourceCode(REMOTE_MACRO).addSourceCode("; \n\n").unIndent();
            cgReq.addSourceCode(serverSupport.endSubmit());
        }
        return cgReq;
    }

    private static boolean genSignonAndRsubmit(CodegenRequest cgReq, ClassifierMap classifierMap, ServerSupport server, Stack rsubmitStack) throws MdException, RemoteException {
        StringBuffer rsubmit;
        boolean inRemoteSubmit = false;
        StringBuffer signon = server.access();
        boolean alreadySignedOn = true;
        if (signon != null && signon.length() > 0) {
            cgReq.addSourceCode(signon);
            alreadySignedOn = false;
        }
        if ((rsubmit = server.startSubmit(SASCodeGeneration.SYSRPUTSYNC_YES)) != null && rsubmit.length() > 0) {
            cgReq.genReturnCodeRemoteSetup(server.getHostName());
            cgReq.genRemoteMacroVariablesSetup(server.getHostName()).addSourceCode("\n");
            rsubmitStack.push(server);
            cgReq.addSourceCode(rsubmit).indent().addSourceCode("%macro ").addSourceCode(REMOTE_MACRO).addSourceCode("; \n").indent();
            if (!alreadySignedOn) {
                cgReq.genSystemOptions((AbstractTransformation)classifierMap);
            }
            if (signon != null && signon.length() > 0) {
                cgReq.genReturnCodeMacro();
            }
            inRemoteSubmit = true;
        }
        return inRemoteSubmit;
    }
}

