/*
 * Decompiled with CFR 0.152.
 */
package com.sas.codegen;

import com.sas.codegen.AutoExtract;
import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.DataTableCG;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Select;
import com.sas.workspace.OptionsPropertyHandler;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;

public class Sort {
    private static WAdminResource bundle = WAdminResource.getBundle(Sort.class);
    private static final String SORT_OPTIONS = "SORT";

    private Sort() {
    }

    public static void executeUtility(CodegenRequest cgReq, ClassifierMap classifierMap) throws MdException, RemoteException {
        cgReq.checkSourceAndTarget(classifierMap);
        cgReq.checkTargetsForExternalTable(classifierMap);
        cgReq.checkSourcesForExternalTable(classifierMap);
        DataTableCG sourceTableCG = cgReq.getSourceTableCG(classifierMap);
        String sourceOptions = sourceTableCG.getSourceTableOptions();
        DataTable targetTable = (DataTable)classifierMap.getClassifierTargets().get(0);
        DataTableCG targetTableCG = (DataTableCG)CodeGenUtil.getCodeGenClass((CMetadata)targetTable);
        String targetName = targetTableCG.getDataLocation(cgReq);
        String targetOptions = targetTableCG.getTargetTableOptions(true);
        OptionsPropertyHandler op = new OptionsPropertyHandler((Root)classifierMap);
        String sortOptions = op.getOptionsString(SORT_OPTIONS);
        cgReq.genSystemOptions((AbstractTransformation)classifierMap);
        cgReq.genTableDelete(targetTable);
        if (AutoExtract.columnMapping(classifierMap, cgReq, sourceOptions)) {
            sourceOptions = "";
        }
        cgReq.addSourceCode("proc sort data = &SYSLAST \n");
        if (sourceOptions.trim().length() > 0) {
            cgReq.addSourceCode("                    (" + sourceOptions.trim() + ") \n");
        }
        cgReq.addSourceCode("          out = " + targetName);
        if (targetOptions.length() > 0) {
            cgReq.addSourceCode("\n").addSourceCode("                    " + targetOptions.trim());
        }
        if (sortOptions.trim().length() > 0) {
            cgReq.addSourceCode("\n").addSourceCode("          " + sortOptions.trim());
        }
        cgReq.addSourceCode("; \n").indent();
        String byStatement = cgReq.makeByStatement((Select)classifierMap);
        if (byStatement == null) {
            throw new CodegenException(bundle.getString("Sort.OrderByNoColumns.msg.txt"));
        }
        cgReq.addSourceCode(byStatement + "; \n").unIndent().addSourceCode("run; \n\n").genRCSetCall("&syserr");
    }
}

