/*
 * Decompiled with CFR 0.152.
 */
package com.sas.codegen;

import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.DataTableCG;
import com.sas.codegen.Deployment;
import com.sas.codegen.PhysicalTableCG;
import com.sas.codegen.SAS;
import com.sas.codegen.TableLoaderOptions;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.Index;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.TransformationStep;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.workspace.DBMSNamesUtil;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.PropertyHandler;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class SASSPDS
extends SAS {
    private static WAdminResource bundle = WAdminResource.getBundle(SASSPDS.class);
    private static final String APPEND_OPTION = "APPEND";
    private boolean recreateIndex;
    private boolean m_removeRows;
    private Integer parallelGroup;
    private static final String SPDS_OPTION_TEMPLATE = "/com/sas/wadmin/visuals/res/Options_SPDSTable_Template.xml";

    public SASSPDS() {
        this.setConstraintSupport(false);
    }

    public SAS getSASInstance() {
        SAS sasCG = new SAS();
        sasCG.setMetadataClass(this.getMetadataClass());
        return sasCG;
    }

    @Override
    public List getOptionModels() throws RemoteException, ServiceException, ServerConnectionException, MdException, IOException, SAXException, ParserConfigurationException {
        ArrayList models = new ArrayList();
        models.addAll(super.getOptionModels());
        return models;
    }

    @Override
    public void update(CodegenRequest cgReq) throws MdException, RemoteException {
        cgReq.addSectionComment(bundle.getString("DBMSSTORE.Update.msg.notrans")).genPercentPutStatement(bundle.getString("DBMSSTORE.Update.note.sasmacro.notrans")).addSourceCode("\n");
        String tableName = this.getDataLocation(cgReq);
        StringBuffer gen_opts = this.getDSOptions();
        gen_opts.append(" UNIQUESAVE=REP ");
        if (gen_opts.length() > 0) {
            gen_opts.insert(0, " (").append(")");
        }
        cgReq.genJobStatusUpdateBefore(this.m_table).addSourceCode("proc append base = ").addSourceCode(tableName).addSourceCode(gen_opts.toString()).addSourceCode("\n").addSourceCode("   data = &etls_lastTable (&SYSOPT) force; \n").addSourceCode("run; \n\n").genRCSetCall("&syserr").genJobStatusUpdateAfter(this.m_table);
    }

    public String getDBNULL(CodegenRequest cgReq, ClassifierMap classifierMap) throws MdException, RemoteException {
        return "";
    }

    public void loadMacroValues(CodegenRequest cgReq) throws MdException, RemoteException {
        Property prop;
        int i;
        TransformationStep step = null;
        if (cgReq.getCurrentTransformation() instanceof TransformationStep) {
            step = (TransformationStep)cgReq.getCurrentTransformation();
        }
        cgReq.addCommentLine(bundle.getString("SPDS.MacroOptions.comment.notrans"));
        PropertyHandler OP = new PropertyHandler((Root)step, "MACROOPTIONS");
        AssociationList propList = OP.getPropertyList();
        if (propList == null) {
            return;
        }
        for (i = 0; i < propList.size(); ++i) {
            prop = (Property)propList.get(i);
            cgReq.addSourceCode("%local ");
            cgReq.addSourceCode(prop.getPropertyName());
            cgReq.addSourceCode(";\n");
        }
        for (i = 0; i < propList.size(); ++i) {
            prop = (Property)propList.get(i);
            cgReq.addSourceCode("%let ");
            cgReq.addSourceCode(prop.getPropertyName());
            cgReq.addSourceCode(prop.getDelimiter());
            cgReq.addSourceCode(prop.getDefaultValue());
            cgReq.addSourceCode(";\n");
        }
    }

    @Override
    public void load(CodegenRequest cgReq, ClassifierMap classifierMap) throws MdException, RemoteException {
        this.load(cgReq, classifierMap, true);
    }

    public void load(CodegenRequest cgReq, ClassifierMap classifierMap, boolean mapColumns) throws MdException, RemoteException {
        this.m_table = (PhysicalTable)this.getMetadataClass();
        this.m_classifierMap = classifierMap;
        this.setNickname(cgReq);
        boolean append = false;
        boolean refresh = false;
        boolean update = false;
        this.m_TLO = new TableLoaderOptions(this.m_classifierMap);
        String loadType = this.m_TLO.getLoadType();
        this.recreateIndex = this.m_TLO.getRecreateIndex();
        boolean parallelIndex = this.m_TLO.getParallelIndex();
        boolean truncate = this.m_TLO.getTruncate();
        boolean remove = this.m_TLO.getRemove();
        this.parallelGroup = this.m_TLO.getParallelGroupOption().length() == 0 ? Integer.valueOf("0") : Integer.valueOf(this.m_TLO.getParallelGroupOption());
        boolean recreateIndexInParallel = parallelIndex && this.recreateIndex;
        cgReq.addSourceCode("%global etls_tableExist;\n").addSourceCode("%global etls_numIndex;\n").addSourceCode("%global etls_lastTable;\n").addSourceCode("%let etls_tableExist = -1; \n").addSourceCode("%let etls_numIndex = -1; \n").addSourceCode("%let etls_lastTable = &SYSLAST; \n\n");
        if (!(loadType.equalsIgnoreCase("Update") || loadType.equalsIgnoreCase("Append") || loadType.equalsIgnoreCase("Refresh"))) {
            throw new CodegenException(bundle.formatString("DBMSSTORE.BadLoadTechnique.msg.txt", (Object)loadType));
        }
        try {
            cgReq.genAdditionalSystemOptions((AbstractTransformation)classifierMap);
        }
        catch (Exception exception) {
            // empty catch block
        }
        cgReq.addSectionComment(bundle.getString("DBMSSTORE.DefineMacro.msg.notrans")).addSourceCode("%macro etls_loader;\n\n").indent();
        this.loadMacroValues(cgReq);
        AssociationList lInputs = classifierMap.getClassifierSources();
        int numSources = lInputs.size();
        append = this.m_TLO.stringToBoolean(this.m_TLO.getSpecificOptionValue(APPEND_OPTION));
        if (numSources > 1 && !append) {
            throw new CodegenException(bundle.getString("DBMSSTORE.MultipleInputs.msg.txt"));
        }
        String dsOptions = "";
        if (numSources == 1) {
            DataTableCG sourceTableCG = cgReq.getSourceTableCG(classifierMap);
            dsOptions = sourceTableCG.getSourceTableOptions(false);
            if (dsOptions.length() > 0) {
                cgReq.addSourceCode("%let SYSOPT = %nrquote(").addSourceCode(dsOptions).addSourceCode(");\n\n");
            } else {
                cgReq.addSourceCode("%let SYSOPT = ;\n\n");
            }
        } else {
            cgReq.addSourceCode("%let SYSOPT = ;\n\n");
        }
        String preserveCase = cgReq.getGlobalData("Case");
        String specialChar = cgReq.getGlobalData("SpecChar");
        AssociationList lCols = this.m_table.getColumns();
        boolean hasLoadTime = false;
        String loadColName = this.m_TLO.getLoadTimeSASColumnName();
        boolean loadColOption = true;
        if (loadColName.trim().equals("")) {
            loadColOption = false;
        }
        for (int i = 0; i < lCols.size(); ++i) {
            Column col = (Column)lCols.get(i);
            String name = col.getSASColumnName();
            if ((!preserveCase.equals("Y") || !name.equals(loadColName)) && (preserveCase.equals("Y") || !name.equalsIgnoreCase(loadColName))) continue;
            String type = col.getSASColumnType();
            if (type.equalsIgnoreCase("N")) {
                hasLoadTime = true;
                break;
            }
            throw new CodegenException(bundle.formatString("DBMSSTORE.InvalidColumnType.msg.txt", (Object)loadColName));
        }
        if (!hasLoadTime && loadColOption) {
            throw new CodegenException(bundle.formatString("DBMSSTORE.InvalidColumnName.msg.txt", (Object)loadColName));
        }
        if (numSources > 0 && hasLoadTime || numSources > 1 && append) {
            if (hasLoadTime) {
                cgReq.addSectionComment(bundle.getString("DBMSSTORE.SetLoadTime.msg.notrans"));
            }
            String dsname = cgReq.getUniqueWorkTableName();
            cgReq.genTableDelete(dsname).addSourceCode("data work.").addSourceCode(dsname).addSourceCode(" / view=work.").addSourceCode(dsname).addSourceCode(";\n").indent().addSourceCode("set ");
            if (numSources == 1) {
                cgReq.addSourceCode("&SYSLAST (&SYSOPT)");
            } else if (append) {
                for (int i = 0; i < numSources; ++i) {
                    PhysicalTable sourceTable = (PhysicalTable)lInputs.get(i);
                    PhysicalTableCG sourceTableCG = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)sourceTable);
                    dsname = sourceTableCG.getDataLocation(cgReq);
                    cgReq.addSourceCode(dsname + "\n    ");
                }
            }
            cgReq.addSourceCode(";\n");
            if (hasLoadTime) {
                if (preserveCase.equals("Y") || specialChar.equals("Y")) {
                    loadColName = DBMSNamesUtil.getQuotedString((String)loadColName, (boolean)false);
                }
                String dtFormat = cgReq.isJobDateFormatNLS((AbstractTransformation)this.m_classifierMap) ? "nldatm32." : "datetime20.";
                cgReq.addSourceCode("\n").addSourceCode(loadColName).addSourceCode(" = input(\"&SYSDATE9 &SYSTIME\",DATETIME20.);\n\n").addSourceCode("if _n_ eq 1 then \n").indent().addSourceCode("put 'NOTE: ").addSourceCode(bundle.getString("DBMSSTORE.LoadtimeNote.msg.notrans")).addSourceCode(" ' ").addSourceCode(loadColName).addSourceCode(" ").addSourceCode(dtFormat).addSourceCode(";\n").unIndent();
            }
            cgReq.unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr").addSourceCode("%let SYSLAST = work.").addSourceCode(dsname).addSourceCode(";\n").addSourceCode("%let etls_lastTable = &SYSLAST; \n");
            if (dsOptions.length() > 0) {
                cgReq.addSourceCode("%let SYSOPT = ;\n\n");
            } else {
                cgReq.addSourceCode("\n");
            }
        }
        this.exist(cgReq);
        if (loadType.equalsIgnoreCase("Update")) {
            update = true;
        } else if (loadType.equalsIgnoreCase("Append")) {
            append = true;
        } else {
            refresh = true;
        }
        if (!refresh) {
            this.create(cgReq);
            this.genCodeConditionCheck(cgReq, "Condition5");
            if (!this.recreateIndex) {
                this.createIndexes(cgReq, true, true, this.parallelGroup);
            } else {
                cgReq.addSourceCode("%if (&etls_tableExist gt 0) ").addSourceCode("%then \n").addSourceCode("%do;  ");
                this.getSASInstance().dropIndexes(cgReq);
                cgReq.addSourceCode("%end;  \n\n");
                this.createIndexes(cgReq, recreateIndexInParallel, false, this.parallelGroup);
            }
            if (mapColumns) {
                this.columnMapping(cgReq);
            }
            if (update) {
                this.update(cgReq);
                this.genCodeConditionCheck(cgReq, "Condition4");
            } else {
                this.append(cgReq);
                this.genCodeConditionCheck(cgReq, "Condition4");
            }
        } else {
            if (truncate || remove) {
                this.create(cgReq);
                this.genCodeConditionCheck(cgReq, "Condition5");
                if (!this.recreateIndex) {
                    this.createIndexes(cgReq, true, true, this.parallelGroup);
                } else {
                    cgReq.addSourceCode("%if (&etls_tableExist gt 0) ").addSourceCode("%then \n").addSourceCode("%do;  ").indent();
                    this.getSASInstance().dropIndexes(cgReq);
                    cgReq.unIndent().addSourceCode("%end;  \n\n");
                }
                cgReq.addSourceCode("%if (&etls_tableExist gt 0) %then \n").addSourceCode("%do;  ").addCommentLine(bundle.getString("DBMSSTORE.TableExists.msg.notrans")).addSourceCode("\n").indent();
                if (truncate) {
                    this.truncate(cgReq, classifierMap);
                } else {
                    this.remove(cgReq, false);
                }
                this.genCodeConditionCheck(cgReq, "Condition8");
                cgReq.unIndent().addSourceCode("%end;  ").addCommentLine(bundle.getString("DBMSSTORE.TableExists.msg.notrans")).addSourceCode("\n");
                if (this.recreateIndex) {
                    this.createIndexes(cgReq, recreateIndexInParallel, false, this.parallelGroup);
                }
            } else {
                this.drop(cgReq);
                this.genCodeConditionCheck(cgReq, "Condition6");
                this.create(cgReq);
                this.genCodeConditionCheck(cgReq, "Condition5");
                this.createIndexes(cgReq, recreateIndexInParallel, false, this.parallelGroup);
            }
            if (mapColumns) {
                this.columnMapping(cgReq);
            }
            this.append(cgReq);
            this.genCodeConditionCheck(cgReq, "Condition4");
        }
        if (this.m_mapFlag) {
            cgReq.genTableDelete("work.mapped");
        }
        cgReq.unIndent().addSourceCode("%mend etls_loader;\n").addSourceCode("%etls_loader;\n\n");
        this.genCodeConditionCheck(cgReq, "Condition1");
        this.genCodeConditionCheck(cgReq, "Condition2");
        this.genCodeConditionCheck(cgReq, "Condition3");
    }

    public void createIndexes(CodegenRequest cgReq, boolean inParallel, boolean nonexistentTable, Integer parallelgroup) throws MdException, RemoteException {
        AssociationList indexList = this.m_table.getIndexes();
        if (indexList.size() <= 0) {
            return;
        }
        if (nonexistentTable) {
            cgReq.addSectionComment(bundle.getString("SPDS.CreateIndexTableNonexistent.note.notrans"));
        }
        if (inParallel) {
            cgReq.addSectionComment(bundle.getString("SPDS.CreateParallelIndex.msg.notrans"));
        } else {
            cgReq.addSectionComment(bundle.getString("SPDS.CreateIndex.msg.notrans"));
        }
        if (nonexistentTable) {
            cgReq.addSourceCode("%if (&etls_tableExist eq 0) %then \n").addSourceCode("%do;  ");
            cgReq.addCommentLine(bundle.getString("SPDS.NewIndexTableNoneistent.msg.notrans")).addSourceCode("\n").indent();
        } else if (!this.m_removeRows) {
            cgReq.addCommentLine(bundle.getString("SPDS.RecreateIndex.msg.notrans")).addSourceCode("\n").indent();
        }
        if (inParallel) {
            cgReq.genPercentPutStatement(bundle.getString("SPDS.CreateParallelIndex.note.sasmacro.notrans"));
        } else {
            cgReq.genPercentPutStatement(bundle.getString("SPDS.CreateIndex.note.sasmacro.notrans"));
        }
        String tabname = this.getDataLocation(cgReq, false, true);
        String libname = SASSPDS.getLibref(tabname);
        String tableName = SASSPDS.getTableName(tabname);
        String modifyLine = "";
        modifyLine = inParallel ? "modify " + tableName + " (asyncindex=YES); \n" : "modify " + tableName + " ; \n";
        cgReq.addSourceCode("proc datasets lib = " + libname + " nolist; \n").addSourceCode(modifyLine);
        int multipleCounter = 0;
        boolean groupTogether = false;
        if (parallelgroup == 0) {
            groupTogether = true;
        }
        for (int i = 0; i < indexList.size(); ++i) {
            if (inParallel && !groupTogether) {
                if (multipleCounter == parallelgroup) {
                    cgReq.addSourceCode(modifyLine);
                    multipleCounter = 0;
                }
                ++multipleCounter;
            }
            Index index = (Index)indexList.elementAt(i);
            String indexName = this.getIndexName(cgReq, index);
            AssociationList lColumns = index.getColumns();
            if (lColumns.size() == 1) {
                Column col = (Column)lColumns.elementAt(0);
                String colname = this.getIndexColumnName(cgReq, col);
                if (!colname.equals(indexName)) {
                    throw new CodegenException(bundle.formatString("DBMSSTORE.IndexNoMatch.msg.txt", (Object)indexName, (Object)colname));
                }
                cgReq.addSourceCode("   index create " + indexName + " ");
            } else if (lColumns.size() > 0) {
                cgReq.addSourceCode("   index create " + indexName + " = ");
                String indexColumns = cgReq.makeColumnList((List)lColumns, " ");
                cgReq.addSourceCode("(" + indexColumns + ")");
            } else {
                throw new CodegenException(bundle.getString("DBMSSTORE.NoColumnsOnIndex.msg.txt"));
            }
            StringBuffer opts = new StringBuffer("");
            if (index.getIsUnique() != 0) {
                opts.append(" unique ");
            }
            if (index.getIsNoMiss() != 0) {
                opts.append(" nomiss ");
            }
            if (opts.length() > 1) {
                cgReq.addSourceCode("/" + opts.toString());
            }
            cgReq.addSourceCode(";\n");
        }
        cgReq.addSourceCode("quit; \n\n").genRCSetCall("&syserr").unIndent();
        if (nonexistentTable) {
            cgReq.addSourceCode("%end;  ").addCommentLine(bundle.getString("DBMSSTORE.NewIndex.msg.notrans")).addSourceCode("\n");
        }
    }

    @Override
    public void deleteAllRows(CodegenRequest cgReq, boolean useTruncate) throws MdException, RemoteException {
        this.truncate(cgReq);
    }

    @Override
    public void truncate(CodegenRequest cgReq) throws MdException, RemoteException {
        this.m_table = (PhysicalTable)this.getMetadataClass();
        ServerComponent spdsServer = (ServerComponent)this.m_table.getTablePackage().getDeployedComponents().get(0);
        boolean truncateAvailable = false;
        int major = spdsServer.getMajor();
        int minor = spdsServer.getMinor();
        if (major >= 4 && minor >= 3) {
            truncateAvailable = true;
        }
        String sMajor = String.valueOf(major);
        String sMinor = String.valueOf(minor);
        if (truncateAvailable) {
            cgReq.addSectionComment(bundle.getString("SPDS.Truncate.msg.notrans")).genPercentPutStatement(bundle.formatString("SPDS.Truncate.note.sasmacro.notrans", (Object)sMajor, (Object)sMinor)).addSourceCode("\n");
            cgReq.addSourceCode("proc spdo lib=");
            cgReq.addSourceCode(this.getDataLocationLibRef(cgReq) + ";\n");
            String tname = SASSPDS.getTableName(this.getDataLocation(cgReq));
            cgReq.addSourceCode("   truncate " + tname);
            cgReq.addSourceCode(";\n");
            cgReq.addSourceCode("quit;\n");
            cgReq.genRCSetCall("&sqlrc");
        } else {
            cgReq.addSectionComment(bundle.getString("SPDS.TruncateRemove.msg.notrans"));
            cgReq.genPercentPutStatement(bundle.formatString("SPDS.TruncateRemove.note.sasmacro.notrans", (Object)sMajor, (Object)sMinor)).addSourceCode("\n");
            this.remove(cgReq, true);
        }
    }

    public void truncate(CodegenRequest cgReq, ClassifierMap classifierMap) throws MdException, RemoteException {
        PhysicalTable targetTable = (PhysicalTable)classifierMap.getClassifierTargets().get(0);
        ServerComponent spdsServer = (ServerComponent)targetTable.getTablePackage().getDeployedComponents().get(0);
        boolean truncateAvailable = false;
        int major = spdsServer.getMajor();
        int minor = spdsServer.getMinor();
        if (major >= 4 && minor >= 3) {
            truncateAvailable = true;
        }
        String sMajor = String.valueOf(major);
        String sMinor = String.valueOf(minor);
        if (truncateAvailable) {
            cgReq.addSectionComment(bundle.getString("SPDS.Truncate.msg.notrans")).genPercentPutStatement(bundle.formatString("SPDS.Truncate.note.sasmacro.notrans", (Object)sMajor, (Object)sMinor)).addSourceCode("\n");
            cgReq.addSourceCode("proc spdo lib=");
            cgReq.addSourceCode(this.getDataLocationLibRef(cgReq) + ";\n");
            String tname = SASSPDS.getTableName(this.getDataLocation(cgReq));
            cgReq.addSourceCode("   truncate " + tname);
            cgReq.addSourceCode(";\n");
            cgReq.addSourceCode("quit;\n");
            cgReq.genRCSetCall("&sqlrc");
        } else {
            cgReq.addSectionComment(bundle.getString("SPDS.TruncateRemove.msg.notrans"));
            cgReq.genPercentPutStatement(bundle.formatString("SPDS.TruncateRemove.note.sasmacro.notrans", (Object)sMajor, (Object)sMinor)).addSourceCode("\n");
            this.remove(cgReq, true);
        }
    }

    @Override
    public boolean getTruncateSupport() throws MdException, RemoteException {
        this.m_table = (PhysicalTable)this.getMetadataClass();
        ServerComponent spdsServer = (ServerComponent)this.m_table.getTablePackage().getDeployedComponents().get(0);
        boolean truncateAvailable = false;
        int major = spdsServer.getMajor();
        int minor = spdsServer.getMinor();
        if (major >= 4 && minor >= 3) {
            truncateAvailable = true;
        }
        return truncateAvailable;
    }

    @Override
    public void createConstraints(CodegenRequest cgReq) throws MdException, RemoteException {
    }

    public void remove(CodegenRequest cgReq, boolean truncate) throws MdException, RemoteException {
        if (!truncate) {
            cgReq.addSectionComment(bundle.getString("SPDS.Remove.msg.notrans")).genPercentPutStatement(bundle.getString("SPDS.Remove.note.sasmacro.notrans")).addSourceCode("\n");
        }
        String fullTableName = this.getDataLocation(cgReq);
        cgReq.addCommentLine(bundle.getString("DBMSSTORE.Truncate.PhysicallyDeleteRecords.msg.notrans")).addSourceCode("data " + fullTableName + "; \n").indent().addSourceCode("set " + fullTableName + "; \n").addSourceCode("stop; \n").unIndent().addSourceCode("run; \n\n").genRCSetCall("&syserr");
        if (!this.recreateIndex) {
            this.m_removeRows = true;
            this.createIndexes(cgReq, true, false, this.parallelGroup);
        }
    }

    @Override
    public StringBuffer getConnect(CodegenRequest cgReq) {
        SASCodeGeneration sasCode = new SASCodeGeneration();
        String dbmsOptions = "";
        try {
            Deployment bestDep = this.getBestDeployment(cgReq);
            SASLibrary library = bestDep.getLibrary();
            dbmsOptions = LibraryUtil.getConnectionOptions((SASLibrary)library);
        }
        catch (MdException e) {
            throw new CodegenException(bundle.formatString("DBMSSTORE.NoConnectionInfo.msg.txt", (Object)e.getMessage()));
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        if (this.m_Nick == null) {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoLibraryEngine.msg.txt"));
        }
        if (dbmsOptions.length() > 0) {
            sasCode.addSourceCode(dbmsOptions);
        }
        return sasCode.getSourceBuffer();
    }

    @Override
    public void genDisconnect(CodegenRequest cgReq) {
        if (this.m_Nick == null) {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoLibraryEngine.msg.txt"));
        }
        cgReq.addSourceCode("disconnect from " + this.m_Nick + "; \n\n");
    }

    @Override
    public void genExecuteBegin(CodegenRequest cgReq, String prefix) {
        cgReq.addSourceCode(prefix + "execute \n").addSourceCode(prefix + "( \n").indent();
    }

    @Override
    public void genExecuteEnd(CodegenRequest cgReq, String prefix) {
        if (this.m_Nick == null) {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoLibraryEngine.msg.txt"));
        }
        cgReq.unIndent().addSourceCode(prefix + ") by " + this.m_Nick + "; \n\n");
        cgReq.genRCSetCall("&sqlrc");
    }

    @Override
    public void genBeginSelectAllFromConnect(CodegenRequest cgReq) {
        if (this.m_Nick == null) {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoLibraryEngine.msg.txt"));
        }
        if (this.m_Nick.length() > 0) {
            cgReq.addSourceCode("select * from connection to ").addSourceCode(this.m_Nick).addSourceCode("\n(\n").indent();
        }
    }

    @Override
    public void genEndSelectAllFromConnect(CodegenRequest cgReq) {
        if (this.m_Nick == null) {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoLibraryEngine.msg.txt"));
        }
        if (this.m_Nick.length() > 0) {
            cgReq.addSourceCode("\n").unIndent().addSourceCode(");\n");
            cgReq.addSourceCode("\n").genRCSetCall("&sqlrc");
        }
    }

    @Override
    public boolean getPassThroughSupport() {
        return true;
    }

    @Override
    protected String getSchemaName(CodegenRequest cgReq, boolean quotes) throws MdException, RemoteException {
        Deployment bestPath = this.getBestDeployment(cgReq);
        SASLibrary iLib = bestPath.getLibrary();
        String schemaName = "";
        if (iLib != null) {
            schemaName = iLib.getLibref().trim();
        }
        return schemaName;
    }
}

