/*
 * Decompiled with CFR 0.152.
 */
package com.sas.codegen;

import com.sas.codegen.CodeGenRoot;
import com.sas.codegen.CodegenRequest;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.RowSelector;
import com.sas.metadata.remote.TextStore;
import com.sas.workspace.ExpressionParser;
import java.rmi.RemoteException;

public class RowSelectorCG
extends CodeGenRoot {
    public static final String ROW_SELECTION_COND = "Row Selection Conditions";
    public static final String ALL_ROWS = "All Rows";

    @Override
    public void codeGen(CodegenRequest cgReq) throws MdException, RemoteException {
        RowSelector rowSelector = (RowSelector)this.getMetadataClass();
        if (cgReq.onContextList(rowSelector.getFQID())) {
            return;
        }
        cgReq.addContextList(rowSelector.getFQID());
        this.codeGenSelfOnly(cgReq);
    }

    @Override
    public void codeGenSelfOnly(CodegenRequest cgReq) throws MdException, RemoteException {
        String code = this.getExpression(cgReq);
        if (code.length() > 0) {
            cgReq.addSourceCode(code);
        }
    }

    public String getExpression(CodegenRequest cgReq) throws MdException, RemoteException {
        return this.getExpression(cgReq, false);
    }

    public String getExpression(CodegenRequest cgReq, boolean addNewLine) throws MdException, RemoteException {
        RowSelector rowSelector = (RowSelector)this.getMetadataClass();
        return RowSelectorCG.getExpression(cgReq, rowSelector, addNewLine);
    }

    public static String getExpression(CodegenRequest cgReq, RowSelector rowSelector) throws MdException, RemoteException {
        return RowSelectorCG.getExpression(cgReq, rowSelector, true);
    }

    public static String getExpression(CodegenRequest cgReq, RowSelector rowSelector, boolean addNewLine) throws MdException, RemoteException {
        String expression = "";
        boolean bUseQuotes = cgReq.getQuoting();
        if (rowSelector != null) {
            TextStore text = (TextStore)rowSelector.getSourceCode();
            ClassifierMap cm = rowSelector.getOwningClassifierMap();
            String expr = ExpressionParser.detokenizeString((String)text.getStoredText(), (AbstractTransformation)cm, (boolean)bUseQuotes);
            if (expr != null) {
                expression = expr;
            }
        }
        if (expression.length() > 0) {
            String rslType = rowSelector.getRowsSelected();
            if (rslType.equalsIgnoreCase(ROW_SELECTION_COND)) {
                expression = "if " + expression;
            } else if (rslType.equalsIgnoreCase(ALL_ROWS)) {
                expression = "where " + expression;
            }
            if (addNewLine) {
                expression = expression + "\n";
            }
        }
        return expression;
    }
}

