/*
 * Decompiled with CFR 0.152.
 */
package com.sas.codegen;

import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.DBMSSTORE;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;

public class ORACLE
extends DBMSSTORE {
    private static WAdminResource bundle = WAdminResource.getBundle(ORACLE.class);

    public ORACLE() {
        this.setConstraintTypesDroppable("PUF");
        this.setUnquotedTableNameAction("U");
        this.setTableAliasKeyword(" ");
    }

    @Override
    public void queryIndexes(CodegenRequest cgReq) throws MdException, RemoteException {
        String tableName = ORACLE.getTableName(this.getDataLocation(cgReq, true, false));
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoTableReference.msg.txt"));
        }
        cgReq.indent().addSourceCode("from connection to " + this.getNickname() + "\n").addSourceCode("( \n").indent().addSourceCode("select index_name as idxname , \n").addSourceCode("       table_name as tabName \n").indent().addSourceCode("from user_indexes \n").indent();
        tableName = tableName.replaceAll("'", "''");
        cgReq.addSourceCode("where table_name = '" + tableName + "' \n").addSourceCode("      and generated = 'N' \n").unIndent().unIndent().unIndent().addSourceCode("); \n").unIndent();
    }

    @Override
    public void dropSingleConstraint(CodegenRequest cgReq) throws MdException, RemoteException {
        this.genExecuteBegin(cgReq, "");
        cgReq.addSourceCode("alter table " + this.getDataLocation(cgReq, true, true) + " drop constraint &etls_constName \n");
        this.genExecuteEnd(cgReq, "");
    }

    @Override
    public void queryConstraints(CodegenRequest cgReq) throws MdException, RemoteException {
        String tableName = ORACLE.getTableName(this.getDataLocation(cgReq, true, false));
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoTableReference.msg.txt"));
        }
        cgReq.indent().addSourceCode("from connection to " + this.getNickname() + "\n").addSourceCode("( \n").indent().addSourceCode("select constraint_name as constName, constraint_type as constType \n").indent().addSourceCode("from user_constraints \n").indent().addSourceCode("where table_name = '" + tableName + "' \n").unIndent().unIndent().unIndent().addSourceCode("); \n").unIndent();
    }

    @Override
    public void genDeleteAll(CodegenRequest cgReq) throws MdException, RemoteException {
        String tableName = this.getDataLocation(cgReq, true, true);
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoTableReference.msg.txt"));
        }
        cgReq.addSourceCode("truncate table " + tableName + "\n");
    }

    @Override
    public void genDeleteAll2(CodegenRequest cgReq) throws MdException, RemoteException {
        String tableName = this.getDataLocation(cgReq, true, true);
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoTableReference.msg.txt"));
        }
        cgReq.addSourceCode("delete from " + tableName + "\n");
    }

    @Override
    public boolean getTruncateSupport() throws MdException, RemoteException {
        return true;
    }
}

