/*
 * Decompiled with CFR 0.152.
 */
package com.sas.codegen;

import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.DBMSSTORE;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.Index;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.util.List;

public class OLEDBACCESS
extends DBMSSTORE {
    private static WAdminResource bundle = WAdminResource.getBundle(OLEDBACCESS.class);

    @Override
    public void dropSingleIndex(CodegenRequest cgReq) throws MdException, RemoteException {
        cgReq.addSourceCode("drop index `%bquote(&etls_indexName)` on `%bquote(&etls_indexTable)` \n");
    }

    @Override
    public void genDeleteAll(CodegenRequest cgReq) throws MdException, RemoteException {
        String tableName = this.getDataLocation(cgReq, true, false);
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoTableReference.msg.txt"));
        }
        tableName = tableName.replaceAll("'", "%str(%')");
        cgReq.addSourceCode("delete from `" + tableName + "`\n");
    }

    @Override
    public void genDeleteAll2(CodegenRequest cgReq) throws MdException, RemoteException {
        this.genDeleteAll(cgReq);
    }

    @Override
    public void genTruncate(CodegenRequest cgReq) throws MdException, RemoteException {
        String tableName = this.getDataLocation(cgReq, true, false);
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoTableReference.msg.txt"));
        }
        tableName = tableName.replaceAll("'", "%str(%')");
        cgReq.addSourceCode("truncate table `" + tableName + "`\n");
    }

    @Override
    public boolean getTruncateSupport() throws MdException, RemoteException {
        return false;
    }

    @Override
    public void genSingleIndex(CodegenRequest cgReq, Index index) throws MdException, RemoteException {
        AssociationList lColumns;
        String preOpts = this.getPreIndexOptions(index);
        String tableOpts = this.getIndexTableOptions(cgReq, index);
        String idxname = index.getName();
        if (idxname == null || idxname.trim().length() <= 0) {
            throw new CodegenException(bundle.getString("DBMSSTORE.IndexNameUndefined.msg.txt"));
        }
        if (index.getOwningPhysicalTable() == null) {
            throw new CodegenException(bundle.getString("IndexCG.MissingIndexTable.msg.txt"));
        }
        cgReq.addSourceCode("create ");
        if (preOpts.length() > 0) {
            cgReq.addSourceCode(preOpts.trim() + " ");
        }
        String tableName = this.getDataLocation(cgReq, this.m_passthru, false);
        tableName = tableName.replaceAll("'", "%str(%')");
        idxname = idxname.replaceAll("'", "%str(%')");
        cgReq.addSourceCode("index `" + idxname + "`\n").indent().addSourceCode("on `" + tableName + "`\n").indent().addSourceCode("  (");
        if (tableOpts.length() > 0) {
            cgReq.addSourceCode(tableOpts + "\n   ");
        }
        if ((lColumns = index.getColumns()).isEmpty()) {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoColumnsOnIndex.msg.txt"));
        }
        String columns = this.makeColumnList((List)lColumns, true, "   ", ",", "", "");
        cgReq.addSourceCode(columns).addSourceCode(") \n").unIndent().unIndent();
    }

    public String getIndexName(Index index) throws MdException, RemoteException {
        String name = index.getName();
        if (name == null || name.trim().length() <= 0) {
            throw new CodegenException(bundle.getString("IndexCG.MissingIndexName.msg.txt"));
        }
        PhysicalTable table = index.getOwningPhysicalTable();
        if (table == null) {
            throw new CodegenException(bundle.getString("IndexCG.MissingIndexTable.msg.txt"));
        }
        return name;
    }

    public String makeColumnList(List columnList, boolean oneColumnPerLine, String spacesToIndentNextLines, String delimiter, String tableAlias, String indent) throws MdException, RemoteException {
        if (columnList.size() == 0) {
            return "";
        }
        if (indent == null) {
            indent = "";
        }
        if (!delimiter.equals(" ")) {
            delimiter = delimiter + " ";
        }
        if ((tableAlias = tableAlias.trim()).length() > 0) {
            tableAlias = tableAlias.concat(".");
        }
        StringBuffer columnString = new StringBuffer();
        for (int i = 0; i < columnList.size(); ++i) {
            Object obj = columnList.get(i);
            String columnName = "";
            if (obj instanceof String) {
                columnName = "`" + obj.toString().replaceAll("'", "%str(%')") + "`";
            } else if (obj instanceof Column) {
                Column column = (Column)obj;
                columnName = "`" + column.getSASColumnName().replaceAll("'", "%str(%')") + "`";
            }
            if (oneColumnPerLine && i > 0) {
                columnString.append(delimiter).append("\n").append(spacesToIndentNextLines);
            }
            if (tableAlias.length() > 0) {
                columnString.append(tableAlias);
            }
            columnString.append(columnName);
        }
        return columnString.toString();
    }
}

